; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+f,-d < %s | FileCheck %s --check-prefix=LA32F
; RUN: llc --mtriple=loongarch32 --mattr=+d < %s | FileCheck %s --check-prefix=LA32D
; RUN: llc --mtriple=loongarch64 --mattr=+f,-d < %s | FileCheck %s --check-prefix=LA64F
; RUN: llc --mtriple=loongarch64 --mattr=+d < %s | FileCheck %s --check-prefix=LA64D

;; TODO: Merge the offset of address calculation into the offset field of instructions.

%f2 = type <2 x float>
%f4 = type <4 x float>
%f8 = type <8 x float>
%d2 = type <2 x double>
%d4 = type <4 x double>
%d8 = type <8 x double>

define void @test_zero(ptr %P, ptr %S) nounwind {
; LA32F-LABEL: test_zero:
; LA32F:       # %bb.0:
; LA32F-NEXT:    fld.s $fa0, $a0, 12
; LA32F-NEXT:    movgr2fr.w $fa1, $zero
; LA32F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32F-NEXT:    fst.s $fa0, $a1, 12
; LA32F-NEXT:    fld.s $fa0, $a0, 8
; LA32F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32F-NEXT:    fst.s $fa0, $a1, 8
; LA32F-NEXT:    fld.s $fa0, $a0, 4
; LA32F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32F-NEXT:    fst.s $fa0, $a1, 4
; LA32F-NEXT:    fld.s $fa0, $a0, 0
; LA32F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32F-NEXT:    fst.s $fa0, $a1, 0
; LA32F-NEXT:    ret
;
; LA32D-LABEL: test_zero:
; LA32D:       # %bb.0:
; LA32D-NEXT:    fld.s $fa0, $a0, 12
; LA32D-NEXT:    movgr2fr.w $fa1, $zero
; LA32D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32D-NEXT:    fst.s $fa0, $a1, 12
; LA32D-NEXT:    fld.s $fa0, $a0, 8
; LA32D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32D-NEXT:    fst.s $fa0, $a1, 8
; LA32D-NEXT:    fld.s $fa0, $a0, 4
; LA32D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32D-NEXT:    fst.s $fa0, $a1, 4
; LA32D-NEXT:    fld.s $fa0, $a0, 0
; LA32D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32D-NEXT:    fst.s $fa0, $a1, 0
; LA32D-NEXT:    ret
;
; LA64F-LABEL: test_zero:
; LA64F:       # %bb.0:
; LA64F-NEXT:    fld.s $fa0, $a0, 12
; LA64F-NEXT:    movgr2fr.w $fa1, $zero
; LA64F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64F-NEXT:    fst.s $fa0, $a1, 12
; LA64F-NEXT:    fld.s $fa0, $a0, 8
; LA64F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64F-NEXT:    fst.s $fa0, $a1, 8
; LA64F-NEXT:    fld.s $fa0, $a0, 4
; LA64F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64F-NEXT:    fst.s $fa0, $a1, 4
; LA64F-NEXT:    fld.s $fa0, $a0, 0
; LA64F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64F-NEXT:    fst.s $fa0, $a1, 0
; LA64F-NEXT:    ret
;
; LA64D-LABEL: test_zero:
; LA64D:       # %bb.0:
; LA64D-NEXT:    fld.s $fa0, $a0, 12
; LA64D-NEXT:    movgr2fr.w $fa1, $zero
; LA64D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64D-NEXT:    fst.s $fa0, $a1, 12
; LA64D-NEXT:    fld.s $fa0, $a0, 8
; LA64D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64D-NEXT:    fst.s $fa0, $a1, 8
; LA64D-NEXT:    fld.s $fa0, $a0, 4
; LA64D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64D-NEXT:    fst.s $fa0, $a1, 4
; LA64D-NEXT:    fld.s $fa0, $a0, 0
; LA64D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64D-NEXT:    fst.s $fa0, $a1, 0
; LA64D-NEXT:    ret
  %p = load %f4, ptr %P
  %R = fadd %f4 %p, zeroinitializer
  store %f4 %R, ptr %S
  ret void
}

define void @test_f2(ptr %P, ptr %S) nounwind {
; LA32F-LABEL: test_f2:
; LA32F:       # %bb.0:
; LA32F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI1_0)
; LA32F-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI1_0)
; LA32F-NEXT:    fld.s $fa0, $a2, 0
; LA32F-NEXT:    fld.s $fa1, $a0, 4
; LA32F-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-NEXT:    fst.s $fa0, $a1, 4
; LA32F-NEXT:    fld.s $fa0, $a0, 0
; LA32F-NEXT:    addi.w $a0, $zero, 1
; LA32F-NEXT:    movgr2fr.w $fa1, $a0
; LA32F-NEXT:    ffint.s.w $fa1, $fa1
; LA32F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32F-NEXT:    fst.s $fa0, $a1, 0
; LA32F-NEXT:    ret
;
; LA32D-LABEL: test_f2:
; LA32D:       # %bb.0:
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI1_0)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI1_0)
; LA32D-NEXT:    fld.s $fa0, $a2, 0
; LA32D-NEXT:    fld.s $fa1, $a0, 4
; LA32D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32D-NEXT:    fst.s $fa0, $a1, 4
; LA32D-NEXT:    fld.s $fa0, $a0, 0
; LA32D-NEXT:    addi.w $a0, $zero, 1
; LA32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32D-NEXT:    ffint.s.w $fa1, $fa1
; LA32D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32D-NEXT:    fst.s $fa0, $a1, 0
; LA32D-NEXT:    ret
;
; LA64F-LABEL: test_f2:
; LA64F:       # %bb.0:
; LA64F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI1_0)
; LA64F-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI1_0)
; LA64F-NEXT:    fld.s $fa0, $a2, 0
; LA64F-NEXT:    fld.s $fa1, $a0, 4
; LA64F-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-NEXT:    fst.s $fa0, $a1, 4
; LA64F-NEXT:    fld.s $fa0, $a0, 0
; LA64F-NEXT:    addi.w $a0, $zero, 1
; LA64F-NEXT:    movgr2fr.w $fa1, $a0
; LA64F-NEXT:    ffint.s.w $fa1, $fa1
; LA64F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64F-NEXT:    fst.s $fa0, $a1, 0
; LA64F-NEXT:    ret
;
; LA64D-LABEL: test_f2:
; LA64D:       # %bb.0:
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI1_0)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI1_0)
; LA64D-NEXT:    fld.s $fa0, $a2, 0
; LA64D-NEXT:    fld.s $fa1, $a0, 4
; LA64D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-NEXT:    fst.s $fa0, $a1, 4
; LA64D-NEXT:    fld.s $fa0, $a0, 0
; LA64D-NEXT:    addi.w $a0, $zero, 1
; LA64D-NEXT:    movgr2fr.w $fa1, $a0
; LA64D-NEXT:    ffint.s.w $fa1, $fa1
; LA64D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64D-NEXT:    fst.s $fa0, $a1, 0
; LA64D-NEXT:    ret
  %p = load %f2, ptr %P
  %R = fadd %f2 %p, < float 1.000000e+00, float 2.000000e+00 >
  store %f2 %R, ptr %S
  ret void
}

define void @test_f4(ptr %P, ptr %S) nounwind {
; LA32F-LABEL: test_f4:
; LA32F:       # %bb.0:
; LA32F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_0)
; LA32F-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI2_0)
; LA32F-NEXT:    fld.s $fa0, $a2, 0
; LA32F-NEXT:    fld.s $fa1, $a0, 4
; LA32F-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_1)
; LA32F-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI2_1)
; LA32F-NEXT:    fld.s $fa1, $a2, 0
; LA32F-NEXT:    fld.s $fa2, $a0, 8
; LA32F-NEXT:    fadd.s $fa1, $fa2, $fa1
; LA32F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_2)
; LA32F-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI2_2)
; LA32F-NEXT:    fld.s $fa2, $a2, 0
; LA32F-NEXT:    fld.s $fa3, $a0, 12
; LA32F-NEXT:    fadd.s $fa2, $fa3, $fa2
; LA32F-NEXT:    fst.s $fa2, $a1, 12
; LA32F-NEXT:    fst.s $fa1, $a1, 8
; LA32F-NEXT:    fst.s $fa0, $a1, 4
; LA32F-NEXT:    fld.s $fa0, $a0, 0
; LA32F-NEXT:    addi.w $a0, $zero, 1
; LA32F-NEXT:    movgr2fr.w $fa1, $a0
; LA32F-NEXT:    ffint.s.w $fa1, $fa1
; LA32F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32F-NEXT:    fst.s $fa0, $a1, 0
; LA32F-NEXT:    ret
;
; LA32D-LABEL: test_f4:
; LA32D:       # %bb.0:
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_0)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI2_0)
; LA32D-NEXT:    fld.s $fa0, $a2, 0
; LA32D-NEXT:    fld.s $fa1, $a0, 4
; LA32D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_1)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI2_1)
; LA32D-NEXT:    fld.s $fa1, $a2, 0
; LA32D-NEXT:    fld.s $fa2, $a0, 8
; LA32D-NEXT:    fadd.s $fa1, $fa2, $fa1
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_2)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI2_2)
; LA32D-NEXT:    fld.s $fa2, $a2, 0
; LA32D-NEXT:    fld.s $fa3, $a0, 12
; LA32D-NEXT:    fadd.s $fa2, $fa3, $fa2
; LA32D-NEXT:    fst.s $fa2, $a1, 12
; LA32D-NEXT:    fst.s $fa1, $a1, 8
; LA32D-NEXT:    fst.s $fa0, $a1, 4
; LA32D-NEXT:    fld.s $fa0, $a0, 0
; LA32D-NEXT:    addi.w $a0, $zero, 1
; LA32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32D-NEXT:    ffint.s.w $fa1, $fa1
; LA32D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32D-NEXT:    fst.s $fa0, $a1, 0
; LA32D-NEXT:    ret
;
; LA64F-LABEL: test_f4:
; LA64F:       # %bb.0:
; LA64F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_0)
; LA64F-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI2_0)
; LA64F-NEXT:    fld.s $fa0, $a2, 0
; LA64F-NEXT:    fld.s $fa1, $a0, 4
; LA64F-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_1)
; LA64F-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI2_1)
; LA64F-NEXT:    fld.s $fa1, $a2, 0
; LA64F-NEXT:    fld.s $fa2, $a0, 8
; LA64F-NEXT:    fadd.s $fa1, $fa2, $fa1
; LA64F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_2)
; LA64F-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI2_2)
; LA64F-NEXT:    fld.s $fa2, $a2, 0
; LA64F-NEXT:    fld.s $fa3, $a0, 12
; LA64F-NEXT:    fadd.s $fa2, $fa3, $fa2
; LA64F-NEXT:    fst.s $fa2, $a1, 12
; LA64F-NEXT:    fst.s $fa1, $a1, 8
; LA64F-NEXT:    fst.s $fa0, $a1, 4
; LA64F-NEXT:    fld.s $fa0, $a0, 0
; LA64F-NEXT:    addi.w $a0, $zero, 1
; LA64F-NEXT:    movgr2fr.w $fa1, $a0
; LA64F-NEXT:    ffint.s.w $fa1, $fa1
; LA64F-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64F-NEXT:    fst.s $fa0, $a1, 0
; LA64F-NEXT:    ret
;
; LA64D-LABEL: test_f4:
; LA64D:       # %bb.0:
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_0)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI2_0)
; LA64D-NEXT:    fld.s $fa0, $a2, 0
; LA64D-NEXT:    fld.s $fa1, $a0, 4
; LA64D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_1)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI2_1)
; LA64D-NEXT:    fld.s $fa1, $a2, 0
; LA64D-NEXT:    fld.s $fa2, $a0, 8
; LA64D-NEXT:    fadd.s $fa1, $fa2, $fa1
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI2_2)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI2_2)
; LA64D-NEXT:    fld.s $fa2, $a2, 0
; LA64D-NEXT:    fld.s $fa3, $a0, 12
; LA64D-NEXT:    fadd.s $fa2, $fa3, $fa2
; LA64D-NEXT:    fst.s $fa2, $a1, 12
; LA64D-NEXT:    fst.s $fa1, $a1, 8
; LA64D-NEXT:    fst.s $fa0, $a1, 4
; LA64D-NEXT:    fld.s $fa0, $a0, 0
; LA64D-NEXT:    addi.w $a0, $zero, 1
; LA64D-NEXT:    movgr2fr.w $fa1, $a0
; LA64D-NEXT:    ffint.s.w $fa1, $fa1
; LA64D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64D-NEXT:    fst.s $fa0, $a1, 0
; LA64D-NEXT:    ret
  %p = load %f4, ptr %P
  %R = fadd %f4 %p, < float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00 >
  store %f4 %R, ptr %S
  ret void
}

define void @test_f8(ptr %P, ptr %S) nounwind {
; LA32F-LABEL: test_f8:
; LA32F:       # %bb.0:
; LA32F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_0)
; LA32F-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI3_0)
; LA32F-NEXT:    fld.s $fa0, $a2, 0
; LA32F-NEXT:    fld.s $fa1, $a0, 4
; LA32F-NEXT:    fadd.s $fa1, $fa1, $fa0
; LA32F-NEXT:    fld.s $fa2, $a0, 20
; LA32F-NEXT:    fadd.s $fa0, $fa2, $fa0
; LA32F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_1)
; LA32F-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI3_1)
; LA32F-NEXT:    fld.s $fa2, $a2, 0
; LA32F-NEXT:    fld.s $fa3, $a0, 8
; LA32F-NEXT:    fadd.s $fa3, $fa3, $fa2
; LA32F-NEXT:    fld.s $fa4, $a0, 24
; LA32F-NEXT:    fadd.s $fa2, $fa4, $fa2
; LA32F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_2)
; LA32F-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI3_2)
; LA32F-NEXT:    fld.s $fa4, $a2, 0
; LA32F-NEXT:    fld.s $fa5, $a0, 12
; LA32F-NEXT:    fadd.s $fa5, $fa5, $fa4
; LA32F-NEXT:    fld.s $fa6, $a0, 28
; LA32F-NEXT:    fadd.s $fa4, $fa6, $fa4
; LA32F-NEXT:    fst.s $fa4, $a1, 28
; LA32F-NEXT:    fst.s $fa2, $a1, 24
; LA32F-NEXT:    fst.s $fa0, $a1, 20
; LA32F-NEXT:    fst.s $fa5, $a1, 12
; LA32F-NEXT:    fst.s $fa3, $a1, 8
; LA32F-NEXT:    fst.s $fa1, $a1, 4
; LA32F-NEXT:    addi.w $a2, $zero, 1
; LA32F-NEXT:    movgr2fr.w $fa0, $a2
; LA32F-NEXT:    ffint.s.w $fa0, $fa0
; LA32F-NEXT:    fld.s $fa1, $a0, 16
; LA32F-NEXT:    fadd.s $fa1, $fa1, $fa0
; LA32F-NEXT:    fst.s $fa1, $a1, 16
; LA32F-NEXT:    fld.s $fa1, $a0, 0
; LA32F-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-NEXT:    fst.s $fa0, $a1, 0
; LA32F-NEXT:    ret
;
; LA32D-LABEL: test_f8:
; LA32D:       # %bb.0:
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_0)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI3_0)
; LA32D-NEXT:    fld.s $fa0, $a2, 0
; LA32D-NEXT:    fld.s $fa1, $a0, 4
; LA32D-NEXT:    fadd.s $fa1, $fa1, $fa0
; LA32D-NEXT:    fld.s $fa2, $a0, 20
; LA32D-NEXT:    fadd.s $fa0, $fa2, $fa0
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_1)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI3_1)
; LA32D-NEXT:    fld.s $fa2, $a2, 0
; LA32D-NEXT:    fld.s $fa3, $a0, 8
; LA32D-NEXT:    fadd.s $fa3, $fa3, $fa2
; LA32D-NEXT:    fld.s $fa4, $a0, 24
; LA32D-NEXT:    fadd.s $fa2, $fa4, $fa2
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_2)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI3_2)
; LA32D-NEXT:    fld.s $fa4, $a2, 0
; LA32D-NEXT:    fld.s $fa5, $a0, 12
; LA32D-NEXT:    fadd.s $fa5, $fa5, $fa4
; LA32D-NEXT:    fld.s $fa6, $a0, 28
; LA32D-NEXT:    fadd.s $fa4, $fa6, $fa4
; LA32D-NEXT:    fst.s $fa4, $a1, 28
; LA32D-NEXT:    fst.s $fa2, $a1, 24
; LA32D-NEXT:    fst.s $fa0, $a1, 20
; LA32D-NEXT:    fst.s $fa5, $a1, 12
; LA32D-NEXT:    fst.s $fa3, $a1, 8
; LA32D-NEXT:    fst.s $fa1, $a1, 4
; LA32D-NEXT:    addi.w $a2, $zero, 1
; LA32D-NEXT:    movgr2fr.w $fa0, $a2
; LA32D-NEXT:    ffint.s.w $fa0, $fa0
; LA32D-NEXT:    fld.s $fa1, $a0, 16
; LA32D-NEXT:    fadd.s $fa1, $fa1, $fa0
; LA32D-NEXT:    fst.s $fa1, $a1, 16
; LA32D-NEXT:    fld.s $fa1, $a0, 0
; LA32D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32D-NEXT:    fst.s $fa0, $a1, 0
; LA32D-NEXT:    ret
;
; LA64F-LABEL: test_f8:
; LA64F:       # %bb.0:
; LA64F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_0)
; LA64F-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI3_0)
; LA64F-NEXT:    fld.s $fa0, $a2, 0
; LA64F-NEXT:    fld.s $fa1, $a0, 4
; LA64F-NEXT:    fadd.s $fa1, $fa1, $fa0
; LA64F-NEXT:    fld.s $fa2, $a0, 20
; LA64F-NEXT:    fadd.s $fa0, $fa2, $fa0
; LA64F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_1)
; LA64F-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI3_1)
; LA64F-NEXT:    fld.s $fa2, $a2, 0
; LA64F-NEXT:    fld.s $fa3, $a0, 8
; LA64F-NEXT:    fadd.s $fa3, $fa3, $fa2
; LA64F-NEXT:    fld.s $fa4, $a0, 24
; LA64F-NEXT:    fadd.s $fa2, $fa4, $fa2
; LA64F-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_2)
; LA64F-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI3_2)
; LA64F-NEXT:    fld.s $fa4, $a2, 0
; LA64F-NEXT:    fld.s $fa5, $a0, 12
; LA64F-NEXT:    fadd.s $fa5, $fa5, $fa4
; LA64F-NEXT:    fld.s $fa6, $a0, 28
; LA64F-NEXT:    fadd.s $fa4, $fa6, $fa4
; LA64F-NEXT:    fst.s $fa4, $a1, 28
; LA64F-NEXT:    fst.s $fa2, $a1, 24
; LA64F-NEXT:    fst.s $fa0, $a1, 20
; LA64F-NEXT:    fst.s $fa5, $a1, 12
; LA64F-NEXT:    fst.s $fa3, $a1, 8
; LA64F-NEXT:    fst.s $fa1, $a1, 4
; LA64F-NEXT:    addi.w $a2, $zero, 1
; LA64F-NEXT:    movgr2fr.w $fa0, $a2
; LA64F-NEXT:    ffint.s.w $fa0, $fa0
; LA64F-NEXT:    fld.s $fa1, $a0, 16
; LA64F-NEXT:    fadd.s $fa1, $fa1, $fa0
; LA64F-NEXT:    fst.s $fa1, $a1, 16
; LA64F-NEXT:    fld.s $fa1, $a0, 0
; LA64F-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-NEXT:    fst.s $fa0, $a1, 0
; LA64F-NEXT:    ret
;
; LA64D-LABEL: test_f8:
; LA64D:       # %bb.0:
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_0)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI3_0)
; LA64D-NEXT:    fld.s $fa0, $a2, 0
; LA64D-NEXT:    fld.s $fa1, $a0, 4
; LA64D-NEXT:    fadd.s $fa1, $fa1, $fa0
; LA64D-NEXT:    fld.s $fa2, $a0, 20
; LA64D-NEXT:    fadd.s $fa0, $fa2, $fa0
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_1)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI3_1)
; LA64D-NEXT:    fld.s $fa2, $a2, 0
; LA64D-NEXT:    fld.s $fa3, $a0, 8
; LA64D-NEXT:    fadd.s $fa3, $fa3, $fa2
; LA64D-NEXT:    fld.s $fa4, $a0, 24
; LA64D-NEXT:    fadd.s $fa2, $fa4, $fa2
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI3_2)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI3_2)
; LA64D-NEXT:    fld.s $fa4, $a2, 0
; LA64D-NEXT:    fld.s $fa5, $a0, 12
; LA64D-NEXT:    fadd.s $fa5, $fa5, $fa4
; LA64D-NEXT:    fld.s $fa6, $a0, 28
; LA64D-NEXT:    fadd.s $fa4, $fa6, $fa4
; LA64D-NEXT:    fst.s $fa4, $a1, 28
; LA64D-NEXT:    fst.s $fa2, $a1, 24
; LA64D-NEXT:    fst.s $fa0, $a1, 20
; LA64D-NEXT:    fst.s $fa5, $a1, 12
; LA64D-NEXT:    fst.s $fa3, $a1, 8
; LA64D-NEXT:    fst.s $fa1, $a1, 4
; LA64D-NEXT:    addi.w $a2, $zero, 1
; LA64D-NEXT:    movgr2fr.w $fa0, $a2
; LA64D-NEXT:    ffint.s.w $fa0, $fa0
; LA64D-NEXT:    fld.s $fa1, $a0, 16
; LA64D-NEXT:    fadd.s $fa1, $fa1, $fa0
; LA64D-NEXT:    fst.s $fa1, $a1, 16
; LA64D-NEXT:    fld.s $fa1, $a0, 0
; LA64D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-NEXT:    fst.s $fa0, $a1, 0
; LA64D-NEXT:    ret
  %p = load %f8, ptr %P
  %R = fadd %f8 %p, < float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00, float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00 >
  store %f8 %R, ptr %S
  ret void
}

define void @test_d2(ptr %P, ptr %S) nounwind {
; LA32F-LABEL: test_d2:
; LA32F:       # %bb.0:
; LA32F-NEXT:    addi.w $sp, $sp, -16
; LA32F-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $fp, $sp, 8 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $s0, $sp, 4 # 4-byte Folded Spill
; LA32F-NEXT:    move $fp, $a1
; LA32F-NEXT:    move $s0, $a0
; LA32F-NEXT:    ld.w $a0, $a0, 8
; LA32F-NEXT:    ld.w $a1, $s0, 12
; LA32F-NEXT:    lu12i.w $a3, 262144
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 8
; LA32F-NEXT:    st.w $a1, $fp, 12
; LA32F-NEXT:    ld.w $a0, $s0, 0
; LA32F-NEXT:    ld.w $a1, $s0, 4
; LA32F-NEXT:    lu12i.w $a3, 261888
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 0
; LA32F-NEXT:    st.w $a1, $fp, 4
; LA32F-NEXT:    ld.w $s0, $sp, 4 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $fp, $sp, 8 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-NEXT:    addi.w $sp, $sp, 16
; LA32F-NEXT:    ret
;
; LA32D-LABEL: test_d2:
; LA32D:       # %bb.0:
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI4_0)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI4_0)
; LA32D-NEXT:    fld.d $fa0, $a2, 0
; LA32D-NEXT:    fld.d $fa1, $a0, 8
; LA32D-NEXT:    fadd.d $fa0, $fa1, $fa0
; LA32D-NEXT:    fst.d $fa0, $a1, 8
; LA32D-NEXT:    fld.d $fa0, $a0, 0
; LA32D-NEXT:    addi.w $a0, $zero, 1
; LA32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32D-NEXT:    ffint.s.w $fa1, $fa1
; LA32D-NEXT:    fcvt.d.s $fa1, $fa1
; LA32D-NEXT:    fadd.d $fa0, $fa0, $fa1
; LA32D-NEXT:    fst.d $fa0, $a1, 0
; LA32D-NEXT:    ret
;
; LA64F-LABEL: test_d2:
; LA64F:       # %bb.0:
; LA64F-NEXT:    addi.d $sp, $sp, -32
; LA64F-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; LA64F-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; LA64F-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; LA64F-NEXT:    move $fp, $a1
; LA64F-NEXT:    move $s0, $a0
; LA64F-NEXT:    ld.d $a0, $a0, 8
; LA64F-NEXT:    lu52i.d $a1, $zero, 1024
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 8
; LA64F-NEXT:    ld.d $a0, $s0, 0
; LA64F-NEXT:    lu52i.d $a1, $zero, 1023
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 0
; LA64F-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; LA64F-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; LA64F-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; LA64F-NEXT:    addi.d $sp, $sp, 32
; LA64F-NEXT:    ret
;
; LA64D-LABEL: test_d2:
; LA64D:       # %bb.0:
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI4_0)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI4_0)
; LA64D-NEXT:    fld.d $fa0, $a2, 0
; LA64D-NEXT:    fld.d $fa1, $a0, 8
; LA64D-NEXT:    fadd.d $fa0, $fa1, $fa0
; LA64D-NEXT:    fst.d $fa0, $a1, 8
; LA64D-NEXT:    fld.d $fa0, $a0, 0
; LA64D-NEXT:    addi.d $a0, $zero, 1
; LA64D-NEXT:    movgr2fr.d $fa1, $a0
; LA64D-NEXT:    ffint.d.l $fa1, $fa1
; LA64D-NEXT:    fadd.d $fa0, $fa0, $fa1
; LA64D-NEXT:    fst.d $fa0, $a1, 0
; LA64D-NEXT:    ret
  %p = load %d2, ptr %P
  %R = fadd %d2 %p, < double 1.000000e+00, double 2.000000e+00 >
  store %d2 %R, ptr %S
  ret void
}

define void @test_d4(ptr %P, ptr %S) nounwind {
; LA32F-LABEL: test_d4:
; LA32F:       # %bb.0:
; LA32F-NEXT:    addi.w $sp, $sp, -16
; LA32F-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $fp, $sp, 8 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $s0, $sp, 4 # 4-byte Folded Spill
; LA32F-NEXT:    move $fp, $a1
; LA32F-NEXT:    move $s0, $a0
; LA32F-NEXT:    ld.w $a0, $a0, 24
; LA32F-NEXT:    ld.w $a1, $s0, 28
; LA32F-NEXT:    lu12i.w $a3, 262400
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 24
; LA32F-NEXT:    st.w $a1, $fp, 28
; LA32F-NEXT:    ld.w $a0, $s0, 16
; LA32F-NEXT:    ld.w $a1, $s0, 20
; LA32F-NEXT:    lu12i.w $a3, 262272
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 16
; LA32F-NEXT:    st.w $a1, $fp, 20
; LA32F-NEXT:    ld.w $a0, $s0, 8
; LA32F-NEXT:    ld.w $a1, $s0, 12
; LA32F-NEXT:    lu12i.w $a3, 262144
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 8
; LA32F-NEXT:    st.w $a1, $fp, 12
; LA32F-NEXT:    ld.w $a0, $s0, 0
; LA32F-NEXT:    ld.w $a1, $s0, 4
; LA32F-NEXT:    lu12i.w $a3, 261888
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 0
; LA32F-NEXT:    st.w $a1, $fp, 4
; LA32F-NEXT:    ld.w $s0, $sp, 4 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $fp, $sp, 8 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-NEXT:    addi.w $sp, $sp, 16
; LA32F-NEXT:    ret
;
; LA32D-LABEL: test_d4:
; LA32D:       # %bb.0:
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI5_0)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI5_0)
; LA32D-NEXT:    fld.d $fa0, $a2, 0
; LA32D-NEXT:    fld.d $fa1, $a0, 8
; LA32D-NEXT:    fadd.d $fa0, $fa1, $fa0
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI5_1)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI5_1)
; LA32D-NEXT:    fld.d $fa1, $a2, 0
; LA32D-NEXT:    fld.d $fa2, $a0, 16
; LA32D-NEXT:    fadd.d $fa1, $fa2, $fa1
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI5_2)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI5_2)
; LA32D-NEXT:    fld.d $fa2, $a2, 0
; LA32D-NEXT:    fld.d $fa3, $a0, 24
; LA32D-NEXT:    fadd.d $fa2, $fa3, $fa2
; LA32D-NEXT:    fst.d $fa2, $a1, 24
; LA32D-NEXT:    fst.d $fa1, $a1, 16
; LA32D-NEXT:    fst.d $fa0, $a1, 8
; LA32D-NEXT:    fld.d $fa0, $a0, 0
; LA32D-NEXT:    addi.w $a0, $zero, 1
; LA32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32D-NEXT:    ffint.s.w $fa1, $fa1
; LA32D-NEXT:    fcvt.d.s $fa1, $fa1
; LA32D-NEXT:    fadd.d $fa0, $fa0, $fa1
; LA32D-NEXT:    fst.d $fa0, $a1, 0
; LA32D-NEXT:    ret
;
; LA64F-LABEL: test_d4:
; LA64F:       # %bb.0:
; LA64F-NEXT:    addi.d $sp, $sp, -32
; LA64F-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; LA64F-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; LA64F-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; LA64F-NEXT:    move $fp, $a1
; LA64F-NEXT:    move $s0, $a0
; LA64F-NEXT:    ld.d $a0, $a0, 24
; LA64F-NEXT:    lu52i.d $a1, $zero, 1025
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 24
; LA64F-NEXT:    ld.d $a0, $s0, 8
; LA64F-NEXT:    lu52i.d $a1, $zero, 1024
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 8
; LA64F-NEXT:    ld.d $a0, $s0, 0
; LA64F-NEXT:    lu52i.d $a1, $zero, 1023
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 0
; LA64F-NEXT:    ld.d $a0, $s0, 16
; LA64F-NEXT:    ori $a1, $zero, 0
; LA64F-NEXT:    lu32i.d $a1, -524288
; LA64F-NEXT:    lu52i.d $a1, $a1, 1024
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 16
; LA64F-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; LA64F-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; LA64F-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; LA64F-NEXT:    addi.d $sp, $sp, 32
; LA64F-NEXT:    ret
;
; LA64D-LABEL: test_d4:
; LA64D:       # %bb.0:
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI5_0)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI5_0)
; LA64D-NEXT:    fld.d $fa0, $a2, 0
; LA64D-NEXT:    fld.d $fa1, $a0, 8
; LA64D-NEXT:    fadd.d $fa0, $fa1, $fa0
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI5_1)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI5_1)
; LA64D-NEXT:    fld.d $fa1, $a2, 0
; LA64D-NEXT:    fld.d $fa2, $a0, 16
; LA64D-NEXT:    fadd.d $fa1, $fa2, $fa1
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI5_2)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI5_2)
; LA64D-NEXT:    fld.d $fa2, $a2, 0
; LA64D-NEXT:    fld.d $fa3, $a0, 24
; LA64D-NEXT:    fadd.d $fa2, $fa3, $fa2
; LA64D-NEXT:    fst.d $fa2, $a1, 24
; LA64D-NEXT:    fst.d $fa1, $a1, 16
; LA64D-NEXT:    fst.d $fa0, $a1, 8
; LA64D-NEXT:    fld.d $fa0, $a0, 0
; LA64D-NEXT:    addi.d $a0, $zero, 1
; LA64D-NEXT:    movgr2fr.d $fa1, $a0
; LA64D-NEXT:    ffint.d.l $fa1, $fa1
; LA64D-NEXT:    fadd.d $fa0, $fa0, $fa1
; LA64D-NEXT:    fst.d $fa0, $a1, 0
; LA64D-NEXT:    ret
  %p = load %d4, ptr %P
  %R = fadd %d4 %p, < double 1.000000e+00, double 2.000000e+00, double 3.000000e+00, double 4.000000e+00 >
  store %d4 %R, ptr %S
  ret void
}

define void @test_d8(ptr %P, ptr %S) nounwind {
; LA32F-LABEL: test_d8:
; LA32F:       # %bb.0:
; LA32F-NEXT:    addi.w $sp, $sp, -32
; LA32F-NEXT:    st.w $ra, $sp, 28 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $fp, $sp, 24 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $s0, $sp, 20 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $s1, $sp, 16 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $s2, $sp, 12 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $s3, $sp, 8 # 4-byte Folded Spill
; LA32F-NEXT:    st.w $s4, $sp, 4 # 4-byte Folded Spill
; LA32F-NEXT:    move $fp, $a1
; LA32F-NEXT:    move $s0, $a0
; LA32F-NEXT:    ld.w $a0, $a0, 56
; LA32F-NEXT:    ld.w $a1, $s0, 60
; LA32F-NEXT:    lu12i.w $s1, 262400
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    move $a3, $s1
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 56
; LA32F-NEXT:    st.w $a1, $fp, 60
; LA32F-NEXT:    ld.w $a0, $s0, 48
; LA32F-NEXT:    ld.w $a1, $s0, 52
; LA32F-NEXT:    lu12i.w $s2, 262272
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    move $a3, $s2
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 48
; LA32F-NEXT:    st.w $a1, $fp, 52
; LA32F-NEXT:    ld.w $a0, $s0, 40
; LA32F-NEXT:    ld.w $a1, $s0, 44
; LA32F-NEXT:    lu12i.w $s3, 262144
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    move $a3, $s3
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 40
; LA32F-NEXT:    st.w $a1, $fp, 44
; LA32F-NEXT:    ld.w $a0, $s0, 32
; LA32F-NEXT:    ld.w $a1, $s0, 36
; LA32F-NEXT:    lu12i.w $s4, 261888
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    move $a3, $s4
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 32
; LA32F-NEXT:    st.w $a1, $fp, 36
; LA32F-NEXT:    ld.w $a0, $s0, 24
; LA32F-NEXT:    ld.w $a1, $s0, 28
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    move $a3, $s1
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 24
; LA32F-NEXT:    st.w $a1, $fp, 28
; LA32F-NEXT:    ld.w $a0, $s0, 16
; LA32F-NEXT:    ld.w $a1, $s0, 20
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    move $a3, $s2
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 16
; LA32F-NEXT:    st.w $a1, $fp, 20
; LA32F-NEXT:    ld.w $a0, $s0, 8
; LA32F-NEXT:    ld.w $a1, $s0, 12
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    move $a3, $s3
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 8
; LA32F-NEXT:    st.w $a1, $fp, 12
; LA32F-NEXT:    ld.w $a0, $s0, 0
; LA32F-NEXT:    ld.w $a1, $s0, 4
; LA32F-NEXT:    move $a2, $zero
; LA32F-NEXT:    move $a3, $s4
; LA32F-NEXT:    bl %plt(__adddf3)
; LA32F-NEXT:    st.w $a0, $fp, 0
; LA32F-NEXT:    st.w $a1, $fp, 4
; LA32F-NEXT:    ld.w $s4, $sp, 4 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $s3, $sp, 8 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $s2, $sp, 12 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $s1, $sp, 16 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $s0, $sp, 20 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $fp, $sp, 24 # 4-byte Folded Reload
; LA32F-NEXT:    ld.w $ra, $sp, 28 # 4-byte Folded Reload
; LA32F-NEXT:    addi.w $sp, $sp, 32
; LA32F-NEXT:    ret
;
; LA32D-LABEL: test_d8:
; LA32D:       # %bb.0:
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI6_0)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI6_0)
; LA32D-NEXT:    fld.d $fa0, $a2, 0
; LA32D-NEXT:    fld.d $fa1, $a0, 8
; LA32D-NEXT:    fadd.d $fa1, $fa1, $fa0
; LA32D-NEXT:    fld.d $fa2, $a0, 40
; LA32D-NEXT:    fadd.d $fa0, $fa2, $fa0
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI6_1)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI6_1)
; LA32D-NEXT:    fld.d $fa2, $a2, 0
; LA32D-NEXT:    fld.d $fa3, $a0, 16
; LA32D-NEXT:    fadd.d $fa3, $fa3, $fa2
; LA32D-NEXT:    fld.d $fa4, $a0, 48
; LA32D-NEXT:    fadd.d $fa2, $fa4, $fa2
; LA32D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI6_2)
; LA32D-NEXT:    addi.w $a2, $a2, %pc_lo12(.LCPI6_2)
; LA32D-NEXT:    fld.d $fa4, $a2, 0
; LA32D-NEXT:    fld.d $fa5, $a0, 24
; LA32D-NEXT:    fadd.d $fa5, $fa5, $fa4
; LA32D-NEXT:    fld.d $fa6, $a0, 56
; LA32D-NEXT:    fadd.d $fa4, $fa6, $fa4
; LA32D-NEXT:    fst.d $fa4, $a1, 56
; LA32D-NEXT:    fst.d $fa2, $a1, 48
; LA32D-NEXT:    fst.d $fa0, $a1, 40
; LA32D-NEXT:    fst.d $fa5, $a1, 24
; LA32D-NEXT:    fst.d $fa3, $a1, 16
; LA32D-NEXT:    fst.d $fa1, $a1, 8
; LA32D-NEXT:    addi.w $a2, $zero, 1
; LA32D-NEXT:    movgr2fr.w $fa0, $a2
; LA32D-NEXT:    ffint.s.w $fa0, $fa0
; LA32D-NEXT:    fcvt.d.s $fa0, $fa0
; LA32D-NEXT:    fld.d $fa1, $a0, 32
; LA32D-NEXT:    fadd.d $fa1, $fa1, $fa0
; LA32D-NEXT:    fst.d $fa1, $a1, 32
; LA32D-NEXT:    fld.d $fa1, $a0, 0
; LA32D-NEXT:    fadd.d $fa0, $fa1, $fa0
; LA32D-NEXT:    fst.d $fa0, $a1, 0
; LA32D-NEXT:    ret
;
; LA64F-LABEL: test_d8:
; LA64F:       # %bb.0:
; LA64F-NEXT:    addi.d $sp, $sp, -48
; LA64F-NEXT:    st.d $ra, $sp, 40 # 8-byte Folded Spill
; LA64F-NEXT:    st.d $fp, $sp, 32 # 8-byte Folded Spill
; LA64F-NEXT:    st.d $s0, $sp, 24 # 8-byte Folded Spill
; LA64F-NEXT:    st.d $s1, $sp, 16 # 8-byte Folded Spill
; LA64F-NEXT:    st.d $s2, $sp, 8 # 8-byte Folded Spill
; LA64F-NEXT:    st.d $s3, $sp, 0 # 8-byte Folded Spill
; LA64F-NEXT:    move $fp, $a1
; LA64F-NEXT:    move $s0, $a0
; LA64F-NEXT:    ld.d $a0, $a0, 56
; LA64F-NEXT:    lu52i.d $s1, $zero, 1025
; LA64F-NEXT:    move $a1, $s1
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 56
; LA64F-NEXT:    ld.d $a0, $s0, 40
; LA64F-NEXT:    lu52i.d $s2, $zero, 1024
; LA64F-NEXT:    move $a1, $s2
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 40
; LA64F-NEXT:    ld.d $a0, $s0, 32
; LA64F-NEXT:    lu52i.d $s3, $zero, 1023
; LA64F-NEXT:    move $a1, $s3
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 32
; LA64F-NEXT:    ld.d $a0, $s0, 24
; LA64F-NEXT:    move $a1, $s1
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 24
; LA64F-NEXT:    ld.d $a0, $s0, 8
; LA64F-NEXT:    move $a1, $s2
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 8
; LA64F-NEXT:    ld.d $a0, $s0, 0
; LA64F-NEXT:    move $a1, $s3
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 0
; LA64F-NEXT:    ori $a0, $zero, 0
; LA64F-NEXT:    lu32i.d $a0, -524288
; LA64F-NEXT:    lu52i.d $s1, $a0, 1024
; LA64F-NEXT:    ld.d $a0, $s0, 48
; LA64F-NEXT:    move $a1, $s1
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 48
; LA64F-NEXT:    ld.d $a0, $s0, 16
; LA64F-NEXT:    move $a1, $s1
; LA64F-NEXT:    bl %plt(__adddf3)
; LA64F-NEXT:    st.d $a0, $fp, 16
; LA64F-NEXT:    ld.d $s3, $sp, 0 # 8-byte Folded Reload
; LA64F-NEXT:    ld.d $s2, $sp, 8 # 8-byte Folded Reload
; LA64F-NEXT:    ld.d $s1, $sp, 16 # 8-byte Folded Reload
; LA64F-NEXT:    ld.d $s0, $sp, 24 # 8-byte Folded Reload
; LA64F-NEXT:    ld.d $fp, $sp, 32 # 8-byte Folded Reload
; LA64F-NEXT:    ld.d $ra, $sp, 40 # 8-byte Folded Reload
; LA64F-NEXT:    addi.d $sp, $sp, 48
; LA64F-NEXT:    ret
;
; LA64D-LABEL: test_d8:
; LA64D:       # %bb.0:
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI6_0)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI6_0)
; LA64D-NEXT:    fld.d $fa0, $a2, 0
; LA64D-NEXT:    fld.d $fa1, $a0, 8
; LA64D-NEXT:    fadd.d $fa1, $fa1, $fa0
; LA64D-NEXT:    fld.d $fa2, $a0, 40
; LA64D-NEXT:    fadd.d $fa0, $fa2, $fa0
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI6_1)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI6_1)
; LA64D-NEXT:    fld.d $fa2, $a2, 0
; LA64D-NEXT:    fld.d $fa3, $a0, 16
; LA64D-NEXT:    fadd.d $fa3, $fa3, $fa2
; LA64D-NEXT:    fld.d $fa4, $a0, 48
; LA64D-NEXT:    fadd.d $fa2, $fa4, $fa2
; LA64D-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI6_2)
; LA64D-NEXT:    addi.d $a2, $a2, %pc_lo12(.LCPI6_2)
; LA64D-NEXT:    fld.d $fa4, $a2, 0
; LA64D-NEXT:    fld.d $fa5, $a0, 24
; LA64D-NEXT:    fadd.d $fa5, $fa5, $fa4
; LA64D-NEXT:    fld.d $fa6, $a0, 56
; LA64D-NEXT:    fadd.d $fa4, $fa6, $fa4
; LA64D-NEXT:    fst.d $fa4, $a1, 56
; LA64D-NEXT:    fst.d $fa2, $a1, 48
; LA64D-NEXT:    fst.d $fa0, $a1, 40
; LA64D-NEXT:    fst.d $fa5, $a1, 24
; LA64D-NEXT:    fst.d $fa3, $a1, 16
; LA64D-NEXT:    fst.d $fa1, $a1, 8
; LA64D-NEXT:    addi.d $a2, $zero, 1
; LA64D-NEXT:    movgr2fr.d $fa0, $a2
; LA64D-NEXT:    ffint.d.l $fa0, $fa0
; LA64D-NEXT:    fld.d $fa1, $a0, 32
; LA64D-NEXT:    fadd.d $fa1, $fa1, $fa0
; LA64D-NEXT:    fst.d $fa1, $a1, 32
; LA64D-NEXT:    fld.d $fa1, $a0, 0
; LA64D-NEXT:    fadd.d $fa0, $fa1, $fa0
; LA64D-NEXT:    fst.d $fa0, $a1, 0
; LA64D-NEXT:    ret
  %p = load %d8, ptr %P
  %R = fadd %d8 %p, < double 1.000000e+00, double 2.000000e+00, double 3.000000e+00, double 4.000000e+00, double 1.000000e+00, double 2.000000e+00, double 3.000000e+00, double 4.000000e+00 >
  store %d8 %R, ptr %S
  ret void
}
