/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public class StackFrameStream {
    private Frame fr;
    private RegisterMap regMap;
    private boolean isDone;

    public StackFrameStream(JavaThread thread) {
        this(thread, true);
    }

    public StackFrameStream(JavaThread thread, boolean update) {
        if (!VM.getVM().isDebugging()) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(thread.hasLastJavaFrame(), "sanity check");
            }
            this.fr = thread.getLastFrame();
            this.regMap = thread.newRegisterMap(update);
            this.isDone = false;
        } else {
            this.fr = thread.getCurrentFrameGuess();
            this.regMap = thread.newRegisterMap(update);
            while (this.fr != null && !this.fr.isJavaFrame()) {
                if (this.fr.isFirstFrame()) {
                    this.fr = null;
                    continue;
                }
                this.fr = this.fr.sender(this.regMap);
            }
            if (this.fr == null) {
                this.isDone = true;
            }
        }
    }

    public boolean isDone() {
        if (this.isDone) {
            return true;
        }
        if (this.fr == null) {
            this.isDone = true;
            return true;
        }
        this.isDone = this.fr.isFirstFrame();
        return false;
    }

    public void next() {
        if (!this.isDone) {
            this.fr = this.fr.sender(this.regMap);
        }
    }

    public Frame getCurrent() {
        return this.fr;
    }

    public RegisterMap getRegisterMap() {
        return this.regMap;
    }
}

