"use strict";

require("core-js/modules/es.array.find");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.join");

require("core-js/modules/es.function.name");

require("core-js/modules/web.dom-collections.for-each");

require("jest-specific-snapshot");

var _path = _interopRequireDefault(require("path"));

var _fs = _interopRequireDefault(require("fs"));

var _tmp = _interopRequireDefault(require("tmp"));

var _crossSpawn = require("cross-spawn");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// File hierarchy:
// __testfixtures__ / some-test-case / input.*
var inputRegExp = /^input\..*$/;

var runWebComponentsAnalyzer = function runWebComponentsAnalyzer(inputPath) {
  var _tmp$dirSync = _tmp["default"].dirSync(),
      tmpDir = _tmp$dirSync.name,
      removeCallback = _tmp$dirSync.removeCallback;

  var customElementsFile = "".concat(tmpDir, "/custom-elements.json");
  (0, _crossSpawn.sync)('wca', ['analyze', inputPath, '--outFile', customElementsFile], {
    stdio: 'inherit'
  });

  var output = _fs["default"].readFileSync(customElementsFile, 'utf8');

  try {
    removeCallback();
  } catch (e) {//
  }

  return output;
};

describe('web-components component properties', function () {
  // we need to mock lit-html and dynamically require custom-elements
  // because lit-html is distributed as ESM not CJS
  // https://github.com/Polymer/lit-html/issues/516
  jest.mock('lit-html', function () {}); // eslint-disable-next-line global-require

  var _require = require('./custom-elements'),
      extractArgTypesFromElements = _require.extractArgTypesFromElements;

  var fixturesDir = _path["default"].join(__dirname, '__testfixtures__');

  _fs["default"].readdirSync(fixturesDir, {
    withFileTypes: true
  }).forEach(function (testEntry) {
    if (testEntry.isDirectory()) {
      var testDir = _path["default"].join(fixturesDir, testEntry.name);

      var testFile = _fs["default"].readdirSync(testDir).find(function (fileName) {
        return inputRegExp.test(fileName);
      });

      if (testFile) {
        it(testEntry.name, function () {
          var inputPath = _path["default"].join(testDir, testFile); // snapshot the output of wca


          var customElementsJson = runWebComponentsAnalyzer(inputPath);
          var customElements = JSON.parse(customElementsJson);
          customElements.tags.forEach(function (tag) {
            // eslint-disable-next-line no-param-reassign
            tag.path = 'dummy-path-to-component';
          });
          expect(customElements).toMatchSpecificSnapshot(_path["default"].join(testDir, 'custom-elements.snapshot')); // snapshot the properties

          var properties = extractArgTypesFromElements('input', customElements);
          expect(properties).toMatchSpecificSnapshot(_path["default"].join(testDir, 'properties.snapshot'));
        });
      }
    }
  });
});