"use strict";

var _vue = _interopRequireDefault(require("vue/dist/vue"));

var _sourceDecorator = require("./sourceDecorator");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* eslint no-underscore-dangle: ["error", { "allow": ["_vnode"] }] */
expect.addSnapshotSerializer({
  print: function print(val) {
    return val;
  },
  test: function test(val) {
    return typeof val === 'string';
  }
});

var getVNode = function getVNode(Component) {
  var vm = new _vue["default"]({
    render: function render(h) {
      return h(Component);
    }
  }).$mount();
  return vm.$children[0]._vnode;
};

describe('vnodeToString', function () {
  it('basic', function () {
    expect((0, _sourceDecorator.vnodeToString)(getVNode({
      template: "<button>Button</button>"
    }))).toMatchInlineSnapshot("<button >Button</button>");
  });
  it('static class', function () {
    expect((0, _sourceDecorator.vnodeToString)(getVNode({
      template: "<button class=\"foo bar\">Button</button>"
    }))).toMatchInlineSnapshot("<button class=\"foo bar\">Button</button>");
  });
  it('string dynamic class', function () {
    expect((0, _sourceDecorator.vnodeToString)(getVNode({
      template: "<button :class=\"'foo'\">Button</button>"
    }))).toMatchInlineSnapshot("<button class=\"foo\">Button</button>");
  });
  it('non-string dynamic class', function () {
    expect((0, _sourceDecorator.vnodeToString)(getVNode({
      template: "<button :class=\"1\">Button</button>"
    }))).toMatchInlineSnapshot("<button >Button</button>");
  });
  it('array dynamic class', function () {
    expect((0, _sourceDecorator.vnodeToString)(getVNode({
      template: "<button :class=\"['foo', null, false, 0, {bar: true, baz: false}]\">Button</button>"
    }))).toMatchInlineSnapshot("<button class=\"foo bar\">Button</button>");
  });
  it('object dynamic class', function () {
    expect((0, _sourceDecorator.vnodeToString)(getVNode({
      template: "<button :class=\"{foo: true, bar: false}\">Button</button>"
    }))).toMatchInlineSnapshot("<button class=\"foo\">Button</button>");
  });
  it('merge dynamic and static classes', function () {
    expect((0, _sourceDecorator.vnodeToString)(getVNode({
      template: "<button class=\"foo\" :class=\"{bar: null, baz: 1}\">Button</button>"
    }))).toMatchInlineSnapshot("<button class=\"foo baz\">Button</button>");
  });
  it('attributes', function () {
    var MyComponent = {
      props: ['propA', 'propB', 'propC', 'propD', 'propE', 'propF', 'propG'],
      template: '<div/>'
    };
    expect((0, _sourceDecorator.vnodeToString)(getVNode({
      components: {
        MyComponent: MyComponent
      },
      data: function data() {
        return {
          props: {
            propA: 'propA',
            propB: 1,
            propC: null,
            propD: {
              foo: 'bar'
            },
            propE: true,
            propF: function propF() {
              var foo = 'bar';
              return foo;
            },
            propG: undefined
          }
        };
      },
      template: "<my-component v-bind=\"props\"/>"
    }))).toMatchInlineSnapshot("<my-component propE :propD='{\"foo\":\"bar\"}' :propC=\"null\" :propB=\"1\" propA=\"propA\"/>");
  });
  it('children', function () {
    expect((0, _sourceDecorator.vnodeToString)(getVNode({
      template: "\n          <div>\n            <form>\n              <button>Button</button>\n            </form>\n          </div>"
    }))).toMatchInlineSnapshot("<div ><form ><button >Button</button></form></div>");
  });
});