"use strict";

require("core-js/modules/es.array.find");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.join");

require("core-js/modules/es.function.name");

require("core-js/modules/web.dom-collections.for-each");

require("jest-specific-snapshot");

var _path = _interopRequireDefault(require("path"));

var _fs = _interopRequireDefault(require("fs"));

var _core = require("@babel/core");

var _requireFromString2 = _interopRequireDefault(require("require-from-string"));

var _extractProps = require("./extractProps");

var _utils = require("../../lib/utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// File hierarchy:
// __testfixtures__ / some-test-case / input.*
var inputRegExp = /^input\..*$/;

var transformToModule = function transformToModule(inputCode) {
  var options = {
    presets: [['@babel/preset-env', {
      targets: {
        esmodules: true
      }
    }]]
  };

  var _transformSync = (0, _core.transformSync)(inputCode, options),
      code = _transformSync.code;

  return (0, _utils.normalizeNewlines)(code);
};

var annotateWithDocgen = function annotateWithDocgen(inputPath) {
  var options = {
    presets: ['@babel/typescript', '@babel/react'],
    plugins: ['babel-plugin-react-docgen', '@babel/plugin-proposal-class-properties'],
    babelrc: false
  };

  var _transformFileSync = (0, _core.transformFileSync)(inputPath, options),
      code = _transformFileSync.code;

  return (0, _utils.normalizeNewlines)(code);
};

describe('react component properties', function () {
  var fixturesDir = _path["default"].join(__dirname, '__testfixtures__');

  _fs["default"].readdirSync(fixturesDir, {
    withFileTypes: true
  }).forEach(function (testEntry) {
    if (testEntry.isDirectory()) {
      var testDir = _path["default"].join(fixturesDir, testEntry.name);

      var testFile = _fs["default"].readdirSync(testDir).find(function (fileName) {
        return inputRegExp.test(fileName);
      });

      if (testFile) {
        it(testEntry.name, function () {
          var inputPath = _path["default"].join(testDir, testFile); // snapshot the output of babel-plugin-react-docgen


          var docgenPretty = annotateWithDocgen(inputPath);
          expect(docgenPretty).toMatchSpecificSnapshot(_path["default"].join(testDir, 'docgen.snapshot')); // transform into an uglier format that's works with require-from-string

          var docgenModule = transformToModule(docgenPretty); // snapshot the output of component-properties/react

          var _requireFromString = (0, _requireFromString2["default"])(docgenModule),
              component = _requireFromString.component;

          var properties = (0, _extractProps.extractProps)(component);
          expect(properties).toMatchSpecificSnapshot(_path["default"].join(testDir, 'properties.snapshot'));
        });
      }
    }
  });
});