"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.concat");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.create");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.get-prototype-of");

require("core-js/modules/es.object.keys");

require("core-js/modules/es.object.set-prototype-of");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.reflect.construct");

require("core-js/modules/es.regexp.exec");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/es.string.replace");

require("core-js/modules/web.dom-collections.for-each");

require("core-js/modules/web.dom-collections.iterator");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _docgen = require("../../../lib/docgen");

var _handleProp = require("./handleProp");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var DOCGEN_SECTION = 'props';

function ReactComponent() {
  return /*#__PURE__*/_react["default"].createElement("div", null, "React Component!");
}

function createDocgenSection(docgenInfo) {
  return _defineProperty({}, DOCGEN_SECTION, Object.assign({}, docgenInfo));
}

function createDocgenProp(_ref2) {
  var name = _ref2.name,
      type = _ref2.type,
      others = _objectWithoutProperties(_ref2, ["name", "type"]);

  return _defineProperty({}, name, Object.assign({
    type: type,
    required: false
  }, others));
} // eslint-disable-next-line react/forbid-foreign-prop-types


function createComponent(_ref4) {
  var _ref4$propTypes = _ref4.propTypes,
      propTypes = _ref4$propTypes === void 0 ? {} : _ref4$propTypes,
      _ref4$defaultProps = _ref4.defaultProps,
      defaultProps = _ref4$defaultProps === void 0 ? {} : _ref4$defaultProps,
      _ref4$docgenInfo = _ref4.docgenInfo,
      docgenInfo = _ref4$docgenInfo === void 0 ? {} : _ref4$docgenInfo;

  var component = function component() {
    return /*#__PURE__*/_react["default"].createElement("div", null, "Hey!");
  };

  component.propTypes = propTypes;
  component.defaultProps = defaultProps; // @ts-ignore

  component.__docgenInfo = createDocgenSection(docgenInfo);
  return component;
}

function createDefaultValue(defaultValue) {
  return {
    value: defaultValue
  };
}

function extractPropDef(component, rawDefaultProp) {
  return (0, _handleProp.enhancePropTypesProp)((0, _docgen.extractComponentProps)(component, DOCGEN_SECTION)[0], rawDefaultProp);
}

describe('enhancePropTypesProp', function () {
  describe('type', function () {
    function createTestComponent(docgenInfo) {
      return createComponent({
        docgenInfo: Object.assign({}, createDocgenProp(Object.assign({
          name: 'prop'
        }, docgenInfo)))
      });
    }

    describe('custom', function () {
      describe('when raw value is available', function () {
        it('should support literal', function () {
          var component = createTestComponent({
            type: {
              name: 'custom',
              raw: 'MY_LITERAL'
            }
          });

          var _extractPropDef = extractPropDef(component),
              type = _extractPropDef.type;

          expect(type.summary).toBe('MY_LITERAL');
          expect(type.detail).toBeUndefined();
        });
        it('should support short object', function () {
          var component = createTestComponent({
            type: {
              name: 'custom',
              raw: '{\n  text: PropTypes.string.isRequired,\n}'
            }
          });

          var _extractPropDef2 = extractPropDef(component),
              type = _extractPropDef2.type;

          var expectedSummary = '{ text: string }';
          expect(type.summary.replace(/\s/g, '')).toBe(expectedSummary.replace(/\s/g, ''));
          expect(type.detail).toBeUndefined();
        });
        it('should support long object', function () {
          var component = createTestComponent({
            type: {
              name: 'custom',
              raw: '{\n  text: PropTypes.string.isRequired,\n  value1: PropTypes.string.isRequired,\n  value2: PropTypes.string.isRequired,\n  value3: PropTypes.string.isRequired,\n  value4: PropTypes.string.isRequired,\n}'
            }
          });

          var _extractPropDef3 = extractPropDef(component),
              type = _extractPropDef3.type;

          expect(type.summary).toBe('object');
          var expectedDetail = "{\n            text: string,\n            value1: string,\n            value2: string,\n            value3: string,\n            value4: string\n          }";
          expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
        });
        it('should not have a deep object as summary', function () {
          var component = createTestComponent({
            type: {
              name: 'custom',
              raw: '{\n  foo: { bar: PropTypes.string.isRequired,\n  }}'
            }
          });

          var _extractPropDef4 = extractPropDef(component),
              type = _extractPropDef4.type;

          expect(type.summary).toBe('object');
        });
        it('should use identifier of a React element when available', function () {
          var component = createTestComponent({
            type: {
              name: 'custom',
              raw: 'function InlinedFunctionalComponent() {\n  return <div>Inlined FunctionalComponent!</div>;\n}'
            }
          });

          var _extractPropDef5 = extractPropDef(component),
              type = _extractPropDef5.type;

          expect(type.summary).toBe('InlinedFunctionalComponent');
          var expectedDetail = "function InlinedFunctionalComponent() {\n            return <div>Inlined FunctionalComponent!</div>;\n          }";
          expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
        });
        it('should not use identifier of a HTML element', function () {
          var component = createTestComponent({
            type: {
              name: 'custom',
              raw: '<div>Hello world from Montreal, Quebec, Canada!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</div>'
            }
          });

          var _extractPropDef6 = extractPropDef(component),
              type = _extractPropDef6.type;

          expect(type.summary).toBe('element');
          var expectedDetail = '<div>Hello world from Montreal, Quebec, Canada!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</div>';
          expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
        });
        it('should support element without identifier', function () {
          var component = createTestComponent({
            type: {
              name: 'custom',
              raw: '() => {\n  return <div>Inlined FunctionalComponent!</div>;\n}'
            }
          });

          var _extractPropDef7 = extractPropDef(component),
              type = _extractPropDef7.type;

          expect(type.summary).toBe('element');
          var expectedDetail = "() => {\n              return <div>Inlined FunctionalComponent!</div>;\n            }";
          expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
        });
        describe('when it is not a known type', function () {
          it('should return "custom" when its a long type', function () {
            var component = createTestComponent({
              type: {
                name: 'custom',
                raw: 'Symbol("A very very very very very very lonnnngggggggggggggggggggggggggggggggggggg symbol")'
              }
            });

            var _extractPropDef8 = extractPropDef(component),
                type = _extractPropDef8.type;

            expect(type.summary).toBe('custom');
            expect(type.detail).toBe('Symbol("A very very very very very very lonnnngggggggggggggggggggggggggggggggggggg symbol")');
          });
          it('should return "custom" when its a short type', function () {
            var component = createTestComponent({
              type: {
                name: 'custom',
                raw: 'Symbol("Hey!")'
              }
            });

            var _extractPropDef9 = extractPropDef(component),
                type = _extractPropDef9.type;

            expect(type.summary).toBe('Symbol("Hey!")');
            expect(type.detail).toBeUndefined();
          });
        });
      });
      it("should return 'custom' when there is no raw value", function () {
        var component = createTestComponent({
          type: {
            name: 'custom'
          }
        });

        var _extractPropDef10 = extractPropDef(component),
            type = _extractPropDef10.type;

        expect(type.summary).toBe('custom');
      });
    });
    ['any', 'bool', 'string', 'number', 'symbol', 'object', 'element', 'elementType', 'node'].forEach(function (x) {
      it("should return '".concat(x, "' when type is ").concat(x), function () {
        var component = createTestComponent({
          type: {
            name: x
          }
        });

        var _extractPropDef11 = extractPropDef(component),
            type = _extractPropDef11.type;

        expect(type.summary).toBe(x);
      });
    });
    it('should support short shape', function () {
      var component = createTestComponent({
        type: {
          name: 'shape',
          value: {
            foo: {
              name: 'string',
              required: false
            }
          }
        }
      });

      var _extractPropDef12 = extractPropDef(component),
          type = _extractPropDef12.type;

      var expectedSummary = '{ foo: string }';
      expect(type.summary.replace(/\s/g, '')).toBe(expectedSummary.replace(/\s/g, ''));
      expect(type.detail).toBeUndefined();
    });
    it('should support long shape', function () {
      var component = createTestComponent({
        type: {
          name: 'shape',
          value: {
            foo: {
              name: 'string',
              required: false
            },
            bar: {
              name: 'string',
              required: false
            },
            another: {
              name: 'string',
              required: false
            },
            another2: {
              name: 'string',
              required: false
            },
            another3: {
              name: 'string',
              required: false
            },
            another4: {
              name: 'string',
              required: false
            }
          }
        }
      });

      var _extractPropDef13 = extractPropDef(component),
          type = _extractPropDef13.type;

      expect(type.summary).toBe('object');
      var expectedDetail = "{\n        foo: string,\n        bar: string,\n        another: string,\n        another2: string,\n        another3: string,\n        another4: string\n      }";
      expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should not have a deep shape as summary', function () {
      var component = createTestComponent({
        type: {
          name: 'shape',
          value: {
            bar: {
              name: 'shape',
              value: {
                hey: {
                  name: 'string',
                  required: false
                }
              },
              required: false
            }
          }
        }
      });

      var _extractPropDef14 = extractPropDef(component),
          type = _extractPropDef14.type;

      expect(type.summary).toBe('object');
    });
    it('should support enum of string', function () {
      var component = createTestComponent({
        type: {
          name: 'enum',
          value: [{
            value: "'News'",
            computed: false
          }, {
            value: "'Photos'",
            computed: false
          }]
        }
      });

      var _extractPropDef15 = extractPropDef(component),
          type = _extractPropDef15.type;

      expect(type.summary).toBe("'News' | 'Photos'");
    });
    it('should support enum of object', function () {
      var component = createTestComponent({
        type: {
          name: 'enum',
          value: [{
            value: '{\n  text: PropTypes.string.isRequired,\n  value: PropTypes.string.isRequired,\n}',
            computed: true
          }, {
            value: '{\n  foo: PropTypes.string,\n  bar: PropTypes.string,\n  hey: PropTypes.string,\n  ho: PropTypes.string,\n}',
            computed: true
          }]
        }
      });

      var _extractPropDef16 = extractPropDef(component),
          type = _extractPropDef16.type;

      expect(type.summary).toBe('object | object');
      var expectedDetail = "{\n          text: string,\n          value: string\n        } | {\n          foo: string,\n          bar: string,\n          hey: string,\n          ho: string\n        }";
      expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should support short object in enum summary', function () {
      var component = createTestComponent({
        type: {
          name: 'enum',
          value: [{
            value: '{\n  text: PropTypes.string.isRequired,\n}',
            computed: true
          }, {
            value: '{\n  foo: PropTypes.string,\n}',
            computed: true
          }]
        }
      });

      var _extractPropDef17 = extractPropDef(component),
          type = _extractPropDef17.type;

      expect(type.summary).toBe('{ text: string } | { foo: string }');
    });
    it('should not have a deep object in an enum summary', function () {
      var component = createTestComponent({
        type: {
          name: 'enum',
          value: [{
            value: '{\n  text: { foo: PropTypes.string.isRequired,\n }\n}',
            computed: true
          }, {
            value: '{\n  foo: PropTypes.string,\n}',
            computed: true
          }]
        }
      });

      var _extractPropDef18 = extractPropDef(component),
          type = _extractPropDef18.type;

      expect(type.summary).toBe('object | object');
    });
    it('should support enum of element', function () {
      var component = createTestComponent({
        type: {
          name: 'enum',
          value: [{
            value: '() => {\n  return <div>FunctionalComponent!</div>;\n}',
            computed: true
          }, {
            value: 'class ClassComponent extends React.PureComponent {\n  render() {\n    return <div>ClassComponent!</div>;\n  }\n}',
            computed: true
          }]
        }
      });

      var _extractPropDef19 = extractPropDef(component),
          type = _extractPropDef19.type;

      expect(type.summary).toBe('element | ClassComponent');
      var expectedDetail = "() => {\n          return <div>FunctionalComponent!</div>;\n        } | class ClassComponent extends React.PureComponent {\n          render() {\n            return <div>ClassComponent!</div>;\n          }\n        }";
      expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    describe('func', function () {
      it('should return "func" when the prop dont have a description', function () {
        var component = createTestComponent({
          type: {
            name: 'func'
          }
        });

        var _extractPropDef20 = extractPropDef(component),
            type = _extractPropDef20.type;

        expect(type.summary).toBe('func');
      });
      it('should return "func" when the prop have a description without JSDoc tags', function () {
        var component = createTestComponent({
          type: {
            name: 'func'
          },
          description: 'Hey! Hey!'
        });

        var _extractPropDef21 = extractPropDef(component),
            type = _extractPropDef21.type;

        expect(type.summary).toBe('func');
      });
      it('should return a func signature when there is JSDoc tags.', function () {
        var component = createTestComponent({
          type: {
            name: 'func'
          },
          description: '@param event\n@param data\n@returns {string}'
        });

        var _extractPropDef22 = extractPropDef(component),
            type = _extractPropDef22.type;

        expect(type.summary).toBe('(event, data) => string');
      });
    });
    it('should return the instance type when type is instanceOf', function () {
      var component = createTestComponent({
        type: {
          name: 'instanceOf',
          value: 'Set'
        }
      });

      var _extractPropDef23 = extractPropDef(component),
          type = _extractPropDef23.type;

      expect(type.summary).toBe('Set');
    });
    describe('objectOf', function () {
      it('should support objectOf primitive', function () {
        var component = createTestComponent({
          type: {
            name: 'objectOf',
            value: {
              name: 'number'
            }
          }
        });

        var _extractPropDef24 = extractPropDef(component),
            type = _extractPropDef24.type;

        expect(type.summary).toBe('objectOf(number)');
        expect(type.detail).toBeUndefined();
      });
      it('should support objectOf of identifier', function () {
        var component = createTestComponent({
          type: {
            name: 'objectOf',
            value: {
              name: 'custom',
              raw: 'NAMED_OBJECT'
            }
          }
        });

        var _extractPropDef25 = extractPropDef(component),
            type = _extractPropDef25.type;

        expect(type.summary).toBe('objectOf(NAMED_OBJECT)');
        expect(type.detail).toBeUndefined();
      });
      it('should support objectOf short object', function () {
        var component = createTestComponent({
          type: {
            name: 'objectOf',
            value: {
              name: 'custom',
              raw: '{\n  foo: PropTypes.string,\n}'
            }
          }
        });

        var _extractPropDef26 = extractPropDef(component),
            type = _extractPropDef26.type;

        expect(type.summary).toBe('objectOf({ foo: string })');
        expect(type.detail).toBeUndefined();
      });
      it('should support objectOf long object', function () {
        var component = createTestComponent({
          type: {
            name: 'objectOf',
            value: {
              name: 'custom',
              raw: '{\n  foo: PropTypes.string,\n  bar: PropTypes.string,\n  another: PropTypes.string,\n  anotherAnother: PropTypes.string,\n}'
            }
          }
        });

        var _extractPropDef27 = extractPropDef(component),
            type = _extractPropDef27.type;

        expect(type.summary).toBe('objectOf(object)');
        var expectedDetail = "objectOf({\n          foo: string,\n          bar: string,\n          another: string,\n          anotherAnother: string\n        })";
        expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      it('should not have deep object in summary', function () {
        var component = createTestComponent({
          type: {
            name: 'objectOf',
            value: {
              name: 'custom',
              raw: '{\n  foo: { bar: PropTypes.string,\n }\n}'
            }
          }
        });

        var _extractPropDef28 = extractPropDef(component),
            type = _extractPropDef28.type;

        expect(type.summary).toBe('objectOf(object)');
      });
      it('should support objectOf short shape', function () {
        var component = createTestComponent({
          type: {
            name: 'objectOf',
            value: {
              name: 'shape',
              value: {
                foo: {
                  name: 'string',
                  required: false
                }
              }
            }
          }
        });

        var _extractPropDef29 = extractPropDef(component),
            type = _extractPropDef29.type;

        expect(type.summary).toBe('objectOf({ foo: string })');
        expect(type.detail).toBeUndefined();
      });
      it('should support objectOf long shape', function () {
        var component = createTestComponent({
          type: {
            name: 'objectOf',
            value: {
              name: 'shape',
              value: {
                foo: {
                  name: 'string',
                  required: false
                },
                bar: {
                  name: 'string',
                  required: false
                },
                another: {
                  name: 'string',
                  required: false
                },
                anotherAnother: {
                  name: 'string',
                  required: false
                }
              }
            }
          }
        });

        var _extractPropDef30 = extractPropDef(component),
            type = _extractPropDef30.type;

        expect(type.summary).toBe('objectOf(object)');
        var expectedDetail = "objectOf({\n          foo: string,\n          bar: string,\n          another: string,\n          anotherAnother: string\n        })";
        expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      it('should not have a deep shape in summary', function () {
        var component = createTestComponent({
          type: {
            name: 'objectOf',
            value: {
              name: 'shape',
              value: {
                bar: {
                  name: 'shape',
                  value: {
                    hey: {
                      name: 'string',
                      required: false
                    }
                  },
                  required: false
                }
              }
            }
          }
        });

        var _extractPropDef31 = extractPropDef(component),
            type = _extractPropDef31.type;

        expect(type.summary).toBe('objectOf(object)');
      });
    });
    it('should support union', function () {
      var component = createTestComponent({
        type: {
          name: 'union',
          value: [{
            name: 'string'
          }, {
            name: 'instanceOf',
            value: 'Set'
          }]
        }
      });

      var _extractPropDef32 = extractPropDef(component),
          type = _extractPropDef32.type;

      expect(type.summary).toBe('string | Set');
      expect(type.detail).toBeUndefined();
    });
    describe('array', function () {
      it('should support array of primitive', function () {
        var component = createTestComponent({
          type: {
            name: 'arrayOf',
            value: {
              name: 'number'
            }
          }
        });

        var _extractPropDef33 = extractPropDef(component),
            type = _extractPropDef33.type;

        expect(type.summary).toBe('number[]');
        expect(type.detail).toBeUndefined();
      });
      it('should support array of identifier', function () {
        var component = createTestComponent({
          type: {
            name: 'arrayOf',
            value: {
              name: 'custom',
              raw: 'NAMED_OBJECT'
            }
          }
        });

        var _extractPropDef34 = extractPropDef(component),
            type = _extractPropDef34.type;

        expect(type.summary).toBe('NAMED_OBJECT[]');
        expect(type.detail).toBeUndefined();
      });
      it('should support array of short object', function () {
        var component = createTestComponent({
          type: {
            name: 'arrayOf',
            value: {
              name: 'custom',
              raw: '{\n  foo: PropTypes.string,\n}'
            }
          }
        });

        var _extractPropDef35 = extractPropDef(component),
            type = _extractPropDef35.type;

        expect(type.summary).toBe('[{ foo: string }]');
        expect(type.detail).toBeUndefined();
      });
      it('should support array of long object', function () {
        var component = createTestComponent({
          type: {
            name: 'arrayOf',
            value: {
              name: 'custom',
              raw: '{\n  text: PropTypes.string.isRequired,\n  value: PropTypes.string.isRequired,\n  another: PropTypes.string.isRequired,\n  another2: PropTypes.string.isRequired,\n  another3: PropTypes.string.isRequired,\n  another4: PropTypes.string.isRequired,\n}'
            }
          }
        });

        var _extractPropDef36 = extractPropDef(component),
            type = _extractPropDef36.type;

        expect(type.summary).toBe('object[]');
        var expectedDetail = "[{\n          text: string,\n          value: string,\n          another: string,\n          another2: string,\n          another3: string,\n          another4: string\n        }]";
        expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      it('should not have deep object in summary', function () {
        var component = createTestComponent({
          type: {
            name: 'arrayOf',
            value: {
              name: 'custom',
              raw: '{\n  foo: { bar: PropTypes.string, }\n}'
            }
          }
        });

        var _extractPropDef37 = extractPropDef(component),
            type = _extractPropDef37.type;

        expect(type.summary).toBe('object[]');
      });
      it('should support array of short shape', function () {
        var component = createTestComponent({
          type: {
            name: 'arrayOf',
            value: {
              name: 'shape',
              value: {
                foo: {
                  name: 'string',
                  required: false
                }
              }
            }
          }
        });

        var _extractPropDef38 = extractPropDef(component),
            type = _extractPropDef38.type;

        expect(type.summary).toBe('[{ foo: string }]');
        expect(type.detail).toBeUndefined();
      });
      it('should support array of long shape', function () {
        var component = createTestComponent({
          type: {
            name: 'arrayOf',
            value: {
              name: 'shape',
              value: {
                foo: {
                  name: 'string',
                  required: false
                },
                bar: {
                  name: 'string',
                  required: false
                },
                another: {
                  name: 'string',
                  required: false
                },
                another2: {
                  name: 'string',
                  required: false
                },
                another3: {
                  name: 'string',
                  required: false
                },
                another4: {
                  name: 'string',
                  required: false
                }
              }
            }
          }
        });

        var _extractPropDef39 = extractPropDef(component),
            type = _extractPropDef39.type;

        expect(type.summary).toBe('object[]');
        var expectedDetail = "[{\n          foo: string,\n          bar: string,\n          another: string,\n          another2: string,\n          another3: string,\n          another4: string\n        }]";
        expect(type.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      it('should not have deep shape in summary', function () {
        var component = createTestComponent({
          type: {
            name: 'arrayOf',
            value: {
              name: 'shape',
              value: {
                bar: {
                  name: 'shape',
                  value: {
                    hey: {
                      name: 'string',
                      required: false
                    }
                  },
                  required: false
                }
              }
            }
          }
        });

        var _extractPropDef40 = extractPropDef(component),
            type = _extractPropDef40.type;

        expect(type.summary).toBe('object[]');
      });
    });
  });
  describe('defaultValue', function () {
    function createTestComponent(defaultValue) {
      var typeName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'anything-is-fine';
      return createComponent({
        docgenInfo: Object.assign({}, createDocgenProp({
          name: 'prop',
          type: {
            name: typeName
          },
          defaultValue: defaultValue
        }))
      });
    }

    it('should support short object', function () {
      var component = createTestComponent(createDefaultValue("{ foo: 'foo', bar: 'bar' }"));

      var _extractPropDef41 = extractPropDef(component),
          defaultValue = _extractPropDef41.defaultValue;

      var expectedSummary = "{ foo: 'foo', bar: 'bar' }";
      expect(defaultValue.summary.replace(/\s/g, '')).toBe(expectedSummary.replace(/\s/g, ''));
      expect(defaultValue.detail).toBeUndefined();
    });
    it('should support long object', function () {
      var component = createTestComponent(createDefaultValue("{ foo: 'foo', bar: 'bar', another: 'another' }"));

      var _extractPropDef42 = extractPropDef(component),
          defaultValue = _extractPropDef42.defaultValue;

      expect(defaultValue.summary).toBe('object');
      var expectedDetail = "{\n        foo: 'foo',\n        bar: 'bar',\n        another: 'another'\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should not have deep object in summary', function () {
      var component = createTestComponent(createDefaultValue("{ foo: 'foo', bar: { hey: 'ho' } }"));

      var _extractPropDef43 = extractPropDef(component),
          defaultValue = _extractPropDef43.defaultValue;

      expect(defaultValue.summary).toBe('object');
    });
    it('should support short function', function () {
      var component = createTestComponent(createDefaultValue('() => {}'));

      var _extractPropDef44 = extractPropDef(component),
          defaultValue = _extractPropDef44.defaultValue;

      expect(defaultValue.summary).toBe('() => {}');
      expect(defaultValue.detail).toBeUndefined();
    });
    it('should support long function', function () {
      var component = createTestComponent(createDefaultValue('(foo, bar) => {\n  const concat = foo + bar;\n  const append = concat + " hey!";\n  \n  return append;\n}'));

      var _extractPropDef45 = extractPropDef(component),
          defaultValue = _extractPropDef45.defaultValue;

      expect(defaultValue.summary).toBe('func');
      var expectedDetail = "(foo, bar) => {\n        const concat = foo + bar;\n        const append = concat + ' hey!';\n        return append\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should use the name of function when available and indicate that args are present', function () {
      var component = createTestComponent(createDefaultValue('function concat(a, b) {\n  return a + b;\n}'));

      var _extractPropDef46 = extractPropDef(component),
          defaultValue = _extractPropDef46.defaultValue;

      expect(defaultValue.summary).toBe('concat( ... )');
      var expectedDetail = "function concat(a, b) {\n        return a + b\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should use the name of function when available', function () {
      var component = createTestComponent(createDefaultValue('function hello() {\n  return "hello";\n}'));

      var _extractPropDef47 = extractPropDef(component),
          defaultValue = _extractPropDef47.defaultValue;

      expect(defaultValue.summary).toBe('hello()');
      var expectedDetail = "function hello() {\n        return 'hello'\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should support short element', function () {
      var component = createTestComponent(createDefaultValue('<div>Hey!</div>'));

      var _extractPropDef48 = extractPropDef(component),
          defaultValue = _extractPropDef48.defaultValue;

      expect(defaultValue.summary).toBe('<div>Hey!</div>');
      expect(defaultValue.detail).toBeUndefined();
    });
    it('should support long element', function () {
      var component = createTestComponent(createDefaultValue('<div>Hey! Hey! Hey!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</div>'));

      var _extractPropDef49 = extractPropDef(component),
          defaultValue = _extractPropDef49.defaultValue;

      expect(defaultValue.summary).toBe('element');
      expect(defaultValue.detail).toBe('<div>Hey! Hey! Hey!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</div>');
    });
    it('should support element with props', function () {
      var component = createTestComponent(createDefaultValue('<Component className="toto" />'));

      var _extractPropDef50 = extractPropDef(component),
          defaultValue = _extractPropDef50.defaultValue;

      expect(defaultValue.summary).toBe('<Component />');
      expect(defaultValue.detail).toBe('<Component className="toto" />');
    });
    it("should use the name of the React component when it's available", function () {
      var component = createTestComponent(createDefaultValue('function InlinedFunctionalComponent() {\n  return <div>Inlined FunctionalComponent!</div>;\n}'));

      var _extractPropDef51 = extractPropDef(component),
          defaultValue = _extractPropDef51.defaultValue;

      expect(defaultValue.summary).toBe('<InlinedFunctionalComponent />');
      var expectedDetail = "function InlinedFunctionalComponent() {\n        return <div>Inlined FunctionalComponent!</div>;\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should not use the name of an HTML element', function () {
      var component = createTestComponent(createDefaultValue('<div>Hey!</div>'));

      var _extractPropDef52 = extractPropDef(component),
          defaultValue = _extractPropDef52.defaultValue;

      expect(defaultValue.summary).not.toBe('<div />');
    });
    it('should support short array', function () {
      var component = createTestComponent(createDefaultValue('[1]'));

      var _extractPropDef53 = extractPropDef(component),
          defaultValue = _extractPropDef53.defaultValue;

      expect(defaultValue.summary).toBe('[1]');
      expect(defaultValue.detail).toBeUndefined();
    });
    it('should support long array', function () {
      var component = createTestComponent(createDefaultValue('[\n  {\n    thing: {\n      id: 2,\n      func: () => {},\n      arr: [],\n    },\n  },\n]'));

      var _extractPropDef54 = extractPropDef(component),
          defaultValue = _extractPropDef54.defaultValue;

      expect(defaultValue.summary).toBe('array');
      var expectedDetail = "[{\n          thing: {\n            id: 2,\n            func: () => {\n            },\n            arr: []\n          }\n        }]";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should not have deep array in summary', function () {
      var component = createTestComponent(createDefaultValue('[[[1]]]'));

      var _extractPropDef55 = extractPropDef(component),
          defaultValue = _extractPropDef55.defaultValue;

      expect(defaultValue.summary).toBe('array');
    });
    describe('fromRawDefaultProp', function () {
      [{
        type: 'string',
        defaultProp: 'foo'
      }, {
        type: 'number',
        defaultProp: 1
      }, {
        type: 'boolean',
        defaultProp: true
      }, {
        type: 'symbol',
        defaultProp: Symbol('hey!')
      }].forEach(function (x) {
        it("should support ".concat(x.type), function () {
          var component = createTestComponent(null);

          var _extractPropDef56 = extractPropDef(component, x.defaultProp),
              defaultValue = _extractPropDef56.defaultValue;

          expect(defaultValue.summary).toBe(x.defaultProp.toString());
          expect(defaultValue.detail).toBeUndefined();
        });
      });
      it('should support array of primitives', function () {
        var component = createTestComponent(null);

        var _extractPropDef57 = extractPropDef(component, [1, 2, 3]),
            defaultValue = _extractPropDef57.defaultValue;

        expect(defaultValue.summary).toBe('[1,    2,    3]');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support array of short object', function () {
        var component = createTestComponent(null);

        var _extractPropDef58 = extractPropDef(component, [{
          foo: 'bar'
        }]),
            defaultValue = _extractPropDef58.defaultValue;

        expect(defaultValue.summary).toBe("[{ 'foo': 'bar' }]");
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support array of long object', function () {
        var component = createTestComponent(null);

        var _extractPropDef59 = extractPropDef(component, [{
          foo: 'bar',
          bar: 'foo',
          hey: 'ho'
        }]),
            defaultValue = _extractPropDef59.defaultValue;

        expect(defaultValue.summary).toBe('array');
        var expectedDetail = "[{\n          'foo': 'bar',\n          'bar': 'foo',\n          'hey': 'ho'\n        }]";
        expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      it('should support short object', function () {
        var component = createTestComponent(null);

        var _extractPropDef60 = extractPropDef(component, {
          foo: 'bar'
        }),
            defaultValue = _extractPropDef60.defaultValue;

        expect(defaultValue.summary).toBe("{ 'foo': 'bar' }");
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support long object', function () {
        var component = createTestComponent(null);

        var _extractPropDef61 = extractPropDef(component, {
          foo: 'bar',
          bar: 'foo',
          hey: 'ho'
        }),
            defaultValue = _extractPropDef61.defaultValue;

        expect(defaultValue.summary).toBe('object');
        var expectedDetail = "{\n          'foo': 'bar',\n          'bar': 'foo',\n          'hey': 'ho'\n        }";
        expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      it('should support anonymous function', function () {
        var component = createTestComponent(null);

        var _extractPropDef62 = extractPropDef(component, function () {
          return 'hey!';
        }),
            defaultValue = _extractPropDef62.defaultValue;

        expect(defaultValue.summary).toBe('func');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support named function', function () {
        var component = createTestComponent(null);

        var _extractPropDef63 = extractPropDef(component, function hello() {
          return 'world!';
        }),
            defaultValue = _extractPropDef63.defaultValue;

        expect(defaultValue.summary).toBe('hello()');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support named function with params', function () {
        var component = createTestComponent(null);

        var _extractPropDef64 = extractPropDef(component, function add(a, b) {
          return a + b;
        }),
            defaultValue = _extractPropDef64.defaultValue;

        expect(defaultValue.summary).toBe('add( ... )');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support React element', function () {
        var component = createTestComponent(null);

        var defaultProp = /*#__PURE__*/_react["default"].createElement(ReactComponent, null); // Simulate babel-plugin-add-react-displayname.


        defaultProp.type.displayName = 'ReactComponent';

        var _extractPropDef65 = extractPropDef(component, defaultProp),
            defaultValue = _extractPropDef65.defaultValue;

        expect(defaultValue.summary).toBe('<ReactComponent />');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support React element with props', function () {
        var component = createTestComponent(null); // @ts-ignore

        var defaultProp = /*#__PURE__*/_react["default"].createElement(ReactComponent, {
          className: "toto"
        }); // Simulate babel-plugin-add-react-displayname.


        defaultProp.type.displayName = 'ReactComponent';

        var _extractPropDef66 = extractPropDef(component, defaultProp),
            defaultValue = _extractPropDef66.defaultValue;

        expect(defaultValue.summary).toBe('<ReactComponent />');
        expect(defaultValue.detail).toBe('<ReactComponent className="toto" />');
      });
      it('should support short HTML element', function () {
        var component = createTestComponent(null);

        var _extractPropDef67 = extractPropDef(component, /*#__PURE__*/_react["default"].createElement("div", null, "HTML element")),
            defaultValue = _extractPropDef67.defaultValue;

        expect(defaultValue.summary).toBe('<div>HTML element</div>');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support long HTML element', function () {
        var component = createTestComponent(null);

        var _extractPropDef68 = extractPropDef(component, /*#__PURE__*/_react["default"].createElement("div", null, "HTML element!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")),
            defaultValue = _extractPropDef68.defaultValue;

        expect(defaultValue.summary).toBe('element');
        var expectedDetail = "<div>\n          HTML element!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n        </div>";
        expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      ['element', 'elementType'].forEach(function (x) {
        it("should support inlined React class component for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef69 = extractPropDef(component, /*#__PURE__*/function (_React$PureComponent) {
            _inherits(InlinedClassComponent, _React$PureComponent);

            var _super = _createSuper(InlinedClassComponent);

            function InlinedClassComponent() {
              _classCallCheck(this, InlinedClassComponent);

              return _super.apply(this, arguments);
            }

            _createClass(InlinedClassComponent, [{
              key: "render",
              value: function render() {
                return /*#__PURE__*/_react["default"].createElement("div", null, "Inlined ClassComponent!");
              }
            }]);

            return InlinedClassComponent;
          }(_react["default"].PureComponent)),
              defaultValue = _extractPropDef69.defaultValue;

          expect(defaultValue.summary).toBe('<InlinedClassComponent />');
          expect(defaultValue.detail).toBeUndefined();
        });
        it("should support inlined anonymous React functional component for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef70 = extractPropDef(component, function () {
            return /*#__PURE__*/_react["default"].createElement("div", null, "Inlined FunctionalComponent!");
          }),
              defaultValue = _extractPropDef70.defaultValue;

          expect(defaultValue.summary).toBe('element');
          expect(defaultValue.detail).toBeUndefined();
        });
        it("should support inlined anonymous React functional component with props for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef71 = extractPropDef(component, function (_ref5) {
            var foo = _ref5.foo;
            return /*#__PURE__*/_react["default"].createElement("div", null, foo);
          }),
              defaultValue = _extractPropDef71.defaultValue;

          expect(defaultValue.summary).toBe('element');
          expect(defaultValue.detail).toBeUndefined();
        });
        it("should support inlined named React functional component for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef72 = extractPropDef(component, function InlinedFunctionalComponent() {
            return /*#__PURE__*/_react["default"].createElement("div", null, "Inlined FunctionalComponent!");
          }),
              defaultValue = _extractPropDef72.defaultValue;

          expect(defaultValue.summary).toBe('<InlinedFunctionalComponent />');
          expect(defaultValue.detail).toBeUndefined();
        });
        it("should support inlined named React functional component with props for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef73 = extractPropDef(component, function InlinedFunctionalComponent(_ref6) {
            var foo = _ref6.foo;
            return /*#__PURE__*/_react["default"].createElement("div", null, foo);
          }),
              defaultValue = _extractPropDef73.defaultValue;

          expect(defaultValue.summary).toBe('<InlinedFunctionalComponent />');
          expect(defaultValue.detail).toBeUndefined();
        });
      });
    });
  });
});
describe('enhancePropTypesProps', function () {
  it('should keep the original definition order', function () {
    var component = createComponent({
      propTypes: {
        foo: _propTypes["default"].string,
        middleWithDefaultValue: _propTypes["default"].string,
        bar: _propTypes["default"].string,
        endWithDefaultValue: _propTypes["default"].string
      },
      docgenInfo: Object.assign({}, createDocgenProp({
        name: 'middleWithDefaultValue',
        type: {
          name: 'string'
        },
        defaultValue: {
          value: 'Middle!'
        }
      }), createDocgenProp({
        name: 'endWithDefaultValue',
        type: {
          name: 'string'
        },
        defaultValue: {
          value: 'End!'
        }
      }), createDocgenProp({
        name: 'foo',
        type: {
          name: 'string'
        }
      }), createDocgenProp({
        name: 'bar',
        type: {
          name: 'string'
        }
      }))
    });
    var props = (0, _handleProp.enhancePropTypesProps)((0, _docgen.extractComponentProps)(component, DOCGEN_SECTION), component);
    expect(props.length).toBe(4);
    expect(props[0].name).toBe('foo');
    expect(props[1].name).toBe('middleWithDefaultValue');
    expect(props[2].name).toBe('bar');
    expect(props[3].name).toBe('endWithDefaultValue');
  });
  it('should not include @ignore props', function () {
    var component = createComponent({
      propTypes: {
        foo: _propTypes["default"].string,
        bar: _propTypes["default"].string
      },
      docgenInfo: Object.assign({}, createDocgenProp({
        name: 'foo',
        type: {
          name: 'string'
        }
      }), createDocgenProp({
        name: 'bar',
        type: {
          name: 'string'
        },
        description: '@ignore'
      }))
    });
    var props = (0, _handleProp.enhancePropTypesProps)((0, _docgen.extractComponentProps)(component, DOCGEN_SECTION), component);
    expect(props.length).toBe(1);
    expect(props[0].name).toBe('foo');
  });
});