"use strict";

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.map");

require("core-js/modules/web.dom-collections.for-each");

var _react = _interopRequireDefault(require("react"));

var _range = _interopRequireDefault(require("lodash/range"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _addons = _interopRequireDefault(require("@storybook/addons"));

var _jsxDecorator = require("./jsxDecorator");

var _shared = require("../../shared");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* eslint-disable jsx-a11y/no-static-element-interactions, jsx-a11y/click-events-have-key-events */
jest.mock('@storybook/addons');
var mockedAddons = _addons["default"];
expect.addSnapshotSerializer({
  print: function print(val) {
    return val;
  },
  test: function test(val) {
    return typeof val === 'string';
  }
});
describe('renderJsx', function () {
  it('basic', function () {
    expect((0, _jsxDecorator.renderJsx)( /*#__PURE__*/_react["default"].createElement("div", null, "hello"), {})).toMatchInlineSnapshot("\n      <div>\n        hello\n      </div>\n    ");
  });
  it('functions', function () {
    // eslint-disable-next-line no-console
    var onClick = function onClick() {
      return console.log('onClick');
    };

    expect((0, _jsxDecorator.renderJsx)( /*#__PURE__*/_react["default"].createElement("div", {
      onClick: onClick
    }, "hello"), {})).toMatchInlineSnapshot("\n      <div onClick={() => {}}>\n        hello\n      </div>\n    ");
  });
  it('undefined values', function () {
    expect((0, _jsxDecorator.renderJsx)( /*#__PURE__*/_react["default"].createElement("div", {
      className: undefined
    }, "hello"), {})).toMatchInlineSnapshot("\n      <div>\n        hello\n      </div>\n    ");
  });
  it('null values', function () {
    expect((0, _jsxDecorator.renderJsx)( /*#__PURE__*/_react["default"].createElement("div", {
      className: null
    }, "hello"), {})).toMatchInlineSnapshot("\n      <div className={null}>\n        hello\n      </div>\n    ");
  });
  it('large objects', function () {
    var obj = {};
    (0, _range["default"])(20).forEach(function (i) {
      obj["key_".concat(i)] = "val_".concat(i);
    });
    expect((0, _jsxDecorator.renderJsx)( /*#__PURE__*/_react["default"].createElement("div", {
      "data-val": obj
    }), {})).toMatchInlineSnapshot("\n      <div\n        data-val={{\n          key_0: 'val_0',\n          key_1: 'val_1',\n          key_10: 'val_10',\n          key_11: 'val_11',\n          key_12: 'val_12',\n          key_13: 'val_13',\n          key_14: 'val_14',\n          key_15: 'val_15',\n          key_16: 'val_16',\n          key_17: 'val_17',\n          key_18: 'val_18',\n          key_19: 'val_19',\n          key_2: 'val_2',\n          key_3: 'val_3',\n          key_4: 'val_4',\n          key_5: 'val_5',\n          key_6: 'val_6',\n          key_7: 'val_7',\n          key_8: 'val_8',\n          key_9: 'val_9'\n        }}\n       />\n    ");
  });
  it('long arrays', function () {
    var arr = (0, _range["default"])(20).map(function (i) {
      return "item ".concat(i);
    });
    expect((0, _jsxDecorator.renderJsx)( /*#__PURE__*/_react["default"].createElement("div", {
      "data-val": arr
    }), {})).toMatchInlineSnapshot("\n      <div\n        data-val={[\n          'item 0',\n          'item 1',\n          'item 2',\n          'item 3',\n          'item 4',\n          'item 5',\n          'item 6',\n          'item 7',\n          'item 8',\n          'item 9',\n          'item 10',\n          'item 11',\n          'item 12',\n          'item 13',\n          'item 14',\n          'item 15',\n          'item 16',\n          'item 17',\n          'item 18',\n          'item 19'\n        ]}\n       />\n    ");
  });
  it('forwardRef component', function () {
    var MyExoticComponent = /*#__PURE__*/_react["default"].forwardRef(function MyExoticComponent(props, _ref) {
      return /*#__PURE__*/_react["default"].createElement("div", null, props.children);
    });

    expect((0, _jsxDecorator.renderJsx)( /*#__PURE__*/_react["default"].createElement(MyExoticComponent, null, "I'm forwardRef!"), {})).toMatchInlineSnapshot("\n        <MyExoticComponent>\n          I'm forwardRef!\n        </MyExoticComponent>\n      ");
  });
  it('memo component', function () {
    var MyMemoComponent = /*#__PURE__*/_react["default"].memo(function MyMemoComponent(props) {
      return /*#__PURE__*/_react["default"].createElement("div", null, props.children);
    });

    expect((0, _jsxDecorator.renderJsx)( /*#__PURE__*/_react["default"].createElement(MyMemoComponent, null, "I'm memo!"), {})).toMatchInlineSnapshot("\n      <MyMemoComponent>\n        I'm memo!\n      </MyMemoComponent>\n    ");
  });
  it('should not add default props to string if the prop value has not changed', function () {
    var Container = function Container(_ref2) {
      var className = _ref2.className,
          children = _ref2.children;
      return /*#__PURE__*/_react["default"].createElement("div", {
        className: className
      }, children);
    };

    Container.propTypes = {
      children: _propTypes["default"].string.isRequired,
      className: _propTypes["default"].string
    };
    Container.defaultProps = {
      className: 'super-container'
    };
    expect((0, _jsxDecorator.renderJsx)( /*#__PURE__*/_react["default"].createElement(Container, null, "yo dude"), {})).toMatchInlineSnapshot("\n      <Container className=\"super-container\">\n        yo dude\n      </Container>\n    ");
  });
}); // @ts-ignore

var makeContext = function makeContext(name, parameters, args) {
  return {
    id: "jsx-test--".concat(name),
    kind: 'js-text',
    name: name,
    parameters: parameters,
    args: args
  };
};

describe('jsxDecorator', function () {
  var mockChannel;
  beforeEach(function () {
    mockedAddons.getChannel.mockReset();
    mockChannel = {
      on: jest.fn(),
      emit: jest.fn()
    };
    mockedAddons.getChannel.mockReturnValue(mockChannel);
  });
  it('should render dynamically for args stories', function () {
    var storyFn = function storyFn(args) {
      return /*#__PURE__*/_react["default"].createElement("div", null, "args story");
    };

    var context = makeContext('args', {
      __isArgsStory: true
    }, {});
    (0, _jsxDecorator.jsxDecorator)(storyFn, context);
    expect(mockChannel.emit).toHaveBeenCalledWith(_shared.SNIPPET_RENDERED, 'jsx-test--args', '<div>\n  args story\n</div>');
  });
  it('should skip dynamic rendering for no-args stories', function () {
    var storyFn = function storyFn() {
      return /*#__PURE__*/_react["default"].createElement("div", null, "classic story");
    };

    var context = makeContext('classic', {}, {});
    (0, _jsxDecorator.jsxDecorator)(storyFn, context);
    expect(mockChannel.emit).not.toHaveBeenCalled();
  }); // This is deprecated, but still test it

  it('allows the snippet output to be modified by onBeforeRender', function () {
    var storyFn = function storyFn(args) {
      return /*#__PURE__*/_react["default"].createElement("div", null, "args story");
    };

    var onBeforeRender = function onBeforeRender(dom) {
      return "<p>".concat(dom, "</p>");
    };

    var jsx = {
      onBeforeRender: onBeforeRender
    };
    var context = makeContext('args', {
      __isArgsStory: true,
      jsx: jsx
    }, {});
    (0, _jsxDecorator.jsxDecorator)(storyFn, context);
    expect(mockChannel.emit).toHaveBeenCalledWith(_shared.SNIPPET_RENDERED, 'jsx-test--args', '<p><div>\n  args story\n</div></p>');
  });
  it('allows the snippet output to be modified by transformSource', function () {
    var storyFn = function storyFn(args) {
      return /*#__PURE__*/_react["default"].createElement("div", null, "args story");
    };

    var transformSource = function transformSource(dom) {
      return "<p>".concat(dom, "</p>");
    };

    var jsx = {
      transformSource: transformSource
    };
    var context = makeContext('args', {
      __isArgsStory: true,
      jsx: jsx
    }, {});
    (0, _jsxDecorator.jsxDecorator)(storyFn, context);
    expect(mockChannel.emit).toHaveBeenCalledWith(_shared.SNIPPET_RENDERED, 'jsx-test--args', '<p><div>\n  args story\n</div></p>');
  });
  it('provides the story context to transformSource', function () {
    var storyFn = function storyFn(args) {
      return /*#__PURE__*/_react["default"].createElement("div", null, "args story");
    };

    var transformSource = jest.fn();
    var jsx = {
      transformSource: transformSource
    };
    var context = makeContext('args', {
      __isArgsStory: true,
      jsx: jsx
    }, {});
    (0, _jsxDecorator.jsxDecorator)(storyFn, context);
    expect(transformSource).toHaveBeenCalledWith('<div>\n  args story\n</div>', context);
  });
});