"use strict";

var _compodoc = require("./compodoc");

var makeProperty = function makeProperty(compodocType) {
  return {
    type: compodocType,
    name: 'dummy',
    decorators: [],
    optional: true
  };
};

describe('extractType', function () {
  describe('with compodoc type', function () {
    it.each([['string', {
      name: 'string'
    }], ['boolean', {
      name: 'boolean'
    }], ['number', {
      name: 'number'
    }], ['object', {
      name: 'object'
    }], ['foo', {
      name: 'object'
    }], [null, {
      name: 'void'
    }], [undefined, {
      name: 'void'
    }], ['T[]', {
      name: 'object'
    }], ['[]', {
      name: 'object'
    }], ['"primary" | "secondary"', {
      name: 'enum',
      value: ['primary', 'secondary']
    }]])('%s', function (compodocType, expected) {
      expect((0, _compodoc.extractType)(makeProperty(compodocType), null)).toEqual(expected);
    });
  });
  describe('without compodoc type', function () {
    it.each([['string', {
      name: 'string'
    }], ['', {
      name: 'string'
    }], [false, {
      name: 'boolean'
    }], [10, {
      name: 'number'
    }], [['abc'], {
      name: 'object'
    }], [{
      foo: 1
    }, {
      name: 'object'
    }], [undefined, {
      name: 'void'
    }]])('%s', function (defaultValue, expected) {
      expect((0, _compodoc.extractType)(makeProperty(null), defaultValue)).toEqual(expected);
    });
  });
});