/*
 * Copyright (c) 2020 Alibaba Group Holding Limited. All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. Alibaba designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*
 * @test
 * @summary Test the config compatibility in different wisp version
 * @requires os.family == "linux"
 * @library /lib/testlibrary
 * @run main ConfigurationCompatibilityCheckTest
 */

import java.util.ArrayList;
import java.util.Arrays;

public class ConfigurationCompatibilityCheckTest {
    public static void main(String[] args) throws Exception {
        incompatibility("-Dcom.alibaba.wisp.enableThreadAsWisp=true");
        incompatibility("-Dcom.alibaba.wisp.enableThreadAsWisp=true", "-Dcom.alibaba.wisp.transparentWispSwitch=false");
        incompatibility("-Dcom.alibaba.wisp.allThreadAsWisp=true");
        incompatibility("-Dcom.alibaba.wisp.allThreadAsWisp=true", "-Dcom.alibaba.wisp.enableThreadAsWisp=false");
        incompatibility("-Dcom.alibaba.wisp.useCarrierAsPoller=true", "-Dcom.alibaba.wisp.allThreadAsWisp=false");
    }

    private static void incompatibility(String... args) throws Exception {
        ArrayList<String> list = new ArrayList<>();
        list.add("-XX:+UnlockExperimentalVMOptions");
        list.add("-XX:+EnableCoroutine");
        list.addAll(Arrays.asList(args));
        list.add("-version");
        ProcessBuilder pb = jdk.testlibrary.ProcessTools.createJavaProcessBuilder(list.toArray(new String[0]));
        jdk.testlibrary.OutputAnalyzer output = new jdk.testlibrary.OutputAnalyzer(pb.start());
        output.shouldContain("IllegalArgumentException");
    }
}
