﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/inspector2/model/VulnerabilitySource.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace Inspector2
  {
    namespace Model
    {
      namespace VulnerabilitySourceMapper
      {

        static const int NVD_HASH = HashingUtils::HashString("NVD");


        VulnerabilitySource GetVulnerabilitySourceForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == NVD_HASH)
          {
            return VulnerabilitySource::NVD;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<VulnerabilitySource>(hashCode);
          }

          return VulnerabilitySource::NOT_SET;
        }

        Aws::String GetNameForVulnerabilitySource(VulnerabilitySource enumValue)
        {
          switch(enumValue)
          {
          case VulnerabilitySource::NVD:
            return "NVD";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace VulnerabilitySourceMapper
    } // namespace Model
  } // namespace Inspector2
} // namespace Aws
