﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/inspector2/model/AtigData.h>
#include <aws/inspector2/model/CisaData.h>
#include <aws/inspector2/model/Cvss2.h>
#include <aws/inspector2/model/Cvss3.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/inspector2/model/Epss.h>
#include <aws/inspector2/model/ExploitObserved.h>
#include <aws/inspector2/model/VulnerabilitySource.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Inspector2
{
namespace Model
{

  /**
   * <p>Contains details about a specific vulnerability Amazon Inspector can
   * detect.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Vulnerability">AWS
   * API Reference</a></p>
   */
  class Vulnerability
  {
  public:
    AWS_INSPECTOR2_API Vulnerability();
    AWS_INSPECTOR2_API Vulnerability(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Vulnerability& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>An object that contains information about the Amazon Web Services Threat
     * Intel Group (ATIG) details for the vulnerability.</p>
     */
    inline const AtigData& GetAtigData() const{ return m_atigData; }

    /**
     * <p>An object that contains information about the Amazon Web Services Threat
     * Intel Group (ATIG) details for the vulnerability.</p>
     */
    inline bool AtigDataHasBeenSet() const { return m_atigDataHasBeenSet; }

    /**
     * <p>An object that contains information about the Amazon Web Services Threat
     * Intel Group (ATIG) details for the vulnerability.</p>
     */
    inline void SetAtigData(const AtigData& value) { m_atigDataHasBeenSet = true; m_atigData = value; }

    /**
     * <p>An object that contains information about the Amazon Web Services Threat
     * Intel Group (ATIG) details for the vulnerability.</p>
     */
    inline void SetAtigData(AtigData&& value) { m_atigDataHasBeenSet = true; m_atigData = std::move(value); }

    /**
     * <p>An object that contains information about the Amazon Web Services Threat
     * Intel Group (ATIG) details for the vulnerability.</p>
     */
    inline Vulnerability& WithAtigData(const AtigData& value) { SetAtigData(value); return *this;}

    /**
     * <p>An object that contains information about the Amazon Web Services Threat
     * Intel Group (ATIG) details for the vulnerability.</p>
     */
    inline Vulnerability& WithAtigData(AtigData&& value) { SetAtigData(std::move(value)); return *this;}


    /**
     * <p>An object that contains the Cybersecurity and Infrastructure Security Agency
     * (CISA) details for the vulnerability.</p>
     */
    inline const CisaData& GetCisaData() const{ return m_cisaData; }

    /**
     * <p>An object that contains the Cybersecurity and Infrastructure Security Agency
     * (CISA) details for the vulnerability.</p>
     */
    inline bool CisaDataHasBeenSet() const { return m_cisaDataHasBeenSet; }

    /**
     * <p>An object that contains the Cybersecurity and Infrastructure Security Agency
     * (CISA) details for the vulnerability.</p>
     */
    inline void SetCisaData(const CisaData& value) { m_cisaDataHasBeenSet = true; m_cisaData = value; }

    /**
     * <p>An object that contains the Cybersecurity and Infrastructure Security Agency
     * (CISA) details for the vulnerability.</p>
     */
    inline void SetCisaData(CisaData&& value) { m_cisaDataHasBeenSet = true; m_cisaData = std::move(value); }

    /**
     * <p>An object that contains the Cybersecurity and Infrastructure Security Agency
     * (CISA) details for the vulnerability.</p>
     */
    inline Vulnerability& WithCisaData(const CisaData& value) { SetCisaData(value); return *this;}

    /**
     * <p>An object that contains the Cybersecurity and Infrastructure Security Agency
     * (CISA) details for the vulnerability.</p>
     */
    inline Vulnerability& WithCisaData(CisaData&& value) { SetCisaData(std::move(value)); return *this;}


    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 2 details for the vulnerability.</p>
     */
    inline const Cvss2& GetCvss2() const{ return m_cvss2; }

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 2 details for the vulnerability.</p>
     */
    inline bool Cvss2HasBeenSet() const { return m_cvss2HasBeenSet; }

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 2 details for the vulnerability.</p>
     */
    inline void SetCvss2(const Cvss2& value) { m_cvss2HasBeenSet = true; m_cvss2 = value; }

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 2 details for the vulnerability.</p>
     */
    inline void SetCvss2(Cvss2&& value) { m_cvss2HasBeenSet = true; m_cvss2 = std::move(value); }

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 2 details for the vulnerability.</p>
     */
    inline Vulnerability& WithCvss2(const Cvss2& value) { SetCvss2(value); return *this;}

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 2 details for the vulnerability.</p>
     */
    inline Vulnerability& WithCvss2(Cvss2&& value) { SetCvss2(std::move(value)); return *this;}


    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 3 details for the vulnerability.</p>
     */
    inline const Cvss3& GetCvss3() const{ return m_cvss3; }

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 3 details for the vulnerability.</p>
     */
    inline bool Cvss3HasBeenSet() const { return m_cvss3HasBeenSet; }

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 3 details for the vulnerability.</p>
     */
    inline void SetCvss3(const Cvss3& value) { m_cvss3HasBeenSet = true; m_cvss3 = value; }

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 3 details for the vulnerability.</p>
     */
    inline void SetCvss3(Cvss3&& value) { m_cvss3HasBeenSet = true; m_cvss3 = std::move(value); }

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 3 details for the vulnerability.</p>
     */
    inline Vulnerability& WithCvss3(const Cvss3& value) { SetCvss3(value); return *this;}

    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 3 details for the vulnerability.</p>
     */
    inline Vulnerability& WithCvss3(Cvss3&& value) { SetCvss3(std::move(value)); return *this;}


    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetCwes() const{ return m_cwes; }

    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline bool CwesHasBeenSet() const { return m_cwesHasBeenSet; }

    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline void SetCwes(const Aws::Vector<Aws::String>& value) { m_cwesHasBeenSet = true; m_cwes = value; }

    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline void SetCwes(Aws::Vector<Aws::String>&& value) { m_cwesHasBeenSet = true; m_cwes = std::move(value); }

    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline Vulnerability& WithCwes(const Aws::Vector<Aws::String>& value) { SetCwes(value); return *this;}

    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline Vulnerability& WithCwes(Aws::Vector<Aws::String>&& value) { SetCwes(std::move(value)); return *this;}

    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline Vulnerability& AddCwes(const Aws::String& value) { m_cwesHasBeenSet = true; m_cwes.push_back(value); return *this; }

    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline Vulnerability& AddCwes(Aws::String&& value) { m_cwesHasBeenSet = true; m_cwes.push_back(std::move(value)); return *this; }

    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline Vulnerability& AddCwes(const char* value) { m_cwesHasBeenSet = true; m_cwes.push_back(value); return *this; }


    /**
     * <p>A description of the vulnerability.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }

    /**
     * <p>A description of the vulnerability.</p>
     */
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }

    /**
     * <p>A description of the vulnerability.</p>
     */
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }

    /**
     * <p>A description of the vulnerability.</p>
     */
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }

    /**
     * <p>A description of the vulnerability.</p>
     */
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }

    /**
     * <p>A description of the vulnerability.</p>
     */
    inline Vulnerability& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}

    /**
     * <p>A description of the vulnerability.</p>
     */
    inline Vulnerability& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}

    /**
     * <p>A description of the vulnerability.</p>
     */
    inline Vulnerability& WithDescription(const char* value) { SetDescription(value); return *this;}


    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline const Aws::Vector<Aws::String>& GetDetectionPlatforms() const{ return m_detectionPlatforms; }

    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline bool DetectionPlatformsHasBeenSet() const { return m_detectionPlatformsHasBeenSet; }

    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline void SetDetectionPlatforms(const Aws::Vector<Aws::String>& value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms = value; }

    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline void SetDetectionPlatforms(Aws::Vector<Aws::String>&& value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms = std::move(value); }

    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline Vulnerability& WithDetectionPlatforms(const Aws::Vector<Aws::String>& value) { SetDetectionPlatforms(value); return *this;}

    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline Vulnerability& WithDetectionPlatforms(Aws::Vector<Aws::String>&& value) { SetDetectionPlatforms(std::move(value)); return *this;}

    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline Vulnerability& AddDetectionPlatforms(const Aws::String& value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms.push_back(value); return *this; }

    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline Vulnerability& AddDetectionPlatforms(Aws::String&& value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms.push_back(std::move(value)); return *this; }

    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline Vulnerability& AddDetectionPlatforms(const char* value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms.push_back(value); return *this; }


    /**
     * <p>An object that contains the Exploit Prediction Scoring System (EPSS) score
     * for a vulnerability.</p>
     */
    inline const Epss& GetEpss() const{ return m_epss; }

    /**
     * <p>An object that contains the Exploit Prediction Scoring System (EPSS) score
     * for a vulnerability.</p>
     */
    inline bool EpssHasBeenSet() const { return m_epssHasBeenSet; }

    /**
     * <p>An object that contains the Exploit Prediction Scoring System (EPSS) score
     * for a vulnerability.</p>
     */
    inline void SetEpss(const Epss& value) { m_epssHasBeenSet = true; m_epss = value; }

    /**
     * <p>An object that contains the Exploit Prediction Scoring System (EPSS) score
     * for a vulnerability.</p>
     */
    inline void SetEpss(Epss&& value) { m_epssHasBeenSet = true; m_epss = std::move(value); }

    /**
     * <p>An object that contains the Exploit Prediction Scoring System (EPSS) score
     * for a vulnerability.</p>
     */
    inline Vulnerability& WithEpss(const Epss& value) { SetEpss(value); return *this;}

    /**
     * <p>An object that contains the Exploit Prediction Scoring System (EPSS) score
     * for a vulnerability.</p>
     */
    inline Vulnerability& WithEpss(Epss&& value) { SetEpss(std::move(value)); return *this;}


    /**
     * <p>An object that contains details on when the exploit was observed.</p>
     */
    inline const ExploitObserved& GetExploitObserved() const{ return m_exploitObserved; }

    /**
     * <p>An object that contains details on when the exploit was observed.</p>
     */
    inline bool ExploitObservedHasBeenSet() const { return m_exploitObservedHasBeenSet; }

    /**
     * <p>An object that contains details on when the exploit was observed.</p>
     */
    inline void SetExploitObserved(const ExploitObserved& value) { m_exploitObservedHasBeenSet = true; m_exploitObserved = value; }

    /**
     * <p>An object that contains details on when the exploit was observed.</p>
     */
    inline void SetExploitObserved(ExploitObserved&& value) { m_exploitObservedHasBeenSet = true; m_exploitObserved = std::move(value); }

    /**
     * <p>An object that contains details on when the exploit was observed.</p>
     */
    inline Vulnerability& WithExploitObserved(const ExploitObserved& value) { SetExploitObserved(value); return *this;}

    /**
     * <p>An object that contains details on when the exploit was observed.</p>
     */
    inline Vulnerability& WithExploitObserved(ExploitObserved&& value) { SetExploitObserved(std::move(value)); return *this;}


    /**
     * <p>The ID for the specific vulnerability.</p>
     */
    inline const Aws::String& GetId() const{ return m_id; }

    /**
     * <p>The ID for the specific vulnerability.</p>
     */
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }

    /**
     * <p>The ID for the specific vulnerability.</p>
     */
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }

    /**
     * <p>The ID for the specific vulnerability.</p>
     */
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }

    /**
     * <p>The ID for the specific vulnerability.</p>
     */
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }

    /**
     * <p>The ID for the specific vulnerability.</p>
     */
    inline Vulnerability& WithId(const Aws::String& value) { SetId(value); return *this;}

    /**
     * <p>The ID for the specific vulnerability.</p>
     */
    inline Vulnerability& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}

    /**
     * <p>The ID for the specific vulnerability.</p>
     */
    inline Vulnerability& WithId(const char* value) { SetId(value); return *this;}


    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const{ return m_referenceUrls; }

    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }

    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline void SetReferenceUrls(const Aws::Vector<Aws::String>& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = value; }

    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline void SetReferenceUrls(Aws::Vector<Aws::String>&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::move(value); }

    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline Vulnerability& WithReferenceUrls(const Aws::Vector<Aws::String>& value) { SetReferenceUrls(value); return *this;}

    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline Vulnerability& WithReferenceUrls(Aws::Vector<Aws::String>&& value) { SetReferenceUrls(std::move(value)); return *this;}

    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline Vulnerability& AddReferenceUrls(const Aws::String& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }

    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline Vulnerability& AddReferenceUrls(Aws::String&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(std::move(value)); return *this; }

    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline Vulnerability& AddReferenceUrls(const char* value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }


    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline const Aws::Vector<Aws::String>& GetRelatedVulnerabilities() const{ return m_relatedVulnerabilities; }

    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline bool RelatedVulnerabilitiesHasBeenSet() const { return m_relatedVulnerabilitiesHasBeenSet; }

    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline void SetRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = value; }

    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline void SetRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = std::move(value); }

    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline Vulnerability& WithRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { SetRelatedVulnerabilities(value); return *this;}

    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline Vulnerability& WithRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { SetRelatedVulnerabilities(std::move(value)); return *this;}

    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline Vulnerability& AddRelatedVulnerabilities(const Aws::String& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }

    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline Vulnerability& AddRelatedVulnerabilities(Aws::String&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(std::move(value)); return *this; }

    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline Vulnerability& AddRelatedVulnerabilities(const char* value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }


    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline const VulnerabilitySource& GetSource() const{ return m_source; }

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline bool SourceHasBeenSet() const { return m_sourceHasBeenSet; }

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline void SetSource(const VulnerabilitySource& value) { m_sourceHasBeenSet = true; m_source = value; }

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline void SetSource(VulnerabilitySource&& value) { m_sourceHasBeenSet = true; m_source = std::move(value); }

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline Vulnerability& WithSource(const VulnerabilitySource& value) { SetSource(value); return *this;}

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline Vulnerability& WithSource(VulnerabilitySource&& value) { SetSource(std::move(value)); return *this;}


    /**
     * <p>A link to the official source material for this vulnerability.</p>
     */
    inline const Aws::String& GetSourceUrl() const{ return m_sourceUrl; }

    /**
     * <p>A link to the official source material for this vulnerability.</p>
     */
    inline bool SourceUrlHasBeenSet() const { return m_sourceUrlHasBeenSet; }

    /**
     * <p>A link to the official source material for this vulnerability.</p>
     */
    inline void SetSourceUrl(const Aws::String& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl = value; }

    /**
     * <p>A link to the official source material for this vulnerability.</p>
     */
    inline void SetSourceUrl(Aws::String&& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl = std::move(value); }

    /**
     * <p>A link to the official source material for this vulnerability.</p>
     */
    inline void SetSourceUrl(const char* value) { m_sourceUrlHasBeenSet = true; m_sourceUrl.assign(value); }

    /**
     * <p>A link to the official source material for this vulnerability.</p>
     */
    inline Vulnerability& WithSourceUrl(const Aws::String& value) { SetSourceUrl(value); return *this;}

    /**
     * <p>A link to the official source material for this vulnerability.</p>
     */
    inline Vulnerability& WithSourceUrl(Aws::String&& value) { SetSourceUrl(std::move(value)); return *this;}

    /**
     * <p>A link to the official source material for this vulnerability.</p>
     */
    inline Vulnerability& WithSourceUrl(const char* value) { SetSourceUrl(value); return *this;}


    /**
     * <p>The date and time when the vendor created this vulnerability.</p>
     */
    inline const Aws::Utils::DateTime& GetVendorCreatedAt() const{ return m_vendorCreatedAt; }

    /**
     * <p>The date and time when the vendor created this vulnerability.</p>
     */
    inline bool VendorCreatedAtHasBeenSet() const { return m_vendorCreatedAtHasBeenSet; }

    /**
     * <p>The date and time when the vendor created this vulnerability.</p>
     */
    inline void SetVendorCreatedAt(const Aws::Utils::DateTime& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = value; }

    /**
     * <p>The date and time when the vendor created this vulnerability.</p>
     */
    inline void SetVendorCreatedAt(Aws::Utils::DateTime&& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = std::move(value); }

    /**
     * <p>The date and time when the vendor created this vulnerability.</p>
     */
    inline Vulnerability& WithVendorCreatedAt(const Aws::Utils::DateTime& value) { SetVendorCreatedAt(value); return *this;}

    /**
     * <p>The date and time when the vendor created this vulnerability.</p>
     */
    inline Vulnerability& WithVendorCreatedAt(Aws::Utils::DateTime&& value) { SetVendorCreatedAt(std::move(value)); return *this;}


    /**
     * <p>The severity assigned by the vendor.</p>
     */
    inline const Aws::String& GetVendorSeverity() const{ return m_vendorSeverity; }

    /**
     * <p>The severity assigned by the vendor.</p>
     */
    inline bool VendorSeverityHasBeenSet() const { return m_vendorSeverityHasBeenSet; }

    /**
     * <p>The severity assigned by the vendor.</p>
     */
    inline void SetVendorSeverity(const Aws::String& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = value; }

    /**
     * <p>The severity assigned by the vendor.</p>
     */
    inline void SetVendorSeverity(Aws::String&& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = std::move(value); }

    /**
     * <p>The severity assigned by the vendor.</p>
     */
    inline void SetVendorSeverity(const char* value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity.assign(value); }

    /**
     * <p>The severity assigned by the vendor.</p>
     */
    inline Vulnerability& WithVendorSeverity(const Aws::String& value) { SetVendorSeverity(value); return *this;}

    /**
     * <p>The severity assigned by the vendor.</p>
     */
    inline Vulnerability& WithVendorSeverity(Aws::String&& value) { SetVendorSeverity(std::move(value)); return *this;}

    /**
     * <p>The severity assigned by the vendor.</p>
     */
    inline Vulnerability& WithVendorSeverity(const char* value) { SetVendorSeverity(value); return *this;}


    /**
     * <p>The date and time when the vendor last updated this vulnerability.</p>
     */
    inline const Aws::Utils::DateTime& GetVendorUpdatedAt() const{ return m_vendorUpdatedAt; }

    /**
     * <p>The date and time when the vendor last updated this vulnerability.</p>
     */
    inline bool VendorUpdatedAtHasBeenSet() const { return m_vendorUpdatedAtHasBeenSet; }

    /**
     * <p>The date and time when the vendor last updated this vulnerability.</p>
     */
    inline void SetVendorUpdatedAt(const Aws::Utils::DateTime& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = value; }

    /**
     * <p>The date and time when the vendor last updated this vulnerability.</p>
     */
    inline void SetVendorUpdatedAt(Aws::Utils::DateTime&& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = std::move(value); }

    /**
     * <p>The date and time when the vendor last updated this vulnerability.</p>
     */
    inline Vulnerability& WithVendorUpdatedAt(const Aws::Utils::DateTime& value) { SetVendorUpdatedAt(value); return *this;}

    /**
     * <p>The date and time when the vendor last updated this vulnerability.</p>
     */
    inline Vulnerability& WithVendorUpdatedAt(Aws::Utils::DateTime&& value) { SetVendorUpdatedAt(std::move(value)); return *this;}

  private:

    AtigData m_atigData;
    bool m_atigDataHasBeenSet = false;

    CisaData m_cisaData;
    bool m_cisaDataHasBeenSet = false;

    Cvss2 m_cvss2;
    bool m_cvss2HasBeenSet = false;

    Cvss3 m_cvss3;
    bool m_cvss3HasBeenSet = false;

    Aws::Vector<Aws::String> m_cwes;
    bool m_cwesHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    Aws::Vector<Aws::String> m_detectionPlatforms;
    bool m_detectionPlatformsHasBeenSet = false;

    Epss m_epss;
    bool m_epssHasBeenSet = false;

    ExploitObserved m_exploitObserved;
    bool m_exploitObservedHasBeenSet = false;

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet = false;

    Aws::Vector<Aws::String> m_relatedVulnerabilities;
    bool m_relatedVulnerabilitiesHasBeenSet = false;

    VulnerabilitySource m_source;
    bool m_sourceHasBeenSet = false;

    Aws::String m_sourceUrl;
    bool m_sourceUrlHasBeenSet = false;

    Aws::Utils::DateTime m_vendorCreatedAt;
    bool m_vendorCreatedAtHasBeenSet = false;

    Aws::String m_vendorSeverity;
    bool m_vendorSeverityHasBeenSet = false;

    Aws::Utils::DateTime m_vendorUpdatedAt;
    bool m_vendorUpdatedAtHasBeenSet = false;
  };

} // namespace Model
} // namespace Inspector2
} // namespace Aws
