﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/inspector2/model/CodeFilePath.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Inspector2
{
namespace Model
{

  /**
   * <p>Contains information on the code vulnerability identified in your Lambda
   * function.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CodeVulnerabilityDetails">AWS
   * API Reference</a></p>
   */
  class CodeVulnerabilityDetails
  {
  public:
    AWS_INSPECTOR2_API CodeVulnerabilityDetails();
    AWS_INSPECTOR2_API CodeVulnerabilityDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API CodeVulnerabilityDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetCwes() const{ return m_cwes; }

    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline bool CwesHasBeenSet() const { return m_cwesHasBeenSet; }

    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline void SetCwes(const Aws::Vector<Aws::String>& value) { m_cwesHasBeenSet = true; m_cwes = value; }

    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline void SetCwes(Aws::Vector<Aws::String>&& value) { m_cwesHasBeenSet = true; m_cwes = std::move(value); }

    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline CodeVulnerabilityDetails& WithCwes(const Aws::Vector<Aws::String>& value) { SetCwes(value); return *this;}

    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline CodeVulnerabilityDetails& WithCwes(Aws::Vector<Aws::String>&& value) { SetCwes(std::move(value)); return *this;}

    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline CodeVulnerabilityDetails& AddCwes(const Aws::String& value) { m_cwesHasBeenSet = true; m_cwes.push_back(value); return *this; }

    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline CodeVulnerabilityDetails& AddCwes(Aws::String&& value) { m_cwesHasBeenSet = true; m_cwes.push_back(std::move(value)); return *this; }

    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline CodeVulnerabilityDetails& AddCwes(const char* value) { m_cwesHasBeenSet = true; m_cwes.push_back(value); return *this; }


    /**
     * <p>The ID for the Amazon CodeGuru detector associated with the finding. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru
     * Detector Library</a>.</p>
     */
    inline const Aws::String& GetDetectorId() const{ return m_detectorId; }

    /**
     * <p>The ID for the Amazon CodeGuru detector associated with the finding. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru
     * Detector Library</a>.</p>
     */
    inline bool DetectorIdHasBeenSet() const { return m_detectorIdHasBeenSet; }

    /**
     * <p>The ID for the Amazon CodeGuru detector associated with the finding. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru
     * Detector Library</a>.</p>
     */
    inline void SetDetectorId(const Aws::String& value) { m_detectorIdHasBeenSet = true; m_detectorId = value; }

    /**
     * <p>The ID for the Amazon CodeGuru detector associated with the finding. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru
     * Detector Library</a>.</p>
     */
    inline void SetDetectorId(Aws::String&& value) { m_detectorIdHasBeenSet = true; m_detectorId = std::move(value); }

    /**
     * <p>The ID for the Amazon CodeGuru detector associated with the finding. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru
     * Detector Library</a>.</p>
     */
    inline void SetDetectorId(const char* value) { m_detectorIdHasBeenSet = true; m_detectorId.assign(value); }

    /**
     * <p>The ID for the Amazon CodeGuru detector associated with the finding. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru
     * Detector Library</a>.</p>
     */
    inline CodeVulnerabilityDetails& WithDetectorId(const Aws::String& value) { SetDetectorId(value); return *this;}

    /**
     * <p>The ID for the Amazon CodeGuru detector associated with the finding. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru
     * Detector Library</a>.</p>
     */
    inline CodeVulnerabilityDetails& WithDetectorId(Aws::String&& value) { SetDetectorId(std::move(value)); return *this;}

    /**
     * <p>The ID for the Amazon CodeGuru detector associated with the finding. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru
     * Detector Library</a>.</p>
     */
    inline CodeVulnerabilityDetails& WithDetectorId(const char* value) { SetDetectorId(value); return *this;}


    /**
     * <p>The name of the detector used to identify the code vulnerability. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector
     * Library</a>.</p>
     */
    inline const Aws::String& GetDetectorName() const{ return m_detectorName; }

    /**
     * <p>The name of the detector used to identify the code vulnerability. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector
     * Library</a>.</p>
     */
    inline bool DetectorNameHasBeenSet() const { return m_detectorNameHasBeenSet; }

    /**
     * <p>The name of the detector used to identify the code vulnerability. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector
     * Library</a>.</p>
     */
    inline void SetDetectorName(const Aws::String& value) { m_detectorNameHasBeenSet = true; m_detectorName = value; }

    /**
     * <p>The name of the detector used to identify the code vulnerability. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector
     * Library</a>.</p>
     */
    inline void SetDetectorName(Aws::String&& value) { m_detectorNameHasBeenSet = true; m_detectorName = std::move(value); }

    /**
     * <p>The name of the detector used to identify the code vulnerability. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector
     * Library</a>.</p>
     */
    inline void SetDetectorName(const char* value) { m_detectorNameHasBeenSet = true; m_detectorName.assign(value); }

    /**
     * <p>The name of the detector used to identify the code vulnerability. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector
     * Library</a>.</p>
     */
    inline CodeVulnerabilityDetails& WithDetectorName(const Aws::String& value) { SetDetectorName(value); return *this;}

    /**
     * <p>The name of the detector used to identify the code vulnerability. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector
     * Library</a>.</p>
     */
    inline CodeVulnerabilityDetails& WithDetectorName(Aws::String&& value) { SetDetectorName(std::move(value)); return *this;}

    /**
     * <p>The name of the detector used to identify the code vulnerability. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector
     * Library</a>.</p>
     */
    inline CodeVulnerabilityDetails& WithDetectorName(const char* value) { SetDetectorName(value); return *this;}


    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline const Aws::Vector<Aws::String>& GetDetectorTags() const{ return m_detectorTags; }

    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline bool DetectorTagsHasBeenSet() const { return m_detectorTagsHasBeenSet; }

    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline void SetDetectorTags(const Aws::Vector<Aws::String>& value) { m_detectorTagsHasBeenSet = true; m_detectorTags = value; }

    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline void SetDetectorTags(Aws::Vector<Aws::String>&& value) { m_detectorTagsHasBeenSet = true; m_detectorTags = std::move(value); }

    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline CodeVulnerabilityDetails& WithDetectorTags(const Aws::Vector<Aws::String>& value) { SetDetectorTags(value); return *this;}

    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline CodeVulnerabilityDetails& WithDetectorTags(Aws::Vector<Aws::String>&& value) { SetDetectorTags(std::move(value)); return *this;}

    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline CodeVulnerabilityDetails& AddDetectorTags(const Aws::String& value) { m_detectorTagsHasBeenSet = true; m_detectorTags.push_back(value); return *this; }

    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline CodeVulnerabilityDetails& AddDetectorTags(Aws::String&& value) { m_detectorTagsHasBeenSet = true; m_detectorTags.push_back(std::move(value)); return *this; }

    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline CodeVulnerabilityDetails& AddDetectorTags(const char* value) { m_detectorTagsHasBeenSet = true; m_detectorTags.push_back(value); return *this; }


    /**
     * <p>Contains information on where the code vulnerability is located in your
     * code.</p>
     */
    inline const CodeFilePath& GetFilePath() const{ return m_filePath; }

    /**
     * <p>Contains information on where the code vulnerability is located in your
     * code.</p>
     */
    inline bool FilePathHasBeenSet() const { return m_filePathHasBeenSet; }

    /**
     * <p>Contains information on where the code vulnerability is located in your
     * code.</p>
     */
    inline void SetFilePath(const CodeFilePath& value) { m_filePathHasBeenSet = true; m_filePath = value; }

    /**
     * <p>Contains information on where the code vulnerability is located in your
     * code.</p>
     */
    inline void SetFilePath(CodeFilePath&& value) { m_filePathHasBeenSet = true; m_filePath = std::move(value); }

    /**
     * <p>Contains information on where the code vulnerability is located in your
     * code.</p>
     */
    inline CodeVulnerabilityDetails& WithFilePath(const CodeFilePath& value) { SetFilePath(value); return *this;}

    /**
     * <p>Contains information on where the code vulnerability is located in your
     * code.</p>
     */
    inline CodeVulnerabilityDetails& WithFilePath(CodeFilePath&& value) { SetFilePath(std::move(value)); return *this;}


    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const{ return m_referenceUrls; }

    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }

    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline void SetReferenceUrls(const Aws::Vector<Aws::String>& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = value; }

    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline void SetReferenceUrls(Aws::Vector<Aws::String>&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::move(value); }

    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline CodeVulnerabilityDetails& WithReferenceUrls(const Aws::Vector<Aws::String>& value) { SetReferenceUrls(value); return *this;}

    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline CodeVulnerabilityDetails& WithReferenceUrls(Aws::Vector<Aws::String>&& value) { SetReferenceUrls(std::move(value)); return *this;}

    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline CodeVulnerabilityDetails& AddReferenceUrls(const Aws::String& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }

    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline CodeVulnerabilityDetails& AddReferenceUrls(Aws::String&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(std::move(value)); return *this; }

    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline CodeVulnerabilityDetails& AddReferenceUrls(const char* value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }


    /**
     * <p>The identifier for a rule that was used to detect the code vulnerability.</p>
     */
    inline const Aws::String& GetRuleId() const{ return m_ruleId; }

    /**
     * <p>The identifier for a rule that was used to detect the code vulnerability.</p>
     */
    inline bool RuleIdHasBeenSet() const { return m_ruleIdHasBeenSet; }

    /**
     * <p>The identifier for a rule that was used to detect the code vulnerability.</p>
     */
    inline void SetRuleId(const Aws::String& value) { m_ruleIdHasBeenSet = true; m_ruleId = value; }

    /**
     * <p>The identifier for a rule that was used to detect the code vulnerability.</p>
     */
    inline void SetRuleId(Aws::String&& value) { m_ruleIdHasBeenSet = true; m_ruleId = std::move(value); }

    /**
     * <p>The identifier for a rule that was used to detect the code vulnerability.</p>
     */
    inline void SetRuleId(const char* value) { m_ruleIdHasBeenSet = true; m_ruleId.assign(value); }

    /**
     * <p>The identifier for a rule that was used to detect the code vulnerability.</p>
     */
    inline CodeVulnerabilityDetails& WithRuleId(const Aws::String& value) { SetRuleId(value); return *this;}

    /**
     * <p>The identifier for a rule that was used to detect the code vulnerability.</p>
     */
    inline CodeVulnerabilityDetails& WithRuleId(Aws::String&& value) { SetRuleId(std::move(value)); return *this;}

    /**
     * <p>The identifier for a rule that was used to detect the code vulnerability.</p>
     */
    inline CodeVulnerabilityDetails& WithRuleId(const char* value) { SetRuleId(value); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda layer that the code
     * vulnerability was detected in.</p>
     */
    inline const Aws::String& GetSourceLambdaLayerArn() const{ return m_sourceLambdaLayerArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda layer that the code
     * vulnerability was detected in.</p>
     */
    inline bool SourceLambdaLayerArnHasBeenSet() const { return m_sourceLambdaLayerArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda layer that the code
     * vulnerability was detected in.</p>
     */
    inline void SetSourceLambdaLayerArn(const Aws::String& value) { m_sourceLambdaLayerArnHasBeenSet = true; m_sourceLambdaLayerArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda layer that the code
     * vulnerability was detected in.</p>
     */
    inline void SetSourceLambdaLayerArn(Aws::String&& value) { m_sourceLambdaLayerArnHasBeenSet = true; m_sourceLambdaLayerArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda layer that the code
     * vulnerability was detected in.</p>
     */
    inline void SetSourceLambdaLayerArn(const char* value) { m_sourceLambdaLayerArnHasBeenSet = true; m_sourceLambdaLayerArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda layer that the code
     * vulnerability was detected in.</p>
     */
    inline CodeVulnerabilityDetails& WithSourceLambdaLayerArn(const Aws::String& value) { SetSourceLambdaLayerArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda layer that the code
     * vulnerability was detected in.</p>
     */
    inline CodeVulnerabilityDetails& WithSourceLambdaLayerArn(Aws::String&& value) { SetSourceLambdaLayerArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda layer that the code
     * vulnerability was detected in.</p>
     */
    inline CodeVulnerabilityDetails& WithSourceLambdaLayerArn(const char* value) { SetSourceLambdaLayerArn(value); return *this;}

  private:

    Aws::Vector<Aws::String> m_cwes;
    bool m_cwesHasBeenSet = false;

    Aws::String m_detectorId;
    bool m_detectorIdHasBeenSet = false;

    Aws::String m_detectorName;
    bool m_detectorNameHasBeenSet = false;

    Aws::Vector<Aws::String> m_detectorTags;
    bool m_detectorTagsHasBeenSet = false;

    CodeFilePath m_filePath;
    bool m_filePathHasBeenSet = false;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet = false;

    Aws::String m_ruleId;
    bool m_ruleIdHasBeenSet = false;

    Aws::String m_sourceLambdaLayerArn;
    bool m_sourceLambdaLayerArnHasBeenSet = false;
  };

} // namespace Model
} // namespace Inspector2
} // namespace Aws
