﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ecr/model/PackageVulnerabilityDetails.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ECR
{
namespace Model
{

PackageVulnerabilityDetails::PackageVulnerabilityDetails() : 
    m_cvssHasBeenSet(false),
    m_referenceUrlsHasBeenSet(false),
    m_relatedVulnerabilitiesHasBeenSet(false),
    m_sourceHasBeenSet(false),
    m_sourceUrlHasBeenSet(false),
    m_vendorCreatedAtHasBeenSet(false),
    m_vendorSeverityHasBeenSet(false),
    m_vendorUpdatedAtHasBeenSet(false),
    m_vulnerabilityIdHasBeenSet(false),
    m_vulnerablePackagesHasBeenSet(false)
{
}

PackageVulnerabilityDetails::PackageVulnerabilityDetails(JsonView jsonValue) : 
    m_cvssHasBeenSet(false),
    m_referenceUrlsHasBeenSet(false),
    m_relatedVulnerabilitiesHasBeenSet(false),
    m_sourceHasBeenSet(false),
    m_sourceUrlHasBeenSet(false),
    m_vendorCreatedAtHasBeenSet(false),
    m_vendorSeverityHasBeenSet(false),
    m_vendorUpdatedAtHasBeenSet(false),
    m_vulnerabilityIdHasBeenSet(false),
    m_vulnerablePackagesHasBeenSet(false)
{
  *this = jsonValue;
}

PackageVulnerabilityDetails& PackageVulnerabilityDetails::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("cvss"))
  {
    Aws::Utils::Array<JsonView> cvssJsonList = jsonValue.GetArray("cvss");
    for(unsigned cvssIndex = 0; cvssIndex < cvssJsonList.GetLength(); ++cvssIndex)
    {
      m_cvss.push_back(cvssJsonList[cvssIndex].AsObject());
    }
    m_cvssHasBeenSet = true;
  }

  if(jsonValue.ValueExists("referenceUrls"))
  {
    Aws::Utils::Array<JsonView> referenceUrlsJsonList = jsonValue.GetArray("referenceUrls");
    for(unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex)
    {
      m_referenceUrls.push_back(referenceUrlsJsonList[referenceUrlsIndex].AsString());
    }
    m_referenceUrlsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("relatedVulnerabilities"))
  {
    Aws::Utils::Array<JsonView> relatedVulnerabilitiesJsonList = jsonValue.GetArray("relatedVulnerabilities");
    for(unsigned relatedVulnerabilitiesIndex = 0; relatedVulnerabilitiesIndex < relatedVulnerabilitiesJsonList.GetLength(); ++relatedVulnerabilitiesIndex)
    {
      m_relatedVulnerabilities.push_back(relatedVulnerabilitiesJsonList[relatedVulnerabilitiesIndex].AsString());
    }
    m_relatedVulnerabilitiesHasBeenSet = true;
  }

  if(jsonValue.ValueExists("source"))
  {
    m_source = jsonValue.GetString("source");

    m_sourceHasBeenSet = true;
  }

  if(jsonValue.ValueExists("sourceUrl"))
  {
    m_sourceUrl = jsonValue.GetString("sourceUrl");

    m_sourceUrlHasBeenSet = true;
  }

  if(jsonValue.ValueExists("vendorCreatedAt"))
  {
    m_vendorCreatedAt = jsonValue.GetDouble("vendorCreatedAt");

    m_vendorCreatedAtHasBeenSet = true;
  }

  if(jsonValue.ValueExists("vendorSeverity"))
  {
    m_vendorSeverity = jsonValue.GetString("vendorSeverity");

    m_vendorSeverityHasBeenSet = true;
  }

  if(jsonValue.ValueExists("vendorUpdatedAt"))
  {
    m_vendorUpdatedAt = jsonValue.GetDouble("vendorUpdatedAt");

    m_vendorUpdatedAtHasBeenSet = true;
  }

  if(jsonValue.ValueExists("vulnerabilityId"))
  {
    m_vulnerabilityId = jsonValue.GetString("vulnerabilityId");

    m_vulnerabilityIdHasBeenSet = true;
  }

  if(jsonValue.ValueExists("vulnerablePackages"))
  {
    Aws::Utils::Array<JsonView> vulnerablePackagesJsonList = jsonValue.GetArray("vulnerablePackages");
    for(unsigned vulnerablePackagesIndex = 0; vulnerablePackagesIndex < vulnerablePackagesJsonList.GetLength(); ++vulnerablePackagesIndex)
    {
      m_vulnerablePackages.push_back(vulnerablePackagesJsonList[vulnerablePackagesIndex].AsObject());
    }
    m_vulnerablePackagesHasBeenSet = true;
  }

  return *this;
}

JsonValue PackageVulnerabilityDetails::Jsonize() const
{
  JsonValue payload;

  if(m_cvssHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> cvssJsonList(m_cvss.size());
   for(unsigned cvssIndex = 0; cvssIndex < cvssJsonList.GetLength(); ++cvssIndex)
   {
     cvssJsonList[cvssIndex].AsObject(m_cvss[cvssIndex].Jsonize());
   }
   payload.WithArray("cvss", std::move(cvssJsonList));

  }

  if(m_referenceUrlsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> referenceUrlsJsonList(m_referenceUrls.size());
   for(unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex)
   {
     referenceUrlsJsonList[referenceUrlsIndex].AsString(m_referenceUrls[referenceUrlsIndex]);
   }
   payload.WithArray("referenceUrls", std::move(referenceUrlsJsonList));

  }

  if(m_relatedVulnerabilitiesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> relatedVulnerabilitiesJsonList(m_relatedVulnerabilities.size());
   for(unsigned relatedVulnerabilitiesIndex = 0; relatedVulnerabilitiesIndex < relatedVulnerabilitiesJsonList.GetLength(); ++relatedVulnerabilitiesIndex)
   {
     relatedVulnerabilitiesJsonList[relatedVulnerabilitiesIndex].AsString(m_relatedVulnerabilities[relatedVulnerabilitiesIndex]);
   }
   payload.WithArray("relatedVulnerabilities", std::move(relatedVulnerabilitiesJsonList));

  }

  if(m_sourceHasBeenSet)
  {
   payload.WithString("source", m_source);

  }

  if(m_sourceUrlHasBeenSet)
  {
   payload.WithString("sourceUrl", m_sourceUrl);

  }

  if(m_vendorCreatedAtHasBeenSet)
  {
   payload.WithDouble("vendorCreatedAt", m_vendorCreatedAt.SecondsWithMSPrecision());
  }

  if(m_vendorSeverityHasBeenSet)
  {
   payload.WithString("vendorSeverity", m_vendorSeverity);

  }

  if(m_vendorUpdatedAtHasBeenSet)
  {
   payload.WithDouble("vendorUpdatedAt", m_vendorUpdatedAt.SecondsWithMSPrecision());
  }

  if(m_vulnerabilityIdHasBeenSet)
  {
   payload.WithString("vulnerabilityId", m_vulnerabilityId);

  }

  if(m_vulnerablePackagesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> vulnerablePackagesJsonList(m_vulnerablePackages.size());
   for(unsigned vulnerablePackagesIndex = 0; vulnerablePackagesIndex < vulnerablePackagesJsonList.GetLength(); ++vulnerablePackagesIndex)
   {
     vulnerablePackagesJsonList[vulnerablePackagesIndex].AsObject(m_vulnerablePackages[vulnerablePackagesIndex].Jsonize());
   }
   payload.WithArray("vulnerablePackages", std::move(vulnerablePackagesJsonList));

  }

  return payload;
}

} // namespace Model
} // namespace ECR
} // namespace Aws
