// Copyright 2021 by Red Hat, Inc. All rights reserved.
// Use of this source is goverend by the Apache License
// that can be found in the LICENSE file.

package sources

import (
	"github.com/spf13/cobra"

	"github.com/osbuild/weldr-client/v2/cmd/composer-cli/root"
)

var (
	deleteCmd = &cobra.Command{
		Use:     "delete SOURCE",
		Short:   "Delete the project source",
		Example: "  composer-cli sources delete rpmfusion",
		RunE:    delete,
		Args:    cobra.ExactArgs(1),
	}
)

func init() {
	sourcesCmd.AddCommand(deleteCmd)
}

func delete(cmd *cobra.Command, args []string) error {
	resp, err := root.Client.DeleteSource(args[0])
	if err != nil {
		return root.ExecutionError(cmd, "Delete Error: %s", err)
	}
	if resp != nil && !resp.Status {
		return root.ExecutionErrors(cmd, resp.Errors)
	}

	return nil
}
