/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_oaep_2048_sha256_mgf1sha256_vectors_h__
#define rsa_oaep_2048_sha256_mgf1sha256_vectors_h__

#include "testvectors_base/test-structs.h"

const RsaOaepTestVector kRsaOaep2048Sha256Mgf1Sha256WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     1,
     {},
     {0x6e, 0x62, 0xbf, 0x24, 0xd9, 0x5a, 0xff, 0x68, 0x68, 0xaf, 0xec, 0x2a,
      0x92, 0xa4, 0x45, 0xb6, 0x45, 0x8f, 0x16, 0xf6, 0x88, 0xc1, 0x9f, 0xe1,
      0x21, 0x2f, 0x66, 0xa6, 0x31, 0x37, 0x83, 0x16, 0x53, 0xce, 0xdd, 0x35,
      0x9d, 0x8c, 0xff, 0x4d, 0xd4, 0x85, 0xd7, 0x7d, 0xfd, 0x55, 0x81, 0x2c,
      0x18, 0x13, 0x73, 0x20, 0x1f, 0x54, 0xaa, 0xfd, 0x65, 0x73, 0x0d, 0x2a,
      0x30, 0x4e, 0x62, 0x34, 0x55, 0xd5, 0x11, 0x25, 0xd8, 0x91, 0xe6, 0x5d,
      0x97, 0xfc, 0xe5, 0x23, 0x41, 0xca, 0xe4, 0x5f, 0xb6, 0x4c, 0x38, 0xa3,
      0x84, 0xa1, 0xc6, 0x21, 0xe2, 0x71, 0x3e, 0xe6, 0x79, 0x46, 0x33, 0xf0,
      0x29, 0xa9, 0xfd, 0x4d, 0x77, 0x4f, 0x56, 0x55, 0x1e, 0xac, 0x21, 0x76,
      0x16, 0x2e, 0x16, 0x26, 0x40, 0xf2, 0x5e, 0xab, 0x87, 0x3a, 0x34, 0x51,
      0xc4, 0x75, 0x57, 0x0f, 0x19, 0x22, 0x8b, 0xce, 0xde, 0x4c, 0x67, 0xc3,
      0x70, 0xa7, 0x5e, 0xd7, 0xfa, 0xbc, 0xcd, 0x53, 0x8c, 0x98, 0x19, 0xef,
      0xf1, 0x82, 0x48, 0x1b, 0x10, 0xd4, 0x2f, 0x1a, 0x9f, 0x6a, 0x05, 0x37,
      0x3b, 0x8c, 0xf9, 0xb7, 0x18, 0x18, 0xd4, 0x67, 0xbd, 0x3b, 0x8e, 0xba,
      0xcb, 0x61, 0x9e, 0x8a, 0xd4, 0x29, 0x16, 0xe6, 0x00, 0xc0, 0x43, 0xef,
      0xfc, 0xeb, 0x38, 0x55, 0xbc, 0x48, 0xa6, 0x29, 0xe6, 0x0a, 0xe8, 0x86,
      0xf5, 0x1b, 0x2a, 0x78, 0x76, 0xb0, 0xe6, 0x23, 0xfb, 0x2c, 0xe6, 0x8a,
      0xf4, 0xb0, 0x39, 0x24, 0x2f, 0x96, 0x3a, 0xdb, 0x0e, 0x42, 0x40, 0xae,
      0xd0, 0xed, 0x07, 0xf6, 0x5f, 0x1e, 0xe7, 0xc0, 0xcc, 0x77, 0xd2, 0x10,
      0xd0, 0xc2, 0xd1, 0xdc, 0x10, 0xc8, 0x1b, 0x88, 0x1a, 0xa0, 0xc9, 0xc9,
      0xe9, 0x49, 0x96, 0x65, 0xcf, 0x29, 0x70, 0xd2, 0xcc, 0xfe, 0xeb, 0x31,
      0x91, 0x53, 0x17, 0x65},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     2,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x20, 0x71, 0x80, 0xc3, 0x40, 0x65, 0x8b, 0x51, 0x54, 0xae, 0x45, 0xd2,
      0xe4, 0xe7, 0x32, 0x6a, 0x09, 0x97, 0xc6, 0x83, 0xa2, 0x6b, 0x59, 0x5e,
      0x53, 0x6a, 0x29, 0x33, 0x3c, 0x4b, 0x66, 0x14, 0x9a, 0xf8, 0x5e, 0x02,
      0x9d, 0x54, 0x19, 0xa3, 0x9e, 0x3a, 0x14, 0x7b, 0x22, 0x15, 0x16, 0xff,
      0xd8, 0x6b, 0x6b, 0x4b, 0x66, 0xc3, 0xe0, 0xc4, 0xc4, 0x9f, 0xe8, 0xc5,
      0x7a, 0x2f, 0x5c, 0x37, 0xb8, 0x70, 0x4b, 0x9b, 0x59, 0x2b, 0x80, 0xdb,
      0x9c, 0xd7, 0x88, 0xa4, 0xed, 0x51, 0xab, 0x4f, 0x0a, 0x1c, 0xbe, 0xd6,
      0x3b, 0xd1, 0x8d, 0x1f, 0x06, 0xa2, 0x2f, 0x22, 0x58, 0x66, 0xb0, 0xc2,
      0xc4, 0x17, 0xcb, 0x23, 0x47, 0x3b, 0x7b, 0xa4, 0x25, 0x0b, 0x13, 0x53,
      0xbd, 0x2e, 0x5b, 0x4f, 0x0f, 0x93, 0x7c, 0xd2, 0xef, 0xe5, 0xfa, 0x38,
      0xdb, 0x3c, 0x29, 0x5f, 0x77, 0x48, 0xb9, 0x70, 0x08, 0x86, 0x57, 0xdb,
      0x4a, 0xa9, 0xa7, 0x6e, 0x1e, 0xe6, 0xfb, 0xff, 0x16, 0x6e, 0xc1, 0x86,
      0x1d, 0x00, 0xd0, 0x85, 0x32, 0x6c, 0x73, 0x84, 0xbd, 0xd1, 0xbc, 0x2f,
      0x40, 0x0d, 0x4f, 0x74, 0xdb, 0xdf, 0xad, 0xaf, 0x3f, 0xdc, 0x46, 0x07,
      0x3e, 0x66, 0x85, 0x73, 0xe0, 0x20, 0x30, 0xb9, 0xeb, 0x5a, 0xf5, 0x8e,
      0xb5, 0x40, 0xc6, 0x66, 0x77, 0xa7, 0x71, 0x19, 0x44, 0x79, 0xec, 0x00,
      0x98, 0xd8, 0x58, 0xa2, 0xea, 0x45, 0xd0, 0xba, 0x1e, 0x6b, 0x32, 0x44,
      0x0d, 0xfb, 0xac, 0x74, 0x50, 0x00, 0x55, 0x4d, 0x51, 0xa1, 0x76, 0x84,
      0xca, 0x96, 0x4b, 0x02, 0xa7, 0x4d, 0x47, 0x9f, 0x1d, 0x43, 0x2e, 0xf7,
      0x63, 0xef, 0x40, 0x59, 0x71, 0x5a, 0x43, 0x48, 0xcf, 0xe3, 0x6a, 0x21,
      0x53, 0x59, 0x71, 0x2f, 0x25, 0xb6, 0x97, 0x79, 0x03, 0xbe, 0x4a, 0xdb,
      0x92, 0xfe, 0xbb, 0xf6},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     3,
     {0x54, 0x65, 0x73, 0x74},
     {0x5e, 0xab, 0x3f, 0x07, 0x41, 0xe6, 0x39, 0x86, 0xed, 0x64, 0x7d, 0x53,
      0xe1, 0xcd, 0x71, 0xdf, 0x04, 0x19, 0x86, 0x90, 0x08, 0x03, 0xd0, 0xf9,
      0x9c, 0x68, 0x35, 0x5d, 0x24, 0x9a, 0x15, 0xa4, 0x7d, 0xc5, 0xb4, 0xf7,
      0x0a, 0x19, 0x14, 0x77, 0x65, 0x42, 0x99, 0xe5, 0xa2, 0x73, 0x1f, 0x3b,
      0x4e, 0xec, 0x76, 0xde, 0xa1, 0x82, 0x62, 0xfc, 0x69, 0x6a, 0xc7, 0x94,
      0xe5, 0xf6, 0x6c, 0xbf, 0xcd, 0xda, 0xc4, 0x47, 0x2c, 0x57, 0x8e, 0x24,
      0x6c, 0x26, 0x70, 0x75, 0x98, 0x05, 0x55, 0x84, 0x54, 0x0b, 0x83, 0x98,
      0x36, 0xb1, 0x40, 0x4c, 0x56, 0x11, 0xae, 0x55, 0x8a, 0x98, 0x4c, 0xee,
      0x8f, 0xd0, 0x36, 0xce, 0xa9, 0x24, 0xe0, 0xbe, 0x24, 0x74, 0xa9, 0x40,
      0xf6, 0x1e, 0x0a, 0xcc, 0x14, 0xfc, 0xae, 0x95, 0xeb, 0xdc, 0x59, 0x94,
      0x2a, 0x9c, 0xe9, 0xaf, 0x9a, 0x9c, 0x81, 0x99, 0x9f, 0x7f, 0x68, 0x15,
      0xf0, 0x57, 0xff, 0xdc, 0x25, 0x33, 0xcb, 0x15, 0xd6, 0x39, 0x1d, 0x1e,
      0x2d, 0x95, 0xf1, 0x6f, 0x9c, 0x04, 0x20, 0x9c, 0x88, 0x9a, 0x4c, 0x35,
      0x9c, 0x7d, 0x29, 0x26, 0xd2, 0x8a, 0x66, 0xe2, 0xb0, 0x30, 0xa4, 0x16,
      0xb9, 0x28, 0xd2, 0x82, 0x56, 0x27, 0x99, 0x8e, 0x51, 0x91, 0xfb, 0x49,
      0x83, 0xa6, 0xe6, 0x50, 0x24, 0x26, 0x2d, 0x94, 0xfc, 0x09, 0x18, 0x7a,
      0x2d, 0x78, 0x16, 0x21, 0x22, 0x43, 0x32, 0x51, 0xd1, 0xbf, 0xcc, 0x8e,
      0x50, 0x7d, 0x06, 0xeb, 0xa2, 0xd2, 0x29, 0xc1, 0x00, 0x31, 0x26, 0x1d,
      0xa3, 0x2a, 0xb8, 0xcc, 0xd1, 0x5f, 0x1c, 0x5f, 0x9f, 0xbf, 0x07, 0xed,
      0x15, 0x84, 0x83, 0xd7, 0x36, 0xa1, 0x10, 0xaf, 0x4b, 0x44, 0xd6, 0xa4,
      0xda, 0x60, 0xd6, 0xcb, 0x51, 0x9b, 0x44, 0x54, 0x21, 0x3c, 0xf9, 0xf0,
      0xdc, 0x56, 0x0f, 0x2b},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     4,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x0d, 0xa2, 0x90, 0xb0, 0xbf, 0x71, 0xa1, 0x14, 0x1b, 0x2a, 0xdc, 0x62,
      0xb5, 0xb4, 0x2b, 0x07, 0xfc, 0x52, 0x52, 0x0c, 0xb0, 0x5d, 0x1f, 0x39,
      0xcc, 0xca, 0x7b, 0x7c, 0x22, 0xd3, 0x79, 0xa6, 0xc2, 0xf2, 0xd9, 0x31,
      0x43, 0xd0, 0x57, 0x05, 0x01, 0x40, 0x52, 0x7a, 0x1e, 0x56, 0x38, 0x24,
      0x39, 0x38, 0xb5, 0x31, 0xec, 0x3d, 0xe7, 0x01, 0x4b, 0x01, 0x51, 0x30,
      0x1e, 0x49, 0xb9, 0xfa, 0x43, 0x34, 0x82, 0xa0, 0x2a, 0xbd, 0xfd, 0x94,
      0x19, 0x3d, 0xc9, 0xc7, 0x01, 0x57, 0xe5, 0x57, 0x77, 0x6a, 0x69, 0xde,
      0xd0, 0x1e, 0xcb, 0xea, 0xc4, 0x05, 0x13, 0x35, 0x95, 0xc6, 0x11, 0x65,
      0xa4, 0x28, 0xb6, 0x28, 0x47, 0x29, 0xa4, 0x74, 0x6b, 0x47, 0xd2, 0xbb,
      0xac, 0xa9, 0xd7, 0x43, 0x2c, 0x3b, 0x56, 0x93, 0x59, 0x1c, 0xfe, 0xe4,
      0x88, 0xeb, 0x3c, 0x68, 0xdd, 0xb6, 0xcd, 0xe0, 0xdd, 0x61, 0xcf, 0xc6,
      0x95, 0x24, 0x23, 0xf9, 0x94, 0xab, 0xec, 0xee, 0x34, 0xf5, 0x68, 0x37,
      0x32, 0xb2, 0x99, 0x34, 0xa2, 0xc4, 0x98, 0xad, 0x48, 0xcd, 0xd3, 0x0c,
      0x14, 0x91, 0x77, 0x18, 0x9f, 0x48, 0xee, 0xfd, 0x9c, 0xc7, 0x23, 0x2d,
      0xf1, 0x8b, 0xe1, 0x1f, 0xf5, 0xf7, 0xe3, 0xaf, 0x73, 0x19, 0xe3, 0x11,
      0x59, 0x97, 0xc5, 0x99, 0xe2, 0xd8, 0xf7, 0xf4, 0xf6, 0x63, 0xdc, 0xc4,
      0x00, 0x32, 0xd4, 0x03, 0x43, 0x6d, 0x30, 0x58, 0xa5, 0xea, 0x66, 0x47,
      0x36, 0x60, 0xf0, 0xe1, 0x95, 0x28, 0x1e, 0xc6, 0xeb, 0xa9, 0x97, 0xd2,
      0xa9, 0x51, 0xca, 0x6c, 0xa5, 0xf3, 0xc1, 0x12, 0x71, 0x5c, 0x89, 0xda,
      0x1d, 0x3d, 0xfb, 0x20, 0xa2, 0x19, 0x40, 0x59, 0x4e, 0xd1, 0x0a, 0xde,
      0x90, 0xed, 0x74, 0x52, 0xb7, 0x53, 0x75, 0x7d, 0x72, 0x41, 0xcb, 0x8a,
      0x80, 0x3c, 0x37, 0x3a},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     5,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     {0x12, 0x11, 0x96, 0xe5, 0x1a, 0x3f, 0x44, 0x76, 0xbf, 0xb6, 0xad, 0xdd,
      0xfd, 0xeb, 0x3a, 0x25, 0xda, 0xd7, 0x2d, 0x1e, 0xa3, 0x15, 0xd6, 0x52,
      0xf3, 0x31, 0xa4, 0x36, 0x31, 0xad, 0x36, 0x72, 0x4b, 0x3d, 0x14, 0x53,
      0x21, 0x10, 0xdc, 0x44, 0xe4, 0x07, 0xb1, 0x18, 0x46, 0x18, 0xf1, 0x15,
      0x67, 0x7b, 0x33, 0x75, 0x1f, 0xb0, 0xe8, 0x78, 0x6b, 0xa2, 0x20, 0xcf,
      0xa7, 0xfc, 0x3f, 0xce, 0x22, 0x82, 0x2e, 0xab, 0xdd, 0x4f, 0xc2, 0x76,
      0x1c, 0x7f, 0x34, 0xa0, 0x4e, 0x8f, 0x13, 0xc1, 0x02, 0x1c, 0x31, 0xad,
      0xc1, 0x23, 0xa3, 0x2d, 0x87, 0x1f, 0x0d, 0xa6, 0xcd, 0xac, 0xab, 0x9c,
      0x02, 0x02, 0x22, 0xda, 0x52, 0xaf, 0xd5, 0xc3, 0x07, 0xa6, 0xe5, 0x5e,
      0x45, 0x66, 0x94, 0x44, 0x03, 0xfd, 0xa4, 0x26, 0xee, 0x2c, 0x6c, 0x97,
      0x3c, 0xca, 0xaa, 0xfe, 0x2d, 0x08, 0x1e, 0xd8, 0xc5, 0xb1, 0xdc, 0x00,
      0x66, 0x24, 0x24, 0xe3, 0x95, 0xfa, 0xed, 0x86, 0xc9, 0xae, 0x19, 0xa3,
      0xa9, 0x59, 0x50, 0xc8, 0x3d, 0x2a, 0x9a, 0xd5, 0xc7, 0xe7, 0xf6, 0x70,
      0xfa, 0xeb, 0x12, 0x3a, 0xce, 0xf0, 0x7f, 0xe7, 0x79, 0x5a, 0xd2, 0x98,
      0xaa, 0xfe, 0x54, 0x35, 0x04, 0xd7, 0x81, 0x13, 0x36, 0xb3, 0xe2, 0xec,
      0xb1, 0x62, 0x2b, 0xc9, 0x05, 0x99, 0xa1, 0x85, 0xb3, 0x47, 0x00, 0xf8,
      0xf4, 0xc5, 0x2a, 0x65, 0x1d, 0x73, 0xea, 0x57, 0xe8, 0xcf, 0xa8, 0x0e,
      0x61, 0xd9, 0xda, 0x61, 0xf3, 0x69, 0x51, 0xc7, 0x19, 0x4a, 0xe4, 0xde,
      0xe3, 0xc6, 0xe6, 0x7b, 0x57, 0x57, 0xa3, 0x96, 0x85, 0xdd, 0x3f, 0xe0,
      0x1c, 0xb8, 0x76, 0x20, 0xa5, 0x46, 0x66, 0xff, 0x81, 0x32, 0xe9, 0x3d,
      0x70, 0x81, 0xd3, 0x8d, 0xdc, 0x9f, 0x07, 0x94, 0x31, 0x07, 0x5e, 0x96,
      0xcc, 0xa7, 0x8f, 0x59},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     6,
     {0x61},
     {0x7a, 0xe8, 0xe4, 0xf5, 0x49, 0x43, 0x93, 0xbe, 0x14, 0x4d, 0x81, 0x51,
      0x7f, 0x11, 0xba, 0xf4, 0xb6, 0x34, 0xbb, 0x68, 0xb2, 0xf0, 0xea, 0x9b,
      0x30, 0x73, 0x10, 0x35, 0xe8, 0xcb, 0xf4, 0x28, 0x3c, 0x0c, 0xa9, 0x91,
      0x20, 0xf6, 0x0b, 0x75, 0xef, 0x68, 0x5e, 0x98, 0x9f, 0xec, 0xd7, 0xa5,
      0xdc, 0x52, 0x4c, 0xb6, 0x62, 0x92, 0xa0, 0xab, 0x87, 0xeb, 0xc6, 0x1e,
      0x67, 0xba, 0xca, 0x1a, 0x8a, 0xed, 0x99, 0x35, 0x0e, 0xde, 0xe0, 0x45,
      0xdf, 0xdd, 0x02, 0x94, 0x06, 0xac, 0xb7, 0x07, 0xd8, 0x5d, 0xec, 0x95,
      0x55, 0x16, 0x9c, 0xf7, 0xec, 0x51, 0x18, 0xd8, 0xf2, 0x9d, 0x18, 0x2f,
      0x20, 0x5e, 0x28, 0x59, 0xa8, 0xdc, 0xc5, 0x12, 0x2b, 0xed, 0x64, 0x0a,
      0xd0, 0xef, 0x12, 0x8d, 0xeb, 0x21, 0x78, 0x5e, 0xfa, 0xa2, 0x0f, 0x92,
      0x06, 0x7d, 0xc2, 0x16, 0xcf, 0x40, 0xc1, 0x5b, 0xd7, 0x13, 0x0e, 0x2c,
      0x09, 0x41, 0x31, 0x91, 0x79, 0x50, 0xa8, 0x16, 0xda, 0x81, 0x4c, 0x59,
      0x90, 0xfa, 0x6b, 0xee, 0xd7, 0x09, 0xa0, 0x21, 0x8f, 0x4d, 0xdc, 0xa2,
      0x47, 0x37, 0x96, 0xe1, 0xb4, 0x4c, 0xff, 0x6d, 0x7e, 0xd6, 0x01, 0xc5,
      0x74, 0xa7, 0x84, 0xd0, 0x86, 0x5d, 0x3a, 0xfe, 0x5f, 0xec, 0x02, 0x3e,
      0xbe, 0x71, 0xbc, 0xa8, 0x81, 0xda, 0x56, 0x37, 0xe3, 0xd1, 0xd1, 0x72,
      0x38, 0xc2, 0x0a, 0x5b, 0xd0, 0x07, 0x5b, 0xac, 0x01, 0x8f, 0x07, 0x89,
      0x8f, 0x74, 0xb9, 0xe6, 0xdc, 0x0f, 0xa3, 0xd5, 0xf8, 0xd0, 0xb2, 0x74,
      0xdf, 0xef, 0x3e, 0x67, 0x20, 0xd8, 0x39, 0x6b, 0x34, 0xa8, 0x1a, 0xc2,
      0xe6, 0x4d, 0xa5, 0xb3, 0xe5, 0xd7, 0x66, 0x63, 0x23, 0xed, 0x7c, 0x56,
      0xe8, 0xbd, 0xd1, 0x79, 0xf3, 0xc6, 0xb2, 0xcf, 0x05, 0xbc, 0xac, 0x40,
      0x25, 0x13, 0xdd, 0x87},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     7,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     {0x09, 0x69, 0x58, 0x78, 0x6e, 0xe7, 0x97, 0x20, 0x50, 0xd6, 0x7a, 0x9e,
      0x4b, 0x69, 0xd6, 0xc6, 0xaf, 0x7d, 0xb7, 0xcc, 0x67, 0x43, 0x86, 0xdf,
      0x72, 0x57, 0x70, 0xdd, 0x29, 0x12, 0x9b, 0x82, 0x6e, 0x39, 0x55, 0x23,
      0x30, 0x10, 0x4c, 0x8d, 0x71, 0xe6, 0xcc, 0x3a, 0x30, 0x14, 0xdd, 0x2f,
      0x61, 0xb5, 0x41, 0x53, 0xaf, 0x51, 0xb0, 0x43, 0x8d, 0x44, 0x7e, 0xe9,
      0x39, 0xf9, 0xe3, 0xc1, 0x3b, 0xb8, 0xb0, 0x0a, 0x37, 0xde, 0xa6, 0xa0,
      0x68, 0xf6, 0xc9, 0xd2, 0x7e, 0x84, 0x8b, 0x1b, 0xe7, 0xa1, 0xee, 0xeb,
      0x3e, 0xe5, 0x0b, 0x78, 0x03, 0x6f, 0xba, 0x95, 0xae, 0x46, 0x94, 0x8c,
      0xa5, 0xb1, 0x3f, 0x35, 0x6e, 0xa2, 0x4d, 0xb1, 0x0f, 0x60, 0xdc, 0x09,
      0xe4, 0xb8, 0xba, 0xd8, 0xf7, 0x66, 0xb6, 0x68, 0xef, 0x72, 0x52, 0x44,
      0x32, 0x08, 0x0a, 0x0c, 0xe0, 0x0e, 0xd6, 0x76, 0xd6, 0xd5, 0xe3, 0x54,
      0x98, 0x4b, 0x10, 0x78, 0x52, 0x04, 0x12, 0x52, 0x58, 0x48, 0x15, 0x6d,
      0x06, 0xf0, 0x65, 0x24, 0x69, 0xf9, 0x57, 0x91, 0xba, 0xa3, 0xd9, 0xa7,
      0x98, 0xae, 0x53, 0x70, 0x94, 0xf7, 0x6f, 0x97, 0x6f, 0xae, 0xcd, 0x5c,
      0x9c, 0xe0, 0xc9, 0x30, 0xa7, 0x59, 0x10, 0xc6, 0x3d, 0xac, 0xf6, 0x34,
      0x85, 0xcb, 0x4b, 0x5e, 0x7b, 0xdb, 0xcf, 0x4d, 0x80, 0xe7, 0x40, 0x37,
      0xea, 0xa1, 0xa8, 0xfe, 0x4b, 0x52, 0x93, 0x0b, 0xec, 0x6b, 0xe9, 0x9c,
      0xf6, 0xac, 0x88, 0xcf, 0x58, 0x78, 0xdb, 0xf6, 0x85, 0x9d, 0x45, 0x6a,
      0x95, 0xdb, 0xc3, 0x46, 0x54, 0xee, 0xc4, 0x25, 0xde, 0x84, 0xca, 0x2a,
      0x53, 0x5d, 0x51, 0x74, 0x03, 0xa9, 0xaa, 0xda, 0x82, 0x7e, 0x7d, 0x00,
      0x93, 0xec, 0xfc, 0x97, 0xed, 0x05, 0x6a, 0x76, 0x52, 0x82, 0x5e, 0x9a,
      0x45, 0xcb, 0x2d, 0xcb},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     8,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x65, 0x83, 0xe2, 0xf1, 0x76, 0xaa, 0x7e, 0x7f, 0x65, 0x5d, 0x2c, 0x53,
      0x49, 0x73, 0x49, 0xc1, 0x56, 0xc8, 0x85, 0x1f, 0xb2, 0x33, 0x25, 0x58,
      0x9e, 0x85, 0xfb, 0x83, 0xbf, 0xa8, 0x57, 0x34, 0x6c, 0xab, 0xa2, 0x22,
      0xcd, 0xaa, 0x32, 0x34, 0xe7, 0x15, 0x64, 0x15, 0x42, 0x98, 0xc2, 0x4d,
      0xbb, 0x85, 0xe1, 0x88, 0x22, 0xa1, 0xd5, 0xe7, 0xfa, 0xa4, 0x78, 0x63,
      0xa6, 0x4d, 0x76, 0x87, 0x4a, 0x3c, 0xbc, 0x70, 0xf4, 0xd9, 0xf1, 0x37,
      0x42, 0x6a, 0x34, 0x4c, 0x47, 0x3f, 0xac, 0x1d, 0xd7, 0x00, 0x8a, 0x99,
      0x73, 0x76, 0x5e, 0x9f, 0x66, 0xc5, 0xb4, 0x92, 0x53, 0x5a, 0x64, 0x7c,
      0x27, 0x3c, 0x4f, 0x78, 0xce, 0xb5, 0xaa, 0x7b, 0xa9, 0x63, 0xa2, 0x14,
      0x2f, 0x2c, 0xe4, 0xa8, 0x1f, 0x80, 0x4c, 0x00, 0x2b, 0x9b, 0x2e, 0xab,
      0xb3, 0xc7, 0x5e, 0x80, 0xa3, 0xc6, 0xce, 0xaf, 0xe5, 0x38, 0x4a, 0x54,
      0x4c, 0x67, 0x2a, 0x5d, 0x28, 0xd3, 0x2b, 0xb8, 0x71, 0x15, 0xf4, 0x3e,
      0xb7, 0x97, 0x75, 0xfd, 0x9b, 0x3f, 0x4a, 0x2f, 0x6e, 0x6a, 0x89, 0x36,
      0x8b, 0xdd, 0x95, 0xef, 0x1d, 0x01, 0x48, 0x77, 0xb6, 0x0a, 0xfd, 0xb1,
      0x23, 0x4a, 0xcd, 0x57, 0x65, 0x3a, 0x65, 0x45, 0x9f, 0x01, 0xb2, 0xfb,
      0xe3, 0x81, 0xf2, 0x2a, 0x73, 0x95, 0x04, 0xb4, 0x89, 0x7a, 0x7e, 0x6c,
      0x33, 0xb6, 0x34, 0x9b, 0x27, 0x6d, 0xb6, 0x08, 0x3a, 0xba, 0xd9, 0xc1,
      0x69, 0x40, 0x58, 0x59, 0xb8, 0x00, 0xc8, 0x12, 0x23, 0x76, 0x34, 0xb5,
      0x03, 0xde, 0x6a, 0xda, 0x43, 0x01, 0x3c, 0x1d, 0x86, 0x69, 0x7a, 0x13,
      0x5b, 0xe7, 0x8a, 0x97, 0x84, 0x57, 0x6d, 0x79, 0x6d, 0x62, 0xaa, 0x78,
      0x19, 0xe2, 0xea, 0x0e, 0x2d, 0x90, 0x2f, 0xfd, 0xd9, 0xcf, 0xdd, 0x1a,
      0xe6, 0x62, 0x12, 0xee},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     priv_key_1,
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     9,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa0, 0x44, 0x3b, 0xa4, 0x34, 0x15, 0x6d, 0x0b, 0x50, 0x3e, 0xc6, 0x62,
      0xf5, 0xeb, 0x5b, 0x10, 0xe2, 0x0a, 0xd0, 0xcb, 0x82, 0x33, 0x72, 0x0e,
      0xe1, 0x87, 0xba, 0x98, 0x6e, 0x48, 0x11, 0xdd, 0x31, 0x28, 0x44, 0xd3,
      0xed, 0xb2, 0x6b, 0xfa, 0xf5, 0x1b, 0x4b, 0x92, 0x68, 0xdc, 0x3c, 0x76,
      0x07, 0x2d, 0xd4, 0x7c, 0x19, 0x9d, 0x71, 0x3c, 0x91, 0x82, 0x4d, 0xa2,
      0x3f, 0xf0, 0x04, 0x81, 0xee, 0x69, 0xe9, 0xd4, 0xcc, 0x54, 0x31, 0x20,
      0xfc, 0x33, 0xb7, 0x24, 0x4b, 0xf0, 0xc1, 0xad, 0x5f, 0xdd, 0x1a, 0xe9,
      0xcb, 0xad, 0xa7, 0xfe, 0x9a, 0x70, 0xad, 0x0a, 0xfa, 0xaa, 0xad, 0x83,
      0x61, 0xe8, 0xdc, 0x4b, 0x31, 0x98, 0xae, 0x66, 0x1a, 0x84, 0xe2, 0x75,
      0xb6, 0x0b, 0xf2, 0xeb, 0xb8, 0x5e, 0x51, 0x2d, 0xa7, 0x85, 0xd2, 0xfc,
      0x34, 0x82, 0x29, 0x4f, 0xa1, 0x19, 0x67, 0x68, 0x1d, 0x7b, 0xce, 0xff,
      0xc0, 0x8c, 0xe0, 0xe3, 0x6f, 0x0a, 0x8a, 0xf7, 0xfc, 0xfb, 0x13, 0x37,
      0x18, 0x68, 0x63, 0xc2, 0xc1, 0xc1, 0xb9, 0x4c, 0x9e, 0xc9, 0x78, 0x5c,
      0xd3, 0xd9, 0x4d, 0x15, 0x43, 0x7c, 0x23, 0xb7, 0x75, 0x67, 0x7f, 0x3d,
      0x29, 0xa4, 0xc9, 0xe5, 0x2f, 0x13, 0x39, 0x8f, 0xd1, 0x46, 0x61, 0x16,
      0x0e, 0x58, 0x68, 0xbc, 0xa9, 0x76, 0x25, 0xaa, 0x6c, 0x7e, 0xcb, 0x07,
      0xbb, 0xb4, 0x79, 0x64, 0x4d, 0xef, 0x35, 0x3f, 0x1f, 0x01, 0xa4, 0xc4,
      0x10, 0x0f, 0x9a, 0xdb, 0x82, 0xc4, 0xf6, 0xa2, 0x65, 0xa5, 0xee, 0x96,
      0x2d, 0xa5, 0x8c, 0x3c, 0x04, 0x2a, 0xa5, 0x49, 0xc9, 0xd2, 0xde, 0x30,
      0x08, 0xe7, 0x44, 0x8e, 0x0c, 0x4b, 0x9b, 0x4a, 0xc8, 0xf5, 0xe4, 0xd8,
      0x62, 0x98, 0x73, 0x90, 0x9b, 0xb9, 0x95, 0xcc, 0xc0, 0x82, 0x5f, 0xe8,
      0x7d, 0x81, 0xd5, 0x96},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
      0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13},
     priv_key_1,
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     10,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x26, 0xaa, 0x8e, 0x79, 0x31, 0xed, 0x62, 0x4b, 0xfd, 0x40, 0x77, 0xe3,
      0xb8, 0x3e, 0xc0, 0x8d, 0xe0, 0x80, 0x48, 0x3a, 0x61, 0x64, 0x1e, 0x87,
      0x7f, 0x49, 0x3f, 0xb7, 0xd0, 0xae, 0x4d, 0xfe, 0xbd, 0x4f, 0x05, 0x61,
      0x2a, 0x2e, 0x48, 0x69, 0xd2, 0x0d, 0x44, 0x0a, 0x64, 0xe9, 0x28, 0xb1,
      0x3d, 0xaa, 0x3b, 0x79, 0xda, 0x2e, 0xd6, 0x74, 0xb9, 0x94, 0x21, 0xdf,
      0x7e, 0x7f, 0x62, 0x5a, 0x22, 0xb1, 0xc7, 0x11, 0x36, 0xda, 0x27, 0xdb,
      0x69, 0x9d, 0x3d, 0xd9, 0x6e, 0x33, 0x64, 0xee, 0x0c, 0xd2, 0x12, 0x3a,
      0xb6, 0x80, 0x89, 0x30, 0xc6, 0xbc, 0x28, 0xa5, 0xdc, 0x30, 0x78, 0x80,
      0xd1, 0xab, 0x4b, 0x03, 0xbc, 0xd6, 0x17, 0x8a, 0x81, 0xb8, 0xad, 0x52,
      0xaa, 0xff, 0xfb, 0xab, 0x38, 0x7d, 0x40, 0x35, 0x2d, 0xfe, 0xa5, 0x26,
      0xab, 0xed, 0xca, 0x01, 0x6c, 0x87, 0xe9, 0xe5, 0x6c, 0xcc, 0x4c, 0x88,
      0xe8, 0x0f, 0x57, 0x9d, 0xa0, 0x15, 0xb9, 0x79, 0xbc, 0xdd, 0x88, 0x61,
      0x8b, 0x2a, 0x32, 0xce, 0x07, 0x29, 0x18, 0xb2, 0xe2, 0x23, 0x53, 0x53,
      0x59, 0xf1, 0xce, 0x4e, 0xab, 0xa5, 0xe6, 0x92, 0xe6, 0x29, 0x6b, 0x21,
      0x40, 0xdc, 0x23, 0x04, 0x09, 0x2e, 0xbd, 0x6f, 0x13, 0x6a, 0x48, 0x09,
      0x2b, 0x38, 0x49, 0x08, 0x2b, 0x57, 0xe7, 0x0c, 0x93, 0xb5, 0x4d, 0xb5,
      0x50, 0x45, 0xdd, 0x60, 0x94, 0xef, 0x3d, 0x2c, 0xfa, 0x8b, 0xc9, 0xe2,
      0xfd, 0x2b, 0x1b, 0xbe, 0x0c, 0x7c, 0x60, 0x3a, 0xd3, 0x8d, 0x3f, 0x40,
      0xc9, 0xea, 0xc8, 0xae, 0x5e, 0x28, 0xcb, 0xbb, 0x03, 0x1c, 0x38, 0xd9,
      0x3d, 0x3b, 0x25, 0x41, 0xd9, 0x4e, 0xab, 0x3a, 0x1e, 0x89, 0x92, 0xa4,
      0x44, 0xee, 0x4c, 0xe7, 0xb8, 0xd0, 0x8c, 0x0b, 0x9a, 0x4f, 0x62, 0x3d,
      0x32, 0xfc, 0xba, 0x14},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
      0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
      0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f},
     priv_key_1,
     true},

    // Comment: Longest valid message size
    // tcID: 11
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     11,
     {0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78},
     {0x7e, 0xfb, 0x69, 0xf1, 0x13, 0x7d, 0x6a, 0x6e, 0x81, 0x3b, 0x7a, 0xb7,
      0x5b, 0xf0, 0x40, 0x0b, 0x3d, 0x07, 0xa4, 0x42, 0xb8, 0x8a, 0xb0, 0x48,
      0x67, 0x5d, 0xc0, 0x6b, 0x02, 0x15, 0xfc, 0x1a, 0x2e, 0x03, 0x32, 0x63,
      0xec, 0x31, 0xa6, 0xc1, 0xd2, 0xea, 0xc5, 0x6c, 0xb0, 0x47, 0x0d, 0x69,
      0x02, 0x2a, 0x48, 0x13, 0x1d, 0x1f, 0x00, 0x0b, 0xbe, 0xd7, 0x05, 0x86,
      0xb8, 0x0c, 0xf6, 0x35, 0x64, 0x65, 0xc8, 0x83, 0x4d, 0xac, 0xed, 0x7e,
      0xa2, 0xa5, 0xff, 0x8e, 0xf9, 0xc4, 0x4d, 0x5a, 0xb8, 0x28, 0xff, 0xbf,
      0x05, 0x56, 0xa6, 0x39, 0x47, 0x52, 0xa4, 0xa2, 0x8a, 0x70, 0xca, 0xe2,
      0x00, 0x84, 0xe1, 0x23, 0x6f, 0x04, 0x2f, 0x6c, 0x29, 0xde, 0x5c, 0xb3,
      0x4e, 0xf7, 0x3a, 0xcb, 0xa5, 0xab, 0xcc, 0x7c, 0xcb, 0x3a, 0x26, 0x34,
      0x27, 0x01, 0xdf, 0x3b, 0x9d, 0xaa, 0x94, 0x5d, 0x9f, 0xa5, 0xbf, 0x0b,
      0x9b, 0x10, 0x30, 0x66, 0x55, 0xe5, 0x63, 0x70, 0x18, 0x3f, 0x50, 0xfb,
      0x83, 0x21, 0xf8, 0xf0, 0xcd, 0x1c, 0x72, 0x11, 0x47, 0x91, 0xfc, 0xa5,
      0xdf, 0x21, 0x66, 0x29, 0x6b, 0x50, 0x9b, 0x01, 0xa0, 0xb2, 0x91, 0xc4,
      0x61, 0x10, 0x78, 0x7c, 0xeb, 0xe6, 0x9d, 0x41, 0xb3, 0xb1, 0xe8, 0x95,
      0x90, 0xbc, 0x2f, 0x5e, 0x5d, 0x49, 0xea, 0x24, 0xae, 0x0f, 0x12, 0x07,
      0xee, 0xf1, 0xae, 0xe5, 0x4b, 0x97, 0x60, 0x55, 0x3e, 0x80, 0xc5, 0x50,
      0x6a, 0x8a, 0x8a, 0x75, 0x73, 0x2e, 0x92, 0x87, 0x50, 0x25, 0xf0, 0xbf,
      0xd5, 0xea, 0xd7, 0x1e, 0x43, 0x40, 0xc8, 0xa9, 0xfa, 0x16, 0xdc, 0xd5,
      0xa7, 0xdc, 0x96, 0xd8, 0xc4, 0xa7, 0xdc, 0x4e, 0x91, 0xf4, 0x7a, 0x69,
      0x36, 0x64, 0x45, 0xc4, 0x69, 0x5c, 0x8b, 0xad, 0x57, 0x8f, 0xfe, 0x52,
      0xbb, 0x67, 0x2f, 0x65},
     {},
     priv_key_1,
     true},

    // Comment: first byte of l_hash modified
    // tcID: 12
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     12,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x28, 0x7d, 0x71, 0x08, 0xa1, 0xc6, 0xe7, 0xa1, 0x8a, 0xcb, 0x00, 0x45,
      0xb2, 0x0c, 0x57, 0xcd, 0xf2, 0xac, 0x03, 0x45, 0x6b, 0x44, 0x94, 0x27,
      0x64, 0xa7, 0xa9, 0xe9, 0xfd, 0xf3, 0xdb, 0x48, 0x1d, 0x7e, 0x20, 0x2e,
      0x4c, 0x8d, 0x73, 0x3b, 0x56, 0xb9, 0xc1, 0xe9, 0x3d, 0x71, 0xe7, 0x91,
      0xaf, 0x83, 0x25, 0xc9, 0x36, 0x3d, 0xf7, 0x89, 0xb2, 0x52, 0xa5, 0xed,
      0x0e, 0xdd, 0xc7, 0x9e, 0x76, 0xfa, 0x41, 0xc2, 0xcb, 0x0a, 0x35, 0x61,
      0x83, 0x98, 0x21, 0x7a, 0x39, 0x0a, 0x5e, 0x6d, 0x99, 0xee, 0xd9, 0x05,
      0xd5, 0x55, 0x4d, 0x19, 0xc1, 0xcf, 0x4e, 0x30, 0xbd, 0xf1, 0xc2, 0xfc,
      0xc5, 0x14, 0x8b, 0x64, 0x1d, 0x71, 0xb3, 0xf1, 0x97, 0x7b, 0x63, 0xd2,
      0x32, 0x64, 0x8d, 0xdd, 0x93, 0x5e, 0xc9, 0x49, 0x9a, 0x53, 0xac, 0x2f,
      0xbc, 0xac, 0x55, 0xf4, 0x62, 0xe9, 0x10, 0x65, 0xad, 0xaa, 0x01, 0x8a,
      0x39, 0xc4, 0x53, 0xba, 0x75, 0x9b, 0xd6, 0x8b, 0x45, 0x40, 0x74, 0x15,
      0x34, 0x21, 0xe2, 0xce, 0x75, 0xcf, 0x14, 0x9f, 0x74, 0x8b, 0x5b, 0x84,
      0x75, 0x8d, 0xf8, 0xa4, 0x23, 0xd1, 0xc5, 0x0c, 0x88, 0x0a, 0xf8, 0x63,
      0xf2, 0xa6, 0xdf, 0x3c, 0xd4, 0x65, 0xca, 0x36, 0xaa, 0x21, 0x52, 0xb5,
      0x77, 0x1f, 0x3d, 0x50, 0x7f, 0x4a, 0x4d, 0xd9, 0xf8, 0x00, 0x6d, 0x80,
      0xec, 0xa2, 0x35, 0x37, 0x09, 0x22, 0x87, 0x97, 0x6f, 0x21, 0x8a, 0x90,
      0xdf, 0x1e, 0x16, 0xd8, 0x89, 0xfe, 0x31, 0xe7, 0x9f, 0x73, 0x09, 0xf3,
      0x22, 0x4f, 0x61, 0x3e, 0x9b, 0x52, 0x47, 0x9f, 0xe7, 0x3b, 0x7a, 0xad,
      0x91, 0x53, 0x19, 0xa3, 0xb6, 0x2a, 0x59, 0x36, 0x64, 0x9f, 0x7d, 0x01,
      0x5d, 0x7b, 0x09, 0xf7, 0xfa, 0x9f, 0x45, 0x4f, 0x78, 0xa7, 0xc3, 0xdd,
      0x4b, 0xf7, 0x91, 0xe0},
     {},
     priv_key_1,
     false},

    // Comment: last byte of l_hash modified
    // tcID: 13
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     13,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x8b, 0x65, 0x06, 0x5a, 0xf8, 0x27, 0x70, 0x62, 0x5d, 0x24, 0x91, 0x7d,
      0x13, 0xfd, 0x97, 0xae, 0x13, 0x24, 0x7c, 0xad, 0x97, 0x91, 0x0a, 0x26,
      0x51, 0xf9, 0x58, 0x00, 0x16, 0x5b, 0x76, 0xcc, 0x34, 0xbf, 0xe0, 0x6c,
      0xbf, 0x8c, 0x31, 0xa7, 0xd7, 0xab, 0x4f, 0x41, 0xe0, 0x5c, 0x45, 0xa2,
      0x5b, 0x90, 0xc6, 0x06, 0x37, 0x8c, 0x8e, 0x49, 0xc9, 0x5a, 0x15, 0xca,
      0x11, 0xae, 0x37, 0xe7, 0x97, 0xa0, 0x0f, 0x1b, 0x26, 0x80, 0xa6, 0x95,
      0x8c, 0x54, 0x39, 0x6b, 0xe4, 0xe1, 0xce, 0xed, 0xca, 0xbc, 0x58, 0xd9,
      0xf1, 0x36, 0xb3, 0x68, 0x67, 0xa2, 0xfe, 0xfe, 0x64, 0x8a, 0x97, 0x58,
      0xf4, 0x96, 0x34, 0xbf, 0xbc, 0xaa, 0x48, 0x71, 0x7a, 0x11, 0x6c, 0xba,
      0x58, 0xc2, 0x75, 0x39, 0xbe, 0x10, 0xc5, 0x69, 0x11, 0xaa, 0xbe, 0x01,
      0x3e, 0x03, 0x29, 0x64, 0x5e, 0x83, 0x08, 0x42, 0x3c, 0x3a, 0xa4, 0x2e,
      0x0c, 0x9b, 0x1f, 0x4b, 0x5f, 0x54, 0x6d, 0xdd, 0x9f, 0x90, 0xbf, 0x4d,
      0x00, 0x7d, 0xab, 0x52, 0xac, 0x38, 0x79, 0xdb, 0x75, 0x5e, 0x4f, 0x2b,
      0x96, 0xdb, 0x5c, 0xf0, 0x19, 0x50, 0xf3, 0x90, 0x76, 0xf2, 0x61, 0xf5,
      0x0b, 0x1b, 0xae, 0x13, 0x7b, 0xe5, 0x00, 0xb0, 0x3c, 0xef, 0xf6, 0xea,
      0x1b, 0xbd, 0x80, 0xb3, 0x34, 0x24, 0xf7, 0xfa, 0xba, 0x5c, 0xc6, 0xb8,
      0x66, 0x70, 0xfc, 0xb7, 0xdb, 0x1a, 0x9b, 0x3c, 0x58, 0xbd, 0xfd, 0x7b,
      0x75, 0xba, 0x9f, 0x3e, 0xbd, 0x34, 0xae, 0x32, 0xd3, 0x20, 0xc7, 0x57,
      0x02, 0x0a, 0x73, 0x24, 0xdf, 0x7d, 0x39, 0x85, 0xbc, 0xcf, 0xe0, 0xe8,
      0x1b, 0xb7, 0xf6, 0x1b, 0xd9, 0x8c, 0xb3, 0x72, 0x19, 0x31, 0x22, 0x99,
      0xb4, 0xf2, 0x74, 0xb2, 0xc9, 0x0c, 0x52, 0xa8, 0xe1, 0x79, 0x0f, 0x52,
      0xe8, 0xfd, 0xd7, 0x68},
     {},
     priv_key_1,
     false},

    // Comment: l_hash changed to all 0
    // tcID: 14
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     14,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x35, 0x6e, 0x91, 0xdb, 0x9b, 0xd9, 0x32, 0xc7, 0xb5, 0x72, 0x6d, 0xa2,
      0x88, 0xe2, 0x62, 0x0c, 0xd7, 0x96, 0x67, 0xc2, 0xe1, 0xd7, 0xac, 0xa5,
      0x62, 0x33, 0x1c, 0xea, 0xa6, 0xe4, 0xab, 0x47, 0x66, 0x52, 0x13, 0xed,
      0x75, 0x57, 0x9a, 0xbb, 0x14, 0x77, 0x28, 0xbc, 0xff, 0x60, 0x78, 0x7c,
      0x95, 0x10, 0x7f, 0x5b, 0xe7, 0x87, 0xc4, 0x2e, 0x71, 0x4d, 0x51, 0x62,
      0x7f, 0xcc, 0x8b, 0x4e, 0xa7, 0x1c, 0x23, 0x2c, 0x0c, 0x80, 0xce, 0x61,
      0x63, 0xcd, 0x0f, 0xbf, 0xa9, 0xdd, 0x7e, 0x8c, 0x19, 0x90, 0x17, 0x6a,
      0xbc, 0x27, 0x05, 0xf4, 0xff, 0xcf, 0x1d, 0x5c, 0x62, 0x39, 0x3e, 0xab,
      0x1c, 0x0e, 0xc8, 0xa6, 0x53, 0xa9, 0x0f, 0x27, 0xa9, 0x68, 0xdf, 0x8f,
      0x4a, 0xf6, 0x22, 0xe9, 0x6f, 0x66, 0x3f, 0xce, 0xea, 0xd8, 0xb0, 0xbf,
      0x5d, 0xff, 0x65, 0xcd, 0x65, 0x7a, 0x72, 0xb9, 0xc3, 0x32, 0x65, 0xc5,
      0xc2, 0xa8, 0xf7, 0xf9, 0xc6, 0x14, 0xb9, 0xc2, 0xf8, 0xa9, 0x52, 0x46,
      0x97, 0x0e, 0x6a, 0x77, 0x8a, 0xca, 0x4b, 0x12, 0x55, 0x2d, 0xa4, 0x7c,
      0x27, 0x42, 0x82, 0xad, 0x92, 0x05, 0xec, 0xd2, 0x26, 0x4a, 0xe3, 0xc6,
      0x49, 0x59, 0x7b, 0xea, 0xa3, 0x5c, 0x14, 0x19, 0x10, 0xe8, 0x42, 0x33,
      0x77, 0x6d, 0x41, 0x94, 0x48, 0xf5, 0x50, 0x19, 0xa8, 0x4e, 0x19, 0x9a,
      0x48, 0x67, 0xd6, 0x8b, 0xf2, 0x13, 0xf4, 0x7b, 0x03, 0x16, 0xd5, 0x00,
      0x79, 0xda, 0xb7, 0x72, 0x99, 0xfb, 0xbe, 0x7f, 0xe8, 0x92, 0x99, 0x06,
      0x46, 0x1c, 0x11, 0x03, 0xa9, 0x7c, 0x2b, 0x3f, 0x16, 0x33, 0xc8, 0xef,
      0x03, 0xe8, 0x20, 0xec, 0x67, 0x5e, 0x33, 0x1c, 0xd1, 0xfd, 0xa8, 0xeb,
      0xfe, 0xdf, 0x54, 0x1d, 0x0f, 0x2b, 0x57, 0x1f, 0x4e, 0xaf, 0x29, 0x2c,
      0xe0, 0xab, 0x14, 0xc1},
     {},
     priv_key_1,
     false},

    // Comment: l_hash changed to all 1
    // tcID: 15
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     15,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x5a, 0x6e, 0xfd, 0xd2, 0xd2, 0x11, 0xd5, 0x03, 0x66, 0x88, 0x5e, 0x17,
      0x71, 0x90, 0xce, 0x16, 0x21, 0xba, 0x11, 0x0e, 0xe4, 0x65, 0x30, 0xbd,
      0x08, 0x3b, 0xa7, 0x6e, 0xd4, 0x89, 0x92, 0xd8, 0x5e, 0xfd, 0x8f, 0x9b,
      0xa9, 0x64, 0xeb, 0x33, 0xe5, 0x96, 0xe0, 0xc0, 0xbc, 0xb5, 0x45, 0xf8,
      0x9e, 0x2c, 0x95, 0x92, 0xed, 0x18, 0x49, 0x5e, 0x8e, 0x5d, 0xf1, 0x86,
      0x6f, 0xe3, 0x0b, 0x27, 0x52, 0x2a, 0x3a, 0xd9, 0xcf, 0x71, 0x24, 0xc4,
      0xaa, 0x23, 0xf7, 0xc9, 0x25, 0x90, 0x06, 0x13, 0xc5, 0x0b, 0x7c, 0x18,
      0x87, 0x2b, 0x45, 0x37, 0xa7, 0x50, 0x41, 0x9a, 0xe1, 0x28, 0xe9, 0x13,
      0xe9, 0xa2, 0xd8, 0x7c, 0x21, 0x9e, 0x2c, 0xd0, 0x11, 0x32, 0x97, 0x22,
      0x98, 0x02, 0x8e, 0x54, 0xfe, 0x39, 0x4e, 0xf9, 0x77, 0x9d, 0x04, 0x54,
      0x3c, 0x72, 0xee, 0xc4, 0xc5, 0x73, 0x2c, 0xad, 0xff, 0x0b, 0x95, 0x49,
      0x64, 0x70, 0x6b, 0xc4, 0x08, 0x57, 0x22, 0xb0, 0xc5, 0x95, 0x16, 0x2d,
      0x11, 0x79, 0x3a, 0xb2, 0x97, 0x54, 0x83, 0x7b, 0xf5, 0xd3, 0x24, 0xe2,
      0x18, 0x14, 0xea, 0x24, 0xb1, 0x2f, 0xed, 0x44, 0x1f, 0x20, 0xd2, 0x21,
      0x48, 0xba, 0x5a, 0x98, 0x7b, 0x6a, 0xa7, 0xc7, 0xd4, 0xab, 0x5a, 0x33,
      0xaf, 0x8e, 0x6c, 0x90, 0x96, 0xc2, 0x97, 0x77, 0xcb, 0x0d, 0x5c, 0xfe,
      0x93, 0x8a, 0x6e, 0xd5, 0xd3, 0x09, 0x36, 0xa5, 0xa8, 0xf5, 0xfc, 0x43,
      0x5d, 0xf1, 0x4d, 0x1c, 0x43, 0x9d, 0x1b, 0x9d, 0x27, 0x42, 0x54, 0xe7,
      0xb2, 0x48, 0xbd, 0x20, 0xd2, 0x1d, 0xc4, 0x65, 0x2c, 0x16, 0x05, 0xd5,
      0xa2, 0x92, 0x9d, 0xb0, 0x18, 0xbd, 0x45, 0x79, 0x4a, 0x52, 0x3b, 0x21,
      0x7f, 0xe0, 0xa9, 0xa6, 0xb0, 0x70, 0x41, 0x97, 0xba, 0x81, 0x26, 0xfc,
      0x83, 0x11, 0x55, 0x6f},
     {},
     priv_key_1,
     false},

    // Comment: first byte of ps modified
    // tcID: 16
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     16,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x52, 0x58, 0x2e, 0x10, 0x26, 0x46, 0x30, 0xe1, 0x58, 0x41, 0x55, 0xf5,
      0xe9, 0x70, 0xb8, 0xed, 0xa9, 0x10, 0x8a, 0x87, 0x37, 0x08, 0x61, 0xcd,
      0xa1, 0x2e, 0xe7, 0x73, 0x41, 0x1c, 0xf5, 0x56, 0xdb, 0x32, 0x8c, 0x8a,
      0x2a, 0x16, 0x5d, 0x10, 0xf6, 0xf9, 0x69, 0xac, 0x61, 0xb1, 0x70, 0xa7,
      0x59, 0x75, 0xfb, 0xdf, 0x93, 0x19, 0xd1, 0x3c, 0x95, 0x35, 0xf3, 0x0d,
      0x62, 0x1d, 0xb1, 0x9e, 0x41, 0xda, 0x3a, 0x04, 0xfe, 0x40, 0x87, 0x4c,
      0xaf, 0x77, 0x9c, 0x8f, 0x03, 0xbd, 0x5d, 0x18, 0x92, 0xe5, 0x29, 0x25,
      0xb1, 0x83, 0xc1, 0x18, 0x44, 0x6e, 0xd9, 0xa3, 0x35, 0xe9, 0xc1, 0xdc,
      0x45, 0x19, 0xfb, 0x12, 0x53, 0x21, 0x5e, 0x5f, 0x8d, 0x8e, 0xe6, 0xd4,
      0x9c, 0x01, 0x67, 0xaf, 0x9d, 0x5c, 0xa5, 0xb1, 0xac, 0xe0, 0x67, 0xaf,
      0x57, 0x3e, 0x0b, 0xe9, 0xa6, 0x1b, 0xee, 0xcc, 0xda, 0xc3, 0x7b, 0x0e,
      0x54, 0xf6, 0xb0, 0xf7, 0x05, 0x76, 0xcb, 0x8a, 0x40, 0x0d, 0x01, 0x13,
      0x63, 0x57, 0xa8, 0x57, 0x6e, 0x81, 0xc1, 0x19, 0xd3, 0xdd, 0x91, 0xc7,
      0xb5, 0xcb, 0x34, 0x36, 0x92, 0xa8, 0x10, 0x36, 0x2e, 0x1e, 0x6d, 0xc0,
      0x6c, 0x17, 0x46, 0xe0, 0x71, 0xa9, 0x03, 0xa2, 0x85, 0x6b, 0x44, 0x46,
      0xf1, 0x0f, 0x78, 0xc6, 0x70, 0xd6, 0x17, 0xe5, 0xe2, 0x4d, 0xc5, 0xc0,
      0xe4, 0x5c, 0xaa, 0xfb, 0xf8, 0xff, 0xc4, 0xaf, 0x6b, 0x3e, 0xf9, 0x98,
      0xfe, 0x1b, 0xfb, 0x59, 0xaa, 0xcb, 0x16, 0xd9, 0x8d, 0x7e, 0x38, 0x96,
      0x79, 0x93, 0x98, 0x61, 0xa6, 0x72, 0x2c, 0x4e, 0x29, 0xaf, 0x73, 0x1d,
      0xa9, 0x9d, 0x17, 0x05, 0x8d, 0x7a, 0x12, 0xea, 0xd0, 0xd3, 0xd5, 0x76,
      0xde, 0x79, 0x6a, 0xd2, 0xad, 0x59, 0x6f, 0xea, 0xda, 0x4c, 0x09, 0x1f,
      0x10, 0x74, 0x85, 0x36},
     {},
     priv_key_1,
     false},

    // Comment: ps terminated by 0xff
    // tcID: 17
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     17,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x3f, 0x5e, 0x00, 0x34, 0x7c, 0x36, 0xce, 0xb7, 0x9f, 0x40, 0x0e, 0xff,
      0xca, 0xe9, 0x2d, 0x33, 0x1a, 0xa9, 0xf5, 0x25, 0x39, 0x04, 0x1c, 0x50,
      0xdb, 0xbc, 0x6f, 0xd0, 0x71, 0x91, 0x29, 0x12, 0x69, 0x2a, 0x16, 0x35,
      0x33, 0x78, 0x27, 0x6a, 0x2c, 0x15, 0x96, 0x35, 0x8c, 0x46, 0xf6, 0x23,
      0x24, 0x34, 0xa9, 0x5a, 0x99, 0xc5, 0x73, 0xd0, 0xb8, 0x3e, 0x4a, 0x6e,
      0x97, 0x0a, 0x73, 0xe9, 0x9c, 0xa1, 0x3d, 0x73, 0x45, 0x06, 0xe2, 0xa2,
      0xa5, 0x67, 0x44, 0xb1, 0x87, 0x2b, 0xff, 0xd5, 0x01, 0xa8, 0x0b, 0xa7,
      0xcf, 0x54, 0x94, 0xdf, 0x6f, 0xf9, 0xb4, 0x21, 0xcb, 0x10, 0x24, 0x7e,
      0x11, 0xd1, 0x9a, 0xc9, 0xe6, 0x0a, 0xfe, 0x0d, 0xda, 0x87, 0xcb, 0x35,
      0x1c, 0x21, 0xba, 0x55, 0x4e, 0xa5, 0x0b, 0x70, 0xf6, 0xee, 0xe4, 0xff,
      0xa9, 0x49, 0xae, 0x38, 0x69, 0x4e, 0xf8, 0x31, 0x02, 0x0d, 0x4e, 0x59,
      0x9c, 0x6f, 0xf4, 0x49, 0x3d, 0x07, 0xc7, 0xb6, 0xbe, 0x06, 0x45, 0x3b,
      0x84, 0x14, 0x38, 0x13, 0xa6, 0x8d, 0xfe, 0x0f, 0xad, 0xa2, 0x31, 0x7a,
      0x9f, 0x40, 0x40, 0xa3, 0xcf, 0x63, 0x08, 0x09, 0x0b, 0x6b, 0xfa, 0xca,
      0x36, 0x06, 0x73, 0x12, 0xf4, 0x1b, 0xc0, 0xc4, 0xc0, 0x1a, 0xc0, 0x0f,
      0xdb, 0x5a, 0xee, 0x43, 0x95, 0xb0, 0x4c, 0xdf, 0xf8, 0x2c, 0xb4, 0x33,
      0xb0, 0x1c, 0xd3, 0xe7, 0x0d, 0xaa, 0xfc, 0x78, 0x07, 0xb2, 0xf7, 0x70,
      0x22, 0x66, 0x99, 0xe7, 0x53, 0x51, 0x24, 0xa4, 0x53, 0xf7, 0xad, 0x26,
      0x53, 0xbf, 0xb7, 0xcf, 0xe7, 0x1e, 0x12, 0x0d, 0xc3, 0x7b, 0xa8, 0x8a,
      0x5b, 0xe3, 0x47, 0xad, 0x13, 0x43, 0x51, 0xc1, 0x1f, 0xf1, 0x01, 0x9b,
      0x7e, 0x42, 0xd2, 0x4b, 0x7a, 0x38, 0x90, 0xa8, 0x42, 0x4f, 0xae, 0x53,
      0xa1, 0x0c, 0x0e, 0x11},
     {},
     priv_key_1,
     false},

    // Comment: ps is all zero
    // tcID: 18
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     18,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa1, 0x66, 0xbf, 0x7b, 0x5c, 0x2c, 0xf1, 0x89, 0x6c, 0x0b, 0x92, 0x4a,
      0x69, 0x23, 0x3a, 0x0a, 0x58, 0x5b, 0xd4, 0x7e, 0xd7, 0xf2, 0x33, 0x06,
      0x54, 0xaa, 0x68, 0x80, 0x6d, 0xeb, 0x0f, 0xf6, 0x8c, 0x64, 0x75, 0x05,
      0x0a, 0xb4, 0x5c, 0x69, 0x1b, 0xbb, 0xcc, 0x58, 0xdb, 0xc2, 0xf5, 0xc8,
      0x17, 0x72, 0x9e, 0x8e, 0x19, 0x5e, 0xbd, 0x39, 0xd4, 0x8b, 0xd5, 0xe1,
      0x49, 0x77, 0xab, 0xae, 0x08, 0x29, 0x63, 0x68, 0x31, 0x65, 0x59, 0x17,
      0xfb, 0x5a, 0x75, 0x8f, 0xb4, 0x3a, 0x8e, 0x50, 0x5d, 0x6c, 0xe5, 0x95,
      0xf6, 0x25, 0x97, 0x06, 0x85, 0xf7, 0xec, 0x81, 0xcb, 0x55, 0x92, 0x21,
      0x0f, 0x5d, 0x68, 0xc6, 0xe2, 0xe1, 0xef, 0x26, 0xb4, 0xef, 0x8c, 0x92,
      0xbf, 0x44, 0xf0, 0x77, 0xe1, 0xd5, 0x09, 0x9f, 0x37, 0x9c, 0xb8, 0x12,
      0x0a, 0xd1, 0x85, 0xbf, 0x07, 0x87, 0x79, 0x79, 0xca, 0x81, 0xf2, 0x51,
      0xfb, 0x81, 0xbe, 0x0a, 0xd3, 0xc1, 0x4f, 0x4d, 0x78, 0x85, 0xfc, 0xec,
      0x49, 0x6f, 0x80, 0x03, 0x3f, 0xd4, 0x27, 0x9b, 0x68, 0x30, 0xa2, 0x0c,
      0xbd, 0xea, 0xd2, 0x7c, 0x09, 0x67, 0xe2, 0x8d, 0x1e, 0x06, 0xef, 0x4b,
      0xd7, 0xba, 0x89, 0x21, 0x0e, 0xc0, 0xd6, 0x96, 0x27, 0x4a, 0x18, 0x7d,
      0xc2, 0xf1, 0x32, 0x12, 0xf5, 0xad, 0xf0, 0x6e, 0x94, 0x50, 0xec, 0xa3,
      0x98, 0x32, 0x5c, 0xfd, 0xa7, 0x34, 0x31, 0x03, 0x6a, 0xc2, 0x1b, 0x08,
      0x7d, 0x37, 0x3c, 0x9f, 0x57, 0x5c, 0x94, 0x1f, 0x8c, 0xb0, 0x78, 0x96,
      0x11, 0x76, 0xe3, 0x18, 0x59, 0xa6, 0x1c, 0x49, 0xba, 0xf8, 0xff, 0x4f,
      0x81, 0x7a, 0x11, 0x01, 0x04, 0x48, 0xd6, 0xa0, 0xe4, 0x0d, 0xce, 0xde,
      0x1a, 0x5a, 0xc3, 0xbe, 0xfa, 0x4c, 0x6e, 0x9d, 0x9d, 0x67, 0xd8, 0xe8,
      0xfd, 0x8b, 0x6d, 0xe3},
     {},
     priv_key_1,
     false},

    // Comment: ps replaced by 0xff's
    // tcID: 19
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     19,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x75, 0x82, 0x9a, 0xc4, 0xd9, 0x78, 0x48, 0xdf, 0xba, 0x21, 0xc1, 0x68,
      0x8e, 0x93, 0x6c, 0xfc, 0x73, 0x6f, 0x53, 0xfd, 0xe5, 0xb9, 0x1d, 0x53,
      0x30, 0xb6, 0x3a, 0x99, 0x68, 0xdd, 0x4f, 0x51, 0xc2, 0xf5, 0x29, 0xfd,
      0x8d, 0x8f, 0x84, 0xe4, 0xa9, 0x08, 0x19, 0x6f, 0xcc, 0x5d, 0xeb, 0xa2,
      0x1b, 0x5c, 0x73, 0x00, 0xd7, 0x38, 0x1e, 0x07, 0xc4, 0xe0, 0xea, 0x21,
      0x84, 0x96, 0x51, 0x69, 0xcc, 0x94, 0x64, 0x93, 0x3e, 0xf5, 0xa8, 0x40,
      0xd8, 0x6b, 0x1d, 0xbc, 0xc9, 0x45, 0xc7, 0x54, 0x7d, 0x9e, 0xab, 0x24,
      0x5b, 0xa6, 0x4d, 0x24, 0x94, 0x6a, 0x75, 0x96, 0x11, 0x61, 0xc2, 0xb8,
      0xf4, 0x17, 0xda, 0xf1, 0x1b, 0x16, 0x3b, 0x1e, 0x5a, 0x5b, 0x02, 0xd4,
      0x53, 0x41, 0x38, 0x4f, 0x37, 0x75, 0x52, 0x48, 0xfa, 0x87, 0x1e, 0x6a,
      0x82, 0xf9, 0x48, 0xad, 0x62, 0x92, 0xf1, 0x14, 0x45, 0xbf, 0x30, 0x59,
      0x6d, 0xcc, 0xce, 0xc7, 0x3a, 0x44, 0x1c, 0xea, 0x5e, 0x5d, 0xc4, 0x70,
      0x01, 0x63, 0x09, 0xa8, 0x3b, 0x6c, 0x8f, 0x15, 0x85, 0x36, 0x68, 0x7a,
      0xd2, 0x73, 0x4d, 0x3e, 0xa1, 0x56, 0x2d, 0x46, 0xe2, 0x3b, 0xfe, 0x8c,
      0xab, 0x49, 0x8d, 0x19, 0xb0, 0xb1, 0x04, 0xd9, 0x71, 0x82, 0xaa, 0xcf,
      0x85, 0x2b, 0x6d, 0xb3, 0xc4, 0x67, 0x01, 0x09, 0xb8, 0x1a, 0xf1, 0xbd,
      0x99, 0xb4, 0x83, 0xd9, 0x2b, 0x3e, 0x4b, 0xd8, 0x13, 0xed, 0xfa, 0x4d,
      0x05, 0x13, 0x21, 0x4d, 0xcc, 0x5b, 0xb4, 0xda, 0x76, 0x8e, 0x86, 0x00,
      0x7c, 0x22, 0xf1, 0x1e, 0x5f, 0xe6, 0xf4, 0xcb, 0x60, 0xb9, 0x09, 0x95,
      0x8f, 0xb9, 0x4d, 0xea, 0x66, 0x0d, 0x3f, 0xff, 0x0b, 0x99, 0xdb, 0x15,
      0xc2, 0xd2, 0xe6, 0xc8, 0xdf, 0x74, 0x78, 0x33, 0x0d, 0xad, 0xe8, 0xc5,
      0x17, 0xb9, 0x09, 0x75},
     {},
     priv_key_1,
     false},

    // Comment: seed is all 0
    // tcID: 20
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     20,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x8e, 0x5f, 0x01, 0xff, 0x0c, 0x17, 0x75, 0x87, 0x07, 0x15, 0xfd, 0x03,
      0x66, 0xa8, 0x74, 0x85, 0x31, 0xf8, 0xb0, 0x08, 0x03, 0xdf, 0x35, 0xe0,
      0xe2, 0x30, 0x8d, 0xb6, 0x3b, 0xbe, 0xc4, 0xec, 0xa4, 0xe0, 0x93, 0x35,
      0x18, 0x76, 0xb7, 0x94, 0x21, 0x3b, 0x90, 0x4e, 0x5d, 0xde, 0x28, 0x4a,
      0x82, 0xd7, 0x4a, 0xbf, 0xcb, 0xff, 0xf9, 0x4b, 0xc9, 0xa8, 0x30, 0x0b,
      0xea, 0x99, 0xed, 0xd0, 0x7f, 0xe9, 0x7d, 0x6e, 0x0b, 0x11, 0x21, 0x9f,
      0x85, 0xac, 0x15, 0xac, 0xc4, 0x04, 0xd3, 0x7d, 0x3d, 0xa1, 0x68, 0x19,
      0xa1, 0x4a, 0x43, 0x8f, 0x3f, 0x72, 0xf8, 0x17, 0x8b, 0x31, 0x25, 0x26,
      0x23, 0x23, 0x86, 0xe9, 0x18, 0xa8, 0xa7, 0xe1, 0x1f, 0xc3, 0x8f, 0x46,
      0x68, 0xc4, 0x99, 0xa0, 0x04, 0x80, 0xcf, 0x9d, 0x2d, 0x75, 0xaa, 0xbc,
      0x01, 0x98, 0xd3, 0xba, 0x9b, 0xa3, 0x45, 0xfb, 0xa9, 0x10, 0x5c, 0x65,
      0x64, 0xdf, 0x5f, 0x6c, 0xe7, 0x96, 0xf1, 0x41, 0x00, 0xd1, 0x86, 0xab,
      0xff, 0xe4, 0xd8, 0x3d, 0x57, 0x96, 0x9c, 0x1c, 0xad, 0xdc, 0x7c, 0x7a,
      0xa3, 0x40, 0xb4, 0xd1, 0xba, 0xb2, 0x3d, 0x9b, 0x39, 0x82, 0x27, 0x83,
      0x28, 0xdd, 0xeb, 0xe6, 0x48, 0xf5, 0xc5, 0x25, 0x88, 0x73, 0x8f, 0x3c,
      0x56, 0xa8, 0x8b, 0x3f, 0x34, 0xc8, 0x90, 0xc0, 0x3f, 0xaf, 0xc2, 0x7f,
      0x48, 0x5a, 0x17, 0x67, 0x7a, 0x53, 0xe9, 0x74, 0xdc, 0x1d, 0xd8, 0x6f,
      0x46, 0x3a, 0x92, 0x7f, 0x43, 0x28, 0xac, 0x51, 0xbb, 0xc6, 0x17, 0x05,
      0xae, 0x8a, 0xbd, 0x7f, 0x45, 0x62, 0x89, 0x57, 0x48, 0x9e, 0x2d, 0xef,
      0xd8, 0xe0, 0x43, 0xb9, 0x55, 0xb1, 0x18, 0xfb, 0x2a, 0x1c, 0x40, 0x7d,
      0x45, 0x89, 0x30, 0x04, 0xaa, 0xe0, 0xf9, 0x45, 0xf0, 0x6a, 0xdd, 0x1e,
      0x45, 0xb4, 0x1a, 0x03},
     {},
     priv_key_1,
     true},

    // Comment: seed is all 1
    // tcID: 21
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     21,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x50, 0xc2, 0x3e, 0x2a, 0xd6, 0xe3, 0xf3, 0xb1, 0x0a, 0x57, 0x16, 0xcb,
      0xf6, 0x0e, 0xfc, 0xc9, 0xf6, 0x6d, 0x2c, 0x6f, 0x17, 0xbf, 0x05, 0x0b,
      0xa0, 0x15, 0x3b, 0x87, 0x7b, 0xa2, 0x75, 0x5e, 0x8a, 0x0d, 0x54, 0x06,
      0x00, 0x34, 0x56, 0x22, 0x66, 0x15, 0x57, 0x44, 0xef, 0x80, 0x54, 0x7b,
      0x8a, 0xf7, 0x77, 0xb0, 0xff, 0x76, 0x4f, 0xbb, 0x12, 0xba, 0xae, 0x49,
      0xd0, 0x2b, 0x4f, 0x6d, 0x65, 0xb6, 0xcd, 0x8f, 0x0a, 0x39, 0x78, 0x39,
      0x10, 0x1d, 0x32, 0xae, 0x16, 0x3f, 0xf2, 0xe6, 0x07, 0x27, 0x48, 0xd6,
      0xb8, 0x01, 0x7e, 0x5e, 0x73, 0xe3, 0x32, 0xd5, 0x3f, 0x4e, 0x91, 0xfe,
      0x62, 0x33, 0xa8, 0x2d, 0xbf, 0x54, 0xf3, 0x14, 0x6b, 0x48, 0x98, 0x03,
      0x57, 0x5c, 0x5e, 0xa3, 0x7a, 0xb5, 0x5a, 0x9e, 0xa7, 0xea, 0xe4, 0x7a,
      0xd4, 0xf1, 0x72, 0x7d, 0x45, 0x82, 0x2b, 0x56, 0x9c, 0xd6, 0xe5, 0xd4,
      0xb6, 0xab, 0x75, 0x98, 0x50, 0x94, 0x81, 0x86, 0x61, 0x6b, 0x5d, 0xa2,
      0xa9, 0xa3, 0x16, 0xf5, 0x7d, 0x89, 0x9f, 0x91, 0x93, 0x4b, 0xbb, 0x27,
      0xed, 0xcd, 0xfa, 0x19, 0x53, 0x2b, 0xa1, 0xc0, 0x1f, 0x37, 0x24, 0x73,
      0x8d, 0xaf, 0xfd, 0xd8, 0x8c, 0x9a, 0x18, 0x56, 0x2e, 0xbc, 0xbc, 0x49,
      0x18, 0x5b, 0x0a, 0x81, 0x74, 0x07, 0x90, 0x34, 0x76, 0xd4, 0x42, 0xc4,
      0x24, 0xc8, 0x1b, 0x63, 0xae, 0xb8, 0xf9, 0xd1, 0xb1, 0x84, 0x75, 0x6e,
      0x0c, 0xc0, 0xa3, 0x81, 0xea, 0xba, 0x45, 0xa8, 0x5c, 0x8b, 0xbc, 0x67,
      0x70, 0xfd, 0x04, 0x7f, 0xf1, 0xa6, 0x40, 0x4a, 0x38, 0x45, 0x99, 0xfb,
      0xbd, 0x6a, 0x40, 0xb2, 0x12, 0xa0, 0x66, 0xe2, 0x3f, 0x6a, 0x15, 0xcf,
      0x13, 0xe4, 0x2c, 0x0e, 0xa8, 0x8c, 0x71, 0x0e, 0x4d, 0x70, 0xc6, 0x12,
      0x07, 0x49, 0x68, 0xe5},
     {},
     priv_key_1,
     true},

    // Comment: First byte is 1
    // tcID: 22
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     22,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x3f, 0x92, 0xa6, 0x94, 0x66, 0x1c, 0xae, 0x33, 0x6c, 0xac, 0x7a, 0x3c,
      0x5a, 0x6f, 0x67, 0xe0, 0x65, 0x5d, 0x10, 0x21, 0x8a, 0x64, 0x45, 0x97,
      0x39, 0xab, 0x96, 0x64, 0xf2, 0xce, 0xc5, 0x89, 0x78, 0x93, 0x95, 0x12,
      0xdf, 0x62, 0x1e, 0x6b, 0x92, 0xfe, 0x34, 0x29, 0xbb, 0x22, 0xc0, 0x8b,
      0x51, 0x03, 0xda, 0x64, 0x8a, 0x77, 0x19, 0xe7, 0xe9, 0x5a, 0x04, 0xe6,
      0xb6, 0x16, 0x01, 0x54, 0x69, 0x55, 0x82, 0x5d, 0x60, 0xf4, 0xc5, 0x17,
      0x61, 0x9f, 0x85, 0x17, 0x80, 0xad, 0x17, 0xf1, 0xb8, 0xa9, 0x55, 0xcf,
      0x8c, 0x7f, 0x1a, 0x5e, 0x26, 0xca, 0x4a, 0x0c, 0xc1, 0x9c, 0xca, 0x75,
      0x1d, 0x07, 0x90, 0xd5, 0x6e, 0x11, 0x40, 0xa4, 0x70, 0x5e, 0x19, 0x27,
      0x4f, 0x63, 0x8b, 0x7c, 0x16, 0xd9, 0xd3, 0xe4, 0x23, 0xa7, 0xf7, 0x87,
      0xd0, 0x26, 0x99, 0x23, 0x5e, 0x3e, 0x9e, 0x4d, 0x54, 0x3a, 0x95, 0x4f,
      0x9b, 0x1b, 0xce, 0x54, 0x11, 0xc8, 0xeb, 0xdc, 0xae, 0x86, 0xa4, 0xbb,
      0x86, 0xc6, 0x68, 0x18, 0xa0, 0xba, 0xb5, 0x1a, 0x2b, 0x00, 0x38, 0x3b,
      0x31, 0x8e, 0x53, 0xd9, 0x55, 0x08, 0xba, 0xb1, 0xb1, 0x9e, 0x38, 0x8c,
      0xd5, 0xa0, 0x3c, 0xdc, 0xeb, 0xa0, 0xf7, 0x17, 0x6c, 0x17, 0x82, 0xe1,
      0x9e, 0xf6, 0x2c, 0xff, 0x69, 0x35, 0x2d, 0x44, 0x4b, 0x1c, 0xe0, 0xe1,
      0xf3, 0x39, 0xe9, 0x6d, 0x8a, 0x65, 0xc0, 0x7a, 0xa3, 0x7f, 0x5f, 0x2c,
      0xf3, 0x38, 0x67, 0xf6, 0xc4, 0x96, 0xe0, 0xda, 0x6c, 0xd7, 0x9b, 0x3e,
      0x21, 0x83, 0xb5, 0x70, 0x64, 0xce, 0x21, 0xa1, 0xb9, 0x20, 0x72, 0x70,
      0x2e, 0x55, 0x5a, 0x82, 0xca, 0xd7, 0x51, 0x07, 0xfd, 0xfd, 0x8b, 0xd5,
      0xe7, 0xea, 0x5f, 0x11, 0x9c, 0xfb, 0xbc, 0x17, 0x70, 0xe9, 0x62, 0xfd,
      0x0b, 0x78, 0x1a, 0xff},
     {},
     priv_key_1,
     false},

    // Comment: m is 0
    // tcID: 23
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     23,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     {},
     priv_key_1,
     false},

    // Comment: m is 1
    // tcID: 24
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     24,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     {},
     priv_key_1,
     false},

    // Comment: m is n-1
    // tcID: 25
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     25,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa2, 0xb4, 0x51, 0xa0, 0x7d, 0x0a, 0xa5, 0xf9, 0x6e, 0x45, 0x56, 0x71,
      0x51, 0x35, 0x50, 0x51, 0x4a, 0x8a, 0x5b, 0x46, 0x2e, 0xbe, 0xf7, 0x17,
      0x09, 0x4f, 0xa1, 0xfe, 0xe8, 0x22, 0x24, 0xe6, 0x37, 0xf9, 0x74, 0x6d,
      0x3f, 0x7c, 0xaf, 0xd3, 0x18, 0x78, 0xd8, 0x03, 0x25, 0xb6, 0xef, 0x5a,
      0x17, 0x00, 0xf6, 0x59, 0x03, 0xb4, 0x69, 0x42, 0x9e, 0x89, 0xd6, 0xea,
      0xc8, 0x84, 0x50, 0x97, 0xb5, 0xab, 0x39, 0x31, 0x89, 0xdb, 0x92, 0x51,
      0x2e, 0xd8, 0xa7, 0x71, 0x1a, 0x12, 0x53, 0xfa, 0xcd, 0x20, 0xf7, 0x9c,
      0x15, 0xe8, 0x24, 0x7f, 0x3d, 0x3e, 0x42, 0xe4, 0x6e, 0x48, 0xc9, 0x8e,
      0x25, 0x4a, 0x2f, 0xe9, 0x76, 0x53, 0x13, 0xa0, 0x3e, 0xff, 0x8f, 0x17,
      0xe1, 0xa0, 0x29, 0x39, 0x7a, 0x1f, 0xa2, 0x6a, 0x8d, 0xce, 0x26, 0xf4,
      0x90, 0xed, 0x81, 0x29, 0x96, 0x15, 0xd9, 0x81, 0x4c, 0x22, 0xda, 0x61,
      0x04, 0x28, 0xe0, 0x9c, 0x7d, 0x96, 0x58, 0x59, 0x42, 0x66, 0xf5, 0xc0,
      0x21, 0xd0, 0xfc, 0xec, 0xa0, 0x8d, 0x94, 0x5a, 0x12, 0xbe, 0x82, 0xde,
      0x4d, 0x1e, 0xce, 0x6b, 0x4c, 0x03, 0x14, 0x5b, 0x5d, 0x34, 0x95, 0xd4,
      0xed, 0x54, 0x11, 0xeb, 0x87, 0x8d, 0xaf, 0x05, 0xfd, 0x7a, 0xfc, 0x3e,
      0x09, 0xad, 0xa0, 0xf1, 0x12, 0x64, 0x22, 0xf5, 0x90, 0x97, 0x5a, 0x19,
      0x69, 0x81, 0x6f, 0x48, 0x69, 0x8b, 0xcb, 0xba, 0x1b, 0x4d, 0x9c, 0xae,
      0x79, 0xd4, 0x60, 0xd8, 0xf9, 0xf8, 0x5e, 0x79, 0x75, 0x00, 0x5d, 0x9b,
      0xc2, 0x2c, 0x4e, 0x5a, 0xc0, 0xf7, 0xc1, 0xa4, 0x5d, 0x12, 0x56, 0x9a,
      0x62, 0x80, 0x7d, 0x3b, 0x9a, 0x02, 0xe5, 0xa5, 0x30, 0xe7, 0x73, 0x06,
      0x6f, 0x45, 0x3d, 0x1f, 0x5b, 0x4c, 0x2e, 0x9c, 0xf7, 0x82, 0x02, 0x83,
      0xf7, 0x42, 0xb9, 0xd4},
     {},
     priv_key_1,
     false},

    // Comment: added n to c
    // tcID: 26
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     26,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xb0, 0x56, 0xe2, 0x51, 0x3c, 0x7c, 0x47, 0x0d, 0x89, 0x70, 0x32, 0xd4,
      0x06, 0xe9, 0x7b, 0x59, 0x46, 0xdc, 0xad, 0x52, 0xdf, 0x1c, 0x16, 0x50,
      0xd6, 0x1a, 0x1d, 0x7b, 0x0a, 0xf5, 0x9e, 0x8c, 0xfa, 0xec, 0x4d, 0x9e,
      0x83, 0x4d, 0x06, 0xd8, 0x19, 0xb9, 0x2a, 0x7d, 0x44, 0x0d, 0x27, 0x7e,
      0x50, 0x39, 0xab, 0x8a, 0xef, 0xf2, 0x50, 0x43, 0xe9, 0x8b, 0x28, 0x1a,
      0xe6, 0xce, 0x0a, 0x91, 0xf8, 0xdf, 0xbb, 0xd1, 0xb4, 0x99, 0x8f, 0xe5,
      0x48, 0x16, 0x71, 0x38, 0x1b, 0x6a, 0x39, 0x52, 0x44, 0x8b, 0x61, 0x7a,
      0xe6, 0x06, 0xf0, 0x6a, 0x01, 0x43, 0x56, 0x1a, 0x04, 0x0e, 0xda, 0xf3,
      0xc9, 0x72, 0xe6, 0x11, 0xbd, 0x7c, 0xb8, 0x14, 0xaa, 0x47, 0x61, 0xd3,
      0x8e, 0x4a, 0x00, 0x7c, 0xa6, 0x5a, 0xf8, 0xfd, 0xe6, 0xeb, 0x25, 0xd9,
      0x19, 0xd8, 0xbd, 0x92, 0x73, 0xcc, 0xa7, 0x62, 0x29, 0x84, 0xaa, 0x27,
      0x99, 0x4d, 0x04, 0x96, 0x12, 0x42, 0x45, 0x47, 0x77, 0x5c, 0x5d, 0xf7,
      0x54, 0x83, 0x96, 0x21, 0x43, 0x52, 0x2d, 0x07, 0x5b, 0x8c, 0x55, 0xea,
      0x61, 0xb0, 0x45, 0x83, 0xeb, 0x4c, 0x03, 0x58, 0xf9, 0xfb, 0xb9, 0x02,
      0xde, 0xdf, 0xf3, 0x0b, 0x7d, 0x85, 0x92, 0xb5, 0x70, 0x94, 0xdf, 0x4f,
      0x63, 0x45, 0x66, 0x8a, 0xf5, 0x3d, 0x1a, 0xea, 0x86, 0xfb, 0x36, 0xdd,
      0x69, 0xb4, 0x43, 0x4b, 0xac, 0xf8, 0xfc, 0x12, 0xc1, 0x38, 0x02, 0xf5,
      0xb0, 0x35, 0x51, 0xba, 0x8f, 0x20, 0x7d, 0x40, 0x60, 0xa9, 0xf5, 0x6e,
      0x6b, 0x7e, 0x18, 0xc7, 0x66, 0xeb, 0x82, 0xb6, 0xce, 0x6e, 0xe0, 0x74,
      0x7f, 0xbe, 0x78, 0x5c, 0x3c, 0x1c, 0x25, 0xfe, 0x7f, 0xb8, 0x7d, 0xe5,
      0x00, 0x32, 0xb1, 0x72, 0x12, 0x9f, 0xa4, 0x1a, 0x69, 0xc3, 0xce, 0x0e,
      0x77, 0x7e, 0xf1, 0x0f},
     {},
     priv_key_1,
     false},

    // Comment: ciphertext is empty
    // tcID: 27
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     27,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {},
     {},
     priv_key_1,
     false},

    // Comment: prepended bytes to ciphertext
    // tcID: 28
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     28,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x0d, 0xa2, 0x90, 0xb0, 0xbf, 0x71, 0xa1, 0x14, 0x1b, 0x2a,
      0xdc, 0x62, 0xb5, 0xb4, 0x2b, 0x07, 0xfc, 0x52, 0x52, 0x0c, 0xb0, 0x5d,
      0x1f, 0x39, 0xcc, 0xca, 0x7b, 0x7c, 0x22, 0xd3, 0x79, 0xa6, 0xc2, 0xf2,
      0xd9, 0x31, 0x43, 0xd0, 0x57, 0x05, 0x01, 0x40, 0x52, 0x7a, 0x1e, 0x56,
      0x38, 0x24, 0x39, 0x38, 0xb5, 0x31, 0xec, 0x3d, 0xe7, 0x01, 0x4b, 0x01,
      0x51, 0x30, 0x1e, 0x49, 0xb9, 0xfa, 0x43, 0x34, 0x82, 0xa0, 0x2a, 0xbd,
      0xfd, 0x94, 0x19, 0x3d, 0xc9, 0xc7, 0x01, 0x57, 0xe5, 0x57, 0x77, 0x6a,
      0x69, 0xde, 0xd0, 0x1e, 0xcb, 0xea, 0xc4, 0x05, 0x13, 0x35, 0x95, 0xc6,
      0x11, 0x65, 0xa4, 0x28, 0xb6, 0x28, 0x47, 0x29, 0xa4, 0x74, 0x6b, 0x47,
      0xd2, 0xbb, 0xac, 0xa9, 0xd7, 0x43, 0x2c, 0x3b, 0x56, 0x93, 0x59, 0x1c,
      0xfe, 0xe4, 0x88, 0xeb, 0x3c, 0x68, 0xdd, 0xb6, 0xcd, 0xe0, 0xdd, 0x61,
      0xcf, 0xc6, 0x95, 0x24, 0x23, 0xf9, 0x94, 0xab, 0xec, 0xee, 0x34, 0xf5,
      0x68, 0x37, 0x32, 0xb2, 0x99, 0x34, 0xa2, 0xc4, 0x98, 0xad, 0x48, 0xcd,
      0xd3, 0x0c, 0x14, 0x91, 0x77, 0x18, 0x9f, 0x48, 0xee, 0xfd, 0x9c, 0xc7,
      0x23, 0x2d, 0xf1, 0x8b, 0xe1, 0x1f, 0xf5, 0xf7, 0xe3, 0xaf, 0x73, 0x19,
      0xe3, 0x11, 0x59, 0x97, 0xc5, 0x99, 0xe2, 0xd8, 0xf7, 0xf4, 0xf6, 0x63,
      0xdc, 0xc4, 0x00, 0x32, 0xd4, 0x03, 0x43, 0x6d, 0x30, 0x58, 0xa5, 0xea,
      0x66, 0x47, 0x36, 0x60, 0xf0, 0xe1, 0x95, 0x28, 0x1e, 0xc6, 0xeb, 0xa9,
      0x97, 0xd2, 0xa9, 0x51, 0xca, 0x6c, 0xa5, 0xf3, 0xc1, 0x12, 0x71, 0x5c,
      0x89, 0xda, 0x1d, 0x3d, 0xfb, 0x20, 0xa2, 0x19, 0x40, 0x59, 0x4e, 0xd1,
      0x0a, 0xde, 0x90, 0xed, 0x74, 0x52, 0xb7, 0x53, 0x75, 0x7d, 0x72, 0x41,
      0xcb, 0x8a, 0x80, 0x3c, 0x37, 0x3a},
     {},
     priv_key_1,
     false},

    // Comment: appended bytes to ciphertext
    // tcID: 29
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     29,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x0d, 0xa2, 0x90, 0xb0, 0xbf, 0x71, 0xa1, 0x14, 0x1b, 0x2a, 0xdc, 0x62,
      0xb5, 0xb4, 0x2b, 0x07, 0xfc, 0x52, 0x52, 0x0c, 0xb0, 0x5d, 0x1f, 0x39,
      0xcc, 0xca, 0x7b, 0x7c, 0x22, 0xd3, 0x79, 0xa6, 0xc2, 0xf2, 0xd9, 0x31,
      0x43, 0xd0, 0x57, 0x05, 0x01, 0x40, 0x52, 0x7a, 0x1e, 0x56, 0x38, 0x24,
      0x39, 0x38, 0xb5, 0x31, 0xec, 0x3d, 0xe7, 0x01, 0x4b, 0x01, 0x51, 0x30,
      0x1e, 0x49, 0xb9, 0xfa, 0x43, 0x34, 0x82, 0xa0, 0x2a, 0xbd, 0xfd, 0x94,
      0x19, 0x3d, 0xc9, 0xc7, 0x01, 0x57, 0xe5, 0x57, 0x77, 0x6a, 0x69, 0xde,
      0xd0, 0x1e, 0xcb, 0xea, 0xc4, 0x05, 0x13, 0x35, 0x95, 0xc6, 0x11, 0x65,
      0xa4, 0x28, 0xb6, 0x28, 0x47, 0x29, 0xa4, 0x74, 0x6b, 0x47, 0xd2, 0xbb,
      0xac, 0xa9, 0xd7, 0x43, 0x2c, 0x3b, 0x56, 0x93, 0x59, 0x1c, 0xfe, 0xe4,
      0x88, 0xeb, 0x3c, 0x68, 0xdd, 0xb6, 0xcd, 0xe0, 0xdd, 0x61, 0xcf, 0xc6,
      0x95, 0x24, 0x23, 0xf9, 0x94, 0xab, 0xec, 0xee, 0x34, 0xf5, 0x68, 0x37,
      0x32, 0xb2, 0x99, 0x34, 0xa2, 0xc4, 0x98, 0xad, 0x48, 0xcd, 0xd3, 0x0c,
      0x14, 0x91, 0x77, 0x18, 0x9f, 0x48, 0xee, 0xfd, 0x9c, 0xc7, 0x23, 0x2d,
      0xf1, 0x8b, 0xe1, 0x1f, 0xf5, 0xf7, 0xe3, 0xaf, 0x73, 0x19, 0xe3, 0x11,
      0x59, 0x97, 0xc5, 0x99, 0xe2, 0xd8, 0xf7, 0xf4, 0xf6, 0x63, 0xdc, 0xc4,
      0x00, 0x32, 0xd4, 0x03, 0x43, 0x6d, 0x30, 0x58, 0xa5, 0xea, 0x66, 0x47,
      0x36, 0x60, 0xf0, 0xe1, 0x95, 0x28, 0x1e, 0xc6, 0xeb, 0xa9, 0x97, 0xd2,
      0xa9, 0x51, 0xca, 0x6c, 0xa5, 0xf3, 0xc1, 0x12, 0x71, 0x5c, 0x89, 0xda,
      0x1d, 0x3d, 0xfb, 0x20, 0xa2, 0x19, 0x40, 0x59, 0x4e, 0xd1, 0x0a, 0xde,
      0x90, 0xed, 0x74, 0x52, 0xb7, 0x53, 0x75, 0x7d, 0x72, 0x41, 0xcb, 0x8a,
      0x80, 0x3c, 0x37, 0x3a, 0x00, 0x00},
     {},
     priv_key_1,
     false},

    // Comment: truncated ciphertext
    // tcID: 30
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     30,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa2, 0x90, 0xb0, 0xbf, 0x71, 0xa1, 0x14, 0x1b, 0x2a, 0xdc, 0x62, 0xb5,
      0xb4, 0x2b, 0x07, 0xfc, 0x52, 0x52, 0x0c, 0xb0, 0x5d, 0x1f, 0x39, 0xcc,
      0xca, 0x7b, 0x7c, 0x22, 0xd3, 0x79, 0xa6, 0xc2, 0xf2, 0xd9, 0x31, 0x43,
      0xd0, 0x57, 0x05, 0x01, 0x40, 0x52, 0x7a, 0x1e, 0x56, 0x38, 0x24, 0x39,
      0x38, 0xb5, 0x31, 0xec, 0x3d, 0xe7, 0x01, 0x4b, 0x01, 0x51, 0x30, 0x1e,
      0x49, 0xb9, 0xfa, 0x43, 0x34, 0x82, 0xa0, 0x2a, 0xbd, 0xfd, 0x94, 0x19,
      0x3d, 0xc9, 0xc7, 0x01, 0x57, 0xe5, 0x57, 0x77, 0x6a, 0x69, 0xde, 0xd0,
      0x1e, 0xcb, 0xea, 0xc4, 0x05, 0x13, 0x35, 0x95, 0xc6, 0x11, 0x65, 0xa4,
      0x28, 0xb6, 0x28, 0x47, 0x29, 0xa4, 0x74, 0x6b, 0x47, 0xd2, 0xbb, 0xac,
      0xa9, 0xd7, 0x43, 0x2c, 0x3b, 0x56, 0x93, 0x59, 0x1c, 0xfe, 0xe4, 0x88,
      0xeb, 0x3c, 0x68, 0xdd, 0xb6, 0xcd, 0xe0, 0xdd, 0x61, 0xcf, 0xc6, 0x95,
      0x24, 0x23, 0xf9, 0x94, 0xab, 0xec, 0xee, 0x34, 0xf5, 0x68, 0x37, 0x32,
      0xb2, 0x99, 0x34, 0xa2, 0xc4, 0x98, 0xad, 0x48, 0xcd, 0xd3, 0x0c, 0x14,
      0x91, 0x77, 0x18, 0x9f, 0x48, 0xee, 0xfd, 0x9c, 0xc7, 0x23, 0x2d, 0xf1,
      0x8b, 0xe1, 0x1f, 0xf5, 0xf7, 0xe3, 0xaf, 0x73, 0x19, 0xe3, 0x11, 0x59,
      0x97, 0xc5, 0x99, 0xe2, 0xd8, 0xf7, 0xf4, 0xf6, 0x63, 0xdc, 0xc4, 0x00,
      0x32, 0xd4, 0x03, 0x43, 0x6d, 0x30, 0x58, 0xa5, 0xea, 0x66, 0x47, 0x36,
      0x60, 0xf0, 0xe1, 0x95, 0x28, 0x1e, 0xc6, 0xeb, 0xa9, 0x97, 0xd2, 0xa9,
      0x51, 0xca, 0x6c, 0xa5, 0xf3, 0xc1, 0x12, 0x71, 0x5c, 0x89, 0xda, 0x1d,
      0x3d, 0xfb, 0x20, 0xa2, 0x19, 0x40, 0x59, 0x4e, 0xd1, 0x0a, 0xde, 0x90,
      0xed, 0x74, 0x52, 0xb7, 0x53, 0x75, 0x7d, 0x72, 0x41, 0xcb, 0x8a, 0x80,
      0x3c, 0x37, 0x3a},
     {},
     priv_key_1,
     false},

    // Comment: em represents a small integer
    // tcID: 31
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     31,
     {0xc4, 0xfc, 0x4b, 0x06, 0x5f, 0x45, 0x95, 0x75, 0x1c, 0x7f, 0xf8, 0xbb,
      0x99, 0x68, 0x1d, 0x50, 0x5b, 0x7d, 0x0f, 0x17, 0x30, 0xd4, 0x04, 0x61,
      0x79, 0x40, 0xf4, 0xb5, 0xc3, 0xb0, 0x19, 0x79, 0xff, 0xcf, 0xfd, 0x19,
      0xe8, 0x6f, 0x69, 0x45, 0x0e, 0x5f, 0xc1, 0x4d, 0x9b, 0xc2, 0x7a, 0x1f,
      0x39, 0x73, 0x4f, 0xd5, 0xf8, 0xf6, 0x63, 0xd2, 0xd8, 0x7c, 0x44, 0x4e,
      0x3e, 0x15, 0xda, 0x87, 0x64, 0x70, 0x99, 0x09, 0x67, 0x9a, 0xaa, 0x55,
      0x3d, 0x98, 0xdd, 0xbb, 0x1a, 0xd7, 0xdc, 0xc8, 0xbe, 0x04, 0xbb, 0x87,
      0x51, 0x57, 0x0b, 0x4e, 0x6c, 0xdc, 0x7a, 0x8f, 0x56, 0xb0, 0x9a, 0x4a,
      0xf4, 0x30, 0x53, 0xa3, 0x93, 0xbd, 0x8f, 0x94, 0x7d, 0x76, 0x25, 0x13,
      0x7e, 0x6d, 0x84, 0xf9, 0xb9, 0xc7, 0x27, 0x47, 0x5a, 0x98, 0xea, 0x22,
      0xef, 0xcf, 0x67, 0x9e, 0xe0, 0xaa, 0x52, 0x58, 0xda, 0x88, 0xa0, 0x8a,
      0xfc, 0x53, 0xbd, 0x8b, 0xfa, 0x19, 0xb0, 0x13, 0x1d, 0x6f, 0x67, 0x6f,
      0xe1, 0x98, 0xa9, 0xc6, 0xa1, 0xf8, 0x41, 0x74, 0xfc, 0x69, 0xcc, 0xf8,
      0xe3, 0x4e, 0x36, 0x17, 0xf8, 0xff, 0x6c, 0x41, 0x92, 0x07, 0x5c, 0xd6,
      0x66, 0x83, 0x92, 0x52, 0x3f, 0xbe, 0xce, 0xdb, 0x27, 0x57, 0x8e, 0x59,
      0x1d, 0xea, 0xd7, 0x8c, 0x80, 0xa8, 0x9b, 0xe5, 0x89, 0xa1},
     {0x18, 0x41, 0x6f, 0xf4, 0x8c, 0x3a, 0x78, 0xbc, 0x85, 0xe1, 0xf4, 0x83,
      0xd5, 0x46, 0x05, 0x2d, 0x84, 0xde, 0xac, 0x02, 0xce, 0x86, 0xfc, 0xd1,
      0x97, 0x21, 0x5f, 0x22, 0x7b, 0x6d, 0xad, 0x58, 0xbc, 0x19, 0x39, 0x4f,
      0x46, 0x55, 0x11, 0x11, 0xf8, 0x58, 0xb0, 0x88, 0x79, 0xbc, 0x37, 0xc6,
      0x20, 0xb1, 0xe8, 0x1e, 0xba, 0xc4, 0xc7, 0x5f, 0xdd, 0x71, 0x71, 0x3c,
      0xe7, 0x5c, 0x24, 0x29, 0x3f, 0xa3, 0x9c, 0xaf, 0x46, 0x29, 0x4d, 0x28,
      0xbf, 0x87, 0xa4, 0x6d, 0xa9, 0xa7, 0x69, 0xa3, 0x04, 0x15, 0x7e, 0xa1,
      0xfc, 0x71, 0xaf, 0xc3, 0xbf, 0xb7, 0x90, 0xda, 0x32, 0xe8, 0x4d, 0x81,
      0x2a, 0x89, 0x46, 0xd1, 0xb3, 0xd2, 0x11, 0xfb, 0x69, 0x72, 0xb3, 0xfe,
      0x66, 0x74, 0x49, 0x6b, 0x2d, 0x80, 0x56, 0xc1, 0x50, 0x3d, 0x02, 0xfd,
      0x4c, 0x2e, 0x60, 0x7b, 0xfb, 0x1e, 0x6b, 0x26, 0xb3, 0x56, 0x36, 0xb8,
      0xb8, 0x23, 0x75, 0x7e, 0xe9, 0xba, 0x37, 0x95, 0xd3, 0xaf, 0x2d, 0xd8,
      0x71, 0x0b, 0x0a, 0x6d, 0xa4, 0xdb, 0xb4, 0x30, 0xbc, 0x69, 0xdc, 0x08,
      0x9f, 0x15, 0x63, 0xd3, 0x4f, 0x0d, 0x79, 0x43, 0x1d, 0x63, 0xe7, 0xb8,
      0xd9, 0x4c, 0x82, 0x34, 0x64, 0x9b, 0x64, 0x22, 0x3d, 0x1e, 0x0b, 0xe1,
      0x74, 0x63, 0x40, 0x11, 0x84, 0xa0, 0x96, 0xfe, 0xb9, 0xc8, 0x1e, 0x22,
      0x6e, 0xec, 0x26, 0xc7, 0xe9, 0xf3, 0xf4, 0x35, 0x75, 0x36, 0x63, 0x30,
      0x29, 0xeb, 0xc0, 0x34, 0x9b, 0xc1, 0x36, 0xd1, 0x20, 0x6c, 0x60, 0x64,
      0xfc, 0x51, 0xb6, 0xd2, 0xe7, 0x95, 0x78, 0xf2, 0xb2, 0x64, 0x39, 0xc5,
      0xb3, 0xf6, 0xff, 0xe1, 0xb5, 0x15, 0x74, 0x0b, 0x3c, 0x4b, 0x94, 0xa4,
      0x94, 0x30, 0x63, 0x12, 0x92, 0x96, 0x8e, 0xb5, 0x09, 0x83, 0x25, 0x1b,
      0xbc, 0x7f, 0x0f, 0x89},
     {0x5a, 0x35, 0x64, 0xe9, 0x48, 0x2a, 0x07, 0x2b, 0xd9, 0x9d, 0x03, 0x06,
      0xd6, 0x9a, 0x7f, 0x45, 0x95, 0xc4, 0x9f, 0xb9, 0xc0, 0x6b, 0x72, 0x25,
      0x0e, 0xed, 0x2b, 0x50, 0xce, 0xdd, 0xcc, 0x47, 0x00, 0x00, 0x00, 0x00},
     priv_key_1,
     true},

    // Comment: em has low hamming weight
    // tcID: 32
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     32,
     {0x03, 0xfd, 0x61, 0x59, 0x0d, 0xdd, 0x05, 0x55, 0x5a, 0x6d, 0x46, 0xd1,
      0xe8, 0x92, 0x52, 0x93, 0xfe, 0x46, 0xfa, 0x16, 0x8c, 0xb0, 0x61, 0x35,
      0xc2, 0xe7, 0xc8, 0xd3, 0x65, 0x51, 0x18, 0x7e, 0x62, 0x01, 0x6f, 0x40,
      0xf3, 0xeb, 0x31, 0x75, 0x1f, 0x36, 0x90, 0xf5, 0xda, 0x1a, 0xab, 0xa5,
      0xc1, 0x6f, 0xfa, 0x65, 0x0b, 0x2e, 0x6c, 0x25, 0xf3, 0x76, 0x3f, 0xe3,
      0x24, 0x92, 0x9c, 0x4b, 0xec, 0xc7, 0xfb, 0x28, 0xa3, 0x83, 0xd6, 0x6c,
      0x31, 0x97, 0x3c, 0x72, 0xeb, 0x13, 0xff, 0x8c, 0x87, 0xa9, 0x2b, 0x49,
      0x5f, 0x6f, 0x06, 0x19, 0x29, 0x0f, 0x86, 0x75, 0xe9, 0x88, 0x9f, 0x49,
      0xd3, 0x0d, 0x5e, 0x77, 0xb2, 0x11, 0x5e, 0x88, 0x05, 0xee, 0xeb, 0x1a,
      0xa9, 0x32, 0x48, 0x43, 0xa7, 0x5e, 0x0b, 0xbe, 0x70, 0x53, 0x8e, 0xef,
      0xb7, 0x97, 0x8a, 0x0e, 0xa7, 0xbe, 0xb2, 0x11, 0xe6, 0x7b, 0xb0, 0x75,
      0x98, 0x16, 0x73, 0x51, 0x75, 0x18, 0x58, 0x6e, 0xca, 0x5b, 0x04, 0xef,
      0x3a, 0xd6, 0xa3, 0xa9, 0x78, 0x60, 0x5f, 0xbc, 0x0e, 0x67, 0xaf, 0x7f,
      0xe4, 0x12, 0xac, 0xfc, 0xb5, 0x50, 0xd2, 0x0c, 0x99, 0x00, 0xf4, 0xd7,
      0x1d, 0x78, 0x29, 0xa1, 0x07, 0xcc, 0x51, 0xd6, 0x63, 0xdb, 0x54, 0xc5,
      0x71, 0x16, 0x95, 0x99, 0x98, 0xf3, 0x94, 0x6b, 0x4d, 0x43},
     {0x23, 0xee, 0x3b, 0x4d, 0xf8, 0xac, 0x63, 0x20, 0x78, 0x16, 0x7f, 0x2f,
      0x97, 0xa7, 0x36, 0x46, 0x9c, 0x6e, 0x6b, 0x39, 0xce, 0xd4, 0xdd, 0xc5,
      0x52, 0xd3, 0x1f, 0x0f, 0xbc, 0x7c, 0xcb, 0x47, 0x8a, 0xda, 0xbe, 0x56,
      0xca, 0xc2, 0x0c, 0xbe, 0xc1, 0xa0, 0x08, 0x41, 0x25, 0xae, 0xfd, 0xe0,
      0xbd, 0xb5, 0x75, 0xd6, 0x8b, 0xd7, 0x4c, 0xfb, 0xdf, 0x5f, 0x3b, 0xfb,
      0x44, 0x01, 0xfa, 0x57, 0x36, 0x45, 0xc2, 0x23, 0x56, 0x89, 0x18, 0xaa,
      0x91, 0x1c, 0x1f, 0x5a, 0x01, 0xb3, 0xb0, 0x90, 0x3e, 0x91, 0xd8, 0x2e,
      0x8c, 0x04, 0x19, 0x4d, 0xf4, 0xbd, 0xc5, 0xfa, 0xcb, 0x69, 0x59, 0xb4,
      0xdf, 0x23, 0x59, 0x3c, 0x79, 0x25, 0xa8, 0x27, 0xf0, 0x29, 0x06, 0x4c,
      0x75, 0xa4, 0xbc, 0x3d, 0x28, 0x99, 0x64, 0x90, 0x25, 0x67, 0x0e, 0x70,
      0xf3, 0xe0, 0x13, 0x36, 0xfe, 0x96, 0x16, 0x64, 0x56, 0x3a, 0x3b, 0xb0,
      0xc7, 0xbc, 0xa6, 0x6d, 0x7e, 0xed, 0x48, 0x32, 0x67, 0x46, 0xa0, 0x60,
      0xc5, 0xd3, 0xf1, 0x8a, 0x16, 0x0a, 0xbc, 0xe3, 0x99, 0x91, 0x7a, 0xb2,
      0xe2, 0x38, 0x6d, 0x0f, 0x1c, 0x2d, 0x7c, 0x91, 0x05, 0xd1, 0x6b, 0xef,
      0xc1, 0xb0, 0xbf, 0xd7, 0x26, 0x06, 0xec, 0x30, 0x0a, 0x77, 0x7a, 0xc5,
      0x50, 0xb1, 0xb0, 0xb8, 0x07, 0xb7, 0xe4, 0x64, 0x67, 0xdb, 0x5b, 0xfe,
      0x0e, 0xac, 0x8b, 0xcb, 0xeb, 0xb2, 0xdf, 0x47, 0xbc, 0x65, 0xfe, 0x42,
      0x17, 0x43, 0x68, 0x59, 0x5b, 0x72, 0x65, 0x0b, 0x77, 0x0f, 0x47, 0x15,
      0x7d, 0x2d, 0x14, 0xc7, 0x1c, 0xeb, 0xca, 0xaa, 0x5c, 0xf5, 0x67, 0xab,
      0x80, 0x3e, 0x2b, 0xcf, 0xf5, 0xf4, 0x29, 0x8c, 0x06, 0xb1, 0x98, 0x37,
      0x57, 0xab, 0xe0, 0x2f, 0xaf, 0x4c, 0x7c, 0x5f, 0x91, 0x41, 0xaf, 0xac,
      0xe7, 0x2a, 0xb9, 0x8c},
     {0xb5, 0x03, 0xd0, 0x35, 0x21, 0xb4, 0xff, 0xc4, 0xb8, 0x55, 0xc9, 0x4e,
      0x91, 0x1a, 0x61, 0x17, 0xf0, 0x4c, 0x76, 0xc6, 0xfe, 0x80, 0x00, 0xf8,
      0x03, 0x1e, 0x70, 0x54, 0x86, 0xae, 0x64, 0x19, 0x00, 0x00, 0x00, 0x00},
     priv_key_1,
     true},

    // Comment: em has low hamming weight
    // tcID: 33
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     33,
     {0x90, 0xfd, 0x85, 0x1c, 0x72, 0x1e, 0x93, 0x6d, 0xf0, 0x13, 0x4c, 0xe1,
      0x3f, 0x2b, 0x7f, 0x44, 0x69, 0xd5, 0x8f, 0x69, 0xf8, 0x5f, 0x4b, 0xeb,
      0xe2, 0x72, 0x61, 0x23, 0xcc, 0x74, 0x2c, 0x1c, 0x43, 0x29, 0x3f, 0x85,
      0xf5, 0x0b, 0x5c, 0x6d, 0x22, 0x0f, 0x40, 0xc3, 0x87, 0xa1, 0xf2, 0xbb,
      0x27, 0x04, 0xa1, 0x65, 0x08, 0xe2, 0x67, 0xc6, 0xc4, 0x32, 0x4a, 0x82,
      0x19, 0x11, 0x70, 0xe6, 0x7c, 0xbf, 0x57, 0xf5, 0x6d, 0xc0, 0x2a, 0x70,
      0x6e, 0x33, 0x73, 0xe9, 0xdc, 0xa1, 0xca, 0x0f, 0x77, 0x03, 0x80, 0x4c,
      0x00, 0x93, 0xe9, 0xf8, 0xa2, 0xae, 0x55, 0x02, 0xd2, 0xcc, 0xbf, 0x26,
      0xdf, 0xf3, 0xcd, 0x17, 0x9b, 0x5b, 0x8f, 0x97, 0x95, 0x9d, 0x5d, 0x2a,
      0x94, 0x00, 0xb3, 0x1b, 0x01, 0xee, 0x09, 0xca, 0xa6, 0x01, 0x3d, 0x19,
      0x8b, 0xeb, 0x7e, 0x09, 0x79, 0xae, 0xd5, 0x26, 0x39, 0x74, 0x59, 0x1c,
      0xca, 0x36, 0xce, 0xce, 0xb2, 0x52, 0x11, 0x0e, 0x61, 0xbe, 0xbd, 0xf0,
      0x27, 0x23, 0x86, 0xf9, 0x57, 0x1b, 0xe7, 0x9f, 0xe3, 0xaf, 0xc8, 0x47,
      0x8e, 0xb9, 0xe7, 0x15, 0x57, 0x59, 0xed, 0x20, 0xe2, 0xa2, 0xe5, 0x37,
      0xd9, 0x8a, 0xed, 0xa1, 0x8c, 0x37, 0x4e, 0xd9, 0xb4, 0x8b, 0xe8, 0x62,
      0x49, 0x84, 0xba, 0x4b, 0x15, 0xbf, 0xff, 0xff, 0x6c, 0xc9},
     {0x94, 0xf4, 0xed, 0xda, 0x14, 0x7a, 0x95, 0xcf, 0x29, 0xbb, 0x04, 0x02,
      0xd0, 0x41, 0x3e, 0x54, 0x21, 0xb5, 0xae, 0x34, 0x7c, 0x31, 0xb2, 0xec,
      0x32, 0x39, 0xbd, 0x80, 0x8c, 0x4e, 0x5b, 0x60, 0x9d, 0x0c, 0xe9, 0xd9,
      0xc3, 0xa1, 0x2e, 0x47, 0xea, 0xe6, 0xc5, 0xfe, 0x31, 0x92, 0x88, 0x55,
      0x3b, 0xa2, 0x5e, 0x89, 0x32, 0xd6, 0x44, 0xa6, 0x38, 0x70, 0x87, 0xb4,
      0xe4, 0x95, 0xad, 0x4b, 0xc1, 0x24, 0x59, 0x6d, 0x94, 0x40, 0xdd, 0xd5,
      0x37, 0x6f, 0x2c, 0x18, 0x44, 0xe6, 0x1a, 0x7c, 0x51, 0xbe, 0xf5, 0x28,
      0xad, 0x20, 0x06, 0x55, 0x74, 0x19, 0x8a, 0xce, 0x92, 0xd3, 0x40, 0x2d,
      0xcf, 0x4d, 0xf8, 0xff, 0x5d, 0x68, 0xc0, 0x6d, 0xaf, 0xe9, 0x30, 0x2d,
      0xa4, 0xe0, 0x75, 0xab, 0x0e, 0x01, 0x1b, 0xfc, 0x1b, 0xba, 0xa5, 0x5b,
      0x4c, 0xc1, 0xbc, 0x30, 0xdc, 0x9b, 0x10, 0x45, 0x39, 0xc2, 0x1d, 0x60,
      0xb6, 0xfc, 0x70, 0x44, 0xe0, 0x24, 0x25, 0x91, 0x36, 0x07, 0x51, 0xfb,
      0xeb, 0x28, 0x83, 0x09, 0x96, 0x02, 0xa9, 0x00, 0xcb, 0x53, 0x20, 0x19,
      0x5c, 0xb7, 0x07, 0x18, 0x19, 0xdb, 0xce, 0x26, 0x67, 0xa7, 0x53, 0x2a,
      0xac, 0xb2, 0xc9, 0xb9, 0x6f, 0x3e, 0x72, 0x62, 0x67, 0xb7, 0x09, 0xc5,
      0xc0, 0x87, 0x72, 0x80, 0xf5, 0xd4, 0xef, 0xeb, 0x5d, 0x41, 0x55, 0xbf,
      0x87, 0x51, 0xf9, 0x56, 0x0d, 0xb4, 0xbf, 0xaf, 0x81, 0x50, 0xa8, 0xf2,
      0x7b, 0x36, 0x6c, 0x39, 0x35, 0x86, 0x0a, 0xeb, 0x10, 0x6b, 0xd8, 0x89,
      0x14, 0xb6, 0xbc, 0xcf, 0x35, 0xbb, 0x6e, 0xaf, 0x92, 0x17, 0x25, 0x4e,
      0x6d, 0xac, 0xd8, 0x8f, 0x0f, 0x11, 0x82, 0xd6, 0xcb, 0xe2, 0x56, 0x35,
      0xd4, 0xd9, 0xad, 0x76, 0xa0, 0x66, 0x87, 0xd2, 0x52, 0x7e, 0xd7, 0xd9,
      0xcb, 0xf5, 0x08, 0x03},
     {0x3b, 0xd8, 0x0a, 0x63, 0x78, 0x11, 0x5c, 0x0c, 0x94, 0x6b, 0x4e, 0x3a,
      0xf2, 0x8c, 0x6c, 0x96, 0xd1, 0x11, 0x06, 0x21, 0xe2, 0x1e, 0x86, 0x33,
      0x41, 0x6e, 0x9c, 0x8e, 0xf0, 0xa7, 0x3d, 0x40, 0x00, 0x00, 0x00, 0x00},
     priv_key_1,
     true},

    // Comment: em has low hamming weight
    // tcID: 34
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     34,
     {0x0c, 0xf8, 0x3d, 0x29, 0x7f, 0x20, 0xf5, 0x27, 0x98, 0x3f, 0x31, 0x11,
      0x71, 0x6a, 0x68, 0xd0, 0xd3, 0x3d, 0x97, 0xee, 0x4f, 0x5d, 0x18, 0x22,
      0xc9, 0xe5, 0x38, 0x23, 0x98, 0x54, 0x2b, 0xd5, 0x32, 0x31, 0x6d, 0xb2,
      0x9d, 0x8a, 0x8f, 0x92, 0xba, 0xca, 0xe0, 0x63, 0xac, 0xa1, 0xc1, 0xcd,
      0x9b, 0xc2, 0x72, 0xfe, 0xc6, 0x88, 0xb3, 0xf6, 0x79, 0x56, 0xc6, 0x62,
      0xa5, 0xb2, 0xf8, 0x95, 0x50, 0x9f, 0xe6, 0xf2, 0x40, 0x6f, 0x06, 0x74,
      0xaf, 0xb0, 0xf0, 0x47, 0x2a, 0xa2, 0x05, 0xa7, 0xd5, 0x5a, 0x09, 0x2a,
      0x5c, 0xed, 0x1b, 0x1c, 0x1b, 0x92, 0xa7, 0xb9, 0x3f, 0x9c, 0x69, 0x54,
      0x40, 0xa3, 0x25, 0x7e, 0x00, 0x79, 0x49, 0xd2, 0x70, 0x98, 0x41, 0x04,
      0x54, 0xd4, 0xe3, 0x96, 0x12, 0xc7, 0xdc, 0xab, 0xc8, 0x5e, 0x19, 0xf3,
      0x42, 0x17, 0x34, 0xbb, 0x27, 0x17, 0xde, 0x00, 0xc0, 0x41, 0xf5, 0x69,
      0xe8, 0xd4, 0x30, 0x06, 0x00, 0x59, 0x60, 0xaf, 0x8f, 0x57, 0x3e, 0x13,
      0x86, 0x79, 0x11, 0x98, 0x9a, 0x4c, 0x67, 0x8d, 0xa8, 0xf1, 0x5c, 0xa0,
      0x27, 0x8e, 0xbb, 0xb2, 0x17, 0x42, 0xfe, 0x33, 0xb3, 0x61, 0x3f, 0x22,
      0xaf, 0xca, 0x45, 0xac, 0x09, 0xf8, 0x15, 0xb5, 0x01, 0x55, 0xec, 0xab,
      0x6e, 0xb0, 0x78, 0x06, 0xbd, 0xfe, 0xf3, 0x7b, 0x5d, 0xd5},
     {0x68, 0x82, 0x5b, 0x60, 0xb5, 0x3c, 0xc0, 0xbb, 0xc9, 0x2e, 0x4c, 0xe9,
      0x94, 0xb0, 0xdd, 0x27, 0x0b, 0xad, 0x0e, 0xb6, 0x57, 0xe4, 0x1a, 0xcf,
      0x26, 0xa9, 0xe3, 0x16, 0x1c, 0x52, 0x54, 0xe4, 0xbd, 0x38, 0xb0, 0x3e,
      0x90, 0xd7, 0x45, 0x34, 0x24, 0xe6, 0x05, 0xa3, 0x72, 0xbc, 0x18, 0x5f,
      0x3a, 0xe6, 0xba, 0x9f, 0xf5, 0x8f, 0xab, 0x0c, 0xc4, 0xc1, 0xcc, 0x15,
      0x8d, 0x7a, 0x1e, 0x8f, 0x1f, 0x0b, 0x30, 0xac, 0x08, 0x78, 0x9f, 0x75,
      0x76, 0xfa, 0xb2, 0xda, 0xe7, 0xe8, 0x6d, 0xae, 0x60, 0xd9, 0xaf, 0x79,
      0x3d, 0xc1, 0xb4, 0x00, 0xc2, 0xd2, 0x5a, 0x9d, 0x33, 0x57, 0xba, 0x0d,
      0x27, 0x36, 0x1d, 0x74, 0xa1, 0xb4, 0xe1, 0x44, 0x51, 0x47, 0xa4, 0x58,
      0x75, 0x90, 0x1d, 0x70, 0xf3, 0x19, 0x0a, 0x0b, 0x34, 0xde, 0xfb, 0xdb,
      0xec, 0x1c, 0xb9, 0xed, 0x30, 0x14, 0xf1, 0x5a, 0x1a, 0x0f, 0x90, 0x00,
      0xd9, 0xb2, 0x24, 0xfb, 0xa9, 0x44, 0xe7, 0x91, 0xd3, 0x03, 0xd8, 0x16,
      0xba, 0xfe, 0xb8, 0xe6, 0x5d, 0xfc, 0x6d, 0x74, 0x0d, 0x04, 0x71, 0x9c,
      0x4a, 0xb3, 0x6c, 0x4b, 0xbf, 0x4e, 0xbe, 0xa5, 0xfc, 0x45, 0xea, 0xd3,
      0x38, 0x82, 0x5f, 0xc5, 0xa7, 0x1d, 0xd6, 0xc2, 0x5f, 0x8d, 0x88, 0x91,
      0xa4, 0xf8, 0xd6, 0xe0, 0xb3, 0x54, 0x83, 0xc7, 0x5c, 0x1b, 0xd6, 0x45,
      0xc3, 0xcb, 0xe9, 0xdc, 0xf5, 0xa1, 0x7a, 0xe5, 0xcd, 0x2a, 0xbd, 0xfb,
      0x13, 0x2b, 0x2b, 0x37, 0x10, 0x21, 0x22, 0xa9, 0xbf, 0xc4, 0x2c, 0xeb,
      0x3e, 0xac, 0x98, 0xf2, 0xaf, 0x39, 0x90, 0x5b, 0x9c, 0xec, 0xe5, 0xd1,
      0x22, 0xb7, 0x0c, 0x95, 0x23, 0x90, 0x62, 0xce, 0xea, 0xb7, 0x98, 0x69,
      0x1d, 0xd2, 0xb8, 0x80, 0x28, 0x04, 0x79, 0x24, 0xd5, 0xae, 0x81, 0x4d,
      0xf7, 0x8d, 0x55, 0x5b},
     {0x48, 0x91, 0x5c, 0xeb, 0xf2, 0xa2, 0xef, 0x9e, 0x5d, 0x5b, 0x92, 0xcc,
      0xe0, 0x33, 0xb6, 0x04, 0x56, 0xd7, 0x2a, 0xf1, 0xba, 0x54, 0xf8, 0x8f,
      0x50, 0x74, 0xa3, 0x6a, 0x64, 0x3a, 0x31, 0x78, 0x00, 0x00, 0x00, 0x00},
     priv_key_1,
     true},

    // Comment: em has a large hamming weight
    // tcID: 35
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     35,
     {0x21, 0x24, 0xd6, 0xfd, 0xfb, 0xbf, 0x77, 0xac, 0x89, 0xf5, 0x0a, 0x23,
      0x5b, 0x0a, 0xf6, 0x9e, 0xdb, 0xdb, 0xe9, 0xef, 0x3f, 0xcd, 0xe3, 0x64,
      0x41, 0xd7, 0x02, 0x2a, 0xfd, 0xc8, 0x43, 0x44, 0x31, 0xb8, 0x93, 0xeb,
      0xa8, 0x22, 0xcb, 0x82, 0x58, 0x53, 0x84, 0xe3, 0x62, 0x98, 0xdf, 0x45,
      0xb4, 0xb4, 0x41, 0x5a, 0x3b, 0xdc, 0x49, 0x46, 0x04, 0x30, 0x52, 0x72,
      0xf5, 0xe9, 0x88, 0xf2, 0xcc, 0x14, 0xa5, 0x60, 0x43, 0x42, 0x15, 0x57,
      0xd5, 0xe5, 0xdc, 0x95, 0x8f, 0xd7, 0x71, 0xe4, 0xd5, 0x09, 0x12, 0x66,
      0x56, 0xd2, 0x12, 0x22, 0xcb, 0x8e, 0x2e, 0x10, 0x52, 0xba, 0x38, 0x28,
      0x6c, 0x5e, 0x3d, 0x0b, 0xe0, 0xf4, 0xb1, 0xc9, 0x78, 0xa6, 0x1b, 0xd1,
      0xe3, 0x65, 0x2c, 0xcb, 0x63, 0xfe, 0xa8, 0x2e, 0xc4, 0x6d, 0x6b, 0x64,
      0x86, 0x3c, 0x00, 0xb9, 0x3a, 0x32, 0x43, 0xe2, 0x32, 0x8f, 0x70, 0xf6,
      0x92, 0xaa, 0x65, 0xf7, 0x39, 0x76, 0x33, 0x5e, 0xec, 0x5b, 0x29, 0xa9,
      0x54, 0x2b, 0xef, 0xa0, 0x3d, 0x5e, 0x82, 0xab, 0xa9, 0xdc, 0x28, 0x5a,
      0xf0, 0x91, 0x33, 0x82, 0xd6, 0x7a, 0xac, 0xd5, 0x13, 0xbb, 0xf6, 0xf5,
      0x09, 0x5e, 0x4d, 0x5f, 0x9b, 0x5e, 0xbf, 0xb5, 0xdd, 0xc2, 0x5c, 0xaf,
      0xd8, 0x88, 0xad, 0xdf, 0x9f, 0xfa, 0x06, 0x8b, 0xd4, 0xeb},
     {0x0e, 0xd3, 0xb1, 0xf6, 0xa9, 0xb2, 0x00, 0x14, 0x7e, 0x53, 0x50, 0x42,
      0x35, 0x37, 0x68, 0x28, 0x02, 0x44, 0xb3, 0xc8, 0x31, 0x21, 0x59, 0x28,
      0xa2, 0xb2, 0x10, 0x3d, 0xf0, 0x2b, 0x36, 0x13, 0xf4, 0x3e, 0xcf, 0xde,
      0xcc, 0x6a, 0x8f, 0x61, 0xce, 0x01, 0x83, 0xb8, 0xc6, 0x09, 0x80, 0xf8,
      0x2c, 0x3d, 0xde, 0x3a, 0x73, 0x1e, 0xa2, 0x5a, 0x0c, 0xa9, 0xb8, 0x9e,
      0x5f, 0x68, 0xa7, 0xcd, 0x6c, 0xf6, 0xc6, 0x47, 0x5f, 0x59, 0x1f, 0x24,
      0xb7, 0xa8, 0x9a, 0x88, 0x5a, 0x46, 0xed, 0xb0, 0xad, 0xe4, 0x9e, 0x37,
      0x66, 0x52, 0x19, 0xa6, 0xda, 0x9a, 0xfb, 0xbf, 0x65, 0x59, 0x43, 0x91,
      0x26, 0x36, 0xaf, 0x85, 0xe0, 0xbc, 0x85, 0x9f, 0x43, 0xd3, 0xc4, 0x8b,
      0x4e, 0x77, 0xc9, 0xd1, 0xc0, 0xd6, 0x41, 0xa2, 0x1f, 0xec, 0xf4, 0x95,
      0x71, 0x85, 0xb8, 0x05, 0xae, 0xb9, 0x08, 0xc6, 0x38, 0x7c, 0x9d, 0x1c,
      0x8a, 0xd8, 0x5a, 0x16, 0x6c, 0x07, 0x59, 0x42, 0xf0, 0xcf, 0x68, 0xca,
      0x70, 0xf8, 0x17, 0x4a, 0x9d, 0x2a, 0x4e, 0x55, 0x89, 0xc7, 0x00, 0x5e,
      0x2c, 0x42, 0x3f, 0xf9, 0x7c, 0x97, 0xa2, 0x08, 0xda, 0x51, 0xd9, 0xad,
      0xc0, 0xcb, 0x45, 0x88, 0xa2, 0x57, 0xc0, 0xa1, 0xd0, 0xfe, 0xb0, 0x2e,
      0xb0, 0x50, 0xf9, 0x98, 0x03, 0x09, 0xab, 0xd0, 0x92, 0x58, 0x57, 0x0a,
      0xb2, 0xc8, 0x18, 0x6c, 0xc3, 0x57, 0xa9, 0xf6, 0x93, 0x10, 0x7c, 0x84,
      0x85, 0x5f, 0xf6, 0xee, 0x79, 0x36, 0xb7, 0x19, 0x80, 0xde, 0x42, 0x88,
      0x3e, 0x3e, 0xe7, 0xc1, 0xc6, 0xdd, 0xbe, 0x03, 0xd1, 0x6a, 0x1f, 0x1c,
      0x5b, 0xc5, 0xf9, 0x87, 0xe6, 0xde, 0x9c, 0xab, 0x32, 0x9e, 0xd7, 0xa3,
      0x1b, 0x59, 0xca, 0xc4, 0x67, 0xd7, 0xb6, 0x43, 0x2c, 0xb4, 0x0f, 0x61,
      0x6a, 0xc9, 0xd4, 0xa8},
     {0x02, 0xbe, 0x33, 0x9a, 0x2b, 0x39, 0x9f, 0xfe, 0xae, 0xc9, 0x9a, 0xcf,
      0xd8, 0x0f, 0x50, 0xeb, 0xdf, 0xc8, 0xfe, 0x30, 0x21, 0xa9, 0xa4, 0x32,
      0xdd, 0xd4, 0x13, 0x4b, 0x34, 0x66, 0xb4, 0xa8, 0x00, 0x00, 0x00, 0x00},
     priv_key_1,
     true}};

#endif  // rsa_oaep_2048_sha256_mgf1sha256_vectors_h__
