/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.PublicKey;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.KeyAlreadyImportedException;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.util.Password;

public interface CryptoStore {
    public PrivateKey importPrivateKey(byte[] var1, PrivateKey.Type var2) throws TokenException, KeyAlreadyImportedException;

    public PrivateKey importPrivateKey(byte[] var1, PrivateKey.Type var2, boolean var3) throws TokenException, KeyAlreadyImportedException;

    public PrivateKey[] getPrivateKeys() throws TokenException;

    public PublicKey[] getPublicKeys() throws TokenException;

    public PublicKey findPublicKey(PrivateKey var1) throws ObjectNotFoundException, TokenException;

    public SymmetricKey[] getSymmetricKeys() throws TokenException;

    public void deletePrivateKey(PrivateKey var1) throws NoSuchItemOnTokenException, TokenException;

    public void deletePublicKey(PublicKey var1) throws NoSuchItemOnTokenException, TokenException;

    public byte[] getEncryptedPrivateKeyInfo(X509Certificate var1, PBEAlgorithm var2, Password var3, int var4) throws NotInitializedException, ObjectNotFoundException, TokenException;

    public byte[] getEncryptedPrivateKeyInfo(KeyGenerator.CharToByteConverter var1, Password var2, Algorithm var3, int var4, PrivateKey var5);

    public void importEncryptedPrivateKeyInfo(KeyGenerator.CharToByteConverter var1, Password var2, String var3, PublicKey var4, byte[] var5);

    public X509Certificate[] getCertificates() throws TokenException;

    public X509Certificate importCert(byte[] var1, String var2) throws TokenException;

    public void deleteCert(X509Certificate var1) throws NoSuchItemOnTokenException, TokenException;

    public void deleteCertOnly(X509Certificate var1) throws NoSuchItemOnTokenException, TokenException;
}

