/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.AssertionException;

public class ANY
implements ASN1Value {
    private byte[] encoded;
    private Tag tag;
    private ASN1Header header = null;
    private byte[] contents = null;
    private static Template templateInstance = new Template();

    public ANY(Tag tag, byte[] encoded) {
        this.encoded = encoded;
        this.tag = tag;
    }

    public ANY(byte[] encoded) throws InvalidBERException {
        try {
            this.encoded = encoded;
            ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
            ASN1Header head = new ASN1Header(bis);
            this.tag = head.getTag();
        }
        catch (IOException e) {
            throw new AssertionException("IOException while creating ANY: " + e);
        }
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public ASN1Header getHeader() throws InvalidBERException, IOException {
        if (this.header == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.encoded);
            this.header = new ASN1Header(bis);
        }
        return this.header;
    }

    public byte[] getContents() throws InvalidBERException {
        try {
            if (this.contents == null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(this.encoded);
                this.header = new ASN1Header(bis);
                this.contents = new byte[bis.available()];
                if ((long)this.contents.length != this.header.getContentLength() && this.header.getContentLength() != -1L) {
                    throw new InvalidBERException("Length of contents was not the same as the header predicted");
                }
                ASN1Util.readFully(this.contents, bis);
            }
            return this.contents;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read byte array: " + e.getMessage(), e);
        }
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        ostream.write(this.encoded);
    }

    public ASN1Value decodeWith(ASN1Template template) throws InvalidBERException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.encoded);
            return template.decode(bis);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read byte array: " + e.getMessage(), e);
        }
    }

    public ASN1Value decodeWith(Tag implicitTag, ASN1Template template) throws IOException, InvalidBERException {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.encoded);
        return template.decode(implicitTag, bis);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        if (!implicitTag.equals(this.tag)) {
            throw new RuntimeException("No implicit tags allowed for ANY");
        }
        ostream.write(this.encoded);
    }

    public void encodeWithAlternateTag(Tag alternateTag, OutputStream ostream) throws IOException, InvalidBERException {
        byte[] contents = this.getContents();
        ASN1Header oldHead = this.getHeader();
        assert ((long)contents.length == oldHead.getContentLength());
        ASN1Header newHead = new ASN1Header(alternateTag, oldHead.getForm(), contents.length);
        newHead.encode(ostream);
        ostream.write(contents);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return true;
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            try {
                ASN1Header head = ASN1Header.lookAhead(istream);
                if (head.getContentLength() == -1L) {
                    ANY any;
                    ByteArrayOutputStream recording = new ByteArrayOutputStream();
                    head = new ASN1Header(istream);
                    recording.write(head.encode());
                    Template anyt = new Template();
                    boolean count = false;
                    do {
                        any = (ANY)anyt.decode(istream);
                        recording.write(any.getEncoded());
                    } while (!any.getTag().equals(Tag.EOC));
                    return new ANY(head.getTag(), recording.toByteArray());
                }
                byte[] data = new byte[(int)head.getTotalLength()];
                ASN1Util.readFully(data, istream);
                return new ANY(head.getTag(), data);
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "ANY");
            }
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            throw new InvalidBERException("Implicit tag on ANY");
        }
    }
}

