import { DataSourceJsonData } from '@grafana/data';
export declare enum AwsAuthType {
    Keys = "keys",
    Credentials = "credentials",
    Default = "default",
    EC2IAMRole = "ec2_iam_role",
    /**
     * @deprecated use default
     */
    ARN = "arn"
}
export interface AwsAuthDataSourceJsonData extends DataSourceJsonData {
    authType?: AwsAuthType;
    assumeRoleArn?: string;
    externalId?: string;
    profile?: string;
    defaultRegion?: string;
    endpoint?: string;
}
export interface AwsAuthDataSourceSecureJsonData {
    accessKey?: string;
    secretKey?: string;
}
