; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -force-streaming-compatible-sve  < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; RBIT
;

define <4 x i8> @bitreverse_v4i8(<4 x i8> %op) #0 {
; CHECK-LABEL: bitreverse_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    rbit z0.h, p0/m, z0.h
; CHECK-NEXT:    lsr z0.h, p0/m, z0.h, #8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x i8> @llvm.bitreverse.v4i8(<4 x i8> %op)
  ret <4 x i8> %res
}

define <8 x i8> @bitreverse_v8i8(<8 x i8> %op) #0 {
; CHECK-LABEL: bitreverse_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    rbit z0.b, p0/m, z0.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x i8> @llvm.bitreverse.v8i8(<8 x i8> %op)
  ret <8 x i8> %res
}

define <16 x i8> @bitreverse_v16i8(<16 x i8> %op) #0 {
; CHECK-LABEL: bitreverse_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    rbit z0.b, p0/m, z0.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> %op)
  ret <16 x i8> %res
}

define void @bitreverse_v32i8(ptr %a) #0 {
; CHECK-LABEL: bitreverse_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    rbit z0.b, p0/m, z0.b
; CHECK-NEXT:    rbit z1.b, p0/m, z1.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call <32 x i8> @llvm.bitreverse.v32i8(<32 x i8> %op)
  store <32 x i8> %res, ptr %a
  ret void
}

define <2 x i16> @bitreverse_v2i16(<2 x i16> %op) #0 {
; CHECK-LABEL: bitreverse_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    rbit z0.s, p0/m, z0.s
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, #16
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %op)
  ret <2 x i16> %res
}

define <4 x i16> @bitreverse_v4i16(<4 x i16> %op) #0 {
; CHECK-LABEL: bitreverse_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    rbit z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x i16> @llvm.bitreverse.v4i16(<4 x i16> %op)
  ret <4 x i16> %res
}

define <8 x i16> @bitreverse_v8i16(<8 x i16> %op) #0 {
; CHECK-LABEL: bitreverse_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    rbit z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %op)
  ret <8 x i16> %res
}

define void @bitreverse_v16i16(ptr %a) #0 {
; CHECK-LABEL: bitreverse_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    rbit z0.h, p0/m, z0.h
; CHECK-NEXT:    rbit z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call <16 x i16> @llvm.bitreverse.v16i16(<16 x i16> %op)
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @bitreverse_v2i32(<2 x i32> %op) #0 {
; CHECK-LABEL: bitreverse_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    rbit z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %op)
  ret <2 x i32> %res
}

define <4 x i32> @bitreverse_v4i32(<4 x i32> %op) #0 {
; CHECK-LABEL: bitreverse_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    rbit z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %op)
  ret <4 x i32> %res
}

define void @bitreverse_v8i32(ptr %a) #0 {
; CHECK-LABEL: bitreverse_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    rbit z0.s, p0/m, z0.s
; CHECK-NEXT:    rbit z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call <8 x i32> @llvm.bitreverse.v8i32(<8 x i32> %op)
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @bitreverse_v1i64(<1 x i64> %op) #0 {
; CHECK-LABEL: bitreverse_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    rbit z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <1 x i64> @llvm.bitreverse.v1i64(<1 x i64> %op)
  ret <1 x i64> %res
}

define <2 x i64> @bitreverse_v2i64(<2 x i64> %op) #0 {
; CHECK-LABEL: bitreverse_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    rbit z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %op)
  ret <2 x i64> %res
}

define void @bitreverse_v4i64(ptr %a) #0 {
; CHECK-LABEL: bitreverse_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    rbit z0.d, p0/m, z0.d
; CHECK-NEXT:    rbit z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call <4 x i64> @llvm.bitreverse.v4i64(<4 x i64> %op)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; REVB
;

define <2 x i16> @bswap_v2i16(<2 x i16> %op) #0 {
; CHECK-LABEL: bswap_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    lsr z1.s, p0/m, z1.s, #24
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    lsr z2.s, p0/m, z2.s, #8
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    lsl z3.s, p0/m, z3.s, #24
; CHECK-NEXT:    and z0.s, z0.s, #0xff00
; CHECK-NEXT:    and z2.s, z2.s, #0xff00
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, #8
; CHECK-NEXT:    orr z1.d, z2.d, z1.d
; CHECK-NEXT:    orr z0.d, z3.d, z0.d
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, #16
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x i16> @llvm.bswap.v2i16(<2 x i16> %op)
  ret <2 x i16> %res
}

define <4 x i16> @bswap_v4i16(<4 x i16> %op) #0 {
; CHECK-LABEL: bswap_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    lsr z1.h, p0/m, z1.h, #8
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, #8
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x i16> @llvm.bswap.v4i16(<4 x i16> %op)
  ret <4 x i16> %res
}

define <8 x i16> @bswap_v8i16(<8 x i16> %op) #0 {
; CHECK-LABEL: bswap_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    lsr z1.h, p0/m, z1.h, #8
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, #8
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x i16> @llvm.bswap.v8i16(<8 x i16> %op)
  ret <8 x i16> %res
}

define void @bswap_v16i16(ptr %a) #0 {
; CHECK-LABEL: bswap_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    lsr z2.h, p0/m, z2.h, #8
; CHECK-NEXT:    movprfx z3, z1
; CHECK-NEXT:    lsr z3.h, p0/m, z3.h, #8
; CHECK-NEXT:    lsl z1.h, p0/m, z1.h, #8
; CHECK-NEXT:    orr z1.d, z1.d, z3.d
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, #8
; CHECK-NEXT:    orr z0.d, z0.d, z2.d
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call <16 x i16> @llvm.bswap.v16i16(<16 x i16> %op)
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @bswap_v2i32(<2 x i32> %op) #0 {
; CHECK-LABEL: bswap_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    lsr z1.s, p0/m, z1.s, #24
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    lsr z2.s, p0/m, z2.s, #8
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    lsl z3.s, p0/m, z3.s, #24
; CHECK-NEXT:    and z0.s, z0.s, #0xff00
; CHECK-NEXT:    and z2.s, z2.s, #0xff00
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, #8
; CHECK-NEXT:    orr z1.d, z2.d, z1.d
; CHECK-NEXT:    orr z0.d, z3.d, z0.d
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x i32> @llvm.bswap.v2i32(<2 x i32> %op)
  ret <2 x i32> %res
}

define <4 x i32> @bswap_v4i32(<4 x i32> %op) #0 {
; CHECK-LABEL: bswap_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    lsr z1.s, p0/m, z1.s, #24
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    lsr z2.s, p0/m, z2.s, #8
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    lsl z3.s, p0/m, z3.s, #24
; CHECK-NEXT:    and z0.s, z0.s, #0xff00
; CHECK-NEXT:    and z2.s, z2.s, #0xff00
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, #8
; CHECK-NEXT:    orr z1.d, z2.d, z1.d
; CHECK-NEXT:    orr z0.d, z3.d, z0.d
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x i32> @llvm.bswap.v4i32(<4 x i32> %op)
  ret <4 x i32> %res
}

define void @bswap_v8i32(ptr %a) #0 {
; CHECK-LABEL: bswap_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    lsr z3.s, p0/m, z3.s, #8
; CHECK-NEXT:    movprfx z5, z1
; CHECK-NEXT:    lsr z5.s, p0/m, z5.s, #8
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    lsr z2.s, p0/m, z2.s, #24
; CHECK-NEXT:    movprfx z4, z1
; CHECK-NEXT:    lsr z4.s, p0/m, z4.s, #24
; CHECK-NEXT:    and z3.s, z3.s, #0xff00
; CHECK-NEXT:    and z5.s, z5.s, #0xff00
; CHECK-NEXT:    orr z2.d, z3.d, z2.d
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    lsl z3.s, p0/m, z3.s, #24
; CHECK-NEXT:    orr z4.d, z5.d, z4.d
; CHECK-NEXT:    movprfx z5, z1
; CHECK-NEXT:    lsl z5.s, p0/m, z5.s, #24
; CHECK-NEXT:    and z1.s, z1.s, #0xff00
; CHECK-NEXT:    and z0.s, z0.s, #0xff00
; CHECK-NEXT:    lsl z1.s, p0/m, z1.s, #8
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, #8
; CHECK-NEXT:    orr z1.d, z5.d, z1.d
; CHECK-NEXT:    orr z0.d, z3.d, z0.d
; CHECK-NEXT:    orr z1.d, z1.d, z4.d
; CHECK-NEXT:    orr z0.d, z0.d, z2.d
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call <8 x i32> @llvm.bswap.v8i32(<8 x i32> %op)
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @bswap_v1i64(<1 x i64> %op) #0 {
; CHECK-LABEL: bswap_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    lsr z2.d, p0/m, z2.d, #40
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    lsr z1.d, p0/m, z1.d, #56
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    lsr z3.d, p0/m, z3.d, #24
; CHECK-NEXT:    movprfx z4, z0
; CHECK-NEXT:    lsr z4.d, p0/m, z4.d, #8
; CHECK-NEXT:    mov z5.d, z0.d
; CHECK-NEXT:    and z2.d, z2.d, #0xff00
; CHECK-NEXT:    and z3.d, z3.d, #0xff0000
; CHECK-NEXT:    orr z1.d, z2.d, z1.d
; CHECK-NEXT:    mov z2.d, z0.d
; CHECK-NEXT:    and z4.d, z4.d, #0xff000000
; CHECK-NEXT:    and z5.d, z5.d, #0xff000000
; CHECK-NEXT:    orr z3.d, z4.d, z3.d
; CHECK-NEXT:    and z2.d, z2.d, #0xff0000
; CHECK-NEXT:    movprfx z4, z5
; CHECK-NEXT:    lsl z4.d, p0/m, z4.d, #8
; CHECK-NEXT:    movprfx z5, z0
; CHECK-NEXT:    lsl z5.d, p0/m, z5.d, #56
; CHECK-NEXT:    and z0.d, z0.d, #0xff00
; CHECK-NEXT:    lsl z2.d, p0/m, z2.d, #24
; CHECK-NEXT:    lsl z0.d, p0/m, z0.d, #40
; CHECK-NEXT:    orr z2.d, z2.d, z4.d
; CHECK-NEXT:    orr z0.d, z5.d, z0.d
; CHECK-NEXT:    orr z1.d, z3.d, z1.d
; CHECK-NEXT:    orr z0.d, z0.d, z2.d
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <1 x i64> @llvm.bswap.v1i64(<1 x i64> %op)
  ret <1 x i64> %res
}

define <2 x i64> @bswap_v2i64(<2 x i64> %op) #0 {
; CHECK-LABEL: bswap_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    lsr z2.d, p0/m, z2.d, #40
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    lsr z1.d, p0/m, z1.d, #56
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    lsr z3.d, p0/m, z3.d, #24
; CHECK-NEXT:    movprfx z4, z0
; CHECK-NEXT:    lsr z4.d, p0/m, z4.d, #8
; CHECK-NEXT:    mov z5.d, z0.d
; CHECK-NEXT:    and z2.d, z2.d, #0xff00
; CHECK-NEXT:    and z3.d, z3.d, #0xff0000
; CHECK-NEXT:    orr z1.d, z2.d, z1.d
; CHECK-NEXT:    mov z2.d, z0.d
; CHECK-NEXT:    and z4.d, z4.d, #0xff000000
; CHECK-NEXT:    and z5.d, z5.d, #0xff000000
; CHECK-NEXT:    orr z3.d, z4.d, z3.d
; CHECK-NEXT:    and z2.d, z2.d, #0xff0000
; CHECK-NEXT:    movprfx z4, z5
; CHECK-NEXT:    lsl z4.d, p0/m, z4.d, #8
; CHECK-NEXT:    movprfx z5, z0
; CHECK-NEXT:    lsl z5.d, p0/m, z5.d, #56
; CHECK-NEXT:    and z0.d, z0.d, #0xff00
; CHECK-NEXT:    lsl z2.d, p0/m, z2.d, #24
; CHECK-NEXT:    lsl z0.d, p0/m, z0.d, #40
; CHECK-NEXT:    orr z2.d, z2.d, z4.d
; CHECK-NEXT:    orr z0.d, z5.d, z0.d
; CHECK-NEXT:    orr z1.d, z3.d, z1.d
; CHECK-NEXT:    orr z0.d, z0.d, z2.d
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x i64> @llvm.bswap.v2i64(<2 x i64> %op)
  ret <2 x i64> %res
}

define void @bswap_v4i64(ptr %a) #0 {
; CHECK-LABEL: bswap_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    lsr z3.d, p0/m, z3.d, #40
; CHECK-NEXT:    movprfx z4, z0
; CHECK-NEXT:    lsr z4.d, p0/m, z4.d, #24
; CHECK-NEXT:    movprfx z5, z0
; CHECK-NEXT:    lsr z5.d, p0/m, z5.d, #8
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    lsr z2.d, p0/m, z2.d, #56
; CHECK-NEXT:    and z3.d, z3.d, #0xff00
; CHECK-NEXT:    and z4.d, z4.d, #0xff0000
; CHECK-NEXT:    and z5.d, z5.d, #0xff000000
; CHECK-NEXT:    orr z2.d, z3.d, z2.d
; CHECK-NEXT:    orr z3.d, z5.d, z4.d
; CHECK-NEXT:    mov z6.d, z0.d
; CHECK-NEXT:    mov z7.d, z0.d
; CHECK-NEXT:    orr z2.d, z3.d, z2.d
; CHECK-NEXT:    and z6.d, z6.d, #0xff000000
; CHECK-NEXT:    and z7.d, z7.d, #0xff0000
; CHECK-NEXT:    movprfx z3, z6
; CHECK-NEXT:    lsl z3.d, p0/m, z3.d, #8
; CHECK-NEXT:    movprfx z4, z7
; CHECK-NEXT:    lsl z4.d, p0/m, z4.d, #24
; CHECK-NEXT:    orr z3.d, z4.d, z3.d
; CHECK-NEXT:    movprfx z4, z1
; CHECK-NEXT:    lsr z4.d, p0/m, z4.d, #40
; CHECK-NEXT:    movprfx z16, z0
; CHECK-NEXT:    lsl z16.d, p0/m, z16.d, #56
; CHECK-NEXT:    and z0.d, z0.d, #0xff00
; CHECK-NEXT:    movprfx z5, z1
; CHECK-NEXT:    lsr z5.d, p0/m, z5.d, #56
; CHECK-NEXT:    and z4.d, z4.d, #0xff00
; CHECK-NEXT:    lsl z0.d, p0/m, z0.d, #40
; CHECK-NEXT:    orr z4.d, z4.d, z5.d
; CHECK-NEXT:    movprfx z5, z1
; CHECK-NEXT:    lsr z5.d, p0/m, z5.d, #24
; CHECK-NEXT:    movprfx z7, z1
; CHECK-NEXT:    lsr z7.d, p0/m, z7.d, #8
; CHECK-NEXT:    orr z0.d, z16.d, z0.d
; CHECK-NEXT:    mov z6.d, z1.d
; CHECK-NEXT:    mov z16.d, z1.d
; CHECK-NEXT:    and z5.d, z5.d, #0xff0000
; CHECK-NEXT:    and z7.d, z7.d, #0xff000000
; CHECK-NEXT:    orr z5.d, z7.d, z5.d
; CHECK-NEXT:    and z6.d, z6.d, #0xff000000
; CHECK-NEXT:    and z16.d, z16.d, #0xff0000
; CHECK-NEXT:    movprfx z7, z1
; CHECK-NEXT:    lsl z7.d, p0/m, z7.d, #56
; CHECK-NEXT:    and z1.d, z1.d, #0xff00
; CHECK-NEXT:    lsl z6.d, p0/m, z6.d, #8
; CHECK-NEXT:    lsl z16.d, p0/m, z16.d, #24
; CHECK-NEXT:    lsl z1.d, p0/m, z1.d, #40
; CHECK-NEXT:    orr z6.d, z16.d, z6.d
; CHECK-NEXT:    orr z1.d, z7.d, z1.d
; CHECK-NEXT:    orr z4.d, z5.d, z4.d
; CHECK-NEXT:    orr z1.d, z1.d, z6.d
; CHECK-NEXT:    orr z0.d, z0.d, z3.d
; CHECK-NEXT:    orr z1.d, z1.d, z4.d
; CHECK-NEXT:    orr z0.d, z0.d, z2.d
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call <4 x i64> @llvm.bswap.v4i64(<4 x i64> %op)
  store <4 x i64> %res, ptr %a
  ret void
}

attributes #0 = { "target-features"="+sve" }

declare <4 x i8> @llvm.bitreverse.v4i8(<4 x i8>)
declare <8 x i8> @llvm.bitreverse.v8i8(<8 x i8>)
declare <16 x i8> @llvm.bitreverse.v16i8(<16 x i8>)
declare <32 x i8> @llvm.bitreverse.v32i8(<32 x i8>)
declare <2 x i16> @llvm.bitreverse.v2i16(<2 x i16>)
declare <4 x i16> @llvm.bitreverse.v4i16(<4 x i16>)
declare <8 x i16> @llvm.bitreverse.v8i16(<8 x i16>)
declare <16 x i16> @llvm.bitreverse.v16i16(<16 x i16>)
declare <2 x i32> @llvm.bitreverse.v2i32(<2 x i32>)
declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>)
declare <8 x i32> @llvm.bitreverse.v8i32(<8 x i32>)
declare <1 x i64> @llvm.bitreverse.v1i64(<1 x i64>)
declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>)
declare <4 x i64> @llvm.bitreverse.v4i64(<4 x i64>)

declare <2 x i16> @llvm.bswap.v2i16(<2 x i16>)
declare <4 x i16> @llvm.bswap.v4i16(<4 x i16>)
declare <8 x i16> @llvm.bswap.v8i16(<8 x i16>)
declare <16 x i16> @llvm.bswap.v16i16(<16 x i16>)
declare <2 x i32> @llvm.bswap.v2i32(<2 x i32>)
declare <4 x i32> @llvm.bswap.v4i32(<4 x i32>)
declare <8 x i32> @llvm.bswap.v8i32(<8 x i32>)
declare <1 x i64> @llvm.bswap.v1i64(<1 x i64>)
declare <2 x i64> @llvm.bswap.v2i64(<2 x i64>)
declare <4 x i64> @llvm.bswap.v4i64(<4 x i64>)
