/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import org.mozilla.jss.tests.Constants;

public abstract class ClassServer
implements Runnable {
    private ServerSocket server = null;
    private Vector<String> supportedCiphers = new Vector();

    protected ClassServer(ServerSocket ss) {
        this.server = ss;
        this.newListener();
    }

    @Override
    public void run() {
        Socket socket = null;
        boolean socketListenStatus = true;
        while (socketListenStatus) {
            try {
                socket = this.server.accept();
            }
            catch (Exception ex) {
                System.exit(1);
            }
            this.newListener();
            try {
                InputStream is = socket.getInputStream();
                BufferedReader bir = new BufferedReader(new InputStreamReader(is));
                String socketData = bir.readLine();
                if (socketData.equals("null")) {
                    socketListenStatus = false;
                } else if (socketData != null) {
                    this.supportedCiphers.add(socketData);
                }
                socket.close();
            }
            catch (EOFException is) {
            }
            catch (IOException is) {
            }
            catch (NullPointerException npe) {
                socketListenStatus = false;
            }
        }
        try {
            this.server.close();
        }
        catch (Exception ex) {
            System.exit(1);
        }
        System.out.println("Server exiting");
        System.out.println("--------------------------------------------------------");
        System.out.println("Summary of JSS client to JSSE server communication test :");
        System.out.println("--------------------------------------------------------");
        System.out.println("supportedCiphers.size " + this.supportedCiphers.size());
        System.out.println("Constants.jssCiphersSuites " + Constants.jssCipherSuites.length);
        for (int i = 0; i < this.supportedCiphers.size() - 1; ++i) {
            System.out.print(i + " SC " + this.supportedCiphers.elementAt(i));
            for (int j = 0; j < Constants.jssCipherSuites.length; ++j) {
                if (Integer.parseInt(this.supportedCiphers.elementAt(i)) != Constants.jssCipherSuites[j].value) continue;
                System.out.print(" JSSC ");
                System.out.println(" [" + i + "]\t" + Constants.jssCipherSuites[j].name);
                System.out.flush();
            }
        }
        System.out.println("--------------------------------------------------------");
        System.out.flush();
        if (!socketListenStatus) {
            System.exit(0);
        }
    }

    private void newListener() {
        new Thread(this).start();
    }
}

