/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.extensions.AccessDescription;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.URIName;

public class AuthInfoAccessExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 7373316523212538446L;
    public static final String NAME = "AuthInfoAccessExtension";
    public static final String NAME2 = "AuthorityInformationAccess";
    public static final int[] OID_OCSP = new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1};
    public static final ObjectIdentifier METHOD_OCSP = new ObjectIdentifier(OID_OCSP);
    public static final int[] OID_CA_ISSUERS = new int[]{1, 3, 6, 1, 5, 5, 7, 48, 2};
    public static final ObjectIdentifier METHOD_CA_ISSUERS = new ObjectIdentifier(OID_CA_ISSUERS);
    public static final int[] OID = new int[]{1, 3, 6, 1, 5, 5, 7, 1, 1};
    public static final ObjectIdentifier ID = new ObjectIdentifier(OID);
    private Vector<AccessDescription> mDesc = new Vector();

    public AuthInfoAccessExtension(boolean critical) {
        this.extensionId = ID;
        this.critical = critical;
        this.extensionValue = null;
    }

    public AuthInfoAccessExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = ID;
        this.critical = critical;
        this.extensionValue = (byte[])((byte[])value).clone();
        this.decodeThis();
    }

    @Override
    public void set(String name, Object obj) throws CertificateException {
    }

    @Override
    public Object get(String name) throws CertificateException {
        return null;
    }

    @Override
    public void delete(String name) throws CertificateException {
    }

    @Override
    public void decode(InputStream in) throws IOException {
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void addAccessDescription(ObjectIdentifier method, GeneralName gn) {
        this.clearValue();
        this.mDesc.addElement(new AccessDescription(method, gn));
    }

    public AccessDescription getAccessDescription(int pos) {
        return this.mDesc.elementAt(pos);
    }

    public int numberOfAccessDescription() {
        return this.mDesc.size();
    }

    private void decodeThis() throws IOException {
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding of AuthInfoAccess extension");
        }
        while (val.data.available() != 0) {
            DerValue seq = val.data.getDerValue();
            ObjectIdentifier method = seq.data.getDerValue().getOID();
            GeneralName gn = new GeneralName(seq.data.getDerValue());
            this.addAccessDescription(method, gn);
        }
    }

    private void encodeThis() throws IOException {
        try (DerOutputStream seq = new DerOutputStream();
             DerOutputStream tmp = new DerOutputStream();){
            for (int i = 0; i < this.mDesc.size(); ++i) {
                DerOutputStream tmp0 = new DerOutputStream();
                AccessDescription ad = this.mDesc.elementAt(i);
                tmp0.putOID(ad.getMethod());
                ad.getLocation().encode(tmp0);
                tmp.write((byte)48, tmp0);
            }
            seq.write((byte)48, tmp);
            this.extensionValue = seq.toByteArray();
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        String b = super.toString() + "AuthInfoAccess [\n";
        s.append(b);
        for (int i = 0; i < this.mDesc.size(); ++i) {
            AccessDescription ad = this.mDesc.elementAt(i);
            s.append("(" + i + ")");
            s.append(" ");
            s.append(ad.getMethod().toString() + " " + ad.getLocation().toString());
        }
        return s.toString() + "]\n";
    }

    public static void main(String[] argv) {
        AuthInfoAccessExtension aia = new AuthInfoAccessExtension(false);
        GeneralName ocspName = new GeneralName(new URIName("http://ocsp.netscape.com"));
        aia.addAccessDescription(METHOD_OCSP, ocspName);
        GeneralName caIssuersName = new GeneralName(new URIName("http://ocsp.netscape.com"));
        aia.addAccessDescription(METHOD_CA_ISSUERS, caIssuersName);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            aia.encode(os);
            System.out.println(Utils.base64encode(os.toByteArray(), true));
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(aia);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            AuthInfoAccessExtension clone = (AuthInfoAccessExtension)ois.readObject();
            System.out.println(clone);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

