/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.JSONFormattedControlDecodeBehavior;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONFormattedRequestControl
extends Control {
    @NotNull
    public static final String JSON_FORMATTED_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.64";
    @NotNull
    private static final String JSON_FIELD_CONTROLS = "controls";
    private static final long serialVersionUID = -1165320564468120423L;
    @Nullable
    private final JSONObject encodedValue;
    @NotNull
    private final List<JSONObject> controlObjects;

    private JSONFormattedRequestControl(boolean isCritical, @Nullable JSONObject encodedValue, @NotNull List<JSONObject> controlObjects) {
        super(JSON_FORMATTED_REQUEST_OID, isCritical, encodedValue == null ? null : new ASN1OctetString(encodedValue.toSingleLineString()));
        this.encodedValue = encodedValue;
        this.controlObjects = controlObjects;
    }

    @NotNull
    public static JSONFormattedRequestControl createEmptyControl(boolean isCritical) {
        return new JSONFormattedRequestControl(isCritical, null, Collections.emptyList());
    }

    @NotNull
    public static JSONFormattedRequestControl createWithControls(boolean isCritical, Control ... controls) {
        return JSONFormattedRequestControl.createWithControls(isCritical, StaticUtils.toList(controls));
    }

    @NotNull
    public static JSONFormattedRequestControl createWithControls(boolean isCritical, @Nullable Collection<Control> controls) {
        if (controls == null || controls.isEmpty()) {
            return new JSONFormattedRequestControl(isCritical, null, Collections.emptyList());
        }
        ArrayList<JSONObject> controlObjects = new ArrayList<JSONObject>(controls.size());
        for (Control c : controls) {
            controlObjects.add(c.toJSONControl());
        }
        JSONObject encodedValue = new JSONObject(new JSONField(JSON_FIELD_CONTROLS, new JSONArray(controlObjects)));
        return new JSONFormattedRequestControl(isCritical, encodedValue, Collections.unmodifiableList(controlObjects));
    }

    @NotNull
    public static JSONFormattedRequestControl createWithControlObjects(boolean isCritical, JSONObject ... controlObjects) {
        return JSONFormattedRequestControl.createWithControlObjects(isCritical, StaticUtils.toList(controlObjects));
    }

    @NotNull
    public static JSONFormattedRequestControl createWithControlObjects(boolean isCritical, @Nullable Collection<JSONObject> controlObjects) {
        if (controlObjects == null || controlObjects.isEmpty()) {
            return new JSONFormattedRequestControl(isCritical, null, Collections.emptyList());
        }
        ArrayList<JSONObject> controlObjectList = new ArrayList<JSONObject>(controlObjects);
        JSONObject encodedValue = new JSONObject(new JSONField(JSON_FIELD_CONTROLS, new JSONArray(controlObjectList)));
        return new JSONFormattedRequestControl(isCritical, encodedValue, Collections.unmodifiableList(controlObjectList));
    }

    public JSONFormattedRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString rawValue = control.getValue();
        if (rawValue == null) {
            this.encodedValue = null;
            this.controlObjects = Collections.emptyList();
            return;
        }
        try {
            this.encodedValue = new JSONObject(rawValue.stringValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_REQUEST_VALUE_NOT_JSON.get(), e);
        }
        List<String> unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(this.encodedValue, JSON_FIELD_CONTROLS);
        if (!unrecognizedFields.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_REQUEST_UNRECOGNIZED_FIELD.get(unrecognizedFields.get(0)));
        }
        List<JSONValue> controlValues = this.encodedValue.getFieldAsArray(JSON_FIELD_CONTROLS);
        if (controlValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_REQUEST_VALUE_MISSING_CONTROLS.get(JSON_FIELD_CONTROLS));
        }
        if (controlValues.isEmpty()) {
            this.controlObjects = Collections.emptyList();
            return;
        }
        ArrayList<JSONObject> controlObjectsList = new ArrayList<JSONObject>(controlValues.size());
        for (JSONValue controlValue : controlValues) {
            if (controlValue instanceof JSONObject) {
                JSONObject embeddedControlObject = (JSONObject)controlValue;
                try {
                    new JSONControlDecodeHelper(embeddedControlObject, true, true, false);
                    controlObjectsList.add(embeddedControlObject);
                    continue;
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_REQUEST_VALUE_NOT_CONTROL.get(JSON_FIELD_CONTROLS, embeddedControlObject.toSingleLineString(), e.getMessage()), e);
                }
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_REQUEST_VALUE_CONTROL_NOT_OBJECT.get(JSON_FIELD_CONTROLS));
        }
        this.controlObjects = Collections.unmodifiableList(controlObjectsList);
    }

    @NotNull
    public List<JSONObject> getControlObjects() {
        return this.controlObjects;
    }

    @NotNull
    public synchronized List<Control> decodeEmbeddedControls(@NotNull JSONFormattedControlDecodeBehavior behavior, @Nullable List<String> nonFatalDecodeMessages) throws LDAPException {
        ArrayList<Control> controlList = new ArrayList<Control>(this.controlObjects.size());
        ArrayList<String> fatalMessages = new ArrayList<String>(this.controlObjects.size());
        for (JSONObject controlObject : this.controlObjects) {
            JSONControlDecodeHelper jsonControl;
            try {
                jsonControl = new JSONControlDecodeHelper(controlObject, behavior.strict(), true, false);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                if (behavior.throwOnUnparsableObject()) {
                    fatalMessages.add(e.getMessage());
                    continue;
                }
                if (nonFatalDecodeMessages == null) continue;
                nonFatalDecodeMessages.add(e.getMessage());
                continue;
            }
            if (jsonControl.getOID().equals(JSON_FORMATTED_REQUEST_OID) && !behavior.allowEmbeddedJSONFormattedControl()) {
                String message = ControlMessages.ERR_JSON_FORMATTED_REQUEST_DISALLOWED_EMBEDDED_CONTROL.get();
                if (jsonControl.getCriticality()) {
                    fatalMessages.add(message);
                    continue;
                }
                if (nonFatalDecodeMessages == null) continue;
                nonFatalDecodeMessages.add(message);
                continue;
            }
            try {
                controlList.add(Control.decodeJSONControl(controlObject, behavior.strict(), true));
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                if (jsonControl.getCriticality()) {
                    if (behavior.throwOnInvalidCriticalControl()) {
                        fatalMessages.add(e.getMessage());
                        continue;
                    }
                    if (nonFatalDecodeMessages == null) continue;
                    nonFatalDecodeMessages.add(e.getMessage());
                    continue;
                }
                if (behavior.throwOnInvalidNonCriticalControl()) {
                    fatalMessages.add(e.getMessage());
                    continue;
                }
                if (nonFatalDecodeMessages == null) continue;
                nonFatalDecodeMessages.add(e.getMessage());
            }
        }
        if (!fatalMessages.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, StaticUtils.concatenateStrings(fatalMessages));
        }
        return Collections.unmodifiableList(controlList);
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_JSON_FORMATTED_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        if (this.encodedValue == null) {
            return new JSONObject(new JSONField("oid", JSON_FORMATTED_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_JSON_FORMATTED_REQUEST.get()), new JSONField("criticality", this.isCritical()));
        }
        return new JSONObject(new JSONField("oid", JSON_FORMATTED_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_JSON_FORMATTED_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", this.encodedValue));
    }

    @NotNull
    public static JSONFormattedRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, false);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new JSONFormattedRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        if (valueObject == null) {
            return new JSONFormattedRequestControl(jsonControl.getCriticality(), null, Collections.emptyList());
        }
        List<JSONValue> controlValues = valueObject.getFieldAsArray(JSON_FIELD_CONTROLS);
        if (controlValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_REQUEST_DECODE_VALUE_MISSING_CONTROLS.get(controlObject.toSingleLineString(), JSON_FIELD_CONTROLS));
        }
        if (controlValues.isEmpty()) {
            return new JSONFormattedRequestControl(jsonControl.getCriticality(), valueObject, Collections.emptyList());
        }
        ArrayList<JSONObject> controlObjectsList = new ArrayList<JSONObject>(controlValues.size());
        for (JSONValue controlValue : controlValues) {
            if (controlValue instanceof JSONObject) {
                JSONObject embeddedControlObject = (JSONObject)controlValue;
                try {
                    new JSONControlDecodeHelper(embeddedControlObject, strict, true, false);
                    controlObjectsList.add(embeddedControlObject);
                    continue;
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_REQUEST_DECODE_VALUE_NOT_CONTROL.get(controlObject.toSingleLineString(), JSON_FIELD_CONTROLS, embeddedControlObject.toSingleLineString(), e.getMessage()), e);
                }
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_REQUEST_DECODE_VALUE_CONTROL_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_CONTROLS));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_CONTROLS)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JSON_FORMATTED_REQUEST_DECODE_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new JSONFormattedRequestControl(jsonControl.getCriticality(), valueObject, Collections.unmodifiableList(controlObjectsList));
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("JSONFormattedRequestControl(isCritical=");
        buffer.append(this.isCritical());
        if (this.encodedValue != null) {
            buffer.append(", valueObject=");
            this.encodedValue.toSingleLineString(buffer);
        }
        buffer.append(')');
    }
}

