/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the PatchedansibleAnsibleNamespaceMetadata type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PatchedansibleAnsibleNamespaceMetadata{}

// PatchedansibleAnsibleNamespaceMetadata A serializer for Namespaces.
type PatchedansibleAnsibleNamespaceMetadata struct {
	// Required named, only accepts lowercase, numbers and underscores.
	Name *string `json:"name,omitempty"`
	// Optional namespace company owner.
	Company *string `json:"company,omitempty"`
	// Optional namespace contact email.
	Email *string `json:"email,omitempty"`
	// Optional short description.
	Description *string `json:"description,omitempty"`
	// Optional resource page in markdown format.
	Resources *string `json:"resources,omitempty"`
	// Labeled related links.
	Links []NamespaceLink `json:"links,omitempty"`
	// Optional avatar image for Namespace
	Avatar **os.File `json:"avatar,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PatchedansibleAnsibleNamespaceMetadata PatchedansibleAnsibleNamespaceMetadata

// NewPatchedansibleAnsibleNamespaceMetadata instantiates a new PatchedansibleAnsibleNamespaceMetadata object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPatchedansibleAnsibleNamespaceMetadata() *PatchedansibleAnsibleNamespaceMetadata {
	this := PatchedansibleAnsibleNamespaceMetadata{}
	return &this
}

// NewPatchedansibleAnsibleNamespaceMetadataWithDefaults instantiates a new PatchedansibleAnsibleNamespaceMetadata object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPatchedansibleAnsibleNamespaceMetadataWithDefaults() *PatchedansibleAnsibleNamespaceMetadata {
	this := PatchedansibleAnsibleNamespaceMetadata{}
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *PatchedansibleAnsibleNamespaceMetadata) SetName(v string) {
	o.Name = &v
}

// GetCompany returns the Company field value if set, zero value otherwise.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetCompany() string {
	if o == nil || IsNil(o.Company) {
		var ret string
		return ret
	}
	return *o.Company
}

// GetCompanyOk returns a tuple with the Company field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetCompanyOk() (*string, bool) {
	if o == nil || IsNil(o.Company) {
		return nil, false
	}
	return o.Company, true
}

// HasCompany returns a boolean if a field has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) HasCompany() bool {
	if o != nil && !IsNil(o.Company) {
		return true
	}

	return false
}

// SetCompany gets a reference to the given string and assigns it to the Company field.
func (o *PatchedansibleAnsibleNamespaceMetadata) SetCompany(v string) {
	o.Company = &v
}

// GetEmail returns the Email field value if set, zero value otherwise.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetEmail() string {
	if o == nil || IsNil(o.Email) {
		var ret string
		return ret
	}
	return *o.Email
}

// GetEmailOk returns a tuple with the Email field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetEmailOk() (*string, bool) {
	if o == nil || IsNil(o.Email) {
		return nil, false
	}
	return o.Email, true
}

// HasEmail returns a boolean if a field has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) HasEmail() bool {
	if o != nil && !IsNil(o.Email) {
		return true
	}

	return false
}

// SetEmail gets a reference to the given string and assigns it to the Email field.
func (o *PatchedansibleAnsibleNamespaceMetadata) SetEmail(v string) {
	o.Email = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetDescription() string {
	if o == nil || IsNil(o.Description) {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetDescriptionOk() (*string, bool) {
	if o == nil || IsNil(o.Description) {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) HasDescription() bool {
	if o != nil && !IsNil(o.Description) {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *PatchedansibleAnsibleNamespaceMetadata) SetDescription(v string) {
	o.Description = &v
}

// GetResources returns the Resources field value if set, zero value otherwise.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetResources() string {
	if o == nil || IsNil(o.Resources) {
		var ret string
		return ret
	}
	return *o.Resources
}

// GetResourcesOk returns a tuple with the Resources field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetResourcesOk() (*string, bool) {
	if o == nil || IsNil(o.Resources) {
		return nil, false
	}
	return o.Resources, true
}

// HasResources returns a boolean if a field has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) HasResources() bool {
	if o != nil && !IsNil(o.Resources) {
		return true
	}

	return false
}

// SetResources gets a reference to the given string and assigns it to the Resources field.
func (o *PatchedansibleAnsibleNamespaceMetadata) SetResources(v string) {
	o.Resources = &v
}

// GetLinks returns the Links field value if set, zero value otherwise.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetLinks() []NamespaceLink {
	if o == nil || IsNil(o.Links) {
		var ret []NamespaceLink
		return ret
	}
	return o.Links
}

// GetLinksOk returns a tuple with the Links field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetLinksOk() ([]NamespaceLink, bool) {
	if o == nil || IsNil(o.Links) {
		return nil, false
	}
	return o.Links, true
}

// HasLinks returns a boolean if a field has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) HasLinks() bool {
	if o != nil && !IsNil(o.Links) {
		return true
	}

	return false
}

// SetLinks gets a reference to the given []NamespaceLink and assigns it to the Links field.
func (o *PatchedansibleAnsibleNamespaceMetadata) SetLinks(v []NamespaceLink) {
	o.Links = v
}

// GetAvatar returns the Avatar field value if set, zero value otherwise.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetAvatar() *os.File {
	if o == nil || IsNil(o.Avatar) {
		var ret *os.File
		return ret
	}
	return *o.Avatar
}

// GetAvatarOk returns a tuple with the Avatar field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) GetAvatarOk() (**os.File, bool) {
	if o == nil || IsNil(o.Avatar) {
		return nil, false
	}
	return o.Avatar, true
}

// HasAvatar returns a boolean if a field has been set.
func (o *PatchedansibleAnsibleNamespaceMetadata) HasAvatar() bool {
	if o != nil && !IsNil(o.Avatar) {
		return true
	}

	return false
}

// SetAvatar gets a reference to the given *os.File and assigns it to the Avatar field.
func (o *PatchedansibleAnsibleNamespaceMetadata) SetAvatar(v *os.File) {
	o.Avatar = &v
}

func (o PatchedansibleAnsibleNamespaceMetadata) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PatchedansibleAnsibleNamespaceMetadata) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Company) {
		toSerialize["company"] = o.Company
	}
	if !IsNil(o.Email) {
		toSerialize["email"] = o.Email
	}
	if !IsNil(o.Description) {
		toSerialize["description"] = o.Description
	}
	if !IsNil(o.Resources) {
		toSerialize["resources"] = o.Resources
	}
	if !IsNil(o.Links) {
		toSerialize["links"] = o.Links
	}
	if !IsNil(o.Avatar) {
		toSerialize["avatar"] = o.Avatar
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PatchedansibleAnsibleNamespaceMetadata) UnmarshalJSON(bytes []byte) (err error) {
	varPatchedansibleAnsibleNamespaceMetadata := _PatchedansibleAnsibleNamespaceMetadata{}

	if err = json.Unmarshal(bytes, &varPatchedansibleAnsibleNamespaceMetadata); err == nil {
		*o = PatchedansibleAnsibleNamespaceMetadata(varPatchedansibleAnsibleNamespaceMetadata)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "company")
		delete(additionalProperties, "email")
		delete(additionalProperties, "description")
		delete(additionalProperties, "resources")
		delete(additionalProperties, "links")
		delete(additionalProperties, "avatar")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePatchedansibleAnsibleNamespaceMetadata struct {
	value *PatchedansibleAnsibleNamespaceMetadata
	isSet bool
}

func (v NullablePatchedansibleAnsibleNamespaceMetadata) Get() *PatchedansibleAnsibleNamespaceMetadata {
	return v.value
}

func (v *NullablePatchedansibleAnsibleNamespaceMetadata) Set(val *PatchedansibleAnsibleNamespaceMetadata) {
	v.value = val
	v.isSet = true
}

func (v NullablePatchedansibleAnsibleNamespaceMetadata) IsSet() bool {
	return v.isSet
}

func (v *NullablePatchedansibleAnsibleNamespaceMetadata) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePatchedansibleAnsibleNamespaceMetadata(val *PatchedansibleAnsibleNamespaceMetadata) *NullablePatchedansibleAnsibleNamespaceMetadata {
	return &NullablePatchedansibleAnsibleNamespaceMetadata{value: val, isSet: true}
}

func (v NullablePatchedansibleAnsibleNamespaceMetadata) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePatchedansibleAnsibleNamespaceMetadata) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


