/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the PatchedDomain type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PatchedDomain{}

// PatchedDomain Serializer for Domain.
type PatchedDomain struct {
	// A name for this domain.
	Name *string `json:"name,omitempty"`
	// An optional description.
	Description NullableString `json:"description,omitempty"`
	StorageClass *StorageClassEnum `json:"storage_class,omitempty"`
	// Settings for storage class.
	StorageSettings map[string]interface{} `json:"storage_settings,omitempty"`
	// Boolean to have the content app redirect to object storage.
	RedirectToObjectStorage *bool `json:"redirect_to_object_storage,omitempty"`
	// Boolean to hide distributions with a content guard in the content app.
	HideGuardedDistributions *bool `json:"hide_guarded_distributions,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PatchedDomain PatchedDomain

// NewPatchedDomain instantiates a new PatchedDomain object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPatchedDomain() *PatchedDomain {
	this := PatchedDomain{}
	var redirectToObjectStorage bool = true
	this.RedirectToObjectStorage = &redirectToObjectStorage
	var hideGuardedDistributions bool = false
	this.HideGuardedDistributions = &hideGuardedDistributions
	return &this
}

// NewPatchedDomainWithDefaults instantiates a new PatchedDomain object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPatchedDomainWithDefaults() *PatchedDomain {
	this := PatchedDomain{}
	var redirectToObjectStorage bool = true
	this.RedirectToObjectStorage = &redirectToObjectStorage
	var hideGuardedDistributions bool = false
	this.HideGuardedDistributions = &hideGuardedDistributions
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *PatchedDomain) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedDomain) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *PatchedDomain) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *PatchedDomain) SetName(v string) {
	o.Name = &v
}

// GetDescription returns the Description field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatchedDomain) GetDescription() string {
	if o == nil || IsNil(o.Description.Get()) {
		var ret string
		return ret
	}
	return *o.Description.Get()
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatchedDomain) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description.Get(), o.Description.IsSet()
}

// HasDescription returns a boolean if a field has been set.
func (o *PatchedDomain) HasDescription() bool {
	if o != nil && o.Description.IsSet() {
		return true
	}

	return false
}

// SetDescription gets a reference to the given NullableString and assigns it to the Description field.
func (o *PatchedDomain) SetDescription(v string) {
	o.Description.Set(&v)
}
// SetDescriptionNil sets the value for Description to be an explicit nil
func (o *PatchedDomain) SetDescriptionNil() {
	o.Description.Set(nil)
}

// UnsetDescription ensures that no value is present for Description, not even an explicit nil
func (o *PatchedDomain) UnsetDescription() {
	o.Description.Unset()
}

// GetStorageClass returns the StorageClass field value if set, zero value otherwise.
func (o *PatchedDomain) GetStorageClass() StorageClassEnum {
	if o == nil || IsNil(o.StorageClass) {
		var ret StorageClassEnum
		return ret
	}
	return *o.StorageClass
}

// GetStorageClassOk returns a tuple with the StorageClass field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedDomain) GetStorageClassOk() (*StorageClassEnum, bool) {
	if o == nil || IsNil(o.StorageClass) {
		return nil, false
	}
	return o.StorageClass, true
}

// HasStorageClass returns a boolean if a field has been set.
func (o *PatchedDomain) HasStorageClass() bool {
	if o != nil && !IsNil(o.StorageClass) {
		return true
	}

	return false
}

// SetStorageClass gets a reference to the given StorageClassEnum and assigns it to the StorageClass field.
func (o *PatchedDomain) SetStorageClass(v StorageClassEnum) {
	o.StorageClass = &v
}

// GetStorageSettings returns the StorageSettings field value if set, zero value otherwise.
func (o *PatchedDomain) GetStorageSettings() map[string]interface{} {
	if o == nil || IsNil(o.StorageSettings) {
		var ret map[string]interface{}
		return ret
	}
	return o.StorageSettings
}

// GetStorageSettingsOk returns a tuple with the StorageSettings field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedDomain) GetStorageSettingsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.StorageSettings) {
		return map[string]interface{}{}, false
	}
	return o.StorageSettings, true
}

// HasStorageSettings returns a boolean if a field has been set.
func (o *PatchedDomain) HasStorageSettings() bool {
	if o != nil && !IsNil(o.StorageSettings) {
		return true
	}

	return false
}

// SetStorageSettings gets a reference to the given map[string]interface{} and assigns it to the StorageSettings field.
func (o *PatchedDomain) SetStorageSettings(v map[string]interface{}) {
	o.StorageSettings = v
}

// GetRedirectToObjectStorage returns the RedirectToObjectStorage field value if set, zero value otherwise.
func (o *PatchedDomain) GetRedirectToObjectStorage() bool {
	if o == nil || IsNil(o.RedirectToObjectStorage) {
		var ret bool
		return ret
	}
	return *o.RedirectToObjectStorage
}

// GetRedirectToObjectStorageOk returns a tuple with the RedirectToObjectStorage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedDomain) GetRedirectToObjectStorageOk() (*bool, bool) {
	if o == nil || IsNil(o.RedirectToObjectStorage) {
		return nil, false
	}
	return o.RedirectToObjectStorage, true
}

// HasRedirectToObjectStorage returns a boolean if a field has been set.
func (o *PatchedDomain) HasRedirectToObjectStorage() bool {
	if o != nil && !IsNil(o.RedirectToObjectStorage) {
		return true
	}

	return false
}

// SetRedirectToObjectStorage gets a reference to the given bool and assigns it to the RedirectToObjectStorage field.
func (o *PatchedDomain) SetRedirectToObjectStorage(v bool) {
	o.RedirectToObjectStorage = &v
}

// GetHideGuardedDistributions returns the HideGuardedDistributions field value if set, zero value otherwise.
func (o *PatchedDomain) GetHideGuardedDistributions() bool {
	if o == nil || IsNil(o.HideGuardedDistributions) {
		var ret bool
		return ret
	}
	return *o.HideGuardedDistributions
}

// GetHideGuardedDistributionsOk returns a tuple with the HideGuardedDistributions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedDomain) GetHideGuardedDistributionsOk() (*bool, bool) {
	if o == nil || IsNil(o.HideGuardedDistributions) {
		return nil, false
	}
	return o.HideGuardedDistributions, true
}

// HasHideGuardedDistributions returns a boolean if a field has been set.
func (o *PatchedDomain) HasHideGuardedDistributions() bool {
	if o != nil && !IsNil(o.HideGuardedDistributions) {
		return true
	}

	return false
}

// SetHideGuardedDistributions gets a reference to the given bool and assigns it to the HideGuardedDistributions field.
func (o *PatchedDomain) SetHideGuardedDistributions(v bool) {
	o.HideGuardedDistributions = &v
}

func (o PatchedDomain) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PatchedDomain) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if o.Description.IsSet() {
		toSerialize["description"] = o.Description.Get()
	}
	if !IsNil(o.StorageClass) {
		toSerialize["storage_class"] = o.StorageClass
	}
	if !IsNil(o.StorageSettings) {
		toSerialize["storage_settings"] = o.StorageSettings
	}
	if !IsNil(o.RedirectToObjectStorage) {
		toSerialize["redirect_to_object_storage"] = o.RedirectToObjectStorage
	}
	if !IsNil(o.HideGuardedDistributions) {
		toSerialize["hide_guarded_distributions"] = o.HideGuardedDistributions
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PatchedDomain) UnmarshalJSON(bytes []byte) (err error) {
	varPatchedDomain := _PatchedDomain{}

	if err = json.Unmarshal(bytes, &varPatchedDomain); err == nil {
		*o = PatchedDomain(varPatchedDomain)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "description")
		delete(additionalProperties, "storage_class")
		delete(additionalProperties, "storage_settings")
		delete(additionalProperties, "redirect_to_object_storage")
		delete(additionalProperties, "hide_guarded_distributions")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePatchedDomain struct {
	value *PatchedDomain
	isSet bool
}

func (v NullablePatchedDomain) Get() *PatchedDomain {
	return v.value
}

func (v *NullablePatchedDomain) Set(val *PatchedDomain) {
	v.value = val
	v.isSet = true
}

func (v NullablePatchedDomain) IsSet() bool {
	return v.isSet
}

func (v *NullablePatchedDomain) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePatchedDomain(val *PatchedDomain) *NullablePatchedDomain {
	return &NullablePatchedDomain{value: val, isSet: true}
}

func (v NullablePatchedDomain) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePatchedDomain) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


