// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for BlueprintCustomizationsPartitioningMode.
const (
	BlueprintCustomizationsPartitioningModeAutoLvm BlueprintCustomizationsPartitioningMode = "auto-lvm"

	BlueprintCustomizationsPartitioningModeLvm BlueprintCustomizationsPartitioningMode = "lvm"

	BlueprintCustomizationsPartitioningModeRaw BlueprintCustomizationsPartitioningMode = "raw"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for CustomizationsPartitioningMode.
const (
	CustomizationsPartitioningModeAutoLvm CustomizationsPartitioningMode = "auto-lvm"

	CustomizationsPartitioningModeLvm CustomizationsPartitioningMode = "lvm"

	CustomizationsPartitioningModeRaw CustomizationsPartitioningMode = "raw"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesAzureEap7Rhui ImageTypes = "azure-eap7-rhui"

	ImageTypesAzureRhui ImageTypes = "azure-rhui"

	ImageTypesAzureSapRhui ImageTypes = "azure-sap-rhui"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGcpRhui ImageTypes = "gcp-rhui"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesIotBootableContainer ImageTypes = "iot-bootable-container"

	ImageTypesIotCommit ImageTypes = "iot-commit"

	ImageTypesIotContainer ImageTypes = "iot-container"

	ImageTypesIotInstaller ImageTypes = "iot-installer"

	ImageTypesIotRawImage ImageTypes = "iot-raw-image"

	ImageTypesIotSimplifiedInstaller ImageTypes = "iot-simplified-installer"

	ImageTypesLiveInstaller ImageTypes = "live-installer"

	ImageTypesMinimalRaw ImageTypes = "minimal-raw"

	ImageTypesOci ImageTypes = "oci"

	ImageTypesVsphere ImageTypes = "vsphere"

	ImageTypesVsphereOva ImageTypes = "vsphere-ova"

	ImageTypesWsl ImageTypes = "wsl"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesContainer UploadTypes = "container"

	UploadTypesGcp UploadTypes = "gcp"

	UploadTypesLocal UploadTypes = "local"

	UploadTypesOciObjectstorage UploadTypes = "oci.objectstorage"

	UploadTypesPulpOstree UploadTypes = "pulp.ostree"
)

// AWSEC2CloneCompose defines model for AWSEC2CloneCompose.
type AWSEC2CloneCompose struct {
	Region            string    `json:"region"`
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	// If set to false (the default value), a long, obfuscated URL
	// is returned. Its expiration might be sooner than for other upload
	// targets.
	//
	// If set to true, a shorter URL is returned and
	// its expiration is the same as for the other upload targets.
	Public *bool  `json:"public,omitempty"`
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location of the provided resource_group, where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	// If the location is not specified, it is deducted from the provided resource_group.
	Location *string `json:"location,omitempty"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// Blueprint defines model for Blueprint.
type Blueprint struct {
	// Container images to embed into the final artfact
	Containers     *[]Container             `json:"containers,omitempty"`
	Customizations *BlueprintCustomizations `json:"customizations,omitempty"`
	Description    *string                  `json:"description,omitempty"`

	// The distribution to use for the compose. If left empty the host
	// distro will be used.
	Distro *string `json:"distro,omitempty"`

	// Package groups to be installed
	Groups *[]PackageGroup `json:"groups,omitempty"`

	// An alias for packages, retained for backwards compatability
	Modules *[]Package `json:"modules,omitempty"`
	Name    string     `json:"name"`

	// Packages to be installed
	Packages *[]Package `json:"packages,omitempty"`

	// A semver version number
	Version *string `json:"version,omitempty"`
}

// BlueprintCustomizations defines model for BlueprintCustomizations.
type BlueprintCustomizations struct {
	// Directories to create in the final artifact
	Directories *[]Directory `json:"directories,omitempty"`

	// FIDO device onboard configuration
	Fdo *FDO `json:"fdo,omitempty"`

	// Files to create in the final artifact
	Files *[]BlueprintFile `json:"files,omitempty"`

	// List of filesystem mountpoints to create
	Filesystem *[]BlueprintFilesystem `json:"filesystem,omitempty"`

	// Enable FIPS mode
	Fips *bool `json:"fips,omitempty"`

	// Firewalld configuration
	Firewall *BlueprintFirewall `json:"firewall,omitempty"`

	// List of groups to create
	Group *[]Group `json:"group,omitempty"`

	// Configures the hostname
	Hostname *string `json:"hostname,omitempty"`

	// Ignition configuration
	Ignition *Ignition `json:"ignition,omitempty"`

	// Name of the installation device, currently only useful for the edge-simplified-installer type
	InstallationDevice *string    `json:"installation_device,omitempty"`
	Installer          *Installer `json:"installer,omitempty"`
	Kernel             *Kernel    `json:"kernel,omitempty"`

	// Locale configuration
	Locale   *Locale            `json:"locale,omitempty"`
	Openscap *BlueprintOpenSCAP `json:"openscap,omitempty"`

	// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
	// there are one or more mountpoints in which case it will use LVM. 'lvm' always
	// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
	// even when there are one or more mountpoints.
	PartitioningMode *BlueprintCustomizationsPartitioningMode `json:"partitioning_mode,omitempty"`

	// Repositories to write to /etc/yum.repos.d/ in the final image. Note
	// that these are not used at build time.
	Repositories *[]BlueprintRepository `json:"repositories,omitempty"`
	Rhsm         *RHSMCustomization     `json:"rhsm,omitempty"`
	Rpm          *RPMCustomization      `json:"rpm,omitempty"`
	Services     *Services              `json:"services,omitempty"`

	// List of ssh keys
	Sshkey *[]SSHKey `json:"sshkey,omitempty"`

	// Timezone configuration
	Timezone *Timezone `json:"timezone,omitempty"`

	// List of users to create
	User *[]BlueprintUser `json:"user,omitempty"`
}

// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
// there are one or more mountpoints in which case it will use LVM. 'lvm' always
// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
// even when there are one or more mountpoints.
type BlueprintCustomizationsPartitioningMode string

// A custom file to create in the final artifact.
type BlueprintFile struct {
	// Contents of the file as plain text
	Data *string `json:"data,omitempty"`

	// Group of the file as a gid or a group name
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the file in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the file
	Path string `json:"path"`

	// Owner of the file as a uid or a user name
	User *interface{} `json:"user,omitempty"`
}

// BlueprintFilesystem defines model for BlueprintFilesystem.
type BlueprintFilesystem struct {
	// size of the filesystem in bytes
	Minsize    uint64 `json:"minsize"`
	Mountpoint string `json:"mountpoint"`
}

// Firewalld configuration
type BlueprintFirewall struct {
	// List of ports (or port ranges) and protocols to open
	Ports *[]string `json:"ports,omitempty"`

	// Firewalld services to enable or disable
	Services *FirewallServices `json:"services,omitempty"`
	Zones    *[]FirewallZones  `json:"zones,omitempty"`
}

// BlueprintOpenSCAP defines model for BlueprintOpenSCAP.
type BlueprintOpenSCAP struct {
	Datastream    *string                `json:"datastream,omitempty"`
	JsonTailoring *OpenSCAPJSONTailoring `json:"json_tailoring,omitempty"`
	ProfileId     string                 `json:"profile_id"`
	Tailoring     *OpenSCAPTailoring     `json:"tailoring,omitempty"`
}

// BlueprintRepository defines model for BlueprintRepository.
type BlueprintRepository struct {
	Baseurls   *[]string `json:"baseurls,omitempty"`
	Enabled    *bool     `json:"enabled,omitempty"`
	Filename   *string   `json:"filename,omitempty"`
	Gpgcheck   *bool     `json:"gpgcheck,omitempty"`
	Gpgkeys    *[]string `json:"gpgkeys,omitempty"`
	Id         string    `json:"id"`
	Metalink   *string   `json:"metalink,omitempty"`
	Mirrorlist *string   `json:"mirrorlist,omitempty"`

	// Disables modularity filtering for this repository.
	ModuleHotfixes *bool   `json:"module_hotfixes,omitempty"`
	Name           *string `json:"name,omitempty"`
	Priority       *int    `json:"priority,omitempty"`
	RepoGpgcheck   *bool   `json:"repo_gpgcheck,omitempty"`
	Sslverify      *bool   `json:"sslverify,omitempty"`
}

// BlueprintUser defines model for BlueprintUser.
type BlueprintUser struct {
	Description *string `json:"description,omitempty"`

	// Group id to use instead of the default
	Gid *int `json:"gid,omitempty"`

	// A list of additional groups to add the user to
	Groups *[]string `json:"groups,omitempty"`

	// The user's home directory
	Home *string `json:"home,omitempty"`

	// ssh public key
	Key  *string `json:"key,omitempty"`
	Name string  `json:"name"`

	// If the password starts with $6$, $5$, or $2b$ it will be stored as
	// an encrypted password. Otherwise it will be treated as a plain text
	// password.
	Password *string `json:"password,omitempty"`

	// Login shell to use
	Shell *string `json:"shell,omitempty"`

	// User id to use instead of the default
	Uid *int `json:"uid,omitempty"`
}

// CloneComposeBody defines model for CloneComposeBody.
type CloneComposeBody interface{}

// CloneComposeResponse defines model for CloneComposeResponse.
type CloneComposeResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// CloneStatus defines model for CloneStatus.
type CloneStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/UploadStatus)
	UploadStatus `yaml:",inline"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Blueprint      *Blueprint      `json:"blueprint,omitempty"`
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusError defines model for ComposeStatusError.
type ComposeStatusError struct {
	Details *interface{} `json:"details,omitempty"`
	Id      int          `json:"id"`
	Reason  string       `json:"reason"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Container defines model for Container.
type Container struct {
	// Name to use for the container from the image
	Name *string `json:"name,omitempty"`

	// Reference to the container to embed
	Source string `json:"source"`

	// Control TLS verifification
	TlsVerify *bool `json:"tls_verify,omitempty"`
}

// ContainerUploadOptions defines model for ContainerUploadOptions.
type ContainerUploadOptions struct {
	// Name for the created container image
	Name *string `json:"name,omitempty"`

	// Tag for the created container image
	Tag *string `json:"tag,omitempty"`
}

// ContainerUploadStatus defines model for ContainerUploadStatus.
type ContainerUploadStatus struct {
	// Digest of the manifest of the uploaded container on the registry
	Digest string `json:"digest"`

	// FQDN of the uploaded image
	Url string `json:"url"`
}

// CustomRepository defines model for CustomRepository.
type CustomRepository struct {
	Baseurl        *[]string `json:"baseurl,omitempty"`
	CheckGpg       *bool     `json:"check_gpg,omitempty"`
	CheckRepoGpg   *bool     `json:"check_repo_gpg,omitempty"`
	Enabled        *bool     `json:"enabled,omitempty"`
	Filename       *string   `json:"filename,omitempty"`
	Gpgkey         *[]string `json:"gpgkey,omitempty"`
	Id             string    `json:"id"`
	Metalink       *string   `json:"metalink,omitempty"`
	Mirrorlist     *string   `json:"mirrorlist,omitempty"`
	ModuleHotfixes *bool     `json:"module_hotfixes,omitempty"`
	Name           *string   `json:"name,omitempty"`
	Priority       *int      `json:"priority,omitempty"`
	SslVerify      *bool     `json:"ssl_verify,omitempty"`
}

// Customizations defines model for Customizations.
type Customizations struct {
	Containers *[]Container `json:"containers,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will be used to depsolve and retrieve packages. Additionally,
	// these packages will be saved and imported to the `/etc/yum.repos.d/` directory
	// on the image
	CustomRepositories *[]CustomRepository `json:"custom_repositories,omitempty"`
	Directories        *[]Directory        `json:"directories,omitempty"`

	// FIDO device onboard configuration
	Fdo        *FDO          `json:"fdo,omitempty"`
	Files      *[]File       `json:"files,omitempty"`
	Filesystem *[]Filesystem `json:"filesystem,omitempty"`

	// System FIPS mode setup
	Fips *FIPS `json:"fips,omitempty"`

	// Firewalld configuration
	Firewall *FirewallCustomization `json:"firewall,omitempty"`

	// List of groups to create
	Groups *[]Group `json:"groups,omitempty"`

	// Configures the hostname
	Hostname *string `json:"hostname,omitempty"`

	// Ignition configuration
	Ignition *Ignition `json:"ignition,omitempty"`

	// Name of the installation device, currently only useful for the edge-simplified-installer type
	InstallationDevice *string    `json:"installation_device,omitempty"`
	Installer          *Installer `json:"installer,omitempty"`
	Kernel             *Kernel    `json:"kernel,omitempty"`

	// Locale configuration
	Locale   *Locale   `json:"locale,omitempty"`
	Openscap *OpenSCAP `json:"openscap,omitempty"`
	Packages *[]string `json:"packages,omitempty"`

	// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
	// there are one or more mountpoints in which case it will use LVM. 'lvm' always
	// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
	// even when there are one or more mountpoints.
	PartitioningMode *CustomizationsPartitioningMode `json:"partitioning_mode,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository      `json:"payload_repositories,omitempty"`
	Rhsm                *RHSMCustomization `json:"rhsm,omitempty"`
	Rpm                 *RPMCustomization  `json:"rpm,omitempty"`
	Services            *Services          `json:"services,omitempty"`
	Subscription        *Subscription      `json:"subscription,omitempty"`

	// Timezone configuration
	Timezone *Timezone `json:"timezone,omitempty"`
	Users    *[]User   `json:"users,omitempty"`
}

// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
// there are one or more mountpoints in which case it will use LVM. 'lvm' always
// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
// even when there are one or more mountpoints.
type CustomizationsPartitioningMode string

// DNFPluginConfig defines model for DNFPluginConfig.
type DNFPluginConfig struct {
	Enabled *bool `json:"enabled,omitempty"`
}

// A custom directory to create in the final artifact.
type Directory struct {
	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the directory as a group name or a gid
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the directory in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the directory
	Path string `json:"path"`

	// Owner of the directory as a user name or a uid
	User *interface{} `json:"user,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string       `json:"code"`
	Details     *interface{} `json:"details,omitempty"`
	OperationId string       `json:"operation_id"`
	Reason      string       `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// FIDO device onboard configuration
type FDO struct {
	DiMfgStringTypeMacIface *string `json:"di_mfg_string_type_mac_iface,omitempty"`
	DiunPubKeyHash          *string `json:"diun_pub_key_hash,omitempty"`
	DiunPubKeyInsecure      *string `json:"diun_pub_key_insecure,omitempty"`
	DiunPubKeyRootCerts     *string `json:"diun_pub_key_root_certs,omitempty"`
	ManufacturingServerUrl  *string `json:"manufacturing_server_url,omitempty"`
}

// System FIPS mode setup
type FIPS struct {
	// Enables the system FIPS mode
	Enabled *bool `json:"enabled,omitempty"`
}

// A custom file to create in the final artifact.
type File struct {
	// Contents of the file as plain text
	Data *string `json:"data,omitempty"`

	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the file as a gid or a group name
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the file in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the file
	Path string `json:"path"`

	// Owner of the file as a uid or a user name
	User *interface{} `json:"user,omitempty"`
}

// Filesystem defines model for Filesystem.
type Filesystem struct {
	// size of the filesystem in bytes
	MinSize    uint64 `json:"min_size"`
	Mountpoint string `json:"mountpoint"`
}

// Firewalld configuration
type FirewallCustomization struct {
	// List of ports (or port ranges) and protocols to open
	Ports *[]string `json:"ports,omitempty"`

	// Firewalld services to enable or disable
	Services *FirewallServices `json:"services,omitempty"`
}

// Firewalld services to enable or disable
type FirewallServices struct {
	// List of services to disable
	Disabled *[]string `json:"disabled,omitempty"`

	// List of services to enable
	Enabled *[]string `json:"enabled,omitempty"`
}

// Bind a list of network sources to a zone to restrict traffic from
// those sources based on the settings of the zone.
type FirewallZones struct {
	// name of the zone, if left empty the sources will apply to
	// the default zone.
	Name *string `json:"name,omitempty"`

	// List of sources for the zone
	Sources *[]string `json:"sources,omitempty"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket *string `json:"bucket,omitempty"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// Group defines model for Group.
type Group struct {
	// Group id of the group to create (optional)
	Gid *int `json:"gid,omitempty"`

	// Name of the group to create
	Name string `json:"name"`
}

// Ignition configuration
type Ignition struct {
	Embedded  *IgnitionEmbedded  `json:"embedded,omitempty"`
	Firstboot *IgnitionFirstboot `json:"firstboot,omitempty"`
}

// IgnitionEmbedded defines model for IgnitionEmbedded.
type IgnitionEmbedded struct {
	Config string `json:"config"`
}

// IgnitionFirstboot defines model for IgnitionFirstboot.
type IgnitionFirstboot struct {
	// Provisioning URL
	Url string `json:"url"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture string       `json:"architecture"`
	ImageType    ImageTypes   `json:"image_type"`
	Ostree       *OSTree      `json:"ostree,omitempty"`
	Repositories []Repository `json:"repositories"`

	// Size of image, in bytes. When set to 0 the image size is a minimum
	// defined by the image type.
	Size *uint64 `json:"size,omitempty"`

	// Options for a given upload destination.
	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`

	// The type and options for multiple upload targets. Each item defines
	// a separate upload destination with its own options. Multiple
	// different targets as well as multiple targets of the same kind are
	// supported.
	UploadTargets *[]UploadTarget `json:"upload_targets,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Error          *ComposeStatusError `json:"error,omitempty"`
	Status         ImageStatusValue    `json:"status"`
	UploadStatus   *UploadStatus       `json:"upload_status,omitempty"`
	UploadStatuses *[]UploadStatus     `json:"upload_statuses,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// ImportKeys defines model for ImportKeys.
type ImportKeys struct {
	Files *[]string `json:"files,omitempty"`
}

// Installer defines model for Installer.
type Installer struct {
	SudoNopasswd *[]string `json:"sudo-nopasswd,omitempty"`
	Unattended   *bool     `json:"unattended,omitempty"`
}

// Kernel defines model for Kernel.
type Kernel struct {
	// Appends arguments to the bootloader kernel command line
	Append *string `json:"append,omitempty"`

	// Name of the kernel to use
	Name *string `json:"name,omitempty"`
}

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// LocalUploadOptions defines model for LocalUploadOptions.
type LocalUploadOptions struct {
	// This is used in combination with the OSBUILD_LOCALSAVE environmental
	// variable on the server to enable saving the compose locally. This
	// is for development use only, and is not available to users.
	LocalSave bool `json:"local_save"`
}

// Locale configuration
type Locale struct {
	// Sets the keyboard layout
	Keyboard *string `json:"keyboard,omitempty"`

	// List of locales to be installed, the first one becomes primary, subsequent ones are secondary
	Languages *[]string `json:"languages,omitempty"`
}

// OCIUploadOptions defines model for OCIUploadOptions.
type OCIUploadOptions map[string]interface{}

// OCIUploadStatus defines model for OCIUploadStatus.
type OCIUploadStatus struct {
	Url string `json:"url"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	// A URL which, if set, is used for fetching content. Implies that `url` is set as well,
	// which will be used for metadata only.
	Contenturl *string `json:"contenturl,omitempty"`

	// Can be either a commit (example: 02604b2da6e954bd34b8b82a835e5a77d2b60ffa), or a branch-like reference (example: rhel/8/x86_64/edge)
	Parent *string `json:"parent,omitempty"`
	Ref    *string `json:"ref,omitempty"`

	// Determines whether a valid subscription manager (candlepin) identity is required to
	// access this repository. Consumer certificates will be used as client certificates when
	// fetching metadata and content.
	Rhsm *bool   `json:"rhsm,omitempty"`
	Url  *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// OpenSCAP defines model for OpenSCAP.
type OpenSCAP struct {
	JsonTailoring *OpenSCAPJSONTailoring `json:"json_tailoring,omitempty"`
	ProfileId     string                 `json:"profile_id"`
	Tailoring     *OpenSCAPTailoring     `json:"tailoring,omitempty"`
}

// OpenSCAPJSONTailoring defines model for OpenSCAPJSONTailoring.
type OpenSCAPJSONTailoring struct {
	Filepath  string `json:"filepath"`
	ProfileId string `json:"profile_id"`
}

// OpenSCAPTailoring defines model for OpenSCAPTailoring.
type OpenSCAPTailoring struct {
	Selected   *[]string `json:"selected,omitempty"`
	Unselected *[]string `json:"unselected,omitempty"`
}

// Package defines model for Package.
type Package struct {
	// Name of the package to install. File globbing is supported,
	// eg. 'openssh-*'
	Name string `json:"name"`

	// Optional version of the package to install. If left blank the
	// latest available version will be used. Wildcards are supported
	// eg. '4.11.*'
	Version *string `json:"version,omitempty"`
}

// PackageGroup defines model for PackageGroup.
type PackageGroup struct {
	// Package group name
	Name string `json:"name"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// PulpOSTreeUploadOptions defines model for PulpOSTreeUploadOptions.
type PulpOSTreeUploadOptions struct {
	// Basepath for distributing the repository
	Basepath string `json:"basepath"`

	// Repository to import the ostree commit to
	Repository    *string `json:"repository,omitempty"`
	ServerAddress *string `json:"server_address,omitempty"`
}

// PulpOSTreeUploadStatus defines model for PulpOSTreeUploadStatus.
type PulpOSTreeUploadStatus struct {
	RepoUrl string `json:"repo_url"`
}

// RHSMConfig defines model for RHSMConfig.
type RHSMConfig struct {
	DnfPlugins          *SubManDNFPluginsConfig `json:"dnf_plugins,omitempty"`
	SubscriptionManager *SubManConfig           `json:"subscription_manager,omitempty"`
}

// RHSMCustomization defines model for RHSMCustomization.
type RHSMCustomization struct {
	Config *RHSMConfig `json:"config,omitempty"`
}

// RPMCustomization defines model for RPMCustomization.
type RPMCustomization struct {
	ImportKeys *ImportKeys `json:"import_keys,omitempty"`
}

// Repository configuration.
// At least one of the 'baseurl', 'mirrorlist', 'metalink' properties must
// be specified. If more of them are specified, the order of precedence is
// the same as listed above.
type Repository struct {
	Baseurl  *string `json:"baseurl,omitempty"`
	CheckGpg *bool   `json:"check_gpg,omitempty"`

	// Enables gpg verification of the repository metadata
	CheckRepoGpg *bool `json:"check_repo_gpg,omitempty"`

	// GPG key used to sign packages in this repository.
	Gpgkey     *string `json:"gpgkey,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Disables modularity filtering for this repository.
	ModuleHotfixes *bool `json:"module_hotfixes,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`

	// Determines whether a valid subscription is required to access this repository.
	Rhsm *bool `json:"rhsm,omitempty"`
}

// SSHKey defines model for SSHKey.
type SSHKey struct {
	// Adds the key to the user's authorized_keys file
	Key string `json:"key"`

	// User to configure the ssh key for
	User string `json:"user"`
}

// Services defines model for Services.
type Services struct {
	// List of services to disable by default
	Disabled *[]string `json:"disabled,omitempty"`

	// List of services to enable by default
	Enabled *[]string `json:"enabled,omitempty"`

	// List of services to mask by default
	Masked *[]string `json:"masked,omitempty"`
}

// SubManConfig defines model for SubManConfig.
type SubManConfig struct {
	Rhsm      *SubManRHSMConfig      `json:"rhsm,omitempty"`
	Rhsmcertd *SubManRHSMCertdConfig `json:"rhsmcertd,omitempty"`
}

// SubManDNFPluginsConfig defines model for SubManDNFPluginsConfig.
type SubManDNFPluginsConfig struct {
	ProductId           *DNFPluginConfig `json:"product_id,omitempty"`
	SubscriptionManager *DNFPluginConfig `json:"subscription_manager,omitempty"`
}

// SubManRHSMCertdConfig defines model for SubManRHSMCertdConfig.
type SubManRHSMCertdConfig struct {
	AutoRegistration *bool `json:"auto_registration,omitempty"`
}

// SubManRHSMConfig defines model for SubManRHSMConfig.
type SubManRHSMConfig struct {
	ManageRepos *bool `json:"manage_repos,omitempty"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`

	// Optional flag to use rhc to register the system, which also always enables Insights.
	Rhc       *bool  `json:"rhc,omitempty"`
	ServerUrl string `json:"server_url"`
}

// Timezone configuration
type Timezone struct {
	// List of ntp servers
	Ntpservers *[]string `json:"ntpservers,omitempty"`

	// Name of the timezone, defaults to UTC
	Timezone *string `json:"timezone,omitempty"`
}

// Options for a given upload destination.
// This should really be oneOf but AWSS3UploadOptions is a subset of
// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
// are also valid AWSS3UploadOptionas objects which violates the oneOf
// rules. Therefore, we have to use anyOf here but be aware that it isn't
// possible to mix and match more schemas together.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTarget defines model for UploadTarget.
type UploadTarget struct {
	Type UploadTypes `json:"type"`

	// Options for a given upload destination.
	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions UploadOptions `json:"upload_options"`
}

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`

	// If the password starts with $6$, $5$, or $2b$ it will be stored as
	// an encrypted password. Otherwise it will be treated as a plain text
	// password.
	Password *string `json:"password,omitempty"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// PostCloneComposeJSONBody defines parameters for PostCloneCompose.
type PostCloneComposeJSONBody CloneComposeBody

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// PostCloneComposeJSONRequestBody defines body for PostCloneCompose for application/json ContentType.
type PostCloneComposeJSONRequestBody PostCloneComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// The status of a cloned compose
	// (GET /clones/{id})
	GetCloneStatus(ctx echo.Context, id string) error
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Clone an existing compose
	// (POST /composes/{id}/clone)
	PostCloneCompose(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetCloneStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetCloneStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCloneStatus(ctx, id)
	return err
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// PostCloneCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCloneCompose(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCloneCompose(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/clones/:id", wrapper.GetCloneStatus)
	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.POST(baseURL+"/composes/:id/clone", wrapper.PostCloneCompose)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9eXPbuq74V+H4nZme/up9SZzMnHnPcTZnT+wkTa47ubRES4wlUiUpO855/e6/4SJZ",
	"suWt7bnb6/3jnsYiQRAkQAAEwD9zFvUDShARPLf/Zy6ADPpIIGb+cpD8r424xXAgMCW5/dwNdBDAxEZv",
	"uXwOvUE/8FCq+Rh6Icrt5yq5b9/yOSz7fA0Rm+byOQJ9+UW1zOe45SIfyi5iGsjfuWCYOKobx+8ZY1+F",
	"/gAxQIcAC+RzgAlA0HKBAZjEJgIQY1MuL8VHtV2Fz7foowLdeuwetattjxLUluTjaiBo21iiCb0bRgPE",
	"BJaIDKHHUT4XJH76M8eQo+azMFA+x13I0MsEC/cFWhYNzcKYmeX2/5arVGv1xs5uc69cqea+5HOKEpmw",
	"zA+QMThVc2foa4gZsiUYg8OXuBkdvCJLyH56fveBR6F9rUjPv3uCMeI5FBYmiItCJZf/R047n+MEBtyl",
	"4kWvdhInf1qIvi5ilU2wbFzXkbEroAg1l6QIBX2cxgj6uFC2mrXy7l5td7fR2GvY9UEWxbYk8dxk5Lj5",
	"NXugW/uRLRCEAw9bmoWHMPRE3C7N0p0h4EgAQYH6DH4XLgKmC1DM+zEPIPAocfKADoYht6BANri/u+gT",
	"zAFDImQE2UXQERygtwAzKEEDHzuuAAMEOKUEMSBcSMCQMkCFixgI1dz6REDmIMGLfdInM1wEC5EclruU",
	"CcTkaCAxGIDE7hOcHhBzIHHn0EcAcjWU/Ds5HJiNNluiAaUeguTHF3Wz5Vy2FUPmZYvi5BCyUSb895Ch",
	"H9ku2IcOijl0TupLitKhoqamI7KB6iAXHfghV+scEvw1lEeTaujgMSKAIU5DZiHgMBoGRbXEchC5WNTH",
	"Qu6kIaO+6iIniriQ684gsakPKEFgADmyASUAgvv7ziHAvE8cRBCT21AvZEqgKMSyONajFhRmedMTvDBf",
	"okkGjI6xnGSE/otCPw8mLmJINVGjyO0ZeraafEQXSGQ3B3OBmMLvlE7kjvYwFwB6HojQ4Pt94goR8P1S",
	"yaYWL/rYYpTToSha1C8hUgh5yfJwCcq1LRlR999jjCZ/qJ8KlocLHhSIi/+C75EsfJEDvcSDfFAklxhH",
	"P0nSEyoAD5CFhxjZeYCF/NFGdmilFmQJHeaJLtkDhXI7ZQvKZN/Vuyu9XTYg9zwqPRpakNwZMCdqxKzj",
	"LhzEKLxgexGpzqFEKdnsO5Cpo4bdHFStAhxU64V6vVIr7JWtRmGnUq2Vd1CzvIeqWdgJRCARK/CSSOhG",
	"m2FltuAQE1utteZQJTPADWUCepvsxWgfCjxGBRszZAnKpqVhSGzoIyKgxxe+Flw6KQhakEMXNMpzRGpY",
	"u2jYGOwUKlZtWKjbsFyAO9VqoTwo75SrtT17195dK3lnFFtc24UduEZ+LpPPaQm5iciZQzIBIAuFAy9E",
	"AcNEbCm5LUoExMTYDOnt0o6+6d3B5S5A/kCKbyJPWRfJTQE9AJkYQksqYbFe9xtDw9x+7r9KMxOlZJTw",
	"Ugw3S9+zQi6oj99hfA6tAhVPu53u9m1OUclQNG3MBaOLs+5JDUZ+w4NQsa6gIOQo1ggsbTQUQWcIPDQU",
	"APmBmKpPLuWiTzRgMMGepziJL/L2ENmUwUJtL4uB1T7jWaabNZJMqr9LtAbyvOQCeh6yNyW+gaKFWwb9",
	"fWqHxghLD98iAHrYqEaBhsLzUqmSa2mrnwfQGk0gs7miEhRwgD0spmr222CXhVjEOwv0inBZSrEfpVUW",
	"NmPEeKY20AIc+WPEgGkBiLJ6U8u/W9wt7pbXsvx6Zm8vMMsWrB+JWZxFusPZR0k9iyEoYu0s5nq8DdtH",
	"IKdZ9BzadF3/48Nr1RJnbs9j+fPPQjUmsISaia4cbcoF8jP0Qamr0SGYtQG+1K0CiolIoPhdyJhBM1HK",
	"EhpHBA48BI47N13gUxtlGi5DzNAEet4WmJgOkbhaToWZtNpu1ksFlBSy2ZZGm5IhdkKGeCyNVcMMGYsd",
	"gqOTYRUWnaid8j0p8aF47cVGY2ytsXaSHYDukAdWyBgiwpsCSrypPB2GoRcfLsh2UIFjP/CUcl2IRBYD",
	"cgpzp0jJRuMSt2HmBKOOa2cYN/yWz40QI2jtNjjXrYxR5KF17S90q2/5HA0Q4RYMNt5o1wEi3XbrRst5",
	"JtRiYOK8qL2cdE/kYChowRv7uXkfRRd5yBLAlWqsPttHRt2NjugYMrKL4EME6IP+Ls9+BicgJB7ivE+E",
	"0pkhQ8q+pAz4lKEUh2Op7mPLBRbkSKrMMZyLh8si+KBgQ28Cp7xPQo64/D0PkDR5Jy5SgssMQShAb4LB",
	"JPwi+MDg5ANQPSVmMfq8T7KALMHTKCUk9JX7AU5y+ZymX0zKL5kWWUA5XnZu3CW+SqafMCyQ/EcJCas0",
	"Df2i6l+0S2kJbRwCV1QgSWIo5DceEUEoLQpAAQYh9mwgsI+Km2sV8XaKscs8g5jL/XWg7k67l6lTV3UM",
	"1ve7WezGEZMyYS363aid7MPdEZouF7ecu2CEpnxT0nS7p+cokxqSxu+UrOXuXtTuWz4Xci1wsnGTX3/k",
	"/LvnWSbDt1UKkjq/M3Q0bWWoI3qdzqD32ZzqBAXMtpck5pH8V9AhB4EHJWT0Jpaq+4vA1Pk3DwkCB9uS",
	"l6HxcZjzbXYmMKqc4ZSg62Fu/2+L6nL8CyYCOZKgX7TWn3VZhJiPudRiOdAA4oNKYYQJoJaA6vjyoUgh",
	"Ut6p17OmG0DhZmnqwgWxTeml56REhz81vy9AzN501xOi75rS9Asj+sleP4l8c2q7muGXdbtypj2mt5aP",
	"Sfbtmfw1OR+jWmICBlOBeHIa1Up9t96s7dSb+dxbwaEFg0qIidipaysvOgbS7ojSGLK1dkmicz7Gd82E",
	"ZwrmSgtlXqfX3WxgGdVOy86F2wrKBF8ud9Rn8Ls0WykTgEHiIP5R+VoDRgW1qKfEktROkmT8W65a3RdW",
	"kMvnmmXzD+zDQP1zu0usDSV9NOGkxJeyVbuQNhGWEYRn1Ws7YRkrWwubUso7LhiCfuZ0XzklLwJij6pf",
	"1qAYDXPWvb7qxZ2+qUWVG9u4LheJuu0ACeDzLDobaeW+TegLCzQZQI5C5qWXZsZJkUPUskmRIduF2hlq",
	"6TOiZGMuSsxFXrPULL01d1526iUJkfIS5aVcPmdE6n4uZDjTzTu3xZAy9JKUSxl4HlrqP3ECx3KRNcru",
	"6gSO0ieSs1yLzJIV9JGAHiajbEr5mDHKeFE7xwJG5XIUKXNKUb//lrrjH5HzrNoPy+XqDmSW+4em4AZk",
	"04N4mItFJGIc5OeihYigXI3/3wx5CHL0R7OguSAxMpT/v1PXvyj8DiBH191NcFGutheXiiF+y3bCcLmo",
	"HKiWkGExlaJfoMRRrO41o1267GZyue+MYSrBJj7GB5tW9V9Wbw/OvTFieDjN+jzvwl7DbffmIN/Gh7XG",
	"yetkXYNo1QrbkWdX2soI2tHhGpmU+QyKLPPNtvQNHR2CGfIJ1we0bX3/KZUOQZOa72wLquaVTXjdpVnu",
	"j54Z4AMHsgGIr1GyQGYaEdJ40Df/0oZIKUacuwVkVxuNyh5otVqtdu3qHbYr3vNhp3LVO2rI3zpX7OT8",
	"iF0+4U+Xl/eT8BTetc78uwvaeb8bVr8eVu3Dxnv5oPdW2nnLwmnxdkROp5KtRXI+oSzrjstcwpoGgAso",
	"T/8JFi74bee3PPit8VteqoC/VQe/xcb5AAEuKJM2Ju8TSAAiFpsGAtkxpCK4lib1BCds+gECQpkOttYu",
	"Z5p+n8T9kjyZjJlBWh+av0x2MAHqo9memSpv1raW7PM9u3pTr3MyZOqA2mr/zBTlVQdyRsiVsjqSv9wh",
	"HlBigrE8bwOo1wqzOzREDBELKeV87tLNTm+nSrWG6o2d3QJq7g0KlapdK8B6Y6dQr+7sNBr1erlcLqfk",
	"dqhuANdczGVJtXh2s/vA75/UqvapW0c9rKZnx/4PoqSe0gV1+E+dlLpSVR6lTP3GoJC2oSTbsCG00J/f",
	"skTziL7itf5T+orVXLLveA1CK0lxCQkeIi5+Kj38JNAfJ8a81RhDXz0zJGDkXvlZE6NSa0MvFvV9LDLD",
	"In53IXc/RrJSroAApnn+O24ctTaAieWFtlTVro4e7lpb3jrGhNjAiEvQ706HQa3VowgVOtZztkJzV+/5",
	"3CAOKvjybV7zGiQDDjZy321/u59xqZ+4mE9LJGlLFZqZVyGKq9iMLiuvQ2TjiIbznTc3w+fBfK+YWOCi",
	"FAESy/4zzpks6chjuGunGx1C+VRXtCXRZlCyaLYhPpJ0M0Cb9UkR8kHFnc8T3wBKT3C1ONPgjqRVmeFW",
	"QQJi5UGYt5lTRhjkmdbN4ukZN15AQM9HMoy57uGhZSEu5zKE2AuZVDMDRKS0khNKKP5xwwXGmsXxLMxs",
	"RSjoQjhNFGQUBw4ujcHUgVhZl05mG0cu5BnQKGQp7eVVEZZsWjQ/Kc+MGnVfQCfTAvP4y8zOXXT7M+qB",
	"3kUXqDZ4iK3IURkPqmKS11nIZoKZ2nc0pR+J012xLPF6GHvGSgd/zV09U660lExSQSfDNoXOliPo0NRM",
	"nXEdbRKycJtoGMccD/M+GPl7pBlESsxCQPNsMpSYYFS9x7KtPxOuPefuvj28yo6UnqPN1xBOi5iW/KkJ",
	"2y2Z9dhfQbX5QPB8NOXM3aZO3g3cn/8i3k/loXpxAifbS6U/R+6s7DY/5EA17pRfHtK/3EP605ybnHsv",
	"P+q6/KH4u3To7c+KnH1ZHZ9xpKJJkm1S8ZyzuH6ACUhr60XQcxFHfZLqnQxzlaetjQJOvTEyqQyCYTRG",
	"MfwiaMUE8qZ5FU3DZ59nzjg4NtkQ2A8oExq2FIx/Xwgk+fvM09knRvrOpOZmdJ0XdxnknQuX/KeEPG54",
	"BbhJzOLGoNZHHK6E0LnpbhNiGN1fLgTLLPO8/0vFGSbj+n+FH/7bhh+mow5nvp5EZEBAuXAY4tvFAfwK",
	"YfyXCGEM4FRq1/+Uo1Kx3cbnZZ9ErHndBVhw5A1Vju1UAyNU5U7CMcSeivOOWuswSUapAJT1CSRTk8kq",
	"CZ10c6oQGGngf1Q4RwO/cCQ4GGLk2RHMhelgDrBDKIvSWzYSt/8BEZiJDLG1/ZJtfyCmcvPDf/MYycOr",
	"4xsvdDDRx9mihbfCIMqEF+s6y+MtY0Xte4IuEeEhQy8BZFHBi9W56UeqPYiCiYHuCBJ6HEBvOGktJ8Ne",
	"NojKnM1Gh2bGEZkmQhPb/5TQzBlaK+MzdxuN74vPTMYVLARp2ph9Z4zmHDXj+EwTrvkziLlpoGbsrv1Z",
	"vnTLrOFiEmLSAyx7wERScUbo/WauYEsn+pjmc4Cz3dVqyhfG6N9s2qp1xr1BJKY2klea1OvuDjWobMyl",
	"jbRlWGnn8NooxICSAYVsXYCpjV/8ofOiyf0ikXjxofUiRdWSdcUheQnCwcsITV9cyN31rTDhyArZBvDk",
	"3n+xkIl5XXSaQBJKGRoqZOURh9jL0voQC5tfWWzbEbSrQ5HjJDPAkVCp80sPlHWSW4e9qYIcc7Bz+Y1O",
	"o3+DwP+/8Dxbc+vwK+ng/07SwZpcg5d/t2SDl6XZBtmuo18ZB1tmHHxbQdpuAup3UTVCS93L6tRkyoCt",
	"45wzjl2eODEy090S8GZQEvQUyCNIbEe71Dm1blTdOD3oUMiFIyLYssLbUro/RzkgWxD9ABMbwDgumSAx",
	"oWwE9BWzjkoG0saU/2JIYmUJIBgcDrGl7uL7RLiUo7hHXEpJHctICEyc+MiTkLIOzGwPKkm4KWXPPMAL",
	"xTSiYZWjAwaBJ41G5buKC4zNBl0SKrCCRSPw0dmizO3EaqV79cNyuWbpPurf6G8l/ZsP+Uj/8uV/9S+X",
	"rbb+4X9xwJHY17+qf+vf119oZu2Fk/bNj1z9D0JrhMRyjzEkWnuQ522317o6bN0dgq6gDDoIWB7kHBwo",
	"EMX5klnmj4IZYWkEVvZW6LlIm3lzcSHxvY8Umqponw3a1A9CgcARcTAxlzzFPunF9YsUoLmKYhMsXKPf",
	"nbRvgLk1zRv/JubKE5f2sylYpubb7A5KVXxJ1b6KS431yQdTFoYVYIALesnDENt6xT9EmowZTqoFIoX1",
	"NqXIZnXmFkkpp6i/J4o7xXOKvMXJS7UEfSXXG3qq2n0xKaH8G9sKelQJrAi6CIH4ot+joV10KHVMOA3X",
	"W0cVhCrFBcVMDbd0ATEVWBF6AhcM5nGxMcujHHERKWmG/8jvps5XtD31xoy7fZRktqTsIgCGgvpQYAt6",
	"3nSeyCjcopplthgxdFHzBlFzia+Ckt7JWdtXbc9inxxBy402iaK6uR0GMKZUrFiaYdSdTBE8KAy0MswB",
	"ZGi/TwAogA9S2dz/E/kQe9j+9mEftAhQfwFo2wxxrk0JhgKGuDJf4rEsCQLMTasIjikDhnp58AF62EL/",
	"kwih+lA0I5vzsaX7bYmDHtqAWDa2Py0of3YBBsH/wCDgARVFx3SK+iRRUpbLttQw84/K1km85khg+5jw",
	"TBrY1IeY7P+p/ysHVOwJuiEWCOhfwe8Bwz5k04+Lg3ueHjBKGzInLRSm7zxFZqz3QapUH+Zwyua61Vsz",
	"KvWnhYPKoIFk2icRfftzuqvacAu7Ihcro9F+2HTxcsZO3V8kcy6fMwRO/viX1NONz92fV9pNnc0S/st8",
	"XgXkFiI2JKIwYBDbhVq51qjU1hpJCXD5dZXiTiLTfwvlYXUanRFL2jkwc6r8TgMN/mNmKt36aqFzAL+/",
	"XlYncd2+hQYddVtjC6r4UlvbC5tc5h9F7XVYBBcDSsWmnY/jDplK4sIYW4ckmaugdQ5m1W4VrY+TM9sC",
	"hczIyBtGx5jre3Nwf3exUYBjJnbJuPztEIPMcrFAljA+2hnTxqF1SxRf/fMGse+9aaDvGHXCytowhW5P",
	"tsqoyfMTrmJnfiHjkywveH2Nj0hNMh/7horg0UUkKsVcTlYXlR2wPFh9TLAf+n1io6EqHjiYJtopvSZ9",
	"uNSre/W9nd3q3s4yJ5NW119osFFmSdqSmnU3FZ6zdWs5plKXzSDKVlGKa+Ch+RrRQGl0ciGAniTvEwg4",
	"CiCTwtG0tpG0uLSyqw5YLDigExINUQSXBn6f2HiobphENIa0IiZIWsd8hkb0zchQVc96pFwBDPUJDwN9",
	"4m9xZa9p1VNw1x6kKS5JMcDcLv0SceOyYxVFl3AbJ23Ed0lbJ62YdI94G2wGIJ17Odd5C0ach7OSwFHS",
	"SZp8W+V35HMq8kP/UyOt/x1VnjZJIAviLCGkEkPBiRwGTnjBhQXmhtj8lfgnh0H857tGRhehRjDYTX1J",
	"/5Hop0LT4pQ881cUDWt+mEWd5XOOcp46VgzAkTI/1sjUf1MdMBUFeV7BgZcGLT/EA+s/0h/noTA4mY1D",
	"RWZAXS6f8/A4jYGSitAr6DgmakmsxzyQZvzsXwU6hrl8bsK9JUsk+fvcVOxIc9RiGOl3uKE6yci+NHwe",
	"2rRAqEp8t7cLhw8JFAIRe/Nwk/M4VnCbMzyQPJBxL6h+l9azE/rIWPAqRIpSoRIxGNDBiSorVJ4BHibp",
	"WxxCuS/+GFJmoVXFDZaru2aAOOt/Blp/KdhoEDqbZcScm/zC78gNmg17rNMI2h4N7cIB5EucUSrwP92z",
	"Wq6Wy3vl3WI508GirqSzUxxG9BVn5DfIn91wsElmCOSjebOqXs0yQBIlfGd41NY/1GDQnw1lFncGcUaV",
	"L0vWJkpln7ckJfOadECiUpUXIiGIFkO65TLwy85UJfc3oU7WnoqiQ9IgpW6xpCyzg5ZkXhjVcvGLoAJ6",
	"WZ/mqKAGzccvEekHgHTn/NJgkbx6qcH7ESe6Cjh+4XCM1l/X91zMY38vlkakP0ipetoze3DfuTh8ubhu",
	"ty66rYcjgMgYM0p0Sfw+GUOG9TVZdO8iN1/i+ozDsTSKEpXJlR/U86ZFIFFQz6xIRdVGY+TRQAJWjnZK",
	"vGleu7e1n2cWRapFEFvy0MncWiRospTmaEvLW3daY3eP0FTF7ixK1a5UgLVI1U2AB6c0TMcKhJk5rR4k",
	"Tpid2x+5fHXU+UJR8by5LGeyFUFggCzqIw6Miy+v3oOQlidR35WrFnBkUWJDkyaY8KUh8nLfLd73jgvN",
	"H71EvG53ttvzyyH8Ja/PGDN2/8+M/ChERKZDoKXe9FFXOOrukCORj5lN7vYhEpYrGcNAKYKOVMKQcfP+",
	"PWTe32UHaaYaMyrfJ/pOKJXSpGw8U4pB8cySC0cdjZMRGwSJhIWwCr+GpqoE+N2s9T4oV3fK9UHVhjto",
	"r1Ef2LX6oDloVmGz1kANuLtrVwc75eEQfszrGJIBg8RyCx4eIcDixOcZPOYib5ZVKfXij3PXHostsg/2",
	"4WKFhQ26mRDu1cLxEAnEfGkVg4mLDGn0XUrq2RQfEuggBn63ILE9FGDyEWAbEYHFVD/ppPeXuhqGyuRZ",
	"qIkG2pTw0EcMWHJzqeTs+cQ1yIHlYcma6TYuIn0S76V4H0ipGW2sJSXXNg+4mw8fXWAE1yzFonsp++Rd",
	"ciRn1QswB6kaIZM3l5aE/E+r+ZiNYaYNFUWTZXn1l09mOTr5GdRVmK3Aiqv8ILS10fU9/bK2cPRQxk+r",
	"RhA9pWXK6QganbNFcIw9BByPDgbmQj32aeX7BDlF8EGleXG38P8+zAk+4YeZheeWPuZxbW4w4sc8VuAV",
	"PQcz8CAZyVZ9orPxE4pVBCb1Ngx4xJ5tqVdTlEoQTcfMpl6sVIoLU6kVa/D7L0RSj8D8jEVLvU2zGOEI",
	"CVR6TkFQ6vEfxjtZI2rRSZ+5h1FAl3xZmj6esGwXTVjs+HZj2ScCxbJA7uguYNUeXPNalXamLjU585oI",
	"MY5fJN1CL9Bq1g+FEEGOsiNpD8wXbWjEJYqMXTI7i3Or3hOYrnhNQCUMaaNXP8uoLkgiZUpV1FziZngx",
	"1/tKeK/0HczROZ5t5kacI+gyxViVnNhIO45bZg2nct6WpGnZZPgSqEQuvkE62iUkceIXNyDnn7QzStdm",
	"0CIY35ahPR+Nu+zGcW3O36qBbtaNo/fOS1TKePW9QOxCzR5ssw2bMl6LfdISQDKoNg7NOfLBVFH5kAcf",
	"ZoU11F+moMcHMJuHCgzqkwGahXGoY0dlxWqIvj5C0lEelNk6eChgyEK2shewTgOO3zuV40o9eEDHmXGc",
	"iXIv/7gqL1tXddksrcQJHFOoKf1w50wSxZr+EuV+VvFlLiTi5gSM0DRO7pVnwSxhWEUhpm2T1ClZkP87",
	"ODrpXIGbkxtwc39w0WmD86MncHBx3T5Xn/ukT/zbztXBScvqWvTgqHV4MWw+nY7Q+9kOtL3Lp8kuPDnp",
	"eGfQE82z1+pb6aB6/sntDDvh24kIHl53UZ9c3DmH97s7r7DXCB4OG/7x5VktGCGC7kpWz//69XZ0Nb3l",
	"7ucqvf08OXq/7w4q7avL9rB94ow+N2+rffL+PGIdq82Oy7fVCTsfeDC03ftP+AGS1iH3K82no6980Gjd",
	"13Ztcc8ua7dP9qOzd/fpM74ZPjTv+uT84LVXro0fDq7tyy5/qu1dwDbZ6QSV63HQ7BzRUgcdPTxVvvrt",
	"65sWPC8Pzk5r4dCpt0M04p963T6Z3D72UPviLXy+2Lm+/Eyvb84n48vb4dvAqXw+bI7D5/K5eC1ZV6fV",
	"NxiW33zeCvdOzwI0Gl/f3L15fTL9Kl6nz0NGHzA6ngaTZ2d8OxGEXDZLTvcoLJ099NhTuVH1j+57u21r",
	"sFsfWafHvePh5cgjo5NSn5SH9/XWHWyU66e1t9fySAxQbXxu3XymN9fh+cEDP+2Oy+X7k6fW9AaF00/N",
	"Xeu+9HTkXu6Oat2H89c+2UGdZ2eKL6/LE6/ydHJ4d26F3mTE91qfQm/kVGhvUOe1d/95fFPePaG9t8d6",
	"9RWeNx67n67cZ4T6pLlT/kwf3IFVOQ+6n16Hz/SVsyPx3LwZ3D9/ehofN+8CZj+22Ovp4GxUPQvuzltv",
	"PfeN37b4gXtS6ZPyRfhWfYSXB2Wn2mncWJf2Wcn6+krLTctirwefQ/z2yHADh3uXn4Pm115p2H2/8rnd",
	"cUiz9PX5vE9w8zb0huHubvjVfSxNRHUgCBbOHf/66r5dhq9P9/XnQd0dieOme35f+vx5t1796l40ziet",
	"u9Zt66BPxOHxyfPj3djyj5zzw8vKebfVfPYfRoPamXvRu6xcfD6YwseKaxGvFf1unZ6Nof/warcb4z6x",
	"fOsTvj27Pji4PGi3WvVjfHSETnd85h6f7oYP/Pbi8rJafmpYzy55e2oet3zFQ+2TSfO4PRl1+uRg0jk5",
	"vqVn7RZvHxw8tVuTo/apc9Q+rrdabWd0O+v96eqpVdo9eAocb9ptPT+duq/Tc7dPSp+GO+83w4fx4LRa",
	"PvpaG3V2r48Prsrk4vOng/uKH467n772wm7t8YId1PzaSeiJ4Pzu6Oz8QviNo8M+qbCT988t2qtMg72n",
	"TvOidWhfttvX09fWK6eP983dp/uw/ak0IK+sh+6qF3fX7eH0pr2787jXbODrhz7xG91PA357ONltVy+Y",
	"Z7cu65eHIZ0+V7pYnMDn+vntxYP41DuClTrmT92T9us73b15aj7Uzq5HjXKfOF8fnWb1qjTwq0fv3d1e",
	"s/Z4dDioeOPXescbvzmdr+fIqVTePz+9+eyp+3x21h6O34efvKvuTvjmnPbJ61vprDz1nqsXeHDCdk5a",
	"ren13v0jaz13J93L8pH12mtOjtrkbdQ9DKdf/cfJw/jq4HN41HloXqPaU59c4vvK8Oyqye3dw4AfvzUu",
	"P322ySW57X46Za+9m/PDmv/IvJZNjnqu/fTQfH0eBY/u4ZTXSnt76LpP3FGZXZBp+fVqMoLhsITvm9fW",
	"zufx5ej14u7yzGnc7z2cT8/Cx0fxPvlMXi+vGo93xwdfz+v8mfqXl30yFIPeaeVTYzq4eyy1auODAXy7",
	"e6yK3fv3q1frHY26z0cYXlztXZROrbN2565ye9zcaVYP7ZZ3dLxn98mo6tzip+5tC8Kz8tlZ6/10fDe6",
	"O7u4cM6rT7dP+PTqYVoVtbPp8ZAz6Dcm3fbj9dC9QZ3pxUHv+axPxiy48m4GaMh7e43d3rB6cNUJnfdn",
	"1m48vB12z0fPzp1beTgZdzu3pD19H91Od47uq19vAvzY2JMyyr3pfH5m59Q6r51fdPdK+P3stnfnidfL",
	"1h998sfNsLfbJ+p0Obo6XHX0LCllQxl64dzLPqR/VTRb/+bDSk/pz3oDIlnZI9PrIuFFjg1d/kP5mxNa",
	"EeRSoeFAmVyJaHFVVaRPfg9wgDxM0MfMCiML8cJRCUm6ZRWdn+tiTnuRwRIn8oZpx+Y5te3s6kxVsmXb",
	"8R1WFI1gXneAoXApw+/IVvbMYu7qRo81tLqPWIyuT+v3zd36kc0P7slUDGqDyfjOcU69W2/w9NnbJZXy",
	"eG9JDcvMFNh7/cRFbP7oHAjzLJ3cUmnHkO1jsj6ak6v7dkmnLOt446zEn5BdCAbTxFMKGZUvo0JndrYk",
	"Ih3dpfJT0g7XYkOGKp6Jb42MD/loU1xk27WY6ETMbamSyWNJv8Oix2WDEkIaQtKpoIWKhZiwt+gsm69y",
	"SyzxtyzgHDBqh3E2wMqCgnNFe77TdbMAZjn28xNddLmGgr6Yardw7iGe1bJyfhX2Mx4k0NXXA8q3gJoq",
	"zzSHrCXwWJdCMVI3la/BkcWQKOjHb+KjPH5sJmPvDiBHL5mOkUW/yAbqASYcO65I886yIg6UOZAkPF7J",
	"+Kt6uVatZ9/PWuvPzvjeY+hBJ8rMZK6lc4V1kGiiOkeUTAk9Tk1VOCOgOOiYGc2d/svmlC5XkixDPlvW",
	"ouTVBGHX0nXuOEnRLT+/J1I4JBY4sThZh1AvUdpri0iXqNuaWBciAo3VirgUIgIQNUrpWeUioUy4Begj",
	"hi1YDCj1ikQEUs/N5XOVVZ+3UsyS5c2WX+pFrfLRgaEOkfteO6UZ3HdLR1DuM7JZxOPixQaZbvw00Xw6",
	"wNo+3dp2XRaSt9eO8R4ytF2XJRXi13XLCIpb12Uhomhdh2X3T9++ZEueyPZw8BiRjFwJlaSMOeAuDT0b",
	"MAQ9XVVR1VABg1CAxUXSqScqCkvyS59krL2OmQM+gsRECkHPAxkNgd55vE8gQ1rwadtiYVwYtzVScoyp",
	"uhjWvnmJcJ+w0EO6aiRDQ8pQHkwQcOE4TotXuxmojG45uwECcAKjakBYAMzJB9EnAeUcmxA+H7+pQBUf",
	"CsvVlwRmPYCgjrKIpFCOeWfZHVYipWab577msho2ZqkNe8ynZW7BUBv2yH5VYGPe2LD9kptEVSBp+zSU",
	"OJFlk5wzk9ijk86WPXVirpujTfBlbrtsmXjCQkKWZZek8owWduHWE/rBlLDsW/c5kF+WHkTLs2SKvBan",
	"p0TJMMmMEmrhohEYuryBJGDoBUWTFGjKHmeTcPsXNGd1tX/oScoFbfrXg5E/9mDkBtbHZlEzSqm2QobF",
	"tCu3ul72AwSZ3isD9a/jaLizx55UgVVLqZrrdjFUadnkvn1TpsqQZoVe67oNghrnnwow1zFSOr2TF1Xu",
	"k4XMY496EXOtAFouAlWVMqLU/9hJPJlMilB9Vp5Z05eXLjrto6vuUaFaLBdd4XtaBRVqI1x3D9TwJkGQ",
	"AVWgBMAAJ4Jm9nPVqCy4/LCfqxXLxUpO14tTZCpZHiWIl/7E9jfFLVkldE6QDkrRMlMV0wFG0Ml9I2WN",
	"h0T0lot+5whG0fqRKqMfi0s4KylTUfmztFiVBY8pAUrEIhvZxWRtz46tUUk+O6nCkqGPhDIc/pbx8F2U",
	"vxshLyhwVBEfTNTeE24Ua7QfvTAV7Thtwmnx+Ze8DvlFjqZfBVWLUS2XE3HhJp/LM5f4pVdTGnWG0MrD",
	"PUEltZ3TlEnSRG6R+k8c2qSpLg7aIVqFjPI4sK2Hrvz1Q7dCVQpxhJQ/HGtE9Oi1v370ezJzacsdGCAm",
	"9waI97bGpP6PwGRE6ITMLUHjH7H69wS9BSoaF6jUZ0At9ViDnRLhiosj4f23L5JHeOj7kE1NknpSCCnh",
	"Fe8nBacU/aGKGGY9eNXW1TsgIGgSdc2DgMqpY2VnWZRwUylMeYLHiMFIuCt5bww2BK2oviZmSfONLwqu",
	"G8pF9DawFjKIi+iV4Z/D8en3Mb+lj08pzL4tyJvKzx69Y2ctvfkIXMi1+oHsf5rQYbNHK39Jnl+SZ0PJ",
	"Y4RGlqT5WcrTFvpSRMM1ilLq5dSNVKUY8P8xZSlFqYwdlKbLL4Xpl9j6N1WYlsovbQgmtaYM/UU2mSkx",
	"G8iThLD6F5Iif4HulaCMAvyP1r4S49+ZQbK2lCpGiyaz+ocDpHKItcsmW64J9CZKyo+TxmeetBtLr/rP",
	"GiCLN7+lTm1JllTl3xUM4JmSFd9zig8xwdxNHOJg5RmOxezo1iUK1AWLjwQEmOg9jCkBcEBDYUL3eeiJ",
	"Vce8qrjx65Bfe8grOi1hDbkF4gLN+m4uNhAxAYTqd9ys0IPMVKQFvwuXho5rbsfOutdXH4v/cYx0oqoP",
	"O9G1ZbTLs9goekF6PS/FLTdgpzskQka4yi2K36iWyCgb3Iiz6GFqJd9Ngbq4sUUVY8WVj8zyRQX6oABJ",
	"d6x5b1pH6kISvT9diMAVGytY8TImwS9+XMuPM2ItYcrUci8w5n8mr6XZYwOmSyQMr+a5uNKHZLkFPtO1",
	"0dEbtETqIGKK/ZANbKQLidEUr8Wuf1XZchVnRHj+Yoz1jBHRahlfREu5DV/8MlJ/Gan/akbqgmzKkncK",
	"eFKnWBAxsxf+FoRL1sxmTUqqzNqyOJZEO1WH7S9l/dkcsnZ7/NaNIcYvNvvnsJne6P9+TDZ7LAl6HohD",
	"6aLdNGOz9R5tSHTQA7HisFeN2eztmMEUqKMzm1E39x8h0/yHTv3aP/gMX7qU6gNI/vaLi39x8TZcjBZ3",
	"kOTcOMhn+Ql5bZr84L6fj79amKhBRckCaZVLENFrlv+GesnK6XyLczqypNileQRHpT+pl5vi4rrpEDAY",
	"4KIq6+XioU6mgQEu6SLeyvOAWCF6gas0riptZS4wTUAHE2fVAFxAB/3gMIqIJHqkJx5mHZwv3/5/AAAA",
	"//9Cpq87zb8AAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
