/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;

public class DSAParameters
extends AlgorithmParametersSpi {
    protected BigInteger p;
    protected BigInteger q;
    protected BigInteger g;

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.p = ((DSAParameterSpec)paramSpec).getP();
        this.q = ((DSAParameterSpec)paramSpec).getQ();
        this.g = ((DSAParameterSpec)paramSpec).getG();
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        DerValue encodedParams = new DerValue(params);
        if (encodedParams.tag != 48) {
            throw new IOException("DSA params parsing error");
        }
        encodedParams.data.reset();
        this.p = encodedParams.data.getInteger().toBigInteger();
        this.q = encodedParams.data.getInteger().toBigInteger();
        this.g = encodedParams.data.getInteger().toBigInteger();
        if (encodedParams.data.available() != 0) {
            throw new IOException("encoded params have " + encodedParams.data.available() + " extra bytes");
        }
    }

    @Override
    protected void engineInit(byte[] params, String decodingMethod) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        try {
            Class<T> dsaParamSpec = Class.forName("java.security.spec.DSAParameterSpec");
            if (dsaParamSpec.isAssignableFrom(paramSpec)) {
                return (T)new DSAParameterSpec(this.p, this.q, this.g);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        try (DerOutputStream out = new DerOutputStream();){
            DerOutputStream bytes = new DerOutputStream();
            bytes.putInteger(new BigInt(this.p.toByteArray()));
            bytes.putInteger(new BigInt(this.q.toByteArray()));
            bytes.putInteger(new BigInt(this.g.toByteArray()));
            out.write((byte)48, bytes);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return "\n\tp: " + new BigInt(this.p).toString() + "\n\tq: " + new BigInt(this.q).toString() + "\n\tg: " + new BigInt(this.g).toString() + "\n";
    }
}

