/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class GetCert
implements ASN1Value {
    private ANY issuerName;
    private INTEGER serialNumber;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public ANY getIssuer() {
        return this.issuerName;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public GetCert(ANY issuerName, INTEGER serialNumber) {
        if (issuerName == null || serialNumber == null) {
            throw new IllegalArgumentException("parameter to GetCert constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.issuerName = issuerName;
        this.sequence.addElement(issuerName);
        this.serialNumber = serialNumber;
        this.sequence.addElement(serialNumber);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(ANY.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new GetCert((ANY)seq.elementAt(0), (INTEGER)seq.elementAt(1));
        }
    }
}

