﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/ResultSet.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Athena
{
namespace Model
{
  class GetQueryResultsResult
  {
  public:
    AWS_ATHENA_API GetQueryResultsResult();
    AWS_ATHENA_API GetQueryResultsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ATHENA_API GetQueryResultsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The number of rows inserted with a <code>CREATE TABLE AS SELECT</code>
     * statement. </p>
     */
    inline long long GetUpdateCount() const{ return m_updateCount; }

    /**
     * <p>The number of rows inserted with a <code>CREATE TABLE AS SELECT</code>
     * statement. </p>
     */
    inline void SetUpdateCount(long long value) { m_updateCount = value; }

    /**
     * <p>The number of rows inserted with a <code>CREATE TABLE AS SELECT</code>
     * statement. </p>
     */
    inline GetQueryResultsResult& WithUpdateCount(long long value) { SetUpdateCount(value); return *this;}


    /**
     * <p>The results of the query execution.</p>
     */
    inline const ResultSet& GetResultSet() const{ return m_resultSet; }

    /**
     * <p>The results of the query execution.</p>
     */
    inline void SetResultSet(const ResultSet& value) { m_resultSet = value; }

    /**
     * <p>The results of the query execution.</p>
     */
    inline void SetResultSet(ResultSet&& value) { m_resultSet = std::move(value); }

    /**
     * <p>The results of the query execution.</p>
     */
    inline GetQueryResultsResult& WithResultSet(const ResultSet& value) { SetResultSet(value); return *this;}

    /**
     * <p>The results of the query execution.</p>
     */
    inline GetQueryResultsResult& WithResultSet(ResultSet&& value) { SetResultSet(std::move(value)); return *this;}


    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline GetQueryResultsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline GetQueryResultsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline GetQueryResultsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline GetQueryResultsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline GetQueryResultsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline GetQueryResultsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    long long m_updateCount;

    ResultSet m_resultSet;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Athena
} // namespace Aws
