// Copyright 2020 The TensorFlow Runtime Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code is auto-generated by tf_runtime/utils/resnet/resnet50_graph_inference_main.py.
// RUN: bef_executor --work_queue_type=mstd %s.bef | FileCheck %s
// RUN: bef_executor --work_queue_type=s %s.bef | FileCheck %s

// Model: "resnet50"
// __________________________________________________________________________________________________
// Layer (type)                    Output Shape         Param #     Connected to
// ==================================================================================================
// input_1 (InputLayer)            [(1, 224, 224, 3)]   0
// __________________________________________________________________________________________________
// conv1_pad (ZeroPadding2D)       (1, 230, 230, 3)     0           input_1[0][0]
// __________________________________________________________________________________________________
// conv1 (Conv2D)                  (1, 112, 112, 64)    9408        conv1_pad[0][0]
// __________________________________________________________________________________________________
// bn_conv1 (BatchNormalization)   (1, 112, 112, 64)    256         conv1[0][0]
// __________________________________________________________________________________________________
// activation (Activation)         (1, 112, 112, 64)    0           bn_conv1[0][0]
// __________________________________________________________________________________________________
// max_pooling2d (MaxPooling2D)    (1, 56, 56, 64)      0           activation[0][0]
// __________________________________________________________________________________________________
// res2a_branch2a (Conv2D)         (1, 56, 56, 64)      4096        max_pooling2d[0][0]
// __________________________________________________________________________________________________
// bn2a_branch2a (BatchNormalizati (1, 56, 56, 64)      256         res2a_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_1 (Activation)       (1, 56, 56, 64)      0           bn2a_branch2a[0][0]
// __________________________________________________________________________________________________
// res2a_branch2b (Conv2D)         (1, 56, 56, 64)      36864       activation_1[0][0]
// __________________________________________________________________________________________________
// bn2a_branch2b (BatchNormalizati (1, 56, 56, 64)      256         res2a_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_2 (Activation)       (1, 56, 56, 64)      0           bn2a_branch2b[0][0]
// __________________________________________________________________________________________________
// res2a_branch2c (Conv2D)         (1, 56, 56, 256)     16384       activation_2[0][0]
// __________________________________________________________________________________________________
// res2a_branch1 (Conv2D)          (1, 56, 56, 256)     16384       max_pooling2d[0][0]
// __________________________________________________________________________________________________
// bn2a_branch2c (BatchNormalizati (1, 56, 56, 256)     1024        res2a_branch2c[0][0]
// __________________________________________________________________________________________________
// bn2a_branch1 (BatchNormalizatio (1, 56, 56, 256)     1024        res2a_branch1[0][0]
// __________________________________________________________________________________________________
// add (Add)                       (1, 56, 56, 256)     0           bn2a_branch2c[0][0]
// bn2a_branch1[0][0]
// __________________________________________________________________________________________________
// activation_3 (Activation)       (1, 56, 56, 256)     0           add[0][0]
// __________________________________________________________________________________________________
// res2b_branch2a (Conv2D)         (1, 56, 56, 64)      16384       activation_3[0][0]
// __________________________________________________________________________________________________
// bn2b_branch2a (BatchNormalizati (1, 56, 56, 64)      256         res2b_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_4 (Activation)       (1, 56, 56, 64)      0           bn2b_branch2a[0][0]
// __________________________________________________________________________________________________
// res2b_branch2b (Conv2D)         (1, 56, 56, 64)      36864       activation_4[0][0]
// __________________________________________________________________________________________________
// bn2b_branch2b (BatchNormalizati (1, 56, 56, 64)      256         res2b_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_5 (Activation)       (1, 56, 56, 64)      0           bn2b_branch2b[0][0]
// __________________________________________________________________________________________________
// res2b_branch2c (Conv2D)         (1, 56, 56, 256)     16384       activation_5[0][0]
// __________________________________________________________________________________________________
// bn2b_branch2c (BatchNormalizati (1, 56, 56, 256)     1024        res2b_branch2c[0][0]
// __________________________________________________________________________________________________
// add_1 (Add)                     (1, 56, 56, 256)     0           bn2b_branch2c[0][0]
// activation_3[0][0]
// __________________________________________________________________________________________________
// activation_6 (Activation)       (1, 56, 56, 256)     0           add_1[0][0]
// __________________________________________________________________________________________________
// res2c_branch2a (Conv2D)         (1, 56, 56, 64)      16384       activation_6[0][0]
// __________________________________________________________________________________________________
// bn2c_branch2a (BatchNormalizati (1, 56, 56, 64)      256         res2c_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_7 (Activation)       (1, 56, 56, 64)      0           bn2c_branch2a[0][0]
// __________________________________________________________________________________________________
// res2c_branch2b (Conv2D)         (1, 56, 56, 64)      36864       activation_7[0][0]
// __________________________________________________________________________________________________
// bn2c_branch2b (BatchNormalizati (1, 56, 56, 64)      256         res2c_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_8 (Activation)       (1, 56, 56, 64)      0           bn2c_branch2b[0][0]
// __________________________________________________________________________________________________
// res2c_branch2c (Conv2D)         (1, 56, 56, 256)     16384       activation_8[0][0]
// __________________________________________________________________________________________________
// bn2c_branch2c (BatchNormalizati (1, 56, 56, 256)     1024        res2c_branch2c[0][0]
// __________________________________________________________________________________________________
// add_2 (Add)                     (1, 56, 56, 256)     0           bn2c_branch2c[0][0]
// activation_6[0][0]
// __________________________________________________________________________________________________
// activation_9 (Activation)       (1, 56, 56, 256)     0           add_2[0][0]
// __________________________________________________________________________________________________
// res3a_branch2a (Conv2D)         (1, 56, 56, 128)     32768       activation_9[0][0]
// __________________________________________________________________________________________________
// bn3a_branch2a (BatchNormalizati (1, 56, 56, 128)     512         res3a_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_10 (Activation)      (1, 56, 56, 128)     0           bn3a_branch2a[0][0]
// __________________________________________________________________________________________________
// res3a_branch2b (Conv2D)         (1, 28, 28, 128)     147456      activation_10[0][0]
// __________________________________________________________________________________________________
// bn3a_branch2b (BatchNormalizati (1, 28, 28, 128)     512         res3a_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_11 (Activation)      (1, 28, 28, 128)     0           bn3a_branch2b[0][0]
// __________________________________________________________________________________________________
// res3a_branch2c (Conv2D)         (1, 28, 28, 512)     65536       activation_11[0][0]
// __________________________________________________________________________________________________
// res3a_branch1 (Conv2D)          (1, 28, 28, 512)     131072      activation_9[0][0]
// __________________________________________________________________________________________________
// bn3a_branch2c (BatchNormalizati (1, 28, 28, 512)     2048        res3a_branch2c[0][0]
// __________________________________________________________________________________________________
// bn3a_branch1 (BatchNormalizatio (1, 28, 28, 512)     2048        res3a_branch1[0][0]
// __________________________________________________________________________________________________
// add_3 (Add)                     (1, 28, 28, 512)     0           bn3a_branch2c[0][0]
// bn3a_branch1[0][0]
// __________________________________________________________________________________________________
// activation_12 (Activation)      (1, 28, 28, 512)     0           add_3[0][0]
// __________________________________________________________________________________________________
// res3b_branch2a (Conv2D)         (1, 28, 28, 128)     65536       activation_12[0][0]
// __________________________________________________________________________________________________
// bn3b_branch2a (BatchNormalizati (1, 28, 28, 128)     512         res3b_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_13 (Activation)      (1, 28, 28, 128)     0           bn3b_branch2a[0][0]
// __________________________________________________________________________________________________
// res3b_branch2b (Conv2D)         (1, 28, 28, 128)     147456      activation_13[0][0]
// __________________________________________________________________________________________________
// bn3b_branch2b (BatchNormalizati (1, 28, 28, 128)     512         res3b_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_14 (Activation)      (1, 28, 28, 128)     0           bn3b_branch2b[0][0]
// __________________________________________________________________________________________________
// res3b_branch2c (Conv2D)         (1, 28, 28, 512)     65536       activation_14[0][0]
// __________________________________________________________________________________________________
// bn3b_branch2c (BatchNormalizati (1, 28, 28, 512)     2048        res3b_branch2c[0][0]
// __________________________________________________________________________________________________
// add_4 (Add)                     (1, 28, 28, 512)     0           bn3b_branch2c[0][0]
// activation_12[0][0]
// __________________________________________________________________________________________________
// activation_15 (Activation)      (1, 28, 28, 512)     0           add_4[0][0]
// __________________________________________________________________________________________________
// res3c_branch2a (Conv2D)         (1, 28, 28, 128)     65536       activation_15[0][0]
// __________________________________________________________________________________________________
// bn3c_branch2a (BatchNormalizati (1, 28, 28, 128)     512         res3c_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_16 (Activation)      (1, 28, 28, 128)     0           bn3c_branch2a[0][0]
// __________________________________________________________________________________________________
// res3c_branch2b (Conv2D)         (1, 28, 28, 128)     147456      activation_16[0][0]
// __________________________________________________________________________________________________
// bn3c_branch2b (BatchNormalizati (1, 28, 28, 128)     512         res3c_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_17 (Activation)      (1, 28, 28, 128)     0           bn3c_branch2b[0][0]
// __________________________________________________________________________________________________
// res3c_branch2c (Conv2D)         (1, 28, 28, 512)     65536       activation_17[0][0]
// __________________________________________________________________________________________________
// bn3c_branch2c (BatchNormalizati (1, 28, 28, 512)     2048        res3c_branch2c[0][0]
// __________________________________________________________________________________________________
// add_5 (Add)                     (1, 28, 28, 512)     0           bn3c_branch2c[0][0]
// activation_15[0][0]
// __________________________________________________________________________________________________
// activation_18 (Activation)      (1, 28, 28, 512)     0           add_5[0][0]
// __________________________________________________________________________________________________
// res3d_branch2a (Conv2D)         (1, 28, 28, 128)     65536       activation_18[0][0]
// __________________________________________________________________________________________________
// bn3d_branch2a (BatchNormalizati (1, 28, 28, 128)     512         res3d_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_19 (Activation)      (1, 28, 28, 128)     0           bn3d_branch2a[0][0]
// __________________________________________________________________________________________________
// res3d_branch2b (Conv2D)         (1, 28, 28, 128)     147456      activation_19[0][0]
// __________________________________________________________________________________________________
// bn3d_branch2b (BatchNormalizati (1, 28, 28, 128)     512         res3d_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_20 (Activation)      (1, 28, 28, 128)     0           bn3d_branch2b[0][0]
// __________________________________________________________________________________________________
// res3d_branch2c (Conv2D)         (1, 28, 28, 512)     65536       activation_20[0][0]
// __________________________________________________________________________________________________
// bn3d_branch2c (BatchNormalizati (1, 28, 28, 512)     2048        res3d_branch2c[0][0]
// __________________________________________________________________________________________________
// add_6 (Add)                     (1, 28, 28, 512)     0           bn3d_branch2c[0][0]
// activation_18[0][0]
// __________________________________________________________________________________________________
// activation_21 (Activation)      (1, 28, 28, 512)     0           add_6[0][0]
// __________________________________________________________________________________________________
// res4a_branch2a (Conv2D)         (1, 28, 28, 256)     131072      activation_21[0][0]
// __________________________________________________________________________________________________
// bn4a_branch2a (BatchNormalizati (1, 28, 28, 256)     1024        res4a_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_22 (Activation)      (1, 28, 28, 256)     0           bn4a_branch2a[0][0]
// __________________________________________________________________________________________________
// res4a_branch2b (Conv2D)         (1, 14, 14, 256)     589824      activation_22[0][0]
// __________________________________________________________________________________________________
// bn4a_branch2b (BatchNormalizati (1, 14, 14, 256)     1024        res4a_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_23 (Activation)      (1, 14, 14, 256)     0           bn4a_branch2b[0][0]
// __________________________________________________________________________________________________
// res4a_branch2c (Conv2D)         (1, 14, 14, 1024)    262144      activation_23[0][0]
// __________________________________________________________________________________________________
// res4a_branch1 (Conv2D)          (1, 14, 14, 1024)    524288      activation_21[0][0]
// __________________________________________________________________________________________________
// bn4a_branch2c (BatchNormalizati (1, 14, 14, 1024)    4096        res4a_branch2c[0][0]
// __________________________________________________________________________________________________
// bn4a_branch1 (BatchNormalizatio (1, 14, 14, 1024)    4096        res4a_branch1[0][0]
// __________________________________________________________________________________________________
// add_7 (Add)                     (1, 14, 14, 1024)    0           bn4a_branch2c[0][0]
// bn4a_branch1[0][0]
// __________________________________________________________________________________________________
// activation_24 (Activation)      (1, 14, 14, 1024)    0           add_7[0][0]
// __________________________________________________________________________________________________
// res4b_branch2a (Conv2D)         (1, 14, 14, 256)     262144      activation_24[0][0]
// __________________________________________________________________________________________________
// bn4b_branch2a (BatchNormalizati (1, 14, 14, 256)     1024        res4b_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_25 (Activation)      (1, 14, 14, 256)     0           bn4b_branch2a[0][0]
// __________________________________________________________________________________________________
// res4b_branch2b (Conv2D)         (1, 14, 14, 256)     589824      activation_25[0][0]
// __________________________________________________________________________________________________
// bn4b_branch2b (BatchNormalizati (1, 14, 14, 256)     1024        res4b_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_26 (Activation)      (1, 14, 14, 256)     0           bn4b_branch2b[0][0]
// __________________________________________________________________________________________________
// res4b_branch2c (Conv2D)         (1, 14, 14, 1024)    262144      activation_26[0][0]
// __________________________________________________________________________________________________
// bn4b_branch2c (BatchNormalizati (1, 14, 14, 1024)    4096        res4b_branch2c[0][0]
// __________________________________________________________________________________________________
// add_8 (Add)                     (1, 14, 14, 1024)    0           bn4b_branch2c[0][0]
// activation_24[0][0]
// __________________________________________________________________________________________________
// activation_27 (Activation)      (1, 14, 14, 1024)    0           add_8[0][0]
// __________________________________________________________________________________________________
// res4c_branch2a (Conv2D)         (1, 14, 14, 256)     262144      activation_27[0][0]
// __________________________________________________________________________________________________
// bn4c_branch2a (BatchNormalizati (1, 14, 14, 256)     1024        res4c_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_28 (Activation)      (1, 14, 14, 256)     0           bn4c_branch2a[0][0]
// __________________________________________________________________________________________________
// res4c_branch2b (Conv2D)         (1, 14, 14, 256)     589824      activation_28[0][0]
// __________________________________________________________________________________________________
// bn4c_branch2b (BatchNormalizati (1, 14, 14, 256)     1024        res4c_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_29 (Activation)      (1, 14, 14, 256)     0           bn4c_branch2b[0][0]
// __________________________________________________________________________________________________
// res4c_branch2c (Conv2D)         (1, 14, 14, 1024)    262144      activation_29[0][0]
// __________________________________________________________________________________________________
// bn4c_branch2c (BatchNormalizati (1, 14, 14, 1024)    4096        res4c_branch2c[0][0]
// __________________________________________________________________________________________________
// add_9 (Add)                     (1, 14, 14, 1024)    0           bn4c_branch2c[0][0]
// activation_27[0][0]
// __________________________________________________________________________________________________
// activation_30 (Activation)      (1, 14, 14, 1024)    0           add_9[0][0]
// __________________________________________________________________________________________________
// res4d_branch2a (Conv2D)         (1, 14, 14, 256)     262144      activation_30[0][0]
// __________________________________________________________________________________________________
// bn4d_branch2a (BatchNormalizati (1, 14, 14, 256)     1024        res4d_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_31 (Activation)      (1, 14, 14, 256)     0           bn4d_branch2a[0][0]
// __________________________________________________________________________________________________
// res4d_branch2b (Conv2D)         (1, 14, 14, 256)     589824      activation_31[0][0]
// __________________________________________________________________________________________________
// bn4d_branch2b (BatchNormalizati (1, 14, 14, 256)     1024        res4d_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_32 (Activation)      (1, 14, 14, 256)     0           bn4d_branch2b[0][0]
// __________________________________________________________________________________________________
// res4d_branch2c (Conv2D)         (1, 14, 14, 1024)    262144      activation_32[0][0]
// __________________________________________________________________________________________________
// bn4d_branch2c (BatchNormalizati (1, 14, 14, 1024)    4096        res4d_branch2c[0][0]
// __________________________________________________________________________________________________
// add_10 (Add)                    (1, 14, 14, 1024)    0           bn4d_branch2c[0][0]
// activation_30[0][0]
// __________________________________________________________________________________________________
// activation_33 (Activation)      (1, 14, 14, 1024)    0           add_10[0][0]
// __________________________________________________________________________________________________
// res4e_branch2a (Conv2D)         (1, 14, 14, 256)     262144      activation_33[0][0]
// __________________________________________________________________________________________________
// bn4e_branch2a (BatchNormalizati (1, 14, 14, 256)     1024        res4e_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_34 (Activation)      (1, 14, 14, 256)     0           bn4e_branch2a[0][0]
// __________________________________________________________________________________________________
// res4e_branch2b (Conv2D)         (1, 14, 14, 256)     589824      activation_34[0][0]
// __________________________________________________________________________________________________
// bn4e_branch2b (BatchNormalizati (1, 14, 14, 256)     1024        res4e_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_35 (Activation)      (1, 14, 14, 256)     0           bn4e_branch2b[0][0]
// __________________________________________________________________________________________________
// res4e_branch2c (Conv2D)         (1, 14, 14, 1024)    262144      activation_35[0][0]
// __________________________________________________________________________________________________
// bn4e_branch2c (BatchNormalizati (1, 14, 14, 1024)    4096        res4e_branch2c[0][0]
// __________________________________________________________________________________________________
// add_11 (Add)                    (1, 14, 14, 1024)    0           bn4e_branch2c[0][0]
// activation_33[0][0]
// __________________________________________________________________________________________________
// activation_36 (Activation)      (1, 14, 14, 1024)    0           add_11[0][0]
// __________________________________________________________________________________________________
// res4f_branch2a (Conv2D)         (1, 14, 14, 256)     262144      activation_36[0][0]
// __________________________________________________________________________________________________
// bn4f_branch2a (BatchNormalizati (1, 14, 14, 256)     1024        res4f_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_37 (Activation)      (1, 14, 14, 256)     0           bn4f_branch2a[0][0]
// __________________________________________________________________________________________________
// res4f_branch2b (Conv2D)         (1, 14, 14, 256)     589824      activation_37[0][0]
// __________________________________________________________________________________________________
// bn4f_branch2b (BatchNormalizati (1, 14, 14, 256)     1024        res4f_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_38 (Activation)      (1, 14, 14, 256)     0           bn4f_branch2b[0][0]
// __________________________________________________________________________________________________
// res4f_branch2c (Conv2D)         (1, 14, 14, 1024)    262144      activation_38[0][0]
// __________________________________________________________________________________________________
// bn4f_branch2c (BatchNormalizati (1, 14, 14, 1024)    4096        res4f_branch2c[0][0]
// __________________________________________________________________________________________________
// add_12 (Add)                    (1, 14, 14, 1024)    0           bn4f_branch2c[0][0]
// activation_36[0][0]
// __________________________________________________________________________________________________
// activation_39 (Activation)      (1, 14, 14, 1024)    0           add_12[0][0]
// __________________________________________________________________________________________________
// res5a_branch2a (Conv2D)         (1, 14, 14, 512)     524288      activation_39[0][0]
// __________________________________________________________________________________________________
// bn5a_branch2a (BatchNormalizati (1, 14, 14, 512)     2048        res5a_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_40 (Activation)      (1, 14, 14, 512)     0           bn5a_branch2a[0][0]
// __________________________________________________________________________________________________
// res5a_branch2b (Conv2D)         (1, 7, 7, 512)       2359296     activation_40[0][0]
// __________________________________________________________________________________________________
// bn5a_branch2b (BatchNormalizati (1, 7, 7, 512)       2048        res5a_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_41 (Activation)      (1, 7, 7, 512)       0           bn5a_branch2b[0][0]
// __________________________________________________________________________________________________
// res5a_branch2c (Conv2D)         (1, 7, 7, 2048)      1048576     activation_41[0][0]
// __________________________________________________________________________________________________
// res5a_branch1 (Conv2D)          (1, 7, 7, 2048)      2097152     activation_39[0][0]
// __________________________________________________________________________________________________
// bn5a_branch2c (BatchNormalizati (1, 7, 7, 2048)      8192        res5a_branch2c[0][0]
// __________________________________________________________________________________________________
// bn5a_branch1 (BatchNormalizatio (1, 7, 7, 2048)      8192        res5a_branch1[0][0]
// __________________________________________________________________________________________________
// add_13 (Add)                    (1, 7, 7, 2048)      0           bn5a_branch2c[0][0]
// bn5a_branch1[0][0]
// __________________________________________________________________________________________________
// activation_42 (Activation)      (1, 7, 7, 2048)      0           add_13[0][0]
// __________________________________________________________________________________________________
// res5b_branch2a (Conv2D)         (1, 7, 7, 512)       1048576     activation_42[0][0]
// __________________________________________________________________________________________________
// bn5b_branch2a (BatchNormalizati (1, 7, 7, 512)       2048        res5b_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_43 (Activation)      (1, 7, 7, 512)       0           bn5b_branch2a[0][0]
// __________________________________________________________________________________________________
// res5b_branch2b (Conv2D)         (1, 7, 7, 512)       2359296     activation_43[0][0]
// __________________________________________________________________________________________________
// bn5b_branch2b (BatchNormalizati (1, 7, 7, 512)       2048        res5b_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_44 (Activation)      (1, 7, 7, 512)       0           bn5b_branch2b[0][0]
// __________________________________________________________________________________________________
// res5b_branch2c (Conv2D)         (1, 7, 7, 2048)      1048576     activation_44[0][0]
// __________________________________________________________________________________________________
// bn5b_branch2c (BatchNormalizati (1, 7, 7, 2048)      8192        res5b_branch2c[0][0]
// __________________________________________________________________________________________________
// add_14 (Add)                    (1, 7, 7, 2048)      0           bn5b_branch2c[0][0]
// activation_42[0][0]
// __________________________________________________________________________________________________
// activation_45 (Activation)      (1, 7, 7, 2048)      0           add_14[0][0]
// __________________________________________________________________________________________________
// res5c_branch2a (Conv2D)         (1, 7, 7, 512)       1048576     activation_45[0][0]
// __________________________________________________________________________________________________
// bn5c_branch2a (BatchNormalizati (1, 7, 7, 512)       2048        res5c_branch2a[0][0]
// __________________________________________________________________________________________________
// activation_46 (Activation)      (1, 7, 7, 512)       0           bn5c_branch2a[0][0]
// __________________________________________________________________________________________________
// res5c_branch2b (Conv2D)         (1, 7, 7, 512)       2359296     activation_46[0][0]
// __________________________________________________________________________________________________
// bn5c_branch2b (BatchNormalizati (1, 7, 7, 512)       2048        res5c_branch2b[0][0]
// __________________________________________________________________________________________________
// activation_47 (Activation)      (1, 7, 7, 512)       0           bn5c_branch2b[0][0]
// __________________________________________________________________________________________________
// res5c_branch2c (Conv2D)         (1, 7, 7, 2048)      1048576     activation_47[0][0]
// __________________________________________________________________________________________________
// bn5c_branch2c (BatchNormalizati (1, 7, 7, 2048)      8192        res5c_branch2c[0][0]
// __________________________________________________________________________________________________
// add_15 (Add)                    (1, 7, 7, 2048)      0           bn5c_branch2c[0][0]
// activation_45[0][0]
// __________________________________________________________________________________________________
// activation_48 (Activation)      (1, 7, 7, 2048)      0           add_15[0][0]
// __________________________________________________________________________________________________
// reduce_mean (Lambda)            (1, 2048)            0           activation_48[0][0]
// __________________________________________________________________________________________________
// fc1000 (Dense)                  (1, 1001)            2051049     reduce_mean[0][0]
// ==================================================================================================
// Total params: 25,612,201
// Trainable params: 25,559,081
// Non-trainable params: 53,120
// __________________________________________________________________________________________________

func.func @resnet50() {
    %path = "tfrt_test.get_string"() { value = "integrationtest/resnet/test_data/resnet50_graph_inference_tensors.btf" } : () -> !tfrt.string
    %c0 = tfrt.new.chain
    %constant_0 = tfrt.constant.i32 0
    // Read image tensor to use as the input to the inference pipeline
    %tensor_0_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_0) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_1_0 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 230 : i64, 230 : i64, 3 : i64] } : () -> !t.tensor
    %constant_1 = tfrt.constant.i32 1
    %tensor_2_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_1) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_2_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 112 : i64, 112 : i64, 64 : i64] } : () -> !t.tensor
    %constant_2 = tfrt.constant.i32 2
    %tensor_3_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_2) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_3 = tfrt.constant.i32 3
    %tensor_3_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_3) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_4 = tfrt.constant.i32 4
    %tensor_3_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_4) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_5 = tfrt.constant.i32 5
    %tensor_3_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_5) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_5_0 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 64 : i64] } : () -> !t.tensor
    %constant_6 = tfrt.constant.i32 6
    %tensor_6_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_6) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_6_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 64 : i64] } : () -> !t.tensor
    %constant_7 = tfrt.constant.i32 7
    %tensor_7_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_7) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_8 = tfrt.constant.i32 8
    %tensor_7_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_8) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_9 = tfrt.constant.i32 9
    %tensor_7_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_9) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_10 = tfrt.constant.i32 10
    %tensor_7_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_10) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_11 = tfrt.constant.i32 11
    %tensor_9_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_11) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_9_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 64 : i64] } : () -> !t.tensor
    %constant_12 = tfrt.constant.i32 12
    %tensor_10_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_12) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_13 = tfrt.constant.i32 13
    %tensor_10_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_13) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_14 = tfrt.constant.i32 14
    %tensor_10_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_14) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_15 = tfrt.constant.i32 15
    %tensor_10_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_15) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_16 = tfrt.constant.i32 16
    %tensor_12_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_16) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_12_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 256 : i64] } : () -> !t.tensor
    %constant_17 = tfrt.constant.i32 17
    %tensor_13_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_17) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_13_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 256 : i64] } : () -> !t.tensor
    %constant_18 = tfrt.constant.i32 18
    %tensor_14_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_18) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_19 = tfrt.constant.i32 19
    %tensor_14_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_19) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_20 = tfrt.constant.i32 20
    %tensor_14_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_20) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_21 = tfrt.constant.i32 21
    %tensor_14_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_21) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_22 = tfrt.constant.i32 22
    %tensor_15_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_22) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_23 = tfrt.constant.i32 23
    %tensor_15_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_23) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_24 = tfrt.constant.i32 24
    %tensor_15_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_24) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_25 = tfrt.constant.i32 25
    %tensor_15_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_25) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_26 = tfrt.constant.i32 26
    %tensor_18_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_26) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_18_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 64 : i64] } : () -> !t.tensor
    %constant_27 = tfrt.constant.i32 27
    %tensor_19_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_27) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_28 = tfrt.constant.i32 28
    %tensor_19_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_28) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_29 = tfrt.constant.i32 29
    %tensor_19_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_29) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_30 = tfrt.constant.i32 30
    %tensor_19_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_30) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_31 = tfrt.constant.i32 31
    %tensor_21_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_31) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_21_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 64 : i64] } : () -> !t.tensor
    %constant_32 = tfrt.constant.i32 32
    %tensor_22_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_32) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_33 = tfrt.constant.i32 33
    %tensor_22_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_33) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_34 = tfrt.constant.i32 34
    %tensor_22_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_34) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_35 = tfrt.constant.i32 35
    %tensor_22_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_35) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_36 = tfrt.constant.i32 36
    %tensor_24_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_36) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_24_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 256 : i64] } : () -> !t.tensor
    %constant_37 = tfrt.constant.i32 37
    %tensor_25_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_37) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_38 = tfrt.constant.i32 38
    %tensor_25_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_38) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_39 = tfrt.constant.i32 39
    %tensor_25_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_39) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_40 = tfrt.constant.i32 40
    %tensor_25_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_40) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_41 = tfrt.constant.i32 41
    %tensor_28_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_41) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_28_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 64 : i64] } : () -> !t.tensor
    %constant_42 = tfrt.constant.i32 42
    %tensor_29_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_42) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_43 = tfrt.constant.i32 43
    %tensor_29_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_43) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_44 = tfrt.constant.i32 44
    %tensor_29_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_44) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_45 = tfrt.constant.i32 45
    %tensor_29_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_45) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_46 = tfrt.constant.i32 46
    %tensor_31_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_46) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_31_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 64 : i64] } : () -> !t.tensor
    %constant_47 = tfrt.constant.i32 47
    %tensor_32_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_47) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_48 = tfrt.constant.i32 48
    %tensor_32_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_48) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_49 = tfrt.constant.i32 49
    %tensor_32_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_49) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_50 = tfrt.constant.i32 50
    %tensor_32_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_50) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_51 = tfrt.constant.i32 51
    %tensor_34_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_51) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_34_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 256 : i64] } : () -> !t.tensor
    %constant_52 = tfrt.constant.i32 52
    %tensor_35_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_52) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_53 = tfrt.constant.i32 53
    %tensor_35_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_53) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_54 = tfrt.constant.i32 54
    %tensor_35_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_54) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_55 = tfrt.constant.i32 55
    %tensor_35_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_55) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_56 = tfrt.constant.i32 56
    %tensor_38_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_56) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_38_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 56 : i64, 56 : i64, 128 : i64] } : () -> !t.tensor
    %constant_57 = tfrt.constant.i32 57
    %tensor_39_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_57) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_58 = tfrt.constant.i32 58
    %tensor_39_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_58) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_59 = tfrt.constant.i32 59
    %tensor_39_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_59) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_60 = tfrt.constant.i32 60
    %tensor_39_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_60) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_61 = tfrt.constant.i32 61
    %tensor_41_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_61) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_41_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 128 : i64] } : () -> !t.tensor
    %constant_62 = tfrt.constant.i32 62
    %tensor_42_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_62) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_63 = tfrt.constant.i32 63
    %tensor_42_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_63) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_64 = tfrt.constant.i32 64
    %tensor_42_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_64) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_65 = tfrt.constant.i32 65
    %tensor_42_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_65) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_66 = tfrt.constant.i32 66
    %tensor_44_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_66) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_44_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 512 : i64] } : () -> !t.tensor
    %constant_67 = tfrt.constant.i32 67
    %tensor_45_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_67) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_45_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 512 : i64] } : () -> !t.tensor
    %constant_68 = tfrt.constant.i32 68
    %tensor_46_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_68) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_69 = tfrt.constant.i32 69
    %tensor_46_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_69) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_70 = tfrt.constant.i32 70
    %tensor_46_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_70) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_71 = tfrt.constant.i32 71
    %tensor_46_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_71) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_72 = tfrt.constant.i32 72
    %tensor_47_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_72) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_73 = tfrt.constant.i32 73
    %tensor_47_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_73) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_74 = tfrt.constant.i32 74
    %tensor_47_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_74) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_75 = tfrt.constant.i32 75
    %tensor_47_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_75) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_76 = tfrt.constant.i32 76
    %tensor_50_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_76) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_50_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 128 : i64] } : () -> !t.tensor
    %constant_77 = tfrt.constant.i32 77
    %tensor_51_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_77) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_78 = tfrt.constant.i32 78
    %tensor_51_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_78) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_79 = tfrt.constant.i32 79
    %tensor_51_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_79) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_80 = tfrt.constant.i32 80
    %tensor_51_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_80) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_81 = tfrt.constant.i32 81
    %tensor_53_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_81) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_53_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 128 : i64] } : () -> !t.tensor
    %constant_82 = tfrt.constant.i32 82
    %tensor_54_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_82) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_83 = tfrt.constant.i32 83
    %tensor_54_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_83) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_84 = tfrt.constant.i32 84
    %tensor_54_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_84) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_85 = tfrt.constant.i32 85
    %tensor_54_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_85) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_86 = tfrt.constant.i32 86
    %tensor_56_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_86) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_56_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 512 : i64] } : () -> !t.tensor
    %constant_87 = tfrt.constant.i32 87
    %tensor_57_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_87) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_88 = tfrt.constant.i32 88
    %tensor_57_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_88) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_89 = tfrt.constant.i32 89
    %tensor_57_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_89) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_90 = tfrt.constant.i32 90
    %tensor_57_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_90) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_91 = tfrt.constant.i32 91
    %tensor_60_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_91) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_60_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 128 : i64] } : () -> !t.tensor
    %constant_92 = tfrt.constant.i32 92
    %tensor_61_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_92) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_93 = tfrt.constant.i32 93
    %tensor_61_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_93) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_94 = tfrt.constant.i32 94
    %tensor_61_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_94) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_95 = tfrt.constant.i32 95
    %tensor_61_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_95) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_96 = tfrt.constant.i32 96
    %tensor_63_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_96) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_63_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 128 : i64] } : () -> !t.tensor
    %constant_97 = tfrt.constant.i32 97
    %tensor_64_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_97) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_98 = tfrt.constant.i32 98
    %tensor_64_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_98) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_99 = tfrt.constant.i32 99
    %tensor_64_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_99) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_100 = tfrt.constant.i32 100
    %tensor_64_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_100) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_101 = tfrt.constant.i32 101
    %tensor_66_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_101) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_66_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 512 : i64] } : () -> !t.tensor
    %constant_102 = tfrt.constant.i32 102
    %tensor_67_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_102) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_103 = tfrt.constant.i32 103
    %tensor_67_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_103) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_104 = tfrt.constant.i32 104
    %tensor_67_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_104) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_105 = tfrt.constant.i32 105
    %tensor_67_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_105) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_106 = tfrt.constant.i32 106
    %tensor_70_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_106) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_70_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 128 : i64] } : () -> !t.tensor
    %constant_107 = tfrt.constant.i32 107
    %tensor_71_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_107) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_108 = tfrt.constant.i32 108
    %tensor_71_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_108) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_109 = tfrt.constant.i32 109
    %tensor_71_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_109) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_110 = tfrt.constant.i32 110
    %tensor_71_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_110) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_111 = tfrt.constant.i32 111
    %tensor_73_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_111) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_73_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 128 : i64] } : () -> !t.tensor
    %constant_112 = tfrt.constant.i32 112
    %tensor_74_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_112) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_113 = tfrt.constant.i32 113
    %tensor_74_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_113) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_114 = tfrt.constant.i32 114
    %tensor_74_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_114) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_115 = tfrt.constant.i32 115
    %tensor_74_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_115) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_116 = tfrt.constant.i32 116
    %tensor_76_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_116) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_76_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 512 : i64] } : () -> !t.tensor
    %constant_117 = tfrt.constant.i32 117
    %tensor_77_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_117) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_118 = tfrt.constant.i32 118
    %tensor_77_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_118) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_119 = tfrt.constant.i32 119
    %tensor_77_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_119) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_120 = tfrt.constant.i32 120
    %tensor_77_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_120) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_121 = tfrt.constant.i32 121
    %tensor_80_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_121) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_80_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 28 : i64, 28 : i64, 256 : i64] } : () -> !t.tensor
    %constant_122 = tfrt.constant.i32 122
    %tensor_81_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_122) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_123 = tfrt.constant.i32 123
    %tensor_81_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_123) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_124 = tfrt.constant.i32 124
    %tensor_81_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_124) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_125 = tfrt.constant.i32 125
    %tensor_81_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_125) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_126 = tfrt.constant.i32 126
    %tensor_83_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_126) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_83_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_127 = tfrt.constant.i32 127
    %tensor_84_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_127) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_128 = tfrt.constant.i32 128
    %tensor_84_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_128) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_129 = tfrt.constant.i32 129
    %tensor_84_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_129) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_130 = tfrt.constant.i32 130
    %tensor_84_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_130) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_131 = tfrt.constant.i32 131
    %tensor_86_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_131) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_86_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 1024 : i64] } : () -> !t.tensor
    %constant_132 = tfrt.constant.i32 132
    %tensor_87_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_132) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_87_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 1024 : i64] } : () -> !t.tensor
    %constant_133 = tfrt.constant.i32 133
    %tensor_88_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_133) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_134 = tfrt.constant.i32 134
    %tensor_88_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_134) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_135 = tfrt.constant.i32 135
    %tensor_88_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_135) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_136 = tfrt.constant.i32 136
    %tensor_88_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_136) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_137 = tfrt.constant.i32 137
    %tensor_89_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_137) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_138 = tfrt.constant.i32 138
    %tensor_89_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_138) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_139 = tfrt.constant.i32 139
    %tensor_89_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_139) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_140 = tfrt.constant.i32 140
    %tensor_89_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_140) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_141 = tfrt.constant.i32 141
    %tensor_92_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_141) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_92_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_142 = tfrt.constant.i32 142
    %tensor_93_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_142) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_143 = tfrt.constant.i32 143
    %tensor_93_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_143) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_144 = tfrt.constant.i32 144
    %tensor_93_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_144) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_145 = tfrt.constant.i32 145
    %tensor_93_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_145) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_146 = tfrt.constant.i32 146
    %tensor_95_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_146) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_95_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_147 = tfrt.constant.i32 147
    %tensor_96_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_147) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_148 = tfrt.constant.i32 148
    %tensor_96_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_148) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_149 = tfrt.constant.i32 149
    %tensor_96_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_149) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_150 = tfrt.constant.i32 150
    %tensor_96_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_150) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_151 = tfrt.constant.i32 151
    %tensor_98_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_151) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_98_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 1024 : i64] } : () -> !t.tensor
    %constant_152 = tfrt.constant.i32 152
    %tensor_99_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_152) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_153 = tfrt.constant.i32 153
    %tensor_99_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_153) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_154 = tfrt.constant.i32 154
    %tensor_99_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_154) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_155 = tfrt.constant.i32 155
    %tensor_99_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_155) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_156 = tfrt.constant.i32 156
    %tensor_102_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_156) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_102_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_157 = tfrt.constant.i32 157
    %tensor_103_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_157) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_158 = tfrt.constant.i32 158
    %tensor_103_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_158) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_159 = tfrt.constant.i32 159
    %tensor_103_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_159) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_160 = tfrt.constant.i32 160
    %tensor_103_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_160) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_161 = tfrt.constant.i32 161
    %tensor_105_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_161) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_105_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_162 = tfrt.constant.i32 162
    %tensor_106_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_162) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_163 = tfrt.constant.i32 163
    %tensor_106_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_163) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_164 = tfrt.constant.i32 164
    %tensor_106_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_164) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_165 = tfrt.constant.i32 165
    %tensor_106_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_165) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_166 = tfrt.constant.i32 166
    %tensor_108_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_166) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_108_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 1024 : i64] } : () -> !t.tensor
    %constant_167 = tfrt.constant.i32 167
    %tensor_109_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_167) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_168 = tfrt.constant.i32 168
    %tensor_109_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_168) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_169 = tfrt.constant.i32 169
    %tensor_109_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_169) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_170 = tfrt.constant.i32 170
    %tensor_109_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_170) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_171 = tfrt.constant.i32 171
    %tensor_112_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_171) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_112_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_172 = tfrt.constant.i32 172
    %tensor_113_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_172) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_173 = tfrt.constant.i32 173
    %tensor_113_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_173) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_174 = tfrt.constant.i32 174
    %tensor_113_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_174) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_175 = tfrt.constant.i32 175
    %tensor_113_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_175) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_176 = tfrt.constant.i32 176
    %tensor_115_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_176) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_115_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_177 = tfrt.constant.i32 177
    %tensor_116_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_177) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_178 = tfrt.constant.i32 178
    %tensor_116_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_178) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_179 = tfrt.constant.i32 179
    %tensor_116_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_179) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_180 = tfrt.constant.i32 180
    %tensor_116_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_180) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_181 = tfrt.constant.i32 181
    %tensor_118_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_181) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_118_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 1024 : i64] } : () -> !t.tensor
    %constant_182 = tfrt.constant.i32 182
    %tensor_119_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_182) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_183 = tfrt.constant.i32 183
    %tensor_119_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_183) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_184 = tfrt.constant.i32 184
    %tensor_119_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_184) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_185 = tfrt.constant.i32 185
    %tensor_119_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_185) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_186 = tfrt.constant.i32 186
    %tensor_122_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_186) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_122_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_187 = tfrt.constant.i32 187
    %tensor_123_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_187) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_188 = tfrt.constant.i32 188
    %tensor_123_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_188) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_189 = tfrt.constant.i32 189
    %tensor_123_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_189) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_190 = tfrt.constant.i32 190
    %tensor_123_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_190) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_191 = tfrt.constant.i32 191
    %tensor_125_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_191) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_125_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_192 = tfrt.constant.i32 192
    %tensor_126_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_192) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_193 = tfrt.constant.i32 193
    %tensor_126_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_193) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_194 = tfrt.constant.i32 194
    %tensor_126_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_194) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_195 = tfrt.constant.i32 195
    %tensor_126_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_195) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_196 = tfrt.constant.i32 196
    %tensor_128_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_196) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_128_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 1024 : i64] } : () -> !t.tensor
    %constant_197 = tfrt.constant.i32 197
    %tensor_129_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_197) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_198 = tfrt.constant.i32 198
    %tensor_129_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_198) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_199 = tfrt.constant.i32 199
    %tensor_129_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_199) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_200 = tfrt.constant.i32 200
    %tensor_129_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_200) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_201 = tfrt.constant.i32 201
    %tensor_132_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_201) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_132_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_202 = tfrt.constant.i32 202
    %tensor_133_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_202) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_203 = tfrt.constant.i32 203
    %tensor_133_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_203) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_204 = tfrt.constant.i32 204
    %tensor_133_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_204) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_205 = tfrt.constant.i32 205
    %tensor_133_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_205) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_206 = tfrt.constant.i32 206
    %tensor_135_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_206) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_135_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 256 : i64] } : () -> !t.tensor
    %constant_207 = tfrt.constant.i32 207
    %tensor_136_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_207) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_208 = tfrt.constant.i32 208
    %tensor_136_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_208) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_209 = tfrt.constant.i32 209
    %tensor_136_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_209) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_210 = tfrt.constant.i32 210
    %tensor_136_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_210) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_211 = tfrt.constant.i32 211
    %tensor_138_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_211) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_138_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 1024 : i64] } : () -> !t.tensor
    %constant_212 = tfrt.constant.i32 212
    %tensor_139_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_212) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_213 = tfrt.constant.i32 213
    %tensor_139_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_213) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_214 = tfrt.constant.i32 214
    %tensor_139_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_214) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_215 = tfrt.constant.i32 215
    %tensor_139_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_215) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_216 = tfrt.constant.i32 216
    %tensor_142_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_216) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_142_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 14 : i64, 14 : i64, 512 : i64] } : () -> !t.tensor
    %constant_217 = tfrt.constant.i32 217
    %tensor_143_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_217) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_218 = tfrt.constant.i32 218
    %tensor_143_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_218) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_219 = tfrt.constant.i32 219
    %tensor_143_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_219) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_220 = tfrt.constant.i32 220
    %tensor_143_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_220) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_221 = tfrt.constant.i32 221
    %tensor_145_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_221) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_145_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 7 : i64, 7 : i64, 512 : i64] } : () -> !t.tensor
    %constant_222 = tfrt.constant.i32 222
    %tensor_146_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_222) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_223 = tfrt.constant.i32 223
    %tensor_146_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_223) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_224 = tfrt.constant.i32 224
    %tensor_146_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_224) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_225 = tfrt.constant.i32 225
    %tensor_146_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_225) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_226 = tfrt.constant.i32 226
    %tensor_148_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_226) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_148_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 7 : i64, 7 : i64, 2048 : i64] } : () -> !t.tensor
    %constant_227 = tfrt.constant.i32 227
    %tensor_149_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_227) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_149_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 7 : i64, 7 : i64, 2048 : i64] } : () -> !t.tensor
    %constant_228 = tfrt.constant.i32 228
    %tensor_150_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_228) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_229 = tfrt.constant.i32 229
    %tensor_150_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_229) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_230 = tfrt.constant.i32 230
    %tensor_150_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_230) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_231 = tfrt.constant.i32 231
    %tensor_150_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_231) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_232 = tfrt.constant.i32 232
    %tensor_151_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_232) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_233 = tfrt.constant.i32 233
    %tensor_151_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_233) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_234 = tfrt.constant.i32 234
    %tensor_151_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_234) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_235 = tfrt.constant.i32 235
    %tensor_151_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_235) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_236 = tfrt.constant.i32 236
    %tensor_154_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_236) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_154_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 7 : i64, 7 : i64, 512 : i64] } : () -> !t.tensor
    %constant_237 = tfrt.constant.i32 237
    %tensor_155_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_237) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_238 = tfrt.constant.i32 238
    %tensor_155_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_238) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_239 = tfrt.constant.i32 239
    %tensor_155_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_239) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_240 = tfrt.constant.i32 240
    %tensor_155_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_240) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_241 = tfrt.constant.i32 241
    %tensor_157_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_241) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_157_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 7 : i64, 7 : i64, 512 : i64] } : () -> !t.tensor
    %constant_242 = tfrt.constant.i32 242
    %tensor_158_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_242) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_243 = tfrt.constant.i32 243
    %tensor_158_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_243) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_244 = tfrt.constant.i32 244
    %tensor_158_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_244) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_245 = tfrt.constant.i32 245
    %tensor_158_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_245) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_246 = tfrt.constant.i32 246
    %tensor_160_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_246) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_160_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 7 : i64, 7 : i64, 2048 : i64] } : () -> !t.tensor
    %constant_247 = tfrt.constant.i32 247
    %tensor_161_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_247) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_248 = tfrt.constant.i32 248
    %tensor_161_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_248) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_249 = tfrt.constant.i32 249
    %tensor_161_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_249) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_250 = tfrt.constant.i32 250
    %tensor_161_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_250) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_251 = tfrt.constant.i32 251
    %tensor_164_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_251) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_164_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 7 : i64, 7 : i64, 512 : i64] } : () -> !t.tensor
    %constant_252 = tfrt.constant.i32 252
    %tensor_165_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_252) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_253 = tfrt.constant.i32 253
    %tensor_165_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_253) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_254 = tfrt.constant.i32 254
    %tensor_165_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_254) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_255 = tfrt.constant.i32 255
    %tensor_165_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_255) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_256 = tfrt.constant.i32 256
    %tensor_167_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_256) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_167_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 7 : i64, 7 : i64, 512 : i64] } : () -> !t.tensor
    %constant_257 = tfrt.constant.i32 257
    %tensor_168_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_257) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_258 = tfrt.constant.i32 258
    %tensor_168_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_258) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_259 = tfrt.constant.i32 259
    %tensor_168_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_259) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_260 = tfrt.constant.i32 260
    %tensor_168_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_260) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_261 = tfrt.constant.i32 261
    %tensor_170_0 = "btf.read_dense_tensor.f32.4"(%path, %constant_261) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_170_1 = "tfrt_dht.create_uninitialized_tensor.f32.4"() { shape = [1 : i64, 7 : i64, 7 : i64, 2048 : i64] } : () -> !t.tensor
    %constant_262 = tfrt.constant.i32 262
    %tensor_171_0 = "btf.read_dense_tensor.f32.1"(%path, %constant_262) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_263 = tfrt.constant.i32 263
    %tensor_171_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_263) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_264 = tfrt.constant.i32 264
    %tensor_171_2 = "btf.read_dense_tensor.f32.1"(%path, %constant_264) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_265 = tfrt.constant.i32 265
    %tensor_171_3 = "btf.read_dense_tensor.f32.1"(%path, %constant_265) : (!tfrt.string, i32) -> (!t.tensor)
    %tensor_174_0 = "tfrt_dht.create_uninitialized_tensor.f32.2"() { shape = [1 : i64, 2048 : i64] } : () -> !t.tensor
    %constant_266 = tfrt.constant.i32 266
    %tensor_175_0 = "btf.read_dense_tensor.f32.2"(%path, %constant_266) : (!tfrt.string, i32) -> (!t.tensor)
    %constant_267 = tfrt.constant.i32 267
    %tensor_175_1 = "btf.read_dense_tensor.f32.1"(%path, %constant_267) : (!tfrt.string, i32) -> (!t.tensor)
    %one = tfrt.constant.f32 1.0
    %constant_268 = tfrt.constant.i32 268
    // Read the expected inference output
    %expected_prob = "btf.read_dense_tensor.f32.2"(%path, %constant_268) : (!tfrt.string, i32) -> (!t.tensor)
  tfrt_test.benchmark "resnet50_benchmark"(
    %c0 : !tfrt.chain,
    %path : !tfrt.string,
    %tensor_0_0 : !t.tensor,
    %tensor_1_0 : !t.tensor,
    %tensor_2_0 : !t.tensor,
    %tensor_2_1 : !t.tensor,
    %tensor_3_0 : !t.tensor,
    %tensor_3_1 : !t.tensor,
    %tensor_3_2 : !t.tensor,
    %tensor_3_3 : !t.tensor,
    %tensor_5_0 : !t.tensor,
    %tensor_6_0 : !t.tensor,
    %tensor_6_1 : !t.tensor,
    %tensor_7_0 : !t.tensor,
    %tensor_7_1 : !t.tensor,
    %tensor_7_2 : !t.tensor,
    %tensor_7_3 : !t.tensor,
    %tensor_9_0 : !t.tensor,
    %tensor_9_1 : !t.tensor,
    %tensor_10_0 : !t.tensor,
    %tensor_10_1 : !t.tensor,
    %tensor_10_2 : !t.tensor,
    %tensor_10_3 : !t.tensor,
    %tensor_12_0 : !t.tensor,
    %tensor_12_1 : !t.tensor,
    %tensor_13_0 : !t.tensor,
    %tensor_13_1 : !t.tensor,
    %tensor_14_0 : !t.tensor,
    %tensor_14_1 : !t.tensor,
    %tensor_14_2 : !t.tensor,
    %tensor_14_3 : !t.tensor,
    %tensor_15_0 : !t.tensor,
    %tensor_15_1 : !t.tensor,
    %tensor_15_2 : !t.tensor,
    %tensor_15_3 : !t.tensor,
    %tensor_18_0 : !t.tensor,
    %tensor_18_1 : !t.tensor,
    %tensor_19_0 : !t.tensor,
    %tensor_19_1 : !t.tensor,
    %tensor_19_2 : !t.tensor,
    %tensor_19_3 : !t.tensor,
    %tensor_21_0 : !t.tensor,
    %tensor_21_1 : !t.tensor,
    %tensor_22_0 : !t.tensor,
    %tensor_22_1 : !t.tensor,
    %tensor_22_2 : !t.tensor,
    %tensor_22_3 : !t.tensor,
    %tensor_24_0 : !t.tensor,
    %tensor_24_1 : !t.tensor,
    %tensor_25_0 : !t.tensor,
    %tensor_25_1 : !t.tensor,
    %tensor_25_2 : !t.tensor,
    %tensor_25_3 : !t.tensor,
    %tensor_28_0 : !t.tensor,
    %tensor_28_1 : !t.tensor,
    %tensor_29_0 : !t.tensor,
    %tensor_29_1 : !t.tensor,
    %tensor_29_2 : !t.tensor,
    %tensor_29_3 : !t.tensor,
    %tensor_31_0 : !t.tensor,
    %tensor_31_1 : !t.tensor,
    %tensor_32_0 : !t.tensor,
    %tensor_32_1 : !t.tensor,
    %tensor_32_2 : !t.tensor,
    %tensor_32_3 : !t.tensor,
    %tensor_34_0 : !t.tensor,
    %tensor_34_1 : !t.tensor,
    %tensor_35_0 : !t.tensor,
    %tensor_35_1 : !t.tensor,
    %tensor_35_2 : !t.tensor,
    %tensor_35_3 : !t.tensor,
    %tensor_38_0 : !t.tensor,
    %tensor_38_1 : !t.tensor,
    %tensor_39_0 : !t.tensor,
    %tensor_39_1 : !t.tensor,
    %tensor_39_2 : !t.tensor,
    %tensor_39_3 : !t.tensor,
    %tensor_41_0 : !t.tensor,
    %tensor_41_1 : !t.tensor,
    %tensor_42_0 : !t.tensor,
    %tensor_42_1 : !t.tensor,
    %tensor_42_2 : !t.tensor,
    %tensor_42_3 : !t.tensor,
    %tensor_44_0 : !t.tensor,
    %tensor_44_1 : !t.tensor,
    %tensor_45_0 : !t.tensor,
    %tensor_45_1 : !t.tensor,
    %tensor_46_0 : !t.tensor,
    %tensor_46_1 : !t.tensor,
    %tensor_46_2 : !t.tensor,
    %tensor_46_3 : !t.tensor,
    %tensor_47_0 : !t.tensor,
    %tensor_47_1 : !t.tensor,
    %tensor_47_2 : !t.tensor,
    %tensor_47_3 : !t.tensor,
    %tensor_50_0 : !t.tensor,
    %tensor_50_1 : !t.tensor,
    %tensor_51_0 : !t.tensor,
    %tensor_51_1 : !t.tensor,
    %tensor_51_2 : !t.tensor,
    %tensor_51_3 : !t.tensor,
    %tensor_53_0 : !t.tensor,
    %tensor_53_1 : !t.tensor,
    %tensor_54_0 : !t.tensor,
    %tensor_54_1 : !t.tensor,
    %tensor_54_2 : !t.tensor,
    %tensor_54_3 : !t.tensor,
    %tensor_56_0 : !t.tensor,
    %tensor_56_1 : !t.tensor,
    %tensor_57_0 : !t.tensor,
    %tensor_57_1 : !t.tensor,
    %tensor_57_2 : !t.tensor,
    %tensor_57_3 : !t.tensor,
    %tensor_60_0 : !t.tensor,
    %tensor_60_1 : !t.tensor,
    %tensor_61_0 : !t.tensor,
    %tensor_61_1 : !t.tensor,
    %tensor_61_2 : !t.tensor,
    %tensor_61_3 : !t.tensor,
    %tensor_63_0 : !t.tensor,
    %tensor_63_1 : !t.tensor,
    %tensor_64_0 : !t.tensor,
    %tensor_64_1 : !t.tensor,
    %tensor_64_2 : !t.tensor,
    %tensor_64_3 : !t.tensor,
    %tensor_66_0 : !t.tensor,
    %tensor_66_1 : !t.tensor,
    %tensor_67_0 : !t.tensor,
    %tensor_67_1 : !t.tensor,
    %tensor_67_2 : !t.tensor,
    %tensor_67_3 : !t.tensor,
    %tensor_70_0 : !t.tensor,
    %tensor_70_1 : !t.tensor,
    %tensor_71_0 : !t.tensor,
    %tensor_71_1 : !t.tensor,
    %tensor_71_2 : !t.tensor,
    %tensor_71_3 : !t.tensor,
    %tensor_73_0 : !t.tensor,
    %tensor_73_1 : !t.tensor,
    %tensor_74_0 : !t.tensor,
    %tensor_74_1 : !t.tensor,
    %tensor_74_2 : !t.tensor,
    %tensor_74_3 : !t.tensor,
    %tensor_76_0 : !t.tensor,
    %tensor_76_1 : !t.tensor,
    %tensor_77_0 : !t.tensor,
    %tensor_77_1 : !t.tensor,
    %tensor_77_2 : !t.tensor,
    %tensor_77_3 : !t.tensor,
    %tensor_80_0 : !t.tensor,
    %tensor_80_1 : !t.tensor,
    %tensor_81_0 : !t.tensor,
    %tensor_81_1 : !t.tensor,
    %tensor_81_2 : !t.tensor,
    %tensor_81_3 : !t.tensor,
    %tensor_83_0 : !t.tensor,
    %tensor_83_1 : !t.tensor,
    %tensor_84_0 : !t.tensor,
    %tensor_84_1 : !t.tensor,
    %tensor_84_2 : !t.tensor,
    %tensor_84_3 : !t.tensor,
    %tensor_86_0 : !t.tensor,
    %tensor_86_1 : !t.tensor,
    %tensor_87_0 : !t.tensor,
    %tensor_87_1 : !t.tensor,
    %tensor_88_0 : !t.tensor,
    %tensor_88_1 : !t.tensor,
    %tensor_88_2 : !t.tensor,
    %tensor_88_3 : !t.tensor,
    %tensor_89_0 : !t.tensor,
    %tensor_89_1 : !t.tensor,
    %tensor_89_2 : !t.tensor,
    %tensor_89_3 : !t.tensor,
    %tensor_92_0 : !t.tensor,
    %tensor_92_1 : !t.tensor,
    %tensor_93_0 : !t.tensor,
    %tensor_93_1 : !t.tensor,
    %tensor_93_2 : !t.tensor,
    %tensor_93_3 : !t.tensor,
    %tensor_95_0 : !t.tensor,
    %tensor_95_1 : !t.tensor,
    %tensor_96_0 : !t.tensor,
    %tensor_96_1 : !t.tensor,
    %tensor_96_2 : !t.tensor,
    %tensor_96_3 : !t.tensor,
    %tensor_98_0 : !t.tensor,
    %tensor_98_1 : !t.tensor,
    %tensor_99_0 : !t.tensor,
    %tensor_99_1 : !t.tensor,
    %tensor_99_2 : !t.tensor,
    %tensor_99_3 : !t.tensor,
    %tensor_102_0 : !t.tensor,
    %tensor_102_1 : !t.tensor,
    %tensor_103_0 : !t.tensor,
    %tensor_103_1 : !t.tensor,
    %tensor_103_2 : !t.tensor,
    %tensor_103_3 : !t.tensor,
    %tensor_105_0 : !t.tensor,
    %tensor_105_1 : !t.tensor,
    %tensor_106_0 : !t.tensor,
    %tensor_106_1 : !t.tensor,
    %tensor_106_2 : !t.tensor,
    %tensor_106_3 : !t.tensor,
    %tensor_108_0 : !t.tensor,
    %tensor_108_1 : !t.tensor,
    %tensor_109_0 : !t.tensor,
    %tensor_109_1 : !t.tensor,
    %tensor_109_2 : !t.tensor,
    %tensor_109_3 : !t.tensor,
    %tensor_112_0 : !t.tensor,
    %tensor_112_1 : !t.tensor,
    %tensor_113_0 : !t.tensor,
    %tensor_113_1 : !t.tensor,
    %tensor_113_2 : !t.tensor,
    %tensor_113_3 : !t.tensor,
    %tensor_115_0 : !t.tensor,
    %tensor_115_1 : !t.tensor,
    %tensor_116_0 : !t.tensor,
    %tensor_116_1 : !t.tensor,
    %tensor_116_2 : !t.tensor,
    %tensor_116_3 : !t.tensor,
    %tensor_118_0 : !t.tensor,
    %tensor_118_1 : !t.tensor,
    %tensor_119_0 : !t.tensor,
    %tensor_119_1 : !t.tensor,
    %tensor_119_2 : !t.tensor,
    %tensor_119_3 : !t.tensor,
    %tensor_122_0 : !t.tensor,
    %tensor_122_1 : !t.tensor,
    %tensor_123_0 : !t.tensor,
    %tensor_123_1 : !t.tensor,
    %tensor_123_2 : !t.tensor,
    %tensor_123_3 : !t.tensor,
    %tensor_125_0 : !t.tensor,
    %tensor_125_1 : !t.tensor,
    %tensor_126_0 : !t.tensor,
    %tensor_126_1 : !t.tensor,
    %tensor_126_2 : !t.tensor,
    %tensor_126_3 : !t.tensor,
    %tensor_128_0 : !t.tensor,
    %tensor_128_1 : !t.tensor,
    %tensor_129_0 : !t.tensor,
    %tensor_129_1 : !t.tensor,
    %tensor_129_2 : !t.tensor,
    %tensor_129_3 : !t.tensor,
    %tensor_132_0 : !t.tensor,
    %tensor_132_1 : !t.tensor,
    %tensor_133_0 : !t.tensor,
    %tensor_133_1 : !t.tensor,
    %tensor_133_2 : !t.tensor,
    %tensor_133_3 : !t.tensor,
    %tensor_135_0 : !t.tensor,
    %tensor_135_1 : !t.tensor,
    %tensor_136_0 : !t.tensor,
    %tensor_136_1 : !t.tensor,
    %tensor_136_2 : !t.tensor,
    %tensor_136_3 : !t.tensor,
    %tensor_138_0 : !t.tensor,
    %tensor_138_1 : !t.tensor,
    %tensor_139_0 : !t.tensor,
    %tensor_139_1 : !t.tensor,
    %tensor_139_2 : !t.tensor,
    %tensor_139_3 : !t.tensor,
    %tensor_142_0 : !t.tensor,
    %tensor_142_1 : !t.tensor,
    %tensor_143_0 : !t.tensor,
    %tensor_143_1 : !t.tensor,
    %tensor_143_2 : !t.tensor,
    %tensor_143_3 : !t.tensor,
    %tensor_145_0 : !t.tensor,
    %tensor_145_1 : !t.tensor,
    %tensor_146_0 : !t.tensor,
    %tensor_146_1 : !t.tensor,
    %tensor_146_2 : !t.tensor,
    %tensor_146_3 : !t.tensor,
    %tensor_148_0 : !t.tensor,
    %tensor_148_1 : !t.tensor,
    %tensor_149_0 : !t.tensor,
    %tensor_149_1 : !t.tensor,
    %tensor_150_0 : !t.tensor,
    %tensor_150_1 : !t.tensor,
    %tensor_150_2 : !t.tensor,
    %tensor_150_3 : !t.tensor,
    %tensor_151_0 : !t.tensor,
    %tensor_151_1 : !t.tensor,
    %tensor_151_2 : !t.tensor,
    %tensor_151_3 : !t.tensor,
    %tensor_154_0 : !t.tensor,
    %tensor_154_1 : !t.tensor,
    %tensor_155_0 : !t.tensor,
    %tensor_155_1 : !t.tensor,
    %tensor_155_2 : !t.tensor,
    %tensor_155_3 : !t.tensor,
    %tensor_157_0 : !t.tensor,
    %tensor_157_1 : !t.tensor,
    %tensor_158_0 : !t.tensor,
    %tensor_158_1 : !t.tensor,
    %tensor_158_2 : !t.tensor,
    %tensor_158_3 : !t.tensor,
    %tensor_160_0 : !t.tensor,
    %tensor_160_1 : !t.tensor,
    %tensor_161_0 : !t.tensor,
    %tensor_161_1 : !t.tensor,
    %tensor_161_2 : !t.tensor,
    %tensor_161_3 : !t.tensor,
    %tensor_164_0 : !t.tensor,
    %tensor_164_1 : !t.tensor,
    %tensor_165_0 : !t.tensor,
    %tensor_165_1 : !t.tensor,
    %tensor_165_2 : !t.tensor,
    %tensor_165_3 : !t.tensor,
    %tensor_167_0 : !t.tensor,
    %tensor_167_1 : !t.tensor,
    %tensor_168_0 : !t.tensor,
    %tensor_168_1 : !t.tensor,
    %tensor_168_2 : !t.tensor,
    %tensor_168_3 : !t.tensor,
    %tensor_170_0 : !t.tensor,
    %tensor_170_1 : !t.tensor,
    %tensor_171_0 : !t.tensor,
    %tensor_171_1 : !t.tensor,
    %tensor_171_2 : !t.tensor,
    %tensor_171_3 : !t.tensor,
    %tensor_174_0 : !t.tensor,
    %tensor_175_0 : !t.tensor,
    %tensor_175_1 : !t.tensor,
    %one : f32,
    %expected_prob : !t.tensor
  )
  duration_secs = 600, max_count = 1, num_warmup_runs = 0
  {


    %c1 = "eigen.zero_padding.f32"(%tensor_0_0, %tensor_1_0, %c0) { padding = [3 : i64, 3 : i64] } : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c2 = "eigen.conv2d.f32"(%tensor_1_0, %tensor_2_0, %tensor_2_1, %c1) { padding = "valid", strides = [2 : i64, 2 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c3 = "eigen.batch_norm.f32"(%tensor_2_1, %tensor_3_0, %tensor_3_1, %tensor_3_2, %tensor_3_3, %c2) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c4 = "tfrt_test.relu_inplace.f32"(%tensor_2_1, %c3) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c5 = "eigen.max_pooling_2d.f32"(%tensor_2_1, %tensor_5_0, %c4) { padding = "same", pool_size = [3 : i64, 3 : i64], strides = [2 : i64, 2 : i64] } :  (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c6 = "eigen.conv2d.f32"(%tensor_5_0, %tensor_6_0, %tensor_6_1, %c5) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c7 = "eigen.batch_norm.f32"(%tensor_6_1, %tensor_7_0, %tensor_7_1, %tensor_7_2, %tensor_7_3, %c6) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c8 = "tfrt_test.relu_inplace.f32"(%tensor_6_1, %c7) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c9 = "eigen.conv2d.f32"(%tensor_6_1, %tensor_9_0, %tensor_9_1, %c8) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c10 = "eigen.batch_norm.f32"(%tensor_9_1, %tensor_10_0, %tensor_10_1, %tensor_10_2, %tensor_10_3, %c9) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c11 = "tfrt_test.relu_inplace.f32"(%tensor_9_1, %c10) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c12 = "eigen.conv2d.f32"(%tensor_9_1, %tensor_12_0, %tensor_12_1, %c11) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c13 = "eigen.conv2d.f32"(%tensor_5_0, %tensor_13_0, %tensor_13_1, %c5) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c14 = "eigen.batch_norm.f32"(%tensor_12_1, %tensor_14_0, %tensor_14_1, %tensor_14_2, %tensor_14_3, %c12) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c15 = "eigen.batch_norm.f32"(%tensor_13_1, %tensor_15_0, %tensor_15_1, %tensor_15_2, %tensor_15_3, %c13) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c16 = tfrt.merge.chains %c14, %c15 : !tfrt.chain, !tfrt.chain
    %c17 = "tfrt_test.add_inplace.f32"(%tensor_13_1, %tensor_12_1, %c16) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c18 = "tfrt_test.relu_inplace.f32"(%tensor_12_1, %c17) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c19 = "eigen.conv2d.f32"(%tensor_12_1, %tensor_18_0, %tensor_18_1, %c18) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c20 = "eigen.batch_norm.f32"(%tensor_18_1, %tensor_19_0, %tensor_19_1, %tensor_19_2, %tensor_19_3, %c19) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c21 = "tfrt_test.relu_inplace.f32"(%tensor_18_1, %c20) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c22 = "eigen.conv2d.f32"(%tensor_18_1, %tensor_21_0, %tensor_21_1, %c21) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c23 = "eigen.batch_norm.f32"(%tensor_21_1, %tensor_22_0, %tensor_22_1, %tensor_22_2, %tensor_22_3, %c22) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c24 = "tfrt_test.relu_inplace.f32"(%tensor_21_1, %c23) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c25 = "eigen.conv2d.f32"(%tensor_21_1, %tensor_24_0, %tensor_24_1, %c24) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c26 = "eigen.batch_norm.f32"(%tensor_24_1, %tensor_25_0, %tensor_25_1, %tensor_25_2, %tensor_25_3, %c25) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c27 = tfrt.merge.chains %c18, %c26 : !tfrt.chain, !tfrt.chain
    %c28 = "tfrt_test.add_inplace.f32"(%tensor_12_1, %tensor_24_1, %c27) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c29 = "tfrt_test.relu_inplace.f32"(%tensor_24_1, %c28) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c30 = "eigen.conv2d.f32"(%tensor_24_1, %tensor_28_0, %tensor_28_1, %c29) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c31 = "eigen.batch_norm.f32"(%tensor_28_1, %tensor_29_0, %tensor_29_1, %tensor_29_2, %tensor_29_3, %c30) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c32 = "tfrt_test.relu_inplace.f32"(%tensor_28_1, %c31) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c33 = "eigen.conv2d.f32"(%tensor_28_1, %tensor_31_0, %tensor_31_1, %c32) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c34 = "eigen.batch_norm.f32"(%tensor_31_1, %tensor_32_0, %tensor_32_1, %tensor_32_2, %tensor_32_3, %c33) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c35 = "tfrt_test.relu_inplace.f32"(%tensor_31_1, %c34) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c36 = "eigen.conv2d.f32"(%tensor_31_1, %tensor_34_0, %tensor_34_1, %c35) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c37 = "eigen.batch_norm.f32"(%tensor_34_1, %tensor_35_0, %tensor_35_1, %tensor_35_2, %tensor_35_3, %c36) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c38 = tfrt.merge.chains %c29, %c37 : !tfrt.chain, !tfrt.chain
    %c39 = "tfrt_test.add_inplace.f32"(%tensor_24_1, %tensor_34_1, %c38) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c40 = "tfrt_test.relu_inplace.f32"(%tensor_34_1, %c39) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c41 = "eigen.conv2d.f32"(%tensor_34_1, %tensor_38_0, %tensor_38_1, %c40) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c42 = "eigen.batch_norm.f32"(%tensor_38_1, %tensor_39_0, %tensor_39_1, %tensor_39_2, %tensor_39_3, %c41) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c43 = "tfrt_test.relu_inplace.f32"(%tensor_38_1, %c42) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c44 = "eigen.conv2d.f32"(%tensor_38_1, %tensor_41_0, %tensor_41_1, %c43) { padding = "same", strides = [2 : i64, 2 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c45 = "eigen.batch_norm.f32"(%tensor_41_1, %tensor_42_0, %tensor_42_1, %tensor_42_2, %tensor_42_3, %c44) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c46 = "tfrt_test.relu_inplace.f32"(%tensor_41_1, %c45) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c47 = "eigen.conv2d.f32"(%tensor_41_1, %tensor_44_0, %tensor_44_1, %c46) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c48 = "eigen.conv2d.f32"(%tensor_34_1, %tensor_45_0, %tensor_45_1, %c40) { padding = "valid", strides = [2 : i64, 2 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c49 = "eigen.batch_norm.f32"(%tensor_44_1, %tensor_46_0, %tensor_46_1, %tensor_46_2, %tensor_46_3, %c47) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c50 = "eigen.batch_norm.f32"(%tensor_45_1, %tensor_47_0, %tensor_47_1, %tensor_47_2, %tensor_47_3, %c48) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c51 = tfrt.merge.chains %c49, %c50 : !tfrt.chain, !tfrt.chain
    %c52 = "tfrt_test.add_inplace.f32"(%tensor_45_1, %tensor_44_1, %c51) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c53 = "tfrt_test.relu_inplace.f32"(%tensor_44_1, %c52) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c54 = "eigen.conv2d.f32"(%tensor_44_1, %tensor_50_0, %tensor_50_1, %c53) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c55 = "eigen.batch_norm.f32"(%tensor_50_1, %tensor_51_0, %tensor_51_1, %tensor_51_2, %tensor_51_3, %c54) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c56 = "tfrt_test.relu_inplace.f32"(%tensor_50_1, %c55) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c57 = "eigen.conv2d.f32"(%tensor_50_1, %tensor_53_0, %tensor_53_1, %c56) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c58 = "eigen.batch_norm.f32"(%tensor_53_1, %tensor_54_0, %tensor_54_1, %tensor_54_2, %tensor_54_3, %c57) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c59 = "tfrt_test.relu_inplace.f32"(%tensor_53_1, %c58) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c60 = "eigen.conv2d.f32"(%tensor_53_1, %tensor_56_0, %tensor_56_1, %c59) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c61 = "eigen.batch_norm.f32"(%tensor_56_1, %tensor_57_0, %tensor_57_1, %tensor_57_2, %tensor_57_3, %c60) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c62 = tfrt.merge.chains %c53, %c61 : !tfrt.chain, !tfrt.chain
    %c63 = "tfrt_test.add_inplace.f32"(%tensor_44_1, %tensor_56_1, %c62) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c64 = "tfrt_test.relu_inplace.f32"(%tensor_56_1, %c63) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c65 = "eigen.conv2d.f32"(%tensor_56_1, %tensor_60_0, %tensor_60_1, %c64) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c66 = "eigen.batch_norm.f32"(%tensor_60_1, %tensor_61_0, %tensor_61_1, %tensor_61_2, %tensor_61_3, %c65) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c67 = "tfrt_test.relu_inplace.f32"(%tensor_60_1, %c66) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c68 = "eigen.conv2d.f32"(%tensor_60_1, %tensor_63_0, %tensor_63_1, %c67) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c69 = "eigen.batch_norm.f32"(%tensor_63_1, %tensor_64_0, %tensor_64_1, %tensor_64_2, %tensor_64_3, %c68) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c70 = "tfrt_test.relu_inplace.f32"(%tensor_63_1, %c69) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c71 = "eigen.conv2d.f32"(%tensor_63_1, %tensor_66_0, %tensor_66_1, %c70) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c72 = "eigen.batch_norm.f32"(%tensor_66_1, %tensor_67_0, %tensor_67_1, %tensor_67_2, %tensor_67_3, %c71) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c73 = tfrt.merge.chains %c64, %c72 : !tfrt.chain, !tfrt.chain
    %c74 = "tfrt_test.add_inplace.f32"(%tensor_56_1, %tensor_66_1, %c73) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c75 = "tfrt_test.relu_inplace.f32"(%tensor_66_1, %c74) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c76 = "eigen.conv2d.f32"(%tensor_66_1, %tensor_70_0, %tensor_70_1, %c75) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c77 = "eigen.batch_norm.f32"(%tensor_70_1, %tensor_71_0, %tensor_71_1, %tensor_71_2, %tensor_71_3, %c76) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c78 = "tfrt_test.relu_inplace.f32"(%tensor_70_1, %c77) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c79 = "eigen.conv2d.f32"(%tensor_70_1, %tensor_73_0, %tensor_73_1, %c78) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c80 = "eigen.batch_norm.f32"(%tensor_73_1, %tensor_74_0, %tensor_74_1, %tensor_74_2, %tensor_74_3, %c79) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c81 = "tfrt_test.relu_inplace.f32"(%tensor_73_1, %c80) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c82 = "eigen.conv2d.f32"(%tensor_73_1, %tensor_76_0, %tensor_76_1, %c81) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c83 = "eigen.batch_norm.f32"(%tensor_76_1, %tensor_77_0, %tensor_77_1, %tensor_77_2, %tensor_77_3, %c82) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c84 = tfrt.merge.chains %c75, %c83 : !tfrt.chain, !tfrt.chain
    %c85 = "tfrt_test.add_inplace.f32"(%tensor_66_1, %tensor_76_1, %c84) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c86 = "tfrt_test.relu_inplace.f32"(%tensor_76_1, %c85) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c87 = "eigen.conv2d.f32"(%tensor_76_1, %tensor_80_0, %tensor_80_1, %c86) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c88 = "eigen.batch_norm.f32"(%tensor_80_1, %tensor_81_0, %tensor_81_1, %tensor_81_2, %tensor_81_3, %c87) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c89 = "tfrt_test.relu_inplace.f32"(%tensor_80_1, %c88) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c90 = "eigen.conv2d.f32"(%tensor_80_1, %tensor_83_0, %tensor_83_1, %c89) { padding = "same", strides = [2 : i64, 2 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c91 = "eigen.batch_norm.f32"(%tensor_83_1, %tensor_84_0, %tensor_84_1, %tensor_84_2, %tensor_84_3, %c90) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c92 = "tfrt_test.relu_inplace.f32"(%tensor_83_1, %c91) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c93 = "eigen.conv2d.f32"(%tensor_83_1, %tensor_86_0, %tensor_86_1, %c92) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c94 = "eigen.conv2d.f32"(%tensor_76_1, %tensor_87_0, %tensor_87_1, %c86) { padding = "valid", strides = [2 : i64, 2 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c95 = "eigen.batch_norm.f32"(%tensor_86_1, %tensor_88_0, %tensor_88_1, %tensor_88_2, %tensor_88_3, %c93) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c96 = "eigen.batch_norm.f32"(%tensor_87_1, %tensor_89_0, %tensor_89_1, %tensor_89_2, %tensor_89_3, %c94) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c97 = tfrt.merge.chains %c95, %c96 : !tfrt.chain, !tfrt.chain
    %c98 = "tfrt_test.add_inplace.f32"(%tensor_87_1, %tensor_86_1, %c97) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c99 = "tfrt_test.relu_inplace.f32"(%tensor_86_1, %c98) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c100 = "eigen.conv2d.f32"(%tensor_86_1, %tensor_92_0, %tensor_92_1, %c99) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c101 = "eigen.batch_norm.f32"(%tensor_92_1, %tensor_93_0, %tensor_93_1, %tensor_93_2, %tensor_93_3, %c100) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c102 = "tfrt_test.relu_inplace.f32"(%tensor_92_1, %c101) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c103 = "eigen.conv2d.f32"(%tensor_92_1, %tensor_95_0, %tensor_95_1, %c102) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c104 = "eigen.batch_norm.f32"(%tensor_95_1, %tensor_96_0, %tensor_96_1, %tensor_96_2, %tensor_96_3, %c103) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c105 = "tfrt_test.relu_inplace.f32"(%tensor_95_1, %c104) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c106 = "eigen.conv2d.f32"(%tensor_95_1, %tensor_98_0, %tensor_98_1, %c105) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c107 = "eigen.batch_norm.f32"(%tensor_98_1, %tensor_99_0, %tensor_99_1, %tensor_99_2, %tensor_99_3, %c106) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c108 = tfrt.merge.chains %c99, %c107 : !tfrt.chain, !tfrt.chain
    %c109 = "tfrt_test.add_inplace.f32"(%tensor_86_1, %tensor_98_1, %c108) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c110 = "tfrt_test.relu_inplace.f32"(%tensor_98_1, %c109) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c111 = "eigen.conv2d.f32"(%tensor_98_1, %tensor_102_0, %tensor_102_1, %c110) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c112 = "eigen.batch_norm.f32"(%tensor_102_1, %tensor_103_0, %tensor_103_1, %tensor_103_2, %tensor_103_3, %c111) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c113 = "tfrt_test.relu_inplace.f32"(%tensor_102_1, %c112) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c114 = "eigen.conv2d.f32"(%tensor_102_1, %tensor_105_0, %tensor_105_1, %c113) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c115 = "eigen.batch_norm.f32"(%tensor_105_1, %tensor_106_0, %tensor_106_1, %tensor_106_2, %tensor_106_3, %c114) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c116 = "tfrt_test.relu_inplace.f32"(%tensor_105_1, %c115) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c117 = "eigen.conv2d.f32"(%tensor_105_1, %tensor_108_0, %tensor_108_1, %c116) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c118 = "eigen.batch_norm.f32"(%tensor_108_1, %tensor_109_0, %tensor_109_1, %tensor_109_2, %tensor_109_3, %c117) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c119 = tfrt.merge.chains %c110, %c118 : !tfrt.chain, !tfrt.chain
    %c120 = "tfrt_test.add_inplace.f32"(%tensor_98_1, %tensor_108_1, %c119) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c121 = "tfrt_test.relu_inplace.f32"(%tensor_108_1, %c120) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c122 = "eigen.conv2d.f32"(%tensor_108_1, %tensor_112_0, %tensor_112_1, %c121) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c123 = "eigen.batch_norm.f32"(%tensor_112_1, %tensor_113_0, %tensor_113_1, %tensor_113_2, %tensor_113_3, %c122) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c124 = "tfrt_test.relu_inplace.f32"(%tensor_112_1, %c123) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c125 = "eigen.conv2d.f32"(%tensor_112_1, %tensor_115_0, %tensor_115_1, %c124) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c126 = "eigen.batch_norm.f32"(%tensor_115_1, %tensor_116_0, %tensor_116_1, %tensor_116_2, %tensor_116_3, %c125) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c127 = "tfrt_test.relu_inplace.f32"(%tensor_115_1, %c126) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c128 = "eigen.conv2d.f32"(%tensor_115_1, %tensor_118_0, %tensor_118_1, %c127) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c129 = "eigen.batch_norm.f32"(%tensor_118_1, %tensor_119_0, %tensor_119_1, %tensor_119_2, %tensor_119_3, %c128) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c130 = tfrt.merge.chains %c121, %c129 : !tfrt.chain, !tfrt.chain
    %c131 = "tfrt_test.add_inplace.f32"(%tensor_108_1, %tensor_118_1, %c130) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c132 = "tfrt_test.relu_inplace.f32"(%tensor_118_1, %c131) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c133 = "eigen.conv2d.f32"(%tensor_118_1, %tensor_122_0, %tensor_122_1, %c132) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c134 = "eigen.batch_norm.f32"(%tensor_122_1, %tensor_123_0, %tensor_123_1, %tensor_123_2, %tensor_123_3, %c133) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c135 = "tfrt_test.relu_inplace.f32"(%tensor_122_1, %c134) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c136 = "eigen.conv2d.f32"(%tensor_122_1, %tensor_125_0, %tensor_125_1, %c135) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c137 = "eigen.batch_norm.f32"(%tensor_125_1, %tensor_126_0, %tensor_126_1, %tensor_126_2, %tensor_126_3, %c136) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c138 = "tfrt_test.relu_inplace.f32"(%tensor_125_1, %c137) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c139 = "eigen.conv2d.f32"(%tensor_125_1, %tensor_128_0, %tensor_128_1, %c138) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c140 = "eigen.batch_norm.f32"(%tensor_128_1, %tensor_129_0, %tensor_129_1, %tensor_129_2, %tensor_129_3, %c139) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c141 = tfrt.merge.chains %c132, %c140 : !tfrt.chain, !tfrt.chain
    %c142 = "tfrt_test.add_inplace.f32"(%tensor_118_1, %tensor_128_1, %c141) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c143 = "tfrt_test.relu_inplace.f32"(%tensor_128_1, %c142) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c144 = "eigen.conv2d.f32"(%tensor_128_1, %tensor_132_0, %tensor_132_1, %c143) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c145 = "eigen.batch_norm.f32"(%tensor_132_1, %tensor_133_0, %tensor_133_1, %tensor_133_2, %tensor_133_3, %c144) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c146 = "tfrt_test.relu_inplace.f32"(%tensor_132_1, %c145) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c147 = "eigen.conv2d.f32"(%tensor_132_1, %tensor_135_0, %tensor_135_1, %c146) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c148 = "eigen.batch_norm.f32"(%tensor_135_1, %tensor_136_0, %tensor_136_1, %tensor_136_2, %tensor_136_3, %c147) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c149 = "tfrt_test.relu_inplace.f32"(%tensor_135_1, %c148) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c150 = "eigen.conv2d.f32"(%tensor_135_1, %tensor_138_0, %tensor_138_1, %c149) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c151 = "eigen.batch_norm.f32"(%tensor_138_1, %tensor_139_0, %tensor_139_1, %tensor_139_2, %tensor_139_3, %c150) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c152 = tfrt.merge.chains %c143, %c151 : !tfrt.chain, !tfrt.chain
    %c153 = "tfrt_test.add_inplace.f32"(%tensor_128_1, %tensor_138_1, %c152) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c154 = "tfrt_test.relu_inplace.f32"(%tensor_138_1, %c153) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c155 = "eigen.conv2d.f32"(%tensor_138_1, %tensor_142_0, %tensor_142_1, %c154) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c156 = "eigen.batch_norm.f32"(%tensor_142_1, %tensor_143_0, %tensor_143_1, %tensor_143_2, %tensor_143_3, %c155) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c157 = "tfrt_test.relu_inplace.f32"(%tensor_142_1, %c156) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c158 = "eigen.conv2d.f32"(%tensor_142_1, %tensor_145_0, %tensor_145_1, %c157) { padding = "same", strides = [2 : i64, 2 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c159 = "eigen.batch_norm.f32"(%tensor_145_1, %tensor_146_0, %tensor_146_1, %tensor_146_2, %tensor_146_3, %c158) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c160 = "tfrt_test.relu_inplace.f32"(%tensor_145_1, %c159) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c161 = "eigen.conv2d.f32"(%tensor_145_1, %tensor_148_0, %tensor_148_1, %c160) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c162 = "eigen.conv2d.f32"(%tensor_138_1, %tensor_149_0, %tensor_149_1, %c154) { padding = "valid", strides = [2 : i64, 2 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c163 = "eigen.batch_norm.f32"(%tensor_148_1, %tensor_150_0, %tensor_150_1, %tensor_150_2, %tensor_150_3, %c161) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c164 = "eigen.batch_norm.f32"(%tensor_149_1, %tensor_151_0, %tensor_151_1, %tensor_151_2, %tensor_151_3, %c162) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c165 = tfrt.merge.chains %c163, %c164 : !tfrt.chain, !tfrt.chain
    %c166 = "tfrt_test.add_inplace.f32"(%tensor_149_1, %tensor_148_1, %c165) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c167 = "tfrt_test.relu_inplace.f32"(%tensor_148_1, %c166) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c168 = "eigen.conv2d.f32"(%tensor_148_1, %tensor_154_0, %tensor_154_1, %c167) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c169 = "eigen.batch_norm.f32"(%tensor_154_1, %tensor_155_0, %tensor_155_1, %tensor_155_2, %tensor_155_3, %c168) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c170 = "tfrt_test.relu_inplace.f32"(%tensor_154_1, %c169) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c171 = "eigen.conv2d.f32"(%tensor_154_1, %tensor_157_0, %tensor_157_1, %c170) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c172 = "eigen.batch_norm.f32"(%tensor_157_1, %tensor_158_0, %tensor_158_1, %tensor_158_2, %tensor_158_3, %c171) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c173 = "tfrt_test.relu_inplace.f32"(%tensor_157_1, %c172) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c174 = "eigen.conv2d.f32"(%tensor_157_1, %tensor_160_0, %tensor_160_1, %c173) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c175 = "eigen.batch_norm.f32"(%tensor_160_1, %tensor_161_0, %tensor_161_1, %tensor_161_2, %tensor_161_3, %c174) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c176 = tfrt.merge.chains %c167, %c175 : !tfrt.chain, !tfrt.chain
    %c177 = "tfrt_test.add_inplace.f32"(%tensor_148_1, %tensor_160_1, %c176) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c178 = "tfrt_test.relu_inplace.f32"(%tensor_160_1, %c177) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c179 = "eigen.conv2d.f32"(%tensor_160_1, %tensor_164_0, %tensor_164_1, %c178) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c180 = "eigen.batch_norm.f32"(%tensor_164_1, %tensor_165_0, %tensor_165_1, %tensor_165_2, %tensor_165_3, %c179) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c181 = "tfrt_test.relu_inplace.f32"(%tensor_164_1, %c180) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c182 = "eigen.conv2d.f32"(%tensor_164_1, %tensor_167_0, %tensor_167_1, %c181) { padding = "same", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c183 = "eigen.batch_norm.f32"(%tensor_167_1, %tensor_168_0, %tensor_168_1, %tensor_168_2, %tensor_168_3, %c182) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c184 = "tfrt_test.relu_inplace.f32"(%tensor_167_1, %c183) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c185 = "eigen.conv2d.f32"(%tensor_167_1, %tensor_170_0, %tensor_170_1, %c184) { padding = "valid", strides = [1 : i64, 1 : i64] } :  (!t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c186 = "eigen.batch_norm.f32"(%tensor_170_1, %tensor_171_0, %tensor_171_1, %tensor_171_2, %tensor_171_3, %c185) { epsilon = 0.000010 : f32 } :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c187 = tfrt.merge.chains %c178, %c186 : !tfrt.chain, !tfrt.chain
    %c188 = "tfrt_test.add_inplace.f32"(%tensor_160_1, %tensor_170_1, %c187) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %c189 = "tfrt_test.relu_inplace.f32"(%tensor_170_1, %c188) : (!t.tensor, !tfrt.chain) -> !tfrt.chain

    %c190 = "tfrt_test.global_average_pooling.f32"(%tensor_170_1, %tensor_174_0, %c189) : (!t.tensor, !t.tensor, !tfrt.chain) -> !tfrt.chain

    %tensor_175_2 = ts.build_shape [1 : i64, 1001 : i64]
    %tensor_175_3 = "tfrt_test.broadcast.f32.2"(%tensor_175_1, %tensor_175_2, %c0) : (!t.tensor, !ts.shape, !tfrt.chain) -> !t.tensor
    %c191 = "eigen.matmul.f32"(%one, %tensor_174_0, %tensor_175_0, %one, %tensor_175_3, %c190) : (f32, !t.tensor, !t.tensor, f32, !t.tensor, !tfrt.chain) -> !tfrt.chain
    %cmp, %c192 = "tfrt_dht.tensor_allclose.2000ulp.f32"(%expected_prob, %tensor_175_3, %c191) : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)
    %c193 = tfrt_dht.print_tensor %tensor_175_3, %c192
    // CHECK: int1 = 1
    %c194 = "tfrt.print.i1"(%cmp, %c193) : (i1, !tfrt.chain) -> !tfrt.chain
    tfrt.return %c194 : !tfrt.chain
  }
  tfrt.return
}

