## TFSA-2022-079: Denial of service in `tf.ragged.constant` due to lack of validation

### CVE Number
CVE-2022-29202

### Impact
The implementation of [`tf.ragged.constant`](https://github.com/tensorflow/tensorflow/blob/f3b9bf4c3c0597563b289c0512e98d4ce81f886e/tensorflow/python/ops/ragged/ragged_factory_ops.py#L146-L239) does not fully validate the input arguments. This results in a denial of service by consuming all available memory:

```python
import tensorflow as tf
tf.ragged.constant(pylist=[],ragged_rank=8968073515812833920)
```

### Patches
We have patched the issue in GitHub commit [bd4d5583ff9c8df26d47a23e508208844297310e](https://github.com/tensorflow/tensorflow/commit/bd4d5583ff9c8df26d47a23e508208844297310e).

The fix will be included in TensorFlow 2.9.0. We will also cherrypick this commit on TensorFlow 2.8.1, TensorFlow 2.7.2, and TensorFlow 2.6.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported externally via a [GitHub issue](https://github.com/tensorflow/tensorflow/issues/55199).
