## TFSA-2020-015: Heap buffer overflow due to invalid splits in RaggedCountSparseOutput

### CVE Number
CVE-2020-15201

### Impact
The `RaggedCountSparseOutput` implementation does not validate that the input
arguments form a valid ragged tensor. In particular, there is no validation that
the values in the `splits` tensor generate a valid partitioning of the `values`
tensor. Hence, this code is prone to [heap buffer
overflow](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/kernels/count_ops.cc#L248-L251):
```cc
    for (int idx = 0; idx < num_values; ++idx) {
      while (idx >= splits_values(batch_idx)) {
        batch_idx++;
      }
      // ...
    }
```

If `split_values` does not end with a value at least `num_values` then the
`while` loop condition will trigger a read outside of the bounds of
`split_values` once `batch_idx` grows too large.

### Vulnerable Versions
TensorFlow 2.3.0.

### Patches
We have patched the issue in
[3cbb917b4714766030b28eba9fb41bb97ce9ee02](https://github.com/tensorflow/tensorflow/commit/3cbb917b4714766030b28eba9fb41bb97ce9ee02)
and will release a patch release.

We recommend users to upgrade to TensorFlow 2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
