import string

HEADERS = [
    'IA Control', 'CCI', 'SRGID', 'STIGID', 'SRG Requirement', 'Requirement',
    'SRG VulDiscussion', 'Vul Discussion', 'Status', 'SRG Check', 'Check', 'SRG Fix',
    'Fix', 'Severity', 'Mitigation', 'Artifact Description', 'Status Justification'
    ]
COLUMNS = string.ascii_uppercase[:17]  # A-Q uppercase letters
COLUMN_MAPPINGS = dict(zip(COLUMNS, HEADERS))
srgid_to_iacontrol = {
    'SRG-OS-000001-GPOS-00001': 'AC-2 (1)',
    'SRG-OS-000002-GPOS-00002': 'AC-2 (2)',
    'SRG-OS-000004-GPOS-00004': 'AC-2 (4)',
    'SRG-OS-000021-GPOS-00005': 'AC-7 a',
    'SRG-OS-000023-GPOS-00006': 'AC-8 a',
    'SRG-OS-000024-GPOS-00007': 'AC-8 b',
    'SRG-OS-000027-GPOS-00008': 'AC-10',
    'SRG-OS-000028-GPOS-00009': 'AC-11 b',
    'SRG-OS-000029-GPOS-00010': 'AC-11 a',
    'SRG-OS-000030-GPOS-00011': 'AC-11 a',
    'SRG-OS-000031-GPOS-00012': 'AC-11 (1)',
    'SRG-OS-000032-GPOS-00013': 'AC-17 (1)',
    'SRG-OS-000033-GPOS-00014': 'AC-17 (2)',
    'SRG-OS-000037-GPOS-00015': 'AU-3',
    'SRG-OS-000038-GPOS-00016': 'AU-3',
    'SRG-OS-000039-GPOS-00017': 'AU-3',
    'SRG-OS-000040-GPOS-00018': 'AU-3',
    'SRG-OS-000041-GPOS-00019': 'AU-3',
    'SRG-OS-000042-GPOS-00020': 'AU-3 (1)',
    'SRG-OS-000042-GPOS-00021': 'AU-3 (1)',
    'SRG-OS-000046-GPOS-00022': 'AU-5 a',
    'SRG-OS-000047-GPOS-00023': 'AU-5 b',
    'SRG-OS-000051-GPOS-00024': 'AU-6 (4)',
    'SRG-OS-000054-GPOS-00025': 'AU-7 (1)',
    'SRG-OS-000055-GPOS-00026': 'AU-8 a',
    'SRG-OS-000057-GPOS-00027': 'AU-9',
    'SRG-OS-000058-GPOS-00028': 'AU-9',
    'SRG-OS-000059-GPOS-00029': 'AU-9',
    'SRG-OS-000062-GPOS-00031': 'AU-12 a',
    'SRG-OS-000063-GPOS-00032': 'AU-12 b',
    'SRG-OS-000064-GPOS-00033': 'AU-12 c',
    'SRG-OS-000066-GPOS-00034': 'IA-5 (2) (a)',
    'SRG-OS-000067-GPOS-00035': 'IA-5 (2) (b)',
    'SRG-OS-000068-GPOS-00036': 'IA-5 (2) (c)',
    'SRG-OS-000069-GPOS-00037': 'IA-5 (1) (a)',
    'SRG-OS-000070-GPOS-00038': 'IA-5 (1) (a)',
    'SRG-OS-000071-GPOS-00039': 'IA-5 (1) (a)',
    'SRG-OS-000072-GPOS-00040': 'IA-5 (1) (b)',
    'SRG-OS-000073-GPOS-00041': 'IA-5 (1) (c)',
    'SRG-OS-000074-GPOS-00042': 'IA-5 (1) (c)',
    'SRG-OS-000075-GPOS-00043': 'IA-5 (1) (d)',
    'SRG-OS-000076-GPOS-00044': 'IA-5 (1) (d)',
    'SRG-OS-000077-GPOS-00045': 'IA-5 (1) (e)',
    'SRG-OS-000078-GPOS-00046': 'IA-5 (1) (a)',
    'SRG-OS-000079-GPOS-00047': 'IA-6',
    'SRG-OS-000080-GPOS-00048': 'AC-3',
    'SRG-OS-000095-GPOS-00049': 'CM-7 a',
    'SRG-OS-000096-GPOS-00050': 'CM-7 b',
    'SRG-OS-000104-GPOS-00051': 'IA-2',
    'SRG-OS-000105-GPOS-00052': 'IA-2 (1)',
    'SRG-OS-000106-GPOS-00053': 'IA-2 (2)',
    'SRG-OS-000107-GPOS-00054': 'IA-2 (3)',
    'SRG-OS-000108-GPOS-00055': 'IA-2 (4)',
    'SRG-OS-000109-GPOS-00056': 'IA-2 (5)',
    'SRG-OS-000112-GPOS-00057': 'IA-2 (8)',
    'SRG-OS-000113-GPOS-00058': 'IA-2 (9)',
    'SRG-OS-000114-GPOS-00059': 'IA-3',
    'SRG-OS-000118-GPOS-00060': 'IA-4 e',
    'SRG-OS-000120-GPOS-00061': 'IA-7',
    'SRG-OS-000121-GPOS-00062': 'IA-8',
    'SRG-OS-000122-GPOS-00063': 'AU-7 a',
    'SRG-OS-000123-GPOS-00064': 'AC-2 (2)',
    'SRG-OS-000125-GPOS-00065': 'MA-4 c',
    'SRG-OS-000126-GPOS-00066': 'MA-4 e',
    'SRG-OS-000132-GPOS-00067': 'SC-2',
    'SRG-OS-000134-GPOS-00068': 'SC-3',
    'SRG-OS-000138-GPOS-00069': 'SC-4',
    'SRG-OS-000142-GPOS-00071': 'SC-5 (2)',
    'SRG-OS-000163-GPOS-00072': 'SC-10',
    'SRG-OS-000184-GPOS-00078': 'SC-24',
    'SRG-OS-000185-GPOS-00079': 'SC-28',
    'SRG-OS-000191-GPOS-00080': 'SI-2 (2)',
    'SRG-OS-000205-GPOS-00083': 'SI-11 a',
    'SRG-OS-000206-GPOS-00084': 'SI-11 b',
    'SRG-OS-000228-GPOS-00088': 'AC-8 c 1, AC-8 c 2, AC-8 c 3',
    'SRG-OS-000239-GPOS-00089': 'AC-2 (4)',
    'SRG-OS-000240-GPOS-00090': 'AC-2 (4)',
    'SRG-OS-000241-GPOS-00091': 'AC-2 (4)',
    'SRG-OS-000250-GPOS-00093': 'AC-17 (2)',
    'SRG-OS-000254-GPOS-00095': 'AU-14 (1)',
    'SRG-OS-000255-GPOS-00096': 'AU-3',
    'SRG-OS-000256-GPOS-00097': 'AU-9',
    'SRG-OS-000257-GPOS-00098': 'AU-9',
    'SRG-OS-000258-GPOS-00099': 'AU-9',
    'SRG-OS-000259-GPOS-00100': 'CM-5 (6)',
    'SRG-OS-000266-GPOS-00101': 'IA-5 (1) (a)',
    'SRG-OS-000269-GPOS-00103': 'SC-24',
    'SRG-OS-000274-GPOS-00104': 'AC-2 (4)',
    'SRG-OS-000275-GPOS-00105': 'AC-2 (4)',
    'SRG-OS-000276-GPOS-00106': 'AC-2 (4)',
    'SRG-OS-000277-GPOS-00107': 'AC-2 (4)',
    'SRG-OS-000278-GPOS-00108': 'AU-9 (3)',
    'SRG-OS-000279-GPOS-00109': 'AC-12',
    'SRG-OS-000280-GPOS-00110': 'AC-12 (1)',
    'SRG-OS-000281-GPOS-00111': 'AC-12 (1)',
    'SRG-OS-000297-GPOS-00115': 'AC-17 (1)',
    'SRG-OS-000298-GPOS-00116': 'AC-17 (9)',
    'SRG-OS-000299-GPOS-00117': 'AC-18 (1)',
    'SRG-OS-000300-GPOS-00118': 'AC-18 (1)',
    'SRG-OS-000303-GPOS-00120': 'AC-2 (4)',
    'SRG-OS-000304-GPOS-00121': 'AC-2 (4)',
    'SRG-OS-000312-GPOS-00122': 'AC-3 (4)',
    'SRG-OS-000312-GPOS-00123': 'AC-3 (4)',
    'SRG-OS-000312-GPOS-00124': 'AC-3 (4)',
    'SRG-OS-000324-GPOS-00125': 'AC-6 (10)',
    'SRG-OS-000326-GPOS-00126': 'AC-6 (8)',
    'SRG-OS-000327-GPOS-00127': 'AC-6 (9)',
    'SRG-OS-000329-GPOS-00128': 'AC-7 b',
    'SRG-OS-000337-GPOS-00129': 'AU-12 (3)',
    'SRG-OS-000341-GPOS-00132': 'AU-4',
    'SRG-OS-000342-GPOS-00133': 'AU-4 (1)',
    'SRG-OS-000343-GPOS-00134': 'AU-5 (1)',
    'SRG-OS-000344-GPOS-00135': 'AU-5 (2)',
    'SRG-OS-000348-GPOS-00136': 'AU-7 a',
    'SRG-OS-000349-GPOS-00137': 'AU-7 a',
    'SRG-OS-000350-GPOS-00138': 'AU-7 a',
    'SRG-OS-000351-GPOS-00139': 'AU-7 a',
    'SRG-OS-000352-GPOS-00140': 'AU-7 a',
    'SRG-OS-000353-GPOS-00141': 'AU-7 b',
    'SRG-OS-000354-GPOS-00142': 'AU-7 b',
    'SRG-OS-000355-GPOS-00143': 'AU-8 (1) (a)',
    'SRG-OS-000356-GPOS-00144': 'AU-8 (1) (b)',
    'SRG-OS-000358-GPOS-00145': 'AU-8 b',
    'SRG-OS-000359-GPOS-00146': 'AU-8 b',
    'SRG-OS-000360-GPOS-00147': 'AU-9 (5), CM-6 b',
    'SRG-OS-000362-GPOS-00149': 'CM-11 (2)',
    'SRG-OS-000363-GPOS-00150': 'CM-3 (5)',
    'SRG-OS-000364-GPOS-00151': 'CM-5 (1)',
    'SRG-OS-000365-GPOS-00152': 'CM-5 (1)',
    'SRG-OS-000366-GPOS-00153': 'CM-5 (3)',
    'SRG-OS-000368-GPOS-00154': 'CM-7 (2)',
    'SRG-OS-000370-GPOS-00155': 'CM-7 (5) (b)',
    'SRG-OS-000373-GPOS-00156': 'IA-11',
    'SRG-OS-000373-GPOS-00157': 'IA-11',
    'SRG-OS-000373-GPOS-00158': 'IA-11',
    'SRG-OS-000374-GPOS-00159': 'IA-11',
    'SRG-OS-000375-GPOS-00160': 'IA-2 (11)',
    'SRG-OS-000376-GPOS-00161': 'IA-2 (12)',
    'SRG-OS-000377-GPOS-00162': 'IA-2 (12)',
    'SRG-OS-000378-GPOS-00163': 'IA-3',
    'SRG-OS-000379-GPOS-00164': 'IA-3 (1)',
    'SRG-OS-000380-GPOS-00165': 'IA-5 (1) (f)',
    'SRG-OS-000383-GPOS-00166': 'IA-5 (13)',
    'SRG-OS-000384-GPOS-00167': 'IA-5 (2) (d)',
    'SRG-OS-000392-GPOS-00172': 'MA-4 (1) (a)',
    'SRG-OS-000393-GPOS-00173': 'MA-4 (6)',
    'SRG-OS-000394-GPOS-00174': 'MA-4 (6)',
    'SRG-OS-000395-GPOS-00175': 'MA-4 (7)',
    'SRG-OS-000396-GPOS-00176': 'SC-13',
    'SRG-OS-000403-GPOS-00182': 'SC-23 (5)',
    'SRG-OS-000404-GPOS-00183': 'SC-28 (1)',
    'SRG-OS-000405-GPOS-00184': 'SC-28 (1)',
    'SRG-OS-000420-GPOS-00186': 'SC-5',
    'SRG-OS-000423-GPOS-00187': 'SC-8',
    'SRG-OS-000424-GPOS-00188': 'SC-8 (1)',
    'SRG-OS-000425-GPOS-00189': 'SC-8 (2)',
    'SRG-OS-000426-GPOS-00190': 'SC-8 (2)',
    'SRG-OS-000432-GPOS-00191': 'SI-10 (3)',
    'SRG-OS-000433-GPOS-00192': 'SI-16',
    'SRG-OS-000433-GPOS-00193': 'SI-16',
    'SRG-OS-000437-GPOS-00194': 'SI-2 (6)',
    'SRG-OS-000445-GPOS-00199': 'SI-6 a',
    'SRG-OS-000446-GPOS-00200': 'SI-6 b',
    'SRG-OS-000447-GPOS-00201': 'SI-6 d',
    'SRG-OS-000458-GPOS-00203': 'AU-12 c',
    'SRG-OS-000461-GPOS-00205': 'AU-12 c',
    'SRG-OS-000462-GPOS-00206': 'AU-12 c',
    'SRG-OS-000463-GPOS-00207': 'AU-12 c',
    'SRG-OS-000465-GPOS-00209': 'AU-12 c',
    'SRG-OS-000466-GPOS-00210': 'AU-12 c',
    'SRG-OS-000467-GPOS-00211': 'AU-12 c',
    'SRG-OS-000468-GPOS-00212': 'AU-12 c',
    'SRG-OS-000470-GPOS-00214': 'AU-12 c',
    'SRG-OS-000471-GPOS-00215': 'AU-12 c',
    'SRG-OS-000471-GPOS-00216': 'AU-12 c',
    'SRG-OS-000472-GPOS-00217': 'AU-12 c',
    'SRG-OS-000473-GPOS-00218': 'AU-12 c',
    'SRG-OS-000474-GPOS-00219': 'AU-12 c',
    'SRG-OS-000475-GPOS-00220': 'AU-12 c',
    'SRG-OS-000476-GPOS-00221': 'AU-12 c',
    'SRG-OS-000477-GPOS-00222': 'AU-12 c',
    'SRG-OS-000478-GPOS-00223': 'SC-13',
    'SRG-OS-000479-GPOS-00224': 'AU-4 (1)',
    'SRG-OS-000480-GPOS-00225': 'CM-6 b',
    'SRG-OS-000480-GPOS-00226': 'CM-6 b',
    'SRG-OS-000480-GPOS-00227': 'CM-6 b',
    'SRG-OS-000480-GPOS-00228': 'CM-6 b',
    'SRG-OS-000480-GPOS-00229': 'CM-6 b',
    'SRG-OS-000480-GPOS-00230': 'CM-6 b',
    'SRG-OS-000480-GPOS-00232': 'CM-6 b',
    'SRG-OS-000481-GPOS-000481': 'SC-8'}
