/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the RpmRpmRepositoryResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RpmRpmRepositoryResponse{}

// RpmRpmRepositoryResponse Serializer for Rpm Repositories.
type RpmRpmRepositoryResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	VersionsHref *string `json:"versions_href,omitempty"`
	PulpLabels *map[string]string `json:"pulp_labels,omitempty"`
	LatestVersionHref *string `json:"latest_version_href,omitempty"`
	// A unique name for this repository.
	Name string `json:"name"`
	// An optional description.
	Description NullableString `json:"description,omitempty"`
	// Retain X versions of the repository. Default is null which retains all versions.
	RetainRepoVersions NullableInt64 `json:"retain_repo_versions,omitempty"`
	// An optional remote to use by default when syncing.
	Remote NullableString `json:"remote,omitempty"`
	// Whether to automatically create publications for new repository versions, and update any distributions pointing to this repository.
	Autopublish *bool `json:"autopublish,omitempty"`
	// A reference to an associated signing service.
	MetadataSigningService NullableString `json:"metadata_signing_service,omitempty"`
	// The number of versions of each package to keep in the repository; older versions will be purged. The default is '0', which will disable this feature and keep all versions of each package.
	RetainPackageVersions *int64 `json:"retain_package_versions,omitempty"`
	MetadataChecksumType NullableMetadataChecksumTypeEnum `json:"metadata_checksum_type,omitempty"`
	PackageChecksumType NullablePackageChecksumTypeEnum `json:"package_checksum_type,omitempty"`
	// An option specifying whether a client should perform a GPG signature check on packages.
	Gpgcheck *int64 `json:"gpgcheck,omitempty"`
	// An option specifying whether a client should perform a GPG signature check on the repodata.
	RepoGpgcheck *int64 `json:"repo_gpgcheck,omitempty"`
	// DEPRECATED: An option specifying whether Pulp should generate SQLite metadata.
	SqliteMetadata *bool `json:"sqlite_metadata,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _RpmRpmRepositoryResponse RpmRpmRepositoryResponse

// NewRpmRpmRepositoryResponse instantiates a new RpmRpmRepositoryResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRpmRpmRepositoryResponse(name string) *RpmRpmRepositoryResponse {
	this := RpmRpmRepositoryResponse{}
	this.Name = name
	var autopublish bool = false
	this.Autopublish = &autopublish
	var gpgcheck int64 = 0
	this.Gpgcheck = &gpgcheck
	var repoGpgcheck int64 = 0
	this.RepoGpgcheck = &repoGpgcheck
	var sqliteMetadata bool = false
	this.SqliteMetadata = &sqliteMetadata
	return &this
}

// NewRpmRpmRepositoryResponseWithDefaults instantiates a new RpmRpmRepositoryResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRpmRpmRepositoryResponseWithDefaults() *RpmRpmRepositoryResponse {
	this := RpmRpmRepositoryResponse{}
	var autopublish bool = false
	this.Autopublish = &autopublish
	var gpgcheck int64 = 0
	this.Gpgcheck = &gpgcheck
	var repoGpgcheck int64 = 0
	this.RepoGpgcheck = &repoGpgcheck
	var sqliteMetadata bool = false
	this.SqliteMetadata = &sqliteMetadata
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *RpmRpmRepositoryResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *RpmRpmRepositoryResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetVersionsHref returns the VersionsHref field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetVersionsHref() string {
	if o == nil || IsNil(o.VersionsHref) {
		var ret string
		return ret
	}
	return *o.VersionsHref
}

// GetVersionsHrefOk returns a tuple with the VersionsHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetVersionsHrefOk() (*string, bool) {
	if o == nil || IsNil(o.VersionsHref) {
		return nil, false
	}
	return o.VersionsHref, true
}

// HasVersionsHref returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasVersionsHref() bool {
	if o != nil && !IsNil(o.VersionsHref) {
		return true
	}

	return false
}

// SetVersionsHref gets a reference to the given string and assigns it to the VersionsHref field.
func (o *RpmRpmRepositoryResponse) SetVersionsHref(v string) {
	o.VersionsHref = &v
}

// GetPulpLabels returns the PulpLabels field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetPulpLabels() map[string]string {
	if o == nil || IsNil(o.PulpLabels) {
		var ret map[string]string
		return ret
	}
	return *o.PulpLabels
}

// GetPulpLabelsOk returns a tuple with the PulpLabels field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetPulpLabelsOk() (*map[string]string, bool) {
	if o == nil || IsNil(o.PulpLabels) {
		return nil, false
	}
	return o.PulpLabels, true
}

// HasPulpLabels returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasPulpLabels() bool {
	if o != nil && !IsNil(o.PulpLabels) {
		return true
	}

	return false
}

// SetPulpLabels gets a reference to the given map[string]string and assigns it to the PulpLabels field.
func (o *RpmRpmRepositoryResponse) SetPulpLabels(v map[string]string) {
	o.PulpLabels = &v
}

// GetLatestVersionHref returns the LatestVersionHref field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetLatestVersionHref() string {
	if o == nil || IsNil(o.LatestVersionHref) {
		var ret string
		return ret
	}
	return *o.LatestVersionHref
}

// GetLatestVersionHrefOk returns a tuple with the LatestVersionHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetLatestVersionHrefOk() (*string, bool) {
	if o == nil || IsNil(o.LatestVersionHref) {
		return nil, false
	}
	return o.LatestVersionHref, true
}

// HasLatestVersionHref returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasLatestVersionHref() bool {
	if o != nil && !IsNil(o.LatestVersionHref) {
		return true
	}

	return false
}

// SetLatestVersionHref gets a reference to the given string and assigns it to the LatestVersionHref field.
func (o *RpmRpmRepositoryResponse) SetLatestVersionHref(v string) {
	o.LatestVersionHref = &v
}

// GetName returns the Name field value
func (o *RpmRpmRepositoryResponse) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *RpmRpmRepositoryResponse) SetName(v string) {
	o.Name = v
}

// GetDescription returns the Description field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *RpmRpmRepositoryResponse) GetDescription() string {
	if o == nil || IsNil(o.Description.Get()) {
		var ret string
		return ret
	}
	return *o.Description.Get()
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmRpmRepositoryResponse) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description.Get(), o.Description.IsSet()
}

// HasDescription returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasDescription() bool {
	if o != nil && o.Description.IsSet() {
		return true
	}

	return false
}

// SetDescription gets a reference to the given NullableString and assigns it to the Description field.
func (o *RpmRpmRepositoryResponse) SetDescription(v string) {
	o.Description.Set(&v)
}
// SetDescriptionNil sets the value for Description to be an explicit nil
func (o *RpmRpmRepositoryResponse) SetDescriptionNil() {
	o.Description.Set(nil)
}

// UnsetDescription ensures that no value is present for Description, not even an explicit nil
func (o *RpmRpmRepositoryResponse) UnsetDescription() {
	o.Description.Unset()
}

// GetRetainRepoVersions returns the RetainRepoVersions field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *RpmRpmRepositoryResponse) GetRetainRepoVersions() int64 {
	if o == nil || IsNil(o.RetainRepoVersions.Get()) {
		var ret int64
		return ret
	}
	return *o.RetainRepoVersions.Get()
}

// GetRetainRepoVersionsOk returns a tuple with the RetainRepoVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmRpmRepositoryResponse) GetRetainRepoVersionsOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.RetainRepoVersions.Get(), o.RetainRepoVersions.IsSet()
}

// HasRetainRepoVersions returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasRetainRepoVersions() bool {
	if o != nil && o.RetainRepoVersions.IsSet() {
		return true
	}

	return false
}

// SetRetainRepoVersions gets a reference to the given NullableInt64 and assigns it to the RetainRepoVersions field.
func (o *RpmRpmRepositoryResponse) SetRetainRepoVersions(v int64) {
	o.RetainRepoVersions.Set(&v)
}
// SetRetainRepoVersionsNil sets the value for RetainRepoVersions to be an explicit nil
func (o *RpmRpmRepositoryResponse) SetRetainRepoVersionsNil() {
	o.RetainRepoVersions.Set(nil)
}

// UnsetRetainRepoVersions ensures that no value is present for RetainRepoVersions, not even an explicit nil
func (o *RpmRpmRepositoryResponse) UnsetRetainRepoVersions() {
	o.RetainRepoVersions.Unset()
}

// GetRemote returns the Remote field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *RpmRpmRepositoryResponse) GetRemote() string {
	if o == nil || IsNil(o.Remote.Get()) {
		var ret string
		return ret
	}
	return *o.Remote.Get()
}

// GetRemoteOk returns a tuple with the Remote field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmRpmRepositoryResponse) GetRemoteOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Remote.Get(), o.Remote.IsSet()
}

// HasRemote returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasRemote() bool {
	if o != nil && o.Remote.IsSet() {
		return true
	}

	return false
}

// SetRemote gets a reference to the given NullableString and assigns it to the Remote field.
func (o *RpmRpmRepositoryResponse) SetRemote(v string) {
	o.Remote.Set(&v)
}
// SetRemoteNil sets the value for Remote to be an explicit nil
func (o *RpmRpmRepositoryResponse) SetRemoteNil() {
	o.Remote.Set(nil)
}

// UnsetRemote ensures that no value is present for Remote, not even an explicit nil
func (o *RpmRpmRepositoryResponse) UnsetRemote() {
	o.Remote.Unset()
}

// GetAutopublish returns the Autopublish field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetAutopublish() bool {
	if o == nil || IsNil(o.Autopublish) {
		var ret bool
		return ret
	}
	return *o.Autopublish
}

// GetAutopublishOk returns a tuple with the Autopublish field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetAutopublishOk() (*bool, bool) {
	if o == nil || IsNil(o.Autopublish) {
		return nil, false
	}
	return o.Autopublish, true
}

// HasAutopublish returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasAutopublish() bool {
	if o != nil && !IsNil(o.Autopublish) {
		return true
	}

	return false
}

// SetAutopublish gets a reference to the given bool and assigns it to the Autopublish field.
func (o *RpmRpmRepositoryResponse) SetAutopublish(v bool) {
	o.Autopublish = &v
}

// GetMetadataSigningService returns the MetadataSigningService field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *RpmRpmRepositoryResponse) GetMetadataSigningService() string {
	if o == nil || IsNil(o.MetadataSigningService.Get()) {
		var ret string
		return ret
	}
	return *o.MetadataSigningService.Get()
}

// GetMetadataSigningServiceOk returns a tuple with the MetadataSigningService field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmRpmRepositoryResponse) GetMetadataSigningServiceOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.MetadataSigningService.Get(), o.MetadataSigningService.IsSet()
}

// HasMetadataSigningService returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasMetadataSigningService() bool {
	if o != nil && o.MetadataSigningService.IsSet() {
		return true
	}

	return false
}

// SetMetadataSigningService gets a reference to the given NullableString and assigns it to the MetadataSigningService field.
func (o *RpmRpmRepositoryResponse) SetMetadataSigningService(v string) {
	o.MetadataSigningService.Set(&v)
}
// SetMetadataSigningServiceNil sets the value for MetadataSigningService to be an explicit nil
func (o *RpmRpmRepositoryResponse) SetMetadataSigningServiceNil() {
	o.MetadataSigningService.Set(nil)
}

// UnsetMetadataSigningService ensures that no value is present for MetadataSigningService, not even an explicit nil
func (o *RpmRpmRepositoryResponse) UnsetMetadataSigningService() {
	o.MetadataSigningService.Unset()
}

// GetRetainPackageVersions returns the RetainPackageVersions field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetRetainPackageVersions() int64 {
	if o == nil || IsNil(o.RetainPackageVersions) {
		var ret int64
		return ret
	}
	return *o.RetainPackageVersions
}

// GetRetainPackageVersionsOk returns a tuple with the RetainPackageVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetRetainPackageVersionsOk() (*int64, bool) {
	if o == nil || IsNil(o.RetainPackageVersions) {
		return nil, false
	}
	return o.RetainPackageVersions, true
}

// HasRetainPackageVersions returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasRetainPackageVersions() bool {
	if o != nil && !IsNil(o.RetainPackageVersions) {
		return true
	}

	return false
}

// SetRetainPackageVersions gets a reference to the given int64 and assigns it to the RetainPackageVersions field.
func (o *RpmRpmRepositoryResponse) SetRetainPackageVersions(v int64) {
	o.RetainPackageVersions = &v
}

// GetMetadataChecksumType returns the MetadataChecksumType field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *RpmRpmRepositoryResponse) GetMetadataChecksumType() MetadataChecksumTypeEnum {
	if o == nil || IsNil(o.MetadataChecksumType.Get()) {
		var ret MetadataChecksumTypeEnum
		return ret
	}
	return *o.MetadataChecksumType.Get()
}

// GetMetadataChecksumTypeOk returns a tuple with the MetadataChecksumType field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmRpmRepositoryResponse) GetMetadataChecksumTypeOk() (*MetadataChecksumTypeEnum, bool) {
	if o == nil {
		return nil, false
	}
	return o.MetadataChecksumType.Get(), o.MetadataChecksumType.IsSet()
}

// HasMetadataChecksumType returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasMetadataChecksumType() bool {
	if o != nil && o.MetadataChecksumType.IsSet() {
		return true
	}

	return false
}

// SetMetadataChecksumType gets a reference to the given NullableMetadataChecksumTypeEnum and assigns it to the MetadataChecksumType field.
func (o *RpmRpmRepositoryResponse) SetMetadataChecksumType(v MetadataChecksumTypeEnum) {
	o.MetadataChecksumType.Set(&v)
}
// SetMetadataChecksumTypeNil sets the value for MetadataChecksumType to be an explicit nil
func (o *RpmRpmRepositoryResponse) SetMetadataChecksumTypeNil() {
	o.MetadataChecksumType.Set(nil)
}

// UnsetMetadataChecksumType ensures that no value is present for MetadataChecksumType, not even an explicit nil
func (o *RpmRpmRepositoryResponse) UnsetMetadataChecksumType() {
	o.MetadataChecksumType.Unset()
}

// GetPackageChecksumType returns the PackageChecksumType field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *RpmRpmRepositoryResponse) GetPackageChecksumType() PackageChecksumTypeEnum {
	if o == nil || IsNil(o.PackageChecksumType.Get()) {
		var ret PackageChecksumTypeEnum
		return ret
	}
	return *o.PackageChecksumType.Get()
}

// GetPackageChecksumTypeOk returns a tuple with the PackageChecksumType field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmRpmRepositoryResponse) GetPackageChecksumTypeOk() (*PackageChecksumTypeEnum, bool) {
	if o == nil {
		return nil, false
	}
	return o.PackageChecksumType.Get(), o.PackageChecksumType.IsSet()
}

// HasPackageChecksumType returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasPackageChecksumType() bool {
	if o != nil && o.PackageChecksumType.IsSet() {
		return true
	}

	return false
}

// SetPackageChecksumType gets a reference to the given NullablePackageChecksumTypeEnum and assigns it to the PackageChecksumType field.
func (o *RpmRpmRepositoryResponse) SetPackageChecksumType(v PackageChecksumTypeEnum) {
	o.PackageChecksumType.Set(&v)
}
// SetPackageChecksumTypeNil sets the value for PackageChecksumType to be an explicit nil
func (o *RpmRpmRepositoryResponse) SetPackageChecksumTypeNil() {
	o.PackageChecksumType.Set(nil)
}

// UnsetPackageChecksumType ensures that no value is present for PackageChecksumType, not even an explicit nil
func (o *RpmRpmRepositoryResponse) UnsetPackageChecksumType() {
	o.PackageChecksumType.Unset()
}

// GetGpgcheck returns the Gpgcheck field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetGpgcheck() int64 {
	if o == nil || IsNil(o.Gpgcheck) {
		var ret int64
		return ret
	}
	return *o.Gpgcheck
}

// GetGpgcheckOk returns a tuple with the Gpgcheck field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetGpgcheckOk() (*int64, bool) {
	if o == nil || IsNil(o.Gpgcheck) {
		return nil, false
	}
	return o.Gpgcheck, true
}

// HasGpgcheck returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasGpgcheck() bool {
	if o != nil && !IsNil(o.Gpgcheck) {
		return true
	}

	return false
}

// SetGpgcheck gets a reference to the given int64 and assigns it to the Gpgcheck field.
func (o *RpmRpmRepositoryResponse) SetGpgcheck(v int64) {
	o.Gpgcheck = &v
}

// GetRepoGpgcheck returns the RepoGpgcheck field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetRepoGpgcheck() int64 {
	if o == nil || IsNil(o.RepoGpgcheck) {
		var ret int64
		return ret
	}
	return *o.RepoGpgcheck
}

// GetRepoGpgcheckOk returns a tuple with the RepoGpgcheck field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetRepoGpgcheckOk() (*int64, bool) {
	if o == nil || IsNil(o.RepoGpgcheck) {
		return nil, false
	}
	return o.RepoGpgcheck, true
}

// HasRepoGpgcheck returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasRepoGpgcheck() bool {
	if o != nil && !IsNil(o.RepoGpgcheck) {
		return true
	}

	return false
}

// SetRepoGpgcheck gets a reference to the given int64 and assigns it to the RepoGpgcheck field.
func (o *RpmRpmRepositoryResponse) SetRepoGpgcheck(v int64) {
	o.RepoGpgcheck = &v
}

// GetSqliteMetadata returns the SqliteMetadata field value if set, zero value otherwise.
func (o *RpmRpmRepositoryResponse) GetSqliteMetadata() bool {
	if o == nil || IsNil(o.SqliteMetadata) {
		var ret bool
		return ret
	}
	return *o.SqliteMetadata
}

// GetSqliteMetadataOk returns a tuple with the SqliteMetadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmRepositoryResponse) GetSqliteMetadataOk() (*bool, bool) {
	if o == nil || IsNil(o.SqliteMetadata) {
		return nil, false
	}
	return o.SqliteMetadata, true
}

// HasSqliteMetadata returns a boolean if a field has been set.
func (o *RpmRpmRepositoryResponse) HasSqliteMetadata() bool {
	if o != nil && !IsNil(o.SqliteMetadata) {
		return true
	}

	return false
}

// SetSqliteMetadata gets a reference to the given bool and assigns it to the SqliteMetadata field.
func (o *RpmRpmRepositoryResponse) SetSqliteMetadata(v bool) {
	o.SqliteMetadata = &v
}

func (o RpmRpmRepositoryResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RpmRpmRepositoryResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.VersionsHref) {
		toSerialize["versions_href"] = o.VersionsHref
	}
	if !IsNil(o.PulpLabels) {
		toSerialize["pulp_labels"] = o.PulpLabels
	}
	if !IsNil(o.LatestVersionHref) {
		toSerialize["latest_version_href"] = o.LatestVersionHref
	}
	toSerialize["name"] = o.Name
	if o.Description.IsSet() {
		toSerialize["description"] = o.Description.Get()
	}
	if o.RetainRepoVersions.IsSet() {
		toSerialize["retain_repo_versions"] = o.RetainRepoVersions.Get()
	}
	if o.Remote.IsSet() {
		toSerialize["remote"] = o.Remote.Get()
	}
	if !IsNil(o.Autopublish) {
		toSerialize["autopublish"] = o.Autopublish
	}
	if o.MetadataSigningService.IsSet() {
		toSerialize["metadata_signing_service"] = o.MetadataSigningService.Get()
	}
	if !IsNil(o.RetainPackageVersions) {
		toSerialize["retain_package_versions"] = o.RetainPackageVersions
	}
	if o.MetadataChecksumType.IsSet() {
		toSerialize["metadata_checksum_type"] = o.MetadataChecksumType.Get()
	}
	if o.PackageChecksumType.IsSet() {
		toSerialize["package_checksum_type"] = o.PackageChecksumType.Get()
	}
	if !IsNil(o.Gpgcheck) {
		toSerialize["gpgcheck"] = o.Gpgcheck
	}
	if !IsNil(o.RepoGpgcheck) {
		toSerialize["repo_gpgcheck"] = o.RepoGpgcheck
	}
	if !IsNil(o.SqliteMetadata) {
		toSerialize["sqlite_metadata"] = o.SqliteMetadata
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RpmRpmRepositoryResponse) UnmarshalJSON(bytes []byte) (err error) {
	varRpmRpmRepositoryResponse := _RpmRpmRepositoryResponse{}

	if err = json.Unmarshal(bytes, &varRpmRpmRepositoryResponse); err == nil {
		*o = RpmRpmRepositoryResponse(varRpmRpmRepositoryResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "versions_href")
		delete(additionalProperties, "pulp_labels")
		delete(additionalProperties, "latest_version_href")
		delete(additionalProperties, "name")
		delete(additionalProperties, "description")
		delete(additionalProperties, "retain_repo_versions")
		delete(additionalProperties, "remote")
		delete(additionalProperties, "autopublish")
		delete(additionalProperties, "metadata_signing_service")
		delete(additionalProperties, "retain_package_versions")
		delete(additionalProperties, "metadata_checksum_type")
		delete(additionalProperties, "package_checksum_type")
		delete(additionalProperties, "gpgcheck")
		delete(additionalProperties, "repo_gpgcheck")
		delete(additionalProperties, "sqlite_metadata")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRpmRpmRepositoryResponse struct {
	value *RpmRpmRepositoryResponse
	isSet bool
}

func (v NullableRpmRpmRepositoryResponse) Get() *RpmRpmRepositoryResponse {
	return v.value
}

func (v *NullableRpmRpmRepositoryResponse) Set(val *RpmRpmRepositoryResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableRpmRpmRepositoryResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableRpmRpmRepositoryResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRpmRpmRepositoryResponse(val *RpmRpmRepositoryResponse) *NullableRpmRpmRepositoryResponse {
	return &NullableRpmRpmRepositoryResponse{value: val, isSet: true}
}

func (v NullableRpmRpmRepositoryResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRpmRpmRepositoryResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


