/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the DebAptPublicationResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DebAptPublicationResponse{}

// DebAptPublicationResponse A Serializer for AptPublication.
type DebAptPublicationResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	RepositoryVersion *string `json:"repository_version,omitempty"`
	// A URI of the repository to be published.
	Repository *string `json:"repository,omitempty"`
	// Activate simple publishing mode (all packages in one release component).
	Simple *bool `json:"simple,omitempty"`
	// Activate structured publishing mode.
	Structured *bool `json:"structured,omitempty"`
	// Sign Release files with this signing key
	SigningService *string `json:"signing_service,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _DebAptPublicationResponse DebAptPublicationResponse

// NewDebAptPublicationResponse instantiates a new DebAptPublicationResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDebAptPublicationResponse() *DebAptPublicationResponse {
	this := DebAptPublicationResponse{}
	var simple bool = false
	this.Simple = &simple
	var structured bool = false
	this.Structured = &structured
	return &this
}

// NewDebAptPublicationResponseWithDefaults instantiates a new DebAptPublicationResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDebAptPublicationResponseWithDefaults() *DebAptPublicationResponse {
	this := DebAptPublicationResponse{}
	var simple bool = false
	this.Simple = &simple
	var structured bool = false
	this.Structured = &structured
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *DebAptPublicationResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublicationResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *DebAptPublicationResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *DebAptPublicationResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *DebAptPublicationResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublicationResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *DebAptPublicationResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *DebAptPublicationResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetRepositoryVersion returns the RepositoryVersion field value if set, zero value otherwise.
func (o *DebAptPublicationResponse) GetRepositoryVersion() string {
	if o == nil || IsNil(o.RepositoryVersion) {
		var ret string
		return ret
	}
	return *o.RepositoryVersion
}

// GetRepositoryVersionOk returns a tuple with the RepositoryVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublicationResponse) GetRepositoryVersionOk() (*string, bool) {
	if o == nil || IsNil(o.RepositoryVersion) {
		return nil, false
	}
	return o.RepositoryVersion, true
}

// HasRepositoryVersion returns a boolean if a field has been set.
func (o *DebAptPublicationResponse) HasRepositoryVersion() bool {
	if o != nil && !IsNil(o.RepositoryVersion) {
		return true
	}

	return false
}

// SetRepositoryVersion gets a reference to the given string and assigns it to the RepositoryVersion field.
func (o *DebAptPublicationResponse) SetRepositoryVersion(v string) {
	o.RepositoryVersion = &v
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *DebAptPublicationResponse) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublicationResponse) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *DebAptPublicationResponse) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *DebAptPublicationResponse) SetRepository(v string) {
	o.Repository = &v
}

// GetSimple returns the Simple field value if set, zero value otherwise.
func (o *DebAptPublicationResponse) GetSimple() bool {
	if o == nil || IsNil(o.Simple) {
		var ret bool
		return ret
	}
	return *o.Simple
}

// GetSimpleOk returns a tuple with the Simple field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublicationResponse) GetSimpleOk() (*bool, bool) {
	if o == nil || IsNil(o.Simple) {
		return nil, false
	}
	return o.Simple, true
}

// HasSimple returns a boolean if a field has been set.
func (o *DebAptPublicationResponse) HasSimple() bool {
	if o != nil && !IsNil(o.Simple) {
		return true
	}

	return false
}

// SetSimple gets a reference to the given bool and assigns it to the Simple field.
func (o *DebAptPublicationResponse) SetSimple(v bool) {
	o.Simple = &v
}

// GetStructured returns the Structured field value if set, zero value otherwise.
func (o *DebAptPublicationResponse) GetStructured() bool {
	if o == nil || IsNil(o.Structured) {
		var ret bool
		return ret
	}
	return *o.Structured
}

// GetStructuredOk returns a tuple with the Structured field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublicationResponse) GetStructuredOk() (*bool, bool) {
	if o == nil || IsNil(o.Structured) {
		return nil, false
	}
	return o.Structured, true
}

// HasStructured returns a boolean if a field has been set.
func (o *DebAptPublicationResponse) HasStructured() bool {
	if o != nil && !IsNil(o.Structured) {
		return true
	}

	return false
}

// SetStructured gets a reference to the given bool and assigns it to the Structured field.
func (o *DebAptPublicationResponse) SetStructured(v bool) {
	o.Structured = &v
}

// GetSigningService returns the SigningService field value if set, zero value otherwise.
func (o *DebAptPublicationResponse) GetSigningService() string {
	if o == nil || IsNil(o.SigningService) {
		var ret string
		return ret
	}
	return *o.SigningService
}

// GetSigningServiceOk returns a tuple with the SigningService field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublicationResponse) GetSigningServiceOk() (*string, bool) {
	if o == nil || IsNil(o.SigningService) {
		return nil, false
	}
	return o.SigningService, true
}

// HasSigningService returns a boolean if a field has been set.
func (o *DebAptPublicationResponse) HasSigningService() bool {
	if o != nil && !IsNil(o.SigningService) {
		return true
	}

	return false
}

// SetSigningService gets a reference to the given string and assigns it to the SigningService field.
func (o *DebAptPublicationResponse) SetSigningService(v string) {
	o.SigningService = &v
}

func (o DebAptPublicationResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DebAptPublicationResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.RepositoryVersion) {
		toSerialize["repository_version"] = o.RepositoryVersion
	}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	if !IsNil(o.Simple) {
		toSerialize["simple"] = o.Simple
	}
	if !IsNil(o.Structured) {
		toSerialize["structured"] = o.Structured
	}
	if !IsNil(o.SigningService) {
		toSerialize["signing_service"] = o.SigningService
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *DebAptPublicationResponse) UnmarshalJSON(bytes []byte) (err error) {
	varDebAptPublicationResponse := _DebAptPublicationResponse{}

	if err = json.Unmarshal(bytes, &varDebAptPublicationResponse); err == nil {
		*o = DebAptPublicationResponse(varDebAptPublicationResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "repository_version")
		delete(additionalProperties, "repository")
		delete(additionalProperties, "simple")
		delete(additionalProperties, "structured")
		delete(additionalProperties, "signing_service")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableDebAptPublicationResponse struct {
	value *DebAptPublicationResponse
	isSet bool
}

func (v NullableDebAptPublicationResponse) Get() *DebAptPublicationResponse {
	return v.value
}

func (v *NullableDebAptPublicationResponse) Set(val *DebAptPublicationResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableDebAptPublicationResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableDebAptPublicationResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDebAptPublicationResponse(val *DebAptPublicationResponse) *NullableDebAptPublicationResponse {
	return &NullableDebAptPublicationResponse{value: val, isSet: true}
}

func (v NullableDebAptPublicationResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDebAptPublicationResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


