/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"os"
	"time"
	"reflect"
)


// RemotesPythonAPIService RemotesPythonAPI service
type RemotesPythonAPIService service

type RemotesPythonAPIRemotesPythonPythonCreateRequest struct {
	ctx context.Context
	ApiService *RemotesPythonAPIService
	pythonPythonRemote *PythonPythonRemote
}

func (r RemotesPythonAPIRemotesPythonPythonCreateRequest) PythonPythonRemote(pythonPythonRemote PythonPythonRemote) RemotesPythonAPIRemotesPythonPythonCreateRequest {
	r.pythonPythonRemote = &pythonPythonRemote
	return r
}

func (r RemotesPythonAPIRemotesPythonPythonCreateRequest) Execute() (*PythonPythonRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesPythonPythonCreateExecute(r)
}

/*
RemotesPythonPythonCreate Create a python remote


Python Remotes are representations of an external repository of Python content, eg.
PyPI.  Fields include upstream repository config. Python Remotes are also used to `sync` from
upstream repositories, and contains sync settings.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesPythonAPIRemotesPythonPythonCreateRequest
*/
func (a *RemotesPythonAPIService) RemotesPythonPythonCreate(ctx context.Context) RemotesPythonAPIRemotesPythonPythonCreateRequest {
	return RemotesPythonAPIRemotesPythonPythonCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PythonPythonRemoteResponse
func (a *RemotesPythonAPIService) RemotesPythonPythonCreateExecute(r RemotesPythonAPIRemotesPythonPythonCreateRequest) (*PythonPythonRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PythonPythonRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesPythonAPIService.RemotesPythonPythonCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/python/python/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.pythonPythonRemote == nil {
		return localVarReturnValue, nil, reportError("pythonPythonRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.pythonPythonRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesPythonAPIRemotesPythonPythonDeleteRequest struct {
	ctx context.Context
	ApiService *RemotesPythonAPIService
	pythonPythonRemoteHref string
}

func (r RemotesPythonAPIRemotesPythonPythonDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesPythonPythonDeleteExecute(r)
}

/*
RemotesPythonPythonDelete Delete a python remote

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRemoteHref
 @return RemotesPythonAPIRemotesPythonPythonDeleteRequest
*/
func (a *RemotesPythonAPIService) RemotesPythonPythonDelete(ctx context.Context, pythonPythonRemoteHref string) RemotesPythonAPIRemotesPythonPythonDeleteRequest {
	return RemotesPythonAPIRemotesPythonPythonDeleteRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRemoteHref: pythonPythonRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesPythonAPIService) RemotesPythonPythonDeleteExecute(r RemotesPythonAPIRemotesPythonPythonDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesPythonAPIService.RemotesPythonPythonDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_remote_href"+"}", parameterValueToString(r.pythonPythonRemoteHref, "pythonPythonRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest struct {
	ctx context.Context
	ApiService *RemotesPythonAPIService
	config *os.File
	name *string
	policy *Policy762Enum
}

// A Bandersnatch config that may be used to construct a Python Remote.
func (r RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest) Config(config *os.File) RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest {
	r.config = config
	return r
}

// A unique name for this remote
func (r RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest) Name(name string) RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest {
	r.name = &name
	return r
}

func (r RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest) Policy(policy Policy762Enum) RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest {
	r.policy = &policy
	return r
}

func (r RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest) Execute() (*PythonPythonRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesPythonPythonFromBandersnatchExecute(r)
}

/*
RemotesPythonPythonFromBandersnatch Create from Bandersnatch


Takes the fields specified in the Bandersnatch config and creates a Python Remote from it.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest
*/
func (a *RemotesPythonAPIService) RemotesPythonPythonFromBandersnatch(ctx context.Context) RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest {
	return RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PythonPythonRemoteResponse
func (a *RemotesPythonAPIService) RemotesPythonPythonFromBandersnatchExecute(r RemotesPythonAPIRemotesPythonPythonFromBandersnatchRequest) (*PythonPythonRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PythonPythonRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesPythonAPIService.RemotesPythonPythonFromBandersnatch")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/python/python/from_bandersnatch/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.config == nil {
		return localVarReturnValue, nil, reportError("config is required and must be specified")
	}
	if r.name == nil {
		return localVarReturnValue, nil, reportError("name is required and must be specified")
	}
	if strlen(*r.name) < 1 {
		return localVarReturnValue, nil, reportError("name must have at least 1 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	var configLocalVarFormFileName string
	var configLocalVarFileName     string
	var configLocalVarFileBytes    []byte

	configLocalVarFormFileName = "config"


	configLocalVarFile := r.config

	if configLocalVarFile != nil {
		fbs, _ := io.ReadAll(configLocalVarFile)

		configLocalVarFileBytes = fbs
		configLocalVarFileName = configLocalVarFile.Name()
		configLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: configLocalVarFileBytes, fileName: configLocalVarFileName, formFileName: configLocalVarFormFileName})
	}
	parameterAddToHeaderOrQuery(localVarFormParams, "name", r.name, "")
	if r.policy != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "policy", r.policy, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesPythonAPIRemotesPythonPythonListRequest struct {
	ctx context.Context
	ApiService *RemotesPythonAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	pulpLastUpdated *time.Time
	pulpLastUpdatedGt *time.Time
	pulpLastUpdatedGte *time.Time
	pulpLastUpdatedLt *time.Time
	pulpLastUpdatedLte *time.Time
	pulpLastUpdatedRange *[]time.Time
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r RemotesPythonAPIRemotesPythonPythonListRequest) Limit(limit int32) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RemotesPythonAPIRemotesPythonPythonListRequest) Name(name string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RemotesPythonAPIRemotesPythonPythonListRequest) NameContains(nameContains string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RemotesPythonAPIRemotesPythonPythonListRequest) NameIcontains(nameIcontains string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RemotesPythonAPIRemotesPythonPythonListRequest) NameIn(nameIn []string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RemotesPythonAPIRemotesPythonPythonListRequest) NameStartswith(nameStartswith string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RemotesPythonAPIRemotesPythonPythonListRequest) Offset(offset int32) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;url&#x60; - Url * &#x60;-url&#x60; - Url (descending) * &#x60;ca_cert&#x60; - Ca cert * &#x60;-ca_cert&#x60; - Ca cert (descending) * &#x60;client_cert&#x60; - Client cert * &#x60;-client_cert&#x60; - Client cert (descending) * &#x60;client_key&#x60; - Client key * &#x60;-client_key&#x60; - Client key (descending) * &#x60;tls_validation&#x60; - Tls validation * &#x60;-tls_validation&#x60; - Tls validation (descending) * &#x60;username&#x60; - Username * &#x60;-username&#x60; - Username (descending) * &#x60;password&#x60; - Password * &#x60;-password&#x60; - Password (descending) * &#x60;proxy_url&#x60; - Proxy url * &#x60;-proxy_url&#x60; - Proxy url (descending) * &#x60;proxy_username&#x60; - Proxy username * &#x60;-proxy_username&#x60; - Proxy username (descending) * &#x60;proxy_password&#x60; - Proxy password * &#x60;-proxy_password&#x60; - Proxy password (descending) * &#x60;download_concurrency&#x60; - Download concurrency * &#x60;-download_concurrency&#x60; - Download concurrency (descending) * &#x60;max_retries&#x60; - Max retries * &#x60;-max_retries&#x60; - Max retries (descending) * &#x60;policy&#x60; - Policy * &#x60;-policy&#x60; - Policy (descending) * &#x60;total_timeout&#x60; - Total timeout * &#x60;-total_timeout&#x60; - Total timeout (descending) * &#x60;connect_timeout&#x60; - Connect timeout * &#x60;-connect_timeout&#x60; - Connect timeout (descending) * &#x60;sock_connect_timeout&#x60; - Sock connect timeout * &#x60;-sock_connect_timeout&#x60; - Sock connect timeout (descending) * &#x60;sock_read_timeout&#x60; - Sock read timeout * &#x60;-sock_read_timeout&#x60; - Sock read timeout (descending) * &#x60;headers&#x60; - Headers * &#x60;-headers&#x60; - Headers (descending) * &#x60;rate_limit&#x60; - Rate limit * &#x60;-rate_limit&#x60; - Rate limit (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RemotesPythonAPIRemotesPythonPythonListRequest) Ordering(ordering []string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RemotesPythonAPIRemotesPythonPythonListRequest) PulpHrefIn(pulpHrefIn []string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RemotesPythonAPIRemotesPythonPythonListRequest) PulpIdIn(pulpIdIn []string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RemotesPythonAPIRemotesPythonPythonListRequest) PulpLabelSelect(pulpLabelSelect string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where pulp_last_updated matches value
func (r RemotesPythonAPIRemotesPythonPythonListRequest) PulpLastUpdated(pulpLastUpdated time.Time) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.pulpLastUpdated = &pulpLastUpdated
	return r
}

// Filter results where pulp_last_updated is greater than value
func (r RemotesPythonAPIRemotesPythonPythonListRequest) PulpLastUpdatedGt(pulpLastUpdatedGt time.Time) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.pulpLastUpdatedGt = &pulpLastUpdatedGt
	return r
}

// Filter results where pulp_last_updated is greater than or equal to value
func (r RemotesPythonAPIRemotesPythonPythonListRequest) PulpLastUpdatedGte(pulpLastUpdatedGte time.Time) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.pulpLastUpdatedGte = &pulpLastUpdatedGte
	return r
}

// Filter results where pulp_last_updated is less than value
func (r RemotesPythonAPIRemotesPythonPythonListRequest) PulpLastUpdatedLt(pulpLastUpdatedLt time.Time) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.pulpLastUpdatedLt = &pulpLastUpdatedLt
	return r
}

// Filter results where pulp_last_updated is less than or equal to value
func (r RemotesPythonAPIRemotesPythonPythonListRequest) PulpLastUpdatedLte(pulpLastUpdatedLte time.Time) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.pulpLastUpdatedLte = &pulpLastUpdatedLte
	return r
}

// Filter results where pulp_last_updated is between two comma separated values
func (r RemotesPythonAPIRemotesPythonPythonListRequest) PulpLastUpdatedRange(pulpLastUpdatedRange []time.Time) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.pulpLastUpdatedRange = &pulpLastUpdatedRange
	return r
}

// A list of fields to include in the response.
func (r RemotesPythonAPIRemotesPythonPythonListRequest) Fields(fields []string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesPythonAPIRemotesPythonPythonListRequest) ExcludeFields(excludeFields []string) RemotesPythonAPIRemotesPythonPythonListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesPythonAPIRemotesPythonPythonListRequest) Execute() (*PaginatedpythonPythonRemoteResponseList, *http.Response, error) {
	return r.ApiService.RemotesPythonPythonListExecute(r)
}

/*
RemotesPythonPythonList List python remotes


Python Remotes are representations of an external repository of Python content, eg.
PyPI.  Fields include upstream repository config. Python Remotes are also used to `sync` from
upstream repositories, and contains sync settings.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesPythonAPIRemotesPythonPythonListRequest
*/
func (a *RemotesPythonAPIService) RemotesPythonPythonList(ctx context.Context) RemotesPythonAPIRemotesPythonPythonListRequest {
	return RemotesPythonAPIRemotesPythonPythonListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedpythonPythonRemoteResponseList
func (a *RemotesPythonAPIService) RemotesPythonPythonListExecute(r RemotesPythonAPIRemotesPythonPythonListRequest) (*PaginatedpythonPythonRemoteResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedpythonPythonRemoteResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesPythonAPIService.RemotesPythonPythonList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/python/python/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.pulpLastUpdated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated", r.pulpLastUpdated, "")
	}
	if r.pulpLastUpdatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gt", r.pulpLastUpdatedGt, "")
	}
	if r.pulpLastUpdatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gte", r.pulpLastUpdatedGte, "")
	}
	if r.pulpLastUpdatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lt", r.pulpLastUpdatedLt, "")
	}
	if r.pulpLastUpdatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lte", r.pulpLastUpdatedLte, "")
	}
	if r.pulpLastUpdatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__range", r.pulpLastUpdatedRange, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesPythonAPIRemotesPythonPythonPartialUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesPythonAPIService
	pythonPythonRemoteHref string
	patchedpythonPythonRemote *PatchedpythonPythonRemote
}

func (r RemotesPythonAPIRemotesPythonPythonPartialUpdateRequest) PatchedpythonPythonRemote(patchedpythonPythonRemote PatchedpythonPythonRemote) RemotesPythonAPIRemotesPythonPythonPartialUpdateRequest {
	r.patchedpythonPythonRemote = &patchedpythonPythonRemote
	return r
}

func (r RemotesPythonAPIRemotesPythonPythonPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesPythonPythonPartialUpdateExecute(r)
}

/*
RemotesPythonPythonPartialUpdate Update a python remote

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRemoteHref
 @return RemotesPythonAPIRemotesPythonPythonPartialUpdateRequest
*/
func (a *RemotesPythonAPIService) RemotesPythonPythonPartialUpdate(ctx context.Context, pythonPythonRemoteHref string) RemotesPythonAPIRemotesPythonPythonPartialUpdateRequest {
	return RemotesPythonAPIRemotesPythonPythonPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRemoteHref: pythonPythonRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesPythonAPIService) RemotesPythonPythonPartialUpdateExecute(r RemotesPythonAPIRemotesPythonPythonPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesPythonAPIService.RemotesPythonPythonPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_remote_href"+"}", parameterValueToString(r.pythonPythonRemoteHref, "pythonPythonRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedpythonPythonRemote == nil {
		return localVarReturnValue, nil, reportError("patchedpythonPythonRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedpythonPythonRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesPythonAPIRemotesPythonPythonReadRequest struct {
	ctx context.Context
	ApiService *RemotesPythonAPIService
	pythonPythonRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesPythonAPIRemotesPythonPythonReadRequest) Fields(fields []string) RemotesPythonAPIRemotesPythonPythonReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesPythonAPIRemotesPythonPythonReadRequest) ExcludeFields(excludeFields []string) RemotesPythonAPIRemotesPythonPythonReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesPythonAPIRemotesPythonPythonReadRequest) Execute() (*PythonPythonRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesPythonPythonReadExecute(r)
}

/*
RemotesPythonPythonRead Inspect a python remote


Python Remotes are representations of an external repository of Python content, eg.
PyPI.  Fields include upstream repository config. Python Remotes are also used to `sync` from
upstream repositories, and contains sync settings.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRemoteHref
 @return RemotesPythonAPIRemotesPythonPythonReadRequest
*/
func (a *RemotesPythonAPIService) RemotesPythonPythonRead(ctx context.Context, pythonPythonRemoteHref string) RemotesPythonAPIRemotesPythonPythonReadRequest {
	return RemotesPythonAPIRemotesPythonPythonReadRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRemoteHref: pythonPythonRemoteHref,
	}
}

// Execute executes the request
//  @return PythonPythonRemoteResponse
func (a *RemotesPythonAPIService) RemotesPythonPythonReadExecute(r RemotesPythonAPIRemotesPythonPythonReadRequest) (*PythonPythonRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PythonPythonRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesPythonAPIService.RemotesPythonPythonRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_remote_href"+"}", parameterValueToString(r.pythonPythonRemoteHref, "pythonPythonRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesPythonAPIRemotesPythonPythonUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesPythonAPIService
	pythonPythonRemoteHref string
	pythonPythonRemote *PythonPythonRemote
}

func (r RemotesPythonAPIRemotesPythonPythonUpdateRequest) PythonPythonRemote(pythonPythonRemote PythonPythonRemote) RemotesPythonAPIRemotesPythonPythonUpdateRequest {
	r.pythonPythonRemote = &pythonPythonRemote
	return r
}

func (r RemotesPythonAPIRemotesPythonPythonUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesPythonPythonUpdateExecute(r)
}

/*
RemotesPythonPythonUpdate Update a python remote

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRemoteHref
 @return RemotesPythonAPIRemotesPythonPythonUpdateRequest
*/
func (a *RemotesPythonAPIService) RemotesPythonPythonUpdate(ctx context.Context, pythonPythonRemoteHref string) RemotesPythonAPIRemotesPythonPythonUpdateRequest {
	return RemotesPythonAPIRemotesPythonPythonUpdateRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRemoteHref: pythonPythonRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesPythonAPIService) RemotesPythonPythonUpdateExecute(r RemotesPythonAPIRemotesPythonPythonUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesPythonAPIService.RemotesPythonPythonUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_remote_href"+"}", parameterValueToString(r.pythonPythonRemoteHref, "pythonPythonRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.pythonPythonRemote == nil {
		return localVarReturnValue, nil, reportError("pythonPythonRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.pythonPythonRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
