import React from 'react';
import PropTypes from 'prop-types';

const UilLetterJapaneseA = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M20.47168,11.99707a4.86537,4.86537,0,0,0-4.00049-2.2038A5.59215,5.59215,0,0,0,16.34082,8.769a.9997.9997,0,1,0-1.94531.46192,3.55342,3.55342,0,0,1,.0827.60132,13.57729,13.57729,0,0,0-3.257.82189c.02252-1.20385.07678-2.40728.19672-3.60729l.03827-.38221a33.43522,33.43522,0,0,0,3.48224-.66418l.12011-.02979a1,1,0,1,0-.48047-1.9414l-.12207.03027c-.92163.23047-1.85565.40448-2.79394.5506l.15137-1.51056a1.00009,1.00009,0,0,0-1.99024-.19922L9.627,4.85962C8.69312,4.94336,7.75665,5,6.81836,5a1,1,0,0,0,0,2c.87054,0,1.7395-.04639,2.60681-.1142A46.66015,46.66015,0,0,0,9.222,11.58386c-.13421.07324-.26965.14209-.40264.21936a16.4074,16.4074,0,0,0-1.94922,1.31055l-.02246.01807a13.7396,13.7396,0,0,0-2.64844,2.70068,3.00419,3.00419,0,0,0,2.94629,4.71875A9.74034,9.74034,0,0,0,9.98328,19.5379a.99564.99564,0,0,0,1.82141-.70245c-.02423-.1452-.03534-.29193-.05811-.43732a13.83775,13.83775,0,0,0,1.314-1.15545,13.16694,13.16694,0,0,0,2.10168-2.729c.02289-.03949.04212-.0791.06445-.11865.118-.21057.22944-.422.33179-.63495.05383-.11108.1023-.22174.15155-.33282.05994-.13623.11719-.27222.17047-.40882.05646-.14361.10981-.28662.15845-.42968.03235-.09583.06055-.19123.08948-.28693.05133-.16882.10174-.3371.142-.50427l.005-.01776a3.01462,3.01462,0,0,1,2.46582,1.21972c1.01856,1.76709-.96289,4.977-4.417,7.15479a.99976.99976,0,1,0,1.0664,1.6914C19.88965,19.00977,22.07422,14.77734,20.47168,11.99707ZM6.7959,18.58252a1.00469,1.00469,0,0,1-.97949-1.57373,11.89343,11.89343,0,0,1,2.291-2.32275l.02637-.02149c.35388-.27692.742-.539,1.144-.793.0611,1.19537.17285,2.38684.32593,3.57489A8.18484,8.18484,0,0,1,6.7959,18.58252Zm7.32977-6.583a8.16646,8.16646,0,0,1-.31616.78137c-.0556.1189-.118.23774-.18018.35694q-.14419.27851-.3106.55432c-.08466.13953-.17188.27887-.26514.41742a11.48078,11.48078,0,0,1-1.40711,1.719c-.06982.06983-.14343.1333-.2146.201q-.16314-1.5975-.21124-3.20276a12.51276,12.51276,0,0,1,2.94-.93237C14.149,11.9295,14.13794,11.96436,14.12567,11.99951Z'
  }));
};

UilLetterJapaneseA.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilLetterJapaneseA.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilLetterJapaneseA;