import { FormattedValue } from '../valueFormats';
export declare type DisplayProcessor = (value: any) => DisplayValue;
export interface DisplayValue extends FormattedValue {
    /**
     *  Use isNaN to check if it is a real number
     */
    numeric: number;
    /**
     *  0-1 between min & max
     */
    percent?: number;
    /**
     *  Color based on configs or Threshold
     */
    color?: string;
    title?: string;
}
/**
 * Explicit control for text settings
 */
export interface TextDisplayOptions {
    titleSize?: number;
    valueSize?: number;
}
/**
 * These represents the display value with the longest title and text.
 * Used to align widths and heights when displaying multiple DisplayValues
 */
export interface DisplayValueAlignmentFactors extends FormattedValue {
    title: string;
}
export declare type DecimalCount = number | null | undefined;
export interface DecimalInfo {
    decimals: DecimalCount;
    scaledDecimals: DecimalCount;
}
