/** BEGIN COPYRIGHT BLOCK
 * This Program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; version 2 of the License.
 *
 * This Program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this Program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 * END COPYRIGHT BLOCK **/

#ifndef RH_COOLKEY_H 
#define RH_COOLKEY_H
#include <list>
#include "nspr.h"
#include "prio.h"
#include "ssl.h"
#include "pk11func.h"
#include "cert.h"
#include "sslerr.h"
#include "secerr.h"
#include "sechash.h"

#include "CoolKey.h"

typedef enum {
  eAKS_Unavailable = 0,             // Key is not present.
  eAKS_AppletNotFound,              // Key has a matching ATR but no applet.
  eAKS_Uninitialized,               // Key has an applet, but no certs.
  eAKS_Unknown,                     // We're confused.
  eAKS_Available,                   // Key has either a Phase 1 or Phase 2 cert.
  eAKS_EnrollmentInProgress,        // Key is undergoing enrollment.
  eAKS_UnblockInProgress,           // Key is processing an unblock request.
  eAKS_PINResetInProgress,          // Key is undergoing a PIN reset.
  eAKS_RenewInProgress,             // Key is undergoing certificate renewal
  eAKS_FormatInProgress,            // Key is being reformated.
  eAKS_BlinkInProgress              // Key is blinking.
} CoolKeyStatus;


using namespace std;

class CoolKeyNode
{
  public:

  CoolKeyNode(unsigned long aKeyType, const char * aKeyID, CoolKeyStatus aStatus) {
    mKeyType = aKeyType;
    mKeyID   =  PL_strdup((char *)aKeyID);
    mStatus  = aStatus;
    mPin     = "";
  }

  ~CoolKeyNode() {
      if(mKeyID) {
          PL_strfree((char *)mKeyID);
          mKeyID = NULL;
      }
  }

  unsigned long mKeyType;
  const char* mKeyID;
  CoolKeyStatus mStatus;
  const char* mPin;
};

class rhCoolKey
{
public:

    rhCoolKey(const char* dbDir);

    void ShutDownInstance();
    ~rhCoolKey();
public:
    static void RegisterCoolKeyListener(CoolKeyListener *listener);
    static HRESULT Dispatch( CoolKeyListener *listener,
    unsigned long keyType, const char *keyID, unsigned long keyState,
    unsigned long data, const char *strData);
    static HRESULT Reference( CoolKeyListener *listener );
    static HRESULT Release( CoolKeyListener *listener );

    static HRESULT doSetCoolKeyConfigValue(const char *aName, const char *aValue); 
    static const char *doGetCoolKeyConfigValue(const char *aName );
    static SECStatus badCertHandler(void *arg, PRFileDesc *fd);

    //API

    HRESULT RhNotifyKeyStateChange(PRUint32 aKeyType,const char *aKeyID, PRUint32 aKeyState, PRUint32 aData,const char* strData);
    HRESULT CoolKeyInitializeLog(const char *aPathName, PRUint32 aMaxLines);
    HRESULT CoolKeyLogMsg(unsigned int aLogLevel, const char *aMessage);
    HRESULT BlinkCoolKey(PRUint32 aKeyType, const char *aKeyID, PRUint32 aRate, PRUint32 aDuration);
    HRESULT EnrollCoolKey(PRUint32 aKeyType, const char *aKeyID, const char *aEnrollmentType, const char *aScreenName, const char *aPin, const char *aScreenNamePWord, const char *aTokenCode);
    HRESULT ResetCoolKeyPIN(PRUint32 aKeyType, const char *aKeyID, const char *aScreenName, const char *aPIN, const char *aScreenNamePwd);
    HRESULT FormatCoolKey(PRUint32 aKeyType, const char *aKeyID, const char *aEnrollmentType, const char *aScreenName, const char *aPIN, const char *aScreenNamePWord, const char *aTokenCode);
    HRESULT CancelCoolKeyOperation(PRUint32 aKeyType, const char *aKeyID);
    HRESULT GetCoolKeyCertNicknames(PRUint32 aKeyType, const char *aKeyID, PRUint32 *count, char ***str);
    HRESULT GetAvailableCoolKeys(PRUint32 *count, char ***str);
    HRESULT GetCoolKeyStatus(PRUint32 aKeyType, const char *aKeyID, PRUint32 *_retval);
    HRESULT GetCoolKeyIsReallyCoolKey(PRUint32 aKeyType, const char *aKeyID, bool *_retval);
    HRESULT GetCoolKeyGetAppletVer(PRUint32 aKeyType, const char *aKeyID, bool aIsMajor, PRInt32 *_retval);
    HRESULT GetCoolKeyIsEnrolled(PRUint32 aKeyType, const char *aKeyID, bool *_retval);
    HRESULT GetCoolKeyCertInfo(PRUint32 aKeyType, const char *aKeyID, const char *aCertNickname, char **aCertInfo);
    HRESULT GetCoolKeyATR(PRUint32 aKeyType, const char *aKeyID, char **_retval);
    HRESULT GetCoolKeyTokenName(PRUint32 aKeyType, const char *aKeyID, char **_retval);
    HRESULT GetCoolKeyIssuerInfo(PRUint32 aKeyType, const char *aKeyID, char **_retval);
    HRESULT GetCoolKeyPolicy(PRUint32 aKeyType, const char *aKeyID, char **policy);
    HRESULT GetCoolKeyUID(PRUint32 aKeyType, const char *aKeyID, char **uid);
    HRESULT GetCoolKeyIssuedTo(PRUint32 aKeyType, const char *aKeyID, char **issuedTo);
    HRESULT GetCoolKeyIssuer(PRUint32 aKeyType, const char *aKeyID, char **issuer);
    HRESULT SetCoolKeyConfigValue(const char *aName, const char *aValue, bool *_retval);
    HRESULT GetCoolKeyConfigValue(const char *aName, char **_retval);
    HRESULT GetCoolKeyRequiresAuthentication(PRUint32 aKeyType, const char *aKeyID, bool *_retval);
    HRESULT GetCoolKeyIsAuthenticated(PRUint32 aKeyType, const char *aKeyID, bool *_retval);
    HRESULT AuthenticateCoolKey(PRUint32 aKeyType, const char *aKeyID, const char *aPIN, bool *_retval);
    HRESULT SetCoolKeyDataValue(PRUint32 aKeyType, const char *aKeyID, const char *name, const char *value);
    HRESULT GetCoolKeyVersion(char **_retval);

    //nsCOMPtr<rhIKeyNotify> mJsNotify;

    static std::list<CoolKeyNode*> gASCAvailableKeys;

    static PRLock* certCBLock;
    static PRLock* eventLock;


    static PRBool      gAutoEnrollBlankTokens;

    //nsCOMPtr<nsISupports> nssComponent;
    PRBool InitInstance(const char* dbDir);

    HRESULT ASCSetCoolKeyPin(unsigned long aKeyType, const char * aKeyID, const char * aPin);
    PRBool ASCCoolKeyIsAvailable(unsigned long aKeyType, char * aKeyID);

    CoolKeyNode* GetCoolKeyInfo(unsigned long aKeyType, const char * aKeyID);
    HRESULT  ASCGetAvailableCoolKeyAt(unsigned long aIndex,
                                            unsigned long *aKeyType,
                                            char **aKeyID);

    int   ASCGetNumAvailableCoolKeys(void);


    void InsertKeyIntoAvailableList(unsigned long aKeyType, const char * aKeyID,
                                       CoolKeyStatus aStatus);

    void RemoveKeyFromAvailableList(unsigned long aKeyType, const char * aKeyID);

    //rhIKeyNotify* GetNotifyKeyListener(rhIKeyNotify *listener);

    //int GetNotifyKeyListenerListSize();
    //void AddNotifyKeyListener(rhIKeyNotify *listener);
    //void RemoveNotifyKeyListener(rhIKeyNotify *listener);
    //void ClearNotifyKeyList();

    void ClearAvailableList();


};
#endif
