/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tenant;

import com.alibaba.tenant.TenantContainer;
import com.alibaba.tenant.TenantGlobals;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

class NativeDispatcher {
    static final String CG_CPU = "cpu";
    static final String CG_CPU_SHARES = "cpu.shares";
    static final String CG_CPU_CFS_QUOTA = "cpu.cfs_quota_us";
    static final String CG_CPU_CFS_PERIOD = "cpu.cfs_period_us";
    static final String CG_CPUSET = "cpuset";
    static final String CG_CPUSET_CPUS = "cpuset.cpus";
    static final String CG_CPUSET_MEMS = "cpuset.mems";
    static final String CG_CPUACCT = "cpuacct";
    static final String CG_TASKS = "tasks";
    static boolean IS_CPU_SHARES_ENABLED = false;
    static boolean IS_CPU_CFS_ENABLED = false;
    static boolean IS_CPUSET_ENABLED = false;
    static boolean IS_CPUACCT_ENABLED = false;
    static String CG_MP_CPU = null;
    static String CG_MP_CPUSET = null;
    static String CG_MP_CPUACCT = null;
    static final boolean CGROUP_INIT_SUCCESS;

    NativeDispatcher() {
    }

    long getProcessId() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(string.split("@")[0]);
    }

    private static native int init0();

    native int createCgroup(String var1);

    native int moveToCgroup(String var1);

    native void attach(TenantContainer var1);

    native void createTenantAllocationContext(TenantContainer var1, long var2);

    native void destroyTenantAllocationContext(long var1);

    native long getTenantOccupiedMemory(long var1);

    native void getThreadsAllocatedMemory(long[] var1, long[] var2);

    native TenantContainer containerOf(Object var1);

    private static native void registerNatives0();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("java");
                return null;
            }
        });
        NativeDispatcher.registerNatives0();
        boolean bl = false;
        if (TenantGlobals.isCpuThrottlingEnabled() || TenantGlobals.isCpuAccountingEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.loadLibrary("jgroup");
                    return null;
                }
            });
            boolean bl2 = bl = 0 == NativeDispatcher.init0();
            if (!bl) {
                throw new RuntimeException("JGroup native dispatcher initialization failed!");
            }
        }
        CGROUP_INIT_SUCCESS = bl;
    }
}

