/* Copyright (c) 2023 Intel Corporation

Copyright 2015 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef ITEX_CORE_UTILS_HOST_INFO_H_
#define ITEX_CORE_UTILS_HOST_INFO_H_

#include <string>

#include "itex/core/utils/types.h"

namespace itex {
namespace port {

// Return the hostname of the machine on which this process is running.
string Hostname();

// Return the job name as a string if it exists, otherwise return an empty
// string.
string JobName();

// Returns the Borg job UID as an int64_t if it exists. Otherwise return -1.
int64_t JobUid();

}  // namespace port
}  // namespace itex

#endif  // ITEX_CORE_UTILS_HOST_INFO_H_
