description: 'Payment Card Industry - Data Security Standard (PCI-DSS) is a set of

    security standards designed to ensure the secure handling of payment card

    data, with the goal of preventing data breaches and protecting sensitive

    financial information.


    This profile ensures Red Hat Enterprise Linux 8 is configured in alignment

    with PCI-DSS v4.0 requirements.'
extends: null
metadata:
    version: '4.0'
    SMEs:
    - marcusburghardt
    - mab879
    - vojtapolasek
reference: https://docs-prv.pcisecuritystandards.org/PCI%20DSS/Standard/PCI-DSS-v4_0.pdf
selections:
- file_permissions_cron_d
- audit_rules_immutable
- auditd_audispd_syslog_plugin_activated
- coredump_disable_backtraces
- file_permissions_user_cfg
- audit_rules_login_events_lastlog
- file_at_deny_not_exist
- file_owner_backup_etc_passwd
- file_owner_cron_hourly
- file_permissions_etc_shadow
- file_owner_grub2_cfg
- set_firewalld_default_zone
- accounts_passwords_pam_faillock_deny
- audit_rules_media_export
- dconf_gnome_screensaver_lock_delay
- file_owner_cron_d
- file_groupowner_backup_etc_group
- file_permissions_grub2_cfg
- audit_rules_usergroup_modification_passwd
- no_files_unowned_by_user
- audit_rules_dac_modification_lremovexattr
- audit_rules_suid_privilege_function
- package_xinetd_removed
- selinux_policytype
- sshd_disable_root_login
- file_groupowner_user_cfg
- sshd_disable_empty_passwords
- accounts_password_pam_unix_remember
- accounts_no_uid_except_zero
- file_owner_cron_daily
- sshd_disable_rhosts
- accounts_tmout
- file_groupowner_cron_hourly
- sshd_set_maxstartups
- selinux_confinement_of_daemons
- sysctl_net_ipv4_conf_default_send_redirects
- audit_rules_time_clock_settime
- package_dhcp_removed
- file_permissions_etc_passwd
- sysctl_net_ipv6_conf_default_accept_source_route
- file_permissions_sshd_private_key
- file_permissions_cron_allow
- audit_rules_dac_modification_fsetxattr
- auditd_data_retention_space_left_action
- enable_authselect
- sysctl_net_ipv4_conf_all_rp_filter
- sshd_use_approved_macs
- gnome_gdm_disable_automatic_login
- sysctl_net_ipv4_conf_default_accept_redirects
- file_groupowner_crontab
- file_permissions_sshd_pub_key
- audit_rules_time_stime
- grub2_audit_argument
- audit_rules_login_events_faillock
- auditd_data_retention_space_left
- file_owner_user_cfg
- kernel_module_dccp_disabled
- sshd_enable_pam
- audit_rules_networkconfig_modification
- set_ip6tables_default_rule
- sysctl_net_ipv4_icmp_ignore_bogus_error_responses
- package_ypserv_removed
- coredump_disable_storage
- dconf_gnome_screensaver_lock_enabled
- disable_host_auth
- audit_rules_dac_modification_fchownat
- file_permissions_etc_group
- file_permissions_unauthorized_world_writable
- bios_enable_execution_restrictions
- sudo_custom_logfile
- file_permissions_cron_weekly
- audit_sudo_log_events
- aide_build_database
- network_sniffer_disabled
- package_nftables_installed
- rsyslog_files_permissions
- sshd_set_login_grace_time
- audit_rules_usergroup_modification_shadow
- file_permissions_at_allow
- audit_rules_file_deletion_events_renameat
- accounts_password_pam_pwhistory_remember_password_auth
- audit_rules_dac_modification_fchmodat
- file_permissions_backup_etc_shadow
- aide_periodic_cron_checking
- package_sudo_installed
- file_group_ownership_var_log_audit
- service_rpcbind_disabled
- service_auditd_enabled
- audit_rules_usergroup_modification_group
- set_password_hashing_algorithm_libuserconf
- dconf_gnome_screensaver_idle_delay
- audit_rules_dac_modification_chown
- accounts_maximum_age_login_defs
- account_disable_post_pw_expiration
- file_owner_etc_shadow
- account_unique_name
- directory_access_var_log_audit
- file_owner_cron_weekly
- file_groupowner_cron_weekly
- no_direct_root_logins
- security_patches_up_to_date
- file_groupowner_grub2_cfg
- audit_rules_file_deletion_events_rename
- audit_rules_file_deletion_events_rmdir
- accounts_password_pam_lcredit
- file_groupowner_cron_d
- audit_rules_file_deletion_events_unlinkat
- file_groupowner_etc_shadow
- file_permissions_var_log_audit
- package_logrotate_installed
- file_owner_backup_etc_shadow
- file_ownership_var_log_audit
- display_login_attempts
- sshd_limit_user_access
- no_shelllogin_for_systemaccounts
- accounts_password_set_max_life_existing
- package_ypbind_removed
- file_owner_backup_etc_group
- package_telnet-server_removed
- package_chrony_installed
- package_tftp_removed
- sysctl_net_ipv4_conf_all_secure_redirects
- service_nftables_disabled
- sysctl_net_ipv4_ip_forward
- kernel_module_sctp_disabled
- audit_rules_time_adjtimex
- package_aide_installed
- file_groupowner_etc_issue_net
- configure_firewalld_ports
- audit_rules_dac_modification_lsetxattr
- chronyd_run_as_chrony_user
- ensure_gpgcheck_never_disabled
- file_owner_crontab
- file_permissions_backup_etc_passwd
- audit_rules_dac_modification_fremovexattr
- file_owner_etc_group
- sshd_set_idle_timeout
- configure_ssh_crypto_policy
- no_password_auth_for_systemaccounts
- file_owner_cron_monthly
- set_password_hashing_algorithm_logindefs
- ensure_gpgcheck_globally_activated
- audit_rules_dac_modification_removexattr
- file_groupowner_backup_etc_passwd
- sshd_disable_x11_forwarding
- kernel_module_usb-storage_disabled
- audit_rules_usergroup_modification_gshadow
- audit_rules_mac_modification
- ensure_redhat_gpgkey_installed
- file_groupowner_backup_etc_shadow
- firewalld_loopback_traffic_trusted
- grub2_audit_backlog_limit_argument
- sshd_use_strong_kex
- accounts_password_all_shadowed
- sshd_set_max_auth_tries
- audit_rules_session_events
- ensure_pam_wheel_group_empty
- sysctl_net_ipv4_tcp_syncookies
- audit_rules_time_watch_localtime
- file_owner_cron_allow
- configure_crypto_policy
- sshd_disable_tcp_forwarding
- audit_rules_dac_modification_fchown
- dconf_db_up_to_date
- package_tftp-server_removed
- audit_rules_dac_modification_lchown
- firewalld_loopback_traffic_restricted
- sudo_require_authentication
- package_libselinux_installed
- use_pam_wheel_group_for_su
- wireless_disable_interfaces
- file_permissions_backup_etc_group
- package_audit_installed
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts
- accounts_password_set_warn_age_existing
- account_unique_id
- file_cron_deny_not_exist
- file_permissions_cron_daily
- rsyslog_files_groupownership
- disable_users_coredumps
- sudo_require_reauthentication
- accounts_password_pam_minlen
- sysctl_fs_suid_dumpable
- package_audispd-plugins_installed
- accounts_passwords_pam_faillock_unlock_time
- audit_rules_dac_modification_fchmod
- audit_rules_file_deletion_events_unlink
- dconf_gnome_screensaver_mode_blank
- service_avahi-daemon_disabled
- sshd_do_not_permit_user_env
- dir_perms_world_writable_sticky_bits
- set_password_hashing_algorithm_systemauth
- rsyslog_files_ownership
- postfix_network_listening_disabled
- service_firewalld_enabled
- audit_rules_dac_modification_chmod
- accounts_password_pam_pwhistory_remember_system_auth
- file_groupowner_etc_passwd
- no_empty_passwords
- file_permissions_ungroupowned
- auditd_name_format
- install_PAE_kernel_on_x86-32
- accounts_password_warn_age_login_defs
- ensure_root_password_configured
- selinux_state
- file_groupowner_cron_allow
- sshd_use_approved_ciphers
- audit_rules_login_events_tallylog
- network_nmcli_permissions
- sshd_set_loglevel_verbose
- gnome_gdm_disable_guest_login
- group_unique_name
- sysctl_kernel_core_pattern
- sshd_set_keepalive
- file_permissions_cron_monthly
- dconf_gnome_disable_automount_open
- dconf_gnome_disable_automount
- chronyd_specify_remote_server
- file_groupowner_etc_group
- file_groupowner_cron_daily
- dconf_gnome_screensaver_idle_activation_enabled
- file_owner_etc_passwd
- package_ftp_removed
- audit_rules_sysadmin_actions
- file_groupowner_cron_monthly
- file_permissions_sshd_config
- audit_rules_time_settimeofday
- securetty_root_login_console_only
- file_permissions_etc_issue_net
- accounts_password_last_change_is_in_past
- gid_passwd_group_same
- rpm_verify_ownership
- accounts_password_pam_dcredit
- service_rsyncd_disabled
- accounts_root_gid_zero
- grub2_enable_selinux
- package_net-snmp_removed
- sshd_set_max_sessions
- sudo_add_use_pty
- file_groupowner_at_allow
- group_unique_id
- package_telnet_removed
- audit_rules_dac_modification_setxattr
- no_empty_passwords_etc_shadow
- file_owner_etc_issue_net
- accounts_set_post_pw_existing
- sysctl_net_ipv4_conf_all_send_redirects
- rpm_verify_hashes
- audit_rules_usergroup_modification_opasswd
- dconf_gnome_session_idle_user_locks
- file_permissions_crontab
- auditd_data_retention_admin_space_left_action
- file_permissions_cron_hourly
- service_chronyd_or_ntpd_enabled
- sysctl_kernel_randomize_va_space
- var_multiple_time_servers=generic
- var_auditd_admin_space_left_action=single
- var_auditd_space_left=100MB
- var_auditd_space_left_action=email
- var_auditd_name_format=fqd
- var_accounts_maximum_age_login_defs=90
- var_accounts_password_warn_age_login_defs=7
- var_password_pam_unix_remember=4
- var_password_pam_remember=4
- var_password_pam_remember_control_flag=requisite_or_required
- var_password_pam_dcredit=1
- var_password_pam_lcredit=1
- var_password_pam_minlen=12
- var_accounts_passwords_pam_faillock_deny=10
- var_accounts_passwords_pam_faillock_unlock_time=1800
- var_password_pam_tally2=10
- var_accounts_passwords_pam_tally2_unlock_time=1800
- var_password_hashing_algorithm=SHA512
- inactivity_timeout_value=15_minutes
- var_screensaver_lock_delay=10_seconds
- sshd_idle_timeout_value=15_minutes
- var_sshd_set_keepalive=0
- var_account_disable_post_pw_expiration=90
- var_system_crypto_policy=default_policy
- var_sshd_set_login_grace_time=60
- var_postfix_inet_interfaces=loopback-only
- var_selinux_policy_name=targeted
- var_selinux_state=enforcing
unselected_groups: []
platforms: !!set {}
cpe_names: !!set {}
platform: null
filter_rules: ''
policies:
- pcidss_4
title: PCI-DSS v4.0 Control Baseline for Red Hat Enterprise Linux 8
definition_location: /home/mburket/Developer/ComplianceAsCode/content/products/rhel8/profiles/pci-dss.profile
documentation_complete: true
