documentation_complete: true

title: 'ANSSI-BP-028 (intermediary)'

description: |-
    This profile contains configurations that align to ANSSI-BP-028 v2.0 at the intermediary hardening level.

    ANSSI is the French National Information Security Agency, and stands for Agence nationale de la sécurité des systèmes d'information.
    ANSSI-BP-028 is a configuration recommendation for GNU/Linux systems.

    A copy of the ANSSI-BP-028 can be found at the ANSSI website:
    https://www.ssi.gouv.fr/administration/guide/recommandations-de-securite-relatives-a-un-systeme-gnulinux/

# selinux_state: not applicable
# postfix_client_configure_mail_alias: not applicable. should be exim
# grub2_l1tf_argument debian kernels are not vulnerable, but switching from
# conditional cache flush to force mode prevent protection disabling.

selections:
  - anssi:all:intermediary
  # PASS_MIN_LEN is handled by PAM on debian systems.
  - '!accounts_password_minlen_login_defs'
  # Debian uses apparmor
  - '!selinux_state'
  # The following are MLS related rules (not part of ANSSI-BP-028)
  - '!accounts_polyinstantiated_tmp'
  - '!accounts_polyinstantiated_var_tmp'
  # Following rules once had a prodtype incompatible with the debian12 product
  - '!sysctl_net_ipv4_conf_default_secure_redirects'
  - '!accounts_password_pam_dcredit'
  - '!package_sendmail_removed'
  - '!partition_for_boot'
  - '!sysctl_net_ipv4_conf_all_accept_source_route'
  - '!mount_option_home_nosuid'
  - '!accounts_passwords_pam_faillock_deny_root'
  - '!cracklib_accounts_password_pam_lcredit'
  - '!sysctl_fs_protected_regular'
  - '!dnf-automatic_apply_updates'
  - '!cracklib_accounts_password_pam_ocredit'
  - '!enable_pam_namespace'
  - '!package_talk_removed'
  - '!accounts_password_pam_minlen'
  - '!accounts_password_pam_unix_rounds_system_auth'
  - '!grub2_page_poison_argument'
  - '!ensure_gpgcheck_local_packages'
  - '!grub2_uefi_password'
  - '!sysctl_net_ipv6_conf_all_accept_redirects'
  - '!package_sudo_installed'
  - '!package_xinetd_removed'
  - '!package_rsh-server_removed'
  - '!mount_option_srv_nosuid'
  - '!mount_option_boot_noexec'
  - '!mount_option_var_tmp_noexec'
  - '!sysctl_net_ipv6_conf_default_router_solicitations'
  - '!package_ypserv_removed'
  - '!mount_option_tmp_nosuid'
  - '!security_patches_up_to_date'
  - '!sysctl_net_ipv4_conf_all_rp_filter'
  - '!accounts_passwords_pam_faillock_unlock_time'
  - '!file_permissions_ungroupowned'
  - '!set_password_hashing_algorithm_systemauth'
  - '!sysctl_net_ipv6_conf_all_accept_ra_defrtr'
  - '!package_tftp-server_removed'
  - '!package_rsh_removed'
  - '!sysctl_net_ipv4_conf_default_accept_redirects'
  - '!package_dnf-automatic_installed'
  - '!sysctl_kernel_perf_event_max_sample_rate'
  - '!sysctl_net_ipv6_conf_all_accept_ra_pinfo'
  - '!sysctl_kernel_perf_cpu_time_max_percent'
  - '!timer_dnf-automatic_enabled'
  - '!accounts_passwords_pam_tally2'
  - '!accounts_password_pam_unix_remember'
  - '!file_permissions_unauthorized_sgid'
  - '!sysctl_net_ipv6_conf_all_router_solicitations'
  - '!sysctl_net_ipv4_conf_default_rp_filter'
  - '!sudo_add_umask'
  - '!sudo_add_env_reset'
  - '!package_dhcp_removed'
  - '!sysctl_net_ipv6_conf_default_accept_source_route'
  - '!sysctl_fs_protected_fifos'
  - '!grub2_page_alloc_shuffle_argument'
  - '!mount_option_var_noexec'
  - '!accounts_password_pam_ucredit'
  - '!ensure_gpgcheck_never_disabled'
  - '!mount_option_opt_nosuid'
  - '!partition_for_opt'
  - '!sysctl_kernel_sysrq'
  - '!sysctl_net_ipv4_ip_forward'
  - '!sysctl_net_ipv6_conf_all_accept_ra_rtr_pref'
  - '!postfix_network_listening_disabled'
  - '!ensure_redhat_gpgkey_installed'
  - '!accounts_passwords_pam_faillock_interval'
  - '!sudo_add_ignore_dot'
  - '!sysctl_kernel_perf_event_paranoid'
  - '!mount_option_var_log_nosuid'
  - '!sysctl_net_ipv6_conf_default_autoconf'
  - '!sysctl_net_ipv6_conf_default_max_addresses'
  - '!sysctl_net_ipv6_conf_default_accept_ra_rtr_pref'
  - '!grub2_mds_argument'
  - '!grub2_slub_debug_argument'
  - '!dnf-automatic_security_updates_only'
  - '!mount_option_var_log_noexec'
  - '!partition_for_usr'
  - '!package_telnet-server_removed'
  - '!sysctl_net_ipv4_ip_local_port_range'
  - '!package_talk-server_removed'
  - '!sysctl_kernel_pid_max'
  - '!package_ypbind_removed'
  - '!sysctl_net_ipv4_conf_default_send_redirects'
  - '!mount_option_var_nosuid'
  - '!sysctl_net_ipv6_conf_all_max_addresses'
  - '!sysctl_net_ipv4_conf_all_accept_redirects'
  - '!cracklib_accounts_password_pam_ucredit'
  - '!sysctl_net_ipv4_conf_all_send_redirects'
  - '!sysctl_net_ipv4_conf_all_secure_redirects'
  - '!accounts_passwords_pam_tally2_unlock_time'
  - '!sysctl_net_ipv4_conf_default_accept_source_route'
  - '!cracklib_accounts_password_pam_minlen'
  - '!sebool_polyinstantiation_enabled'
  - '!accounts_tmout'
  - '!mount_option_nodev_nonroot_local_partitions'
  - '!package_tftp_removed'
  - '!sysctl_net_core_bpf_jit_harden'
  - '!grub2_pti_argument'
  - '!file_permissions_unauthorized_suid'
  - '!accounts_passwords_pam_tally2_deny_root'
  - '!sysctl_net_ipv6_conf_default_accept_redirects'
  - '!sysctl_kernel_unprivileged_bpf_disabled'
  - '!accounts_passwords_pam_faillock_deny'
  - '!accounts_password_pam_unix_rounds_password_auth'
  - '!sysctl_vm_mmap_min_addr'
  - '!sysctl_net_ipv4_tcp_rfc1337'
  - '!sysctl_net_ipv4_tcp_syncookies'
  - '!sysctl_kernel_yama_ptrace_scope'
  - '!sysctl_net_ipv6_conf_default_accept_ra_pinfo'
  - '!accounts_password_pam_ocredit'
  - '!accounts_password_pam_lcredit'
  - '!no_files_unowned_by_user'
  - '!mount_option_boot_nosuid'
  - '!audit_rules_privileged_commands_sudo'
  - '!mount_option_tmp_noexec'
  - '!mount_option_home_noexec'
  - '!sysctl_net_ipv4_conf_all_drop_gratuitous_arp'
  - '!sysctl_net_ipv6_conf_all_accept_source_route'
  - '!sysctl_net_ipv6_conf_default_accept_ra_defrtr'
  - '!enable_authselect'
  - '!sysctl_net_ipv4_icmp_ignore_bogus_error_responses'
  - '!sysctl_kernel_dmesg_restrict'
  - '!package_telnet_removed'
  - '!grub2_password'
  - '!dir_perms_world_writable_root_owned'
  - '!cracklib_accounts_password_pam_dcredit'
  - '!partition_for_var_tmp'
  - '!ensure_gpgcheck_globally_activated'
  - '!sysctl_net_ipv6_conf_all_autoconf'
  - '!ensure_oracle_gpgkey_installed'
  - '!mount_option_var_tmp_nosuid'
