// +build linux,seccomp

package seccomp

import (
	"golang.org/x/sys/unix"
)

// Error table
var errnoArch = map[string]uint{
	"EPERM":           uint(unix.EPERM),
	"ENOENT":          uint(unix.ENOENT),
	"ESRCH":           uint(unix.ESRCH),
	"EIO":             uint(unix.EIO),
	"ENXIO":           uint(unix.ENXIO),
	"E2BIG":           uint(unix.E2BIG),
	"ENOEXEC":         uint(unix.ENOEXEC),
	"EBADF":           uint(unix.EBADF),
	"ECHILD":          uint(unix.ECHILD),
	"EDEADLK":         uint(unix.EDEADLK),
	"ENOMEM":          uint(unix.ENOMEM),
	"EACCES":          uint(unix.EACCES),
	"EFAULT":          uint(unix.EFAULT),
	"ENOTBLK":         uint(unix.ENOTBLK),
	"EBUSY":           uint(unix.EBUSY),
	"EEXIST":          uint(unix.EEXIST),
	"EXDEV":           uint(unix.EXDEV),
	"ENODEV":          uint(unix.ENODEV),
	"ENOTDIR":         uint(unix.ENOTDIR),
	"EISDIR":          uint(unix.EISDIR),
	"EINVAL":          uint(unix.EINVAL),
	"ENFILE":          uint(unix.ENFILE),
	"EMFILE":          uint(unix.EMFILE),
	"ENOTTY":          uint(unix.ENOTTY),
	"ETXTBSY":         uint(unix.ETXTBSY),
	"EFBIG":           uint(unix.EFBIG),
	"ENOSPC":          uint(unix.ENOSPC),
	"ESPIPE":          uint(unix.ESPIPE),
	"EROFS":           uint(unix.EROFS),
	"EMLINK":          uint(unix.EMLINK),
	"EPIPE":           uint(unix.EPIPE),
	"EDOM":            uint(unix.EDOM),
	"ERANGE":          uint(unix.ERANGE),
	"EAGAIN":          uint(unix.EAGAIN),
	"EINPROGRESS":     uint(unix.EINPROGRESS),
	"EALREADY":        uint(unix.EALREADY),
	"ENOTSOCK":        uint(unix.ENOTSOCK),
	"EDESTADDRREQ":    uint(unix.EDESTADDRREQ),
	"EMSGSIZE":        uint(unix.EMSGSIZE),
	"EPROTOTYPE":      uint(unix.EPROTOTYPE),
	"ENOPROTOOPT":     uint(unix.ENOPROTOOPT),
	"EPROTONOSUPPORT": uint(unix.EPROTONOSUPPORT),
	"ESOCKTNOSUPPORT": uint(unix.ESOCKTNOSUPPORT),
	"EOPNOTSUPP":      uint(unix.EOPNOTSUPP),
	"EPFNOSUPPORT":    uint(unix.EPFNOSUPPORT),
	"EAFNOSUPPORT":    uint(unix.EAFNOSUPPORT),
	"EADDRINUSE":      uint(unix.EADDRINUSE),
	"EADDRNOTAVAIL":   uint(unix.EADDRNOTAVAIL),
	"ENETDOWN":        uint(unix.ENETDOWN),
	"ENETUNREACH":     uint(unix.ENETUNREACH),
	"ENETRESET":       uint(unix.ENETRESET),
	"ECONNABORTED":    uint(unix.ECONNABORTED),
	"ECONNRESET":      uint(unix.ECONNRESET),
	"ENOBUFS":         uint(unix.ENOBUFS),
	"EISCONN":         uint(unix.EISCONN),
	"ENOTCONN":        uint(unix.ENOTCONN),
	"ESHUTDOWN":       uint(unix.ESHUTDOWN),
	"ETOOMANYREFS":    uint(unix.ETOOMANYREFS),
	"ETIMEDOUT":       uint(unix.ETIMEDOUT),
	"ECONNREFUSED":    uint(unix.ECONNREFUSED),
	"ELOOP":           uint(unix.ELOOP),
	"ENAMETOOLONG":    uint(unix.ENAMETOOLONG),
	"EHOSTDOWN":       uint(unix.EHOSTDOWN),
	"EHOSTUNREACH":    uint(unix.EHOSTUNREACH),
	"ENOTEMPTY":       uint(unix.ENOTEMPTY),
	"EUSERS":          uint(unix.EUSERS),
	"EDQUOT":          uint(unix.EDQUOT),
	"ESTALE":          uint(unix.ESTALE),
	"EREMOTE":         uint(unix.EREMOTE),
	"ENOLCK":          uint(unix.ENOLCK),
	"ENOSYS":          uint(unix.ENOSYS),
	"EILSEQ":          uint(unix.EILSEQ),
	"ENOMEDIUM":       uint(unix.ENOMEDIUM),
	"EMEDIUMTYPE":     uint(unix.EMEDIUMTYPE),
	"EOVERFLOW":       uint(unix.EOVERFLOW),
	"ECANCELED":       uint(unix.ECANCELED),
	"EIDRM":           uint(unix.EIDRM),
	"ENOMSG":          uint(unix.ENOMSG),
	"ENOTSUP":         uint(unix.ENOTSUP),
	"EBADMSG":         uint(unix.EBADMSG),
	"ENOTRECOVERABLE": uint(unix.ENOTRECOVERABLE),
	"EOWNERDEAD":      uint(unix.EOWNERDEAD),
}
