Configuring ACME Realm
======================

## Overview

This document describes the process to configure a realm for ACME responder.
The realm configuration is located at /etc/pki/pki-tomcat/acme/realm.conf.

The `pki-server acme-realm-mod` can be used to configure the realm via command-line.
If the command is invoked without any parameters, it will enter an interactive mode, for example:

```
$ pki-server acme-realm-mod
The current value is displayed in the square brackets.
To keep the current value, simply press Enter.
To change the current value, enter the new value.
To remove the current value, enter a blank space.

Enter the type of the realm. Available types: ds.
  Database Type: ds

Enter the location of the LDAP server (e.g. ldap://localhost.localdomain:389).
  Server URL [ldap://localhost.localdomain:389]:

Enter the authentication type. Available types: BasicAuth, SslClientAuth.
  Authentication Type [BasicAuth]:

Enter the bind DN.
  Bind DN [cn=Directory Manager]:

Enter the bind password.
  Bind Password [********]:

Enter the base DN for the ACME users subtree.
  Users DN [ou=people,dc=acme,dc=pki,dc=example,dc=com]:

Enter the base DN for the ACME groups subtree.
  Groups DN [ou=groups,dc=acme,dc=pki,dc=example,dc=com]:
```

If the command is invoked with `--type` parameter, it will create a new configuration based on the specified type.
If the command is invoked with other parameters, it will update the specified parameters.

## Configuring ACME with In-Memory Realm

The ACME responder can be configured with an in-memory realm.
See [Configuring ACME with In-Memory Realm](Configuring-ACME-with-InMemory-Realm.adoc).

## Configuring ACME with DS Realm

The ACME responder can be configured with a DS realm.
See [Configuring ACME with DS Realm](Configuring-ACME-with-DS-Realm.adoc).

## Configuring ACME with PostgreSQL Realm

The ACME responder can be configured with a PostgreSQL realm.
See [Configuring ACME with PostgreSQL Realm](Configuring-ACME-with-PostgreSQL-Realm.adoc).

## See Also

* [Installing PKI ACME Responder](Installing_PKI_ACME_Responder.md)
