# Authors:
#     Fraser Tweedale <ftweedal@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright (C) 2017 Red Hat, Inc.
# All rights reserved.

from __future__ import absolute_import
import os.path

import pki
from pki.server.upgrade import PKIServerUpgradeScriptlet


class AddSessionAuthenticationPlugin(PKIServerUpgradeScriptlet):
    def __init__(self):
        super(AddSessionAuthenticationPlugin, self).__init__()
        self.message = 'Add SessionAuthentication to CS.cfg'

    def upgrade_subsystem(self, instance, subsystem):
        if subsystem.name == 'ca':
            self.add_plugin(instance, subsystem)

    def add_plugin(self, instance, subsystem):  # pylint: disable=W0613
        filename = os.path.join(subsystem.conf_dir, 'CS.cfg')
        self.backup(filename)

        properties = pki.PropertyFile(filename)
        properties.read()

        properties.set(
            'auths.impl.SessionAuthentication.class',
            'com.netscape.cms.authentication.SessionAuthentication')
        properties.set(
            'auths.instance.SessionAuthentication.pluginName',
            'SessionAuthentication')

        properties.write()
