; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

%S = type { ptr }

; Inlining should nuke the invoke (and any inlined calls) here even with
; argument promotion running along with it.
define void @zot() personality ptr @wibble {
; TUNIT: Function Attrs: mustprogress nofree norecurse noreturn nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@zot
; TUNIT-SAME: () #[[ATTR0:[0-9]+]] personality ptr @wibble {
; TUNIT-NEXT:  bb:
; TUNIT-NEXT:    call void @hoge() #[[ATTR2:[0-9]+]]
; TUNIT-NEXT:    unreachable
; TUNIT:       bb1:
; TUNIT-NEXT:    unreachable
; TUNIT:       bb2:
; TUNIT-NEXT:    unreachable
;
; CGSCC: Function Attrs: mustprogress nofree noreturn nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@zot
; CGSCC-SAME: () #[[ATTR0:[0-9]+]] personality ptr @wibble {
; CGSCC-NEXT:  bb:
; CGSCC-NEXT:    call void @hoge() #[[ATTR4:[0-9]+]]
; CGSCC-NEXT:    unreachable
; CGSCC:       bb1:
; CGSCC-NEXT:    unreachable
; CGSCC:       bb2:
; CGSCC-NEXT:    unreachable
;
bb:
  invoke void @hoge()
  to label %bb1 unwind label %bb2

bb1:
  unreachable

bb2:
  %tmp = landingpad { ptr, i32 }
  cleanup
  unreachable
}

define internal void @hoge() {
; TUNIT: Function Attrs: mustprogress nofree norecurse noreturn nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@hoge
; TUNIT-SAME: () #[[ATTR0]] {
; TUNIT-NEXT:  bb:
; TUNIT-NEXT:    unreachable
;
; CGSCC: Function Attrs: mustprogress nofree noreturn nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@hoge
; CGSCC-SAME: () #[[ATTR0]] {
; CGSCC-NEXT:  bb:
; CGSCC-NEXT:    unreachable
;
bb:
  %tmp = call fastcc ptr @spam(ptr @eggs)
  %tmp1 = call fastcc ptr @spam(ptr @barney)
  unreachable
}

define internal fastcc ptr @spam(ptr %arg) {
; CGSCC: Function Attrs: mustprogress nofree norecurse noreturn nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@spam
; CGSCC-SAME: () #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  bb:
; CGSCC-NEXT:    unreachable
;
bb:
  unreachable
}

define internal i1 @eggs(ptr %arg) {
; CGSCC-LABEL: define {{[^@]+}}@eggs
; CGSCC-SAME: (ptr [[ARG:%.*]]) {
; CGSCC-NEXT:  bb:
; CGSCC-NEXT:    [[TMP:%.*]] = call zeroext i1 @barney()
; CGSCC-NEXT:    unreachable
;
bb:
  %tmp = call zeroext i1 @barney(ptr %arg)
  unreachable
}

define internal i1 @barney(ptr %arg) {
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@barney
; CGSCC-SAME: () #[[ATTR2:[0-9]+]] {
; CGSCC-NEXT:  bb:
; CGSCC-NEXT:    ret i1 undef
;
bb:
  ret i1 undef
}

define i32 @test_inf_promote_caller(i32 %arg) {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@test_inf_promote_caller
; TUNIT-SAME: (i32 [[ARG:%.*]]) #[[ATTR1:[0-9]+]] {
; TUNIT-NEXT:  bb:
; TUNIT-NEXT:    ret i32 0
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@test_inf_promote_caller
; CGSCC-SAME: (i32 [[ARG:%.*]]) #[[ATTR3:[0-9]+]] {
; CGSCC-NEXT:  bb:
; CGSCC-NEXT:    [[TMP:%.*]] = alloca [[S:%.*]], align 8
; CGSCC-NEXT:    [[TRUETMP1:%.*]] = alloca [[S]], align 8
; CGSCC-NEXT:    ret i32 0
;
bb:
  %tmp = alloca %S
  %tmp1 = alloca %S
  %tmp2 = call i32 @test_inf_promote_callee(ptr %tmp, ptr %tmp1)

  ret i32 0
}

define internal i32 @test_inf_promote_callee(ptr %arg, ptr %arg1) {
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@test_inf_promote_callee
; CGSCC-SAME: () #[[ATTR3]] {
; CGSCC-NEXT:  bb:
; CGSCC-NEXT:    ret i32 undef
;
bb:
  %tmp2 = load ptr, ptr %arg1
  %tmp4 = load ptr, ptr %arg
  %tmp5 = call i32 @test_inf_promote_callee(ptr %tmp4, ptr %tmp2)

  ret i32 0
}

declare i32 @wibble(...)
;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse noreturn nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR2]] = { noreturn nounwind memory(none) }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree noreturn nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree norecurse noreturn nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR3]] = { mustprogress nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR4]] = { noreturn nounwind memory(none) }
;.
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
