; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=hawaii -atomic-expand %s | FileCheck -check-prefix=CI %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -atomic-expand %s | FileCheck -check-prefix=GFX9 %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx908 -atomic-expand %s | FileCheck -check-prefix=GFX908 %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a -atomic-expand %s | FileCheck -check-prefix=GFX90A %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx940 -atomic-expand %s | FileCheck -check-prefix=GFX940 %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -atomic-expand %s | FileCheck -check-prefix=GFX11 %s

define void @test_atomicrmw_fadd_f32_global_no_use_unsafe(ptr addrspace(1) %ptr, float %value) #0 {
; CI-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret void
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret void
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe(
; GFX908-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX908-NEXT:    ret void
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe(
; GFX90A-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX90A-NEXT:    ret void
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX940-NEXT:    ret void
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe(
; GFX11-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX11-NEXT:    ret void
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, float %value syncscope("wavefront") monotonic
  ret void
}

define float @test_atomicrmw_fadd_f32_global_unsafe(ptr addrspace(1) %ptr, float %value) #0 {
; CI-LABEL: @test_atomicrmw_fadd_f32_global_unsafe(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret float [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_global_unsafe(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret float [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_global_unsafe(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret float [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_global_unsafe(
; GFX90A-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX90A-NEXT:    ret float [[RES]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_global_unsafe(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX940-NEXT:    ret float [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_global_unsafe(
; GFX11-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX11-NEXT:    ret float [[RES]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, float %value syncscope("wavefront") monotonic
  ret float %res
}

define double @test_atomicrmw_fadd_f64_global_unsafe(ptr addrspace(1) %ptr, double %value) #0 {
; CI-LABEL: @test_atomicrmw_fadd_f64_global_unsafe(
; CI-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; CI-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret double [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f64_global_unsafe(
; GFX9-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret double [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f64_global_unsafe(
; GFX908-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret double [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f64_global_unsafe(
; GFX90A-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], double [[VALUE:%.*]] syncscope("wavefront") monotonic, align 8
; GFX90A-NEXT:    ret double [[RES]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f64_global_unsafe(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], double [[VALUE:%.*]] syncscope("wavefront") monotonic, align 8
; GFX940-NEXT:    ret double [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f64_global_unsafe(
; GFX11-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret double [[TMP5]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, double %value syncscope("wavefront") monotonic
  ret double %res
}

define float @test_atomicrmw_fadd_f32_flat_unsafe(ptr %ptr, float %value) #0 {
; CI-LABEL: @test_atomicrmw_fadd_f32_flat_unsafe(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret float [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_flat_unsafe(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret float [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_flat_unsafe(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret float [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_flat_unsafe(
; GFX90A-NEXT:    br label [[ATOMICRMW_CHECK_SHARED:%.*]]
; GFX90A:       atomicrmw.check.shared:
; GFX90A-NEXT:    [[IS_SHARED:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[PTR:%.*]])
; GFX90A-NEXT:    br i1 [[IS_SHARED]], label [[ATOMICRMW_SHARED:%.*]], label [[ATOMICRMW_CHECK_PRIVATE:%.*]]
; GFX90A:       atomicrmw.shared:
; GFX90A-NEXT:    [[TMP1:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(3)
; GFX90A-NEXT:    [[TMP2:%.*]] = atomicrmw fadd ptr addrspace(3) [[TMP1]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_PHI:%.*]]
; GFX90A:       atomicrmw.check.private:
; GFX90A-NEXT:    [[IS_PRIVATE:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[PTR]])
; GFX90A-NEXT:    br i1 [[IS_PRIVATE]], label [[ATOMICRMW_PRIVATE:%.*]], label [[ATOMICRMW_GLOBAL:%.*]]
; GFX90A:       atomicrmw.private:
; GFX90A-NEXT:    [[TMP3:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(5)
; GFX90A-NEXT:    [[LOADED_PRIVATE:%.*]] = load float, ptr addrspace(5) [[TMP3]], align 4
; GFX90A-NEXT:    [[VAL_NEW:%.*]] = fadd float [[LOADED_PRIVATE]], [[VALUE]]
; GFX90A-NEXT:    store float [[VAL_NEW]], ptr addrspace(5) [[TMP3]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_PHI]]
; GFX90A:       atomicrmw.global:
; GFX90A-NEXT:    [[TMP4:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(1)
; GFX90A-NEXT:    [[TMP5:%.*]] = atomicrmw fadd ptr addrspace(1) [[TMP4]], float [[VALUE]] syncscope("wavefront") monotonic, align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_PHI]]
; GFX90A:       atomicrmw.phi:
; GFX90A-NEXT:    [[LOADED_PHI:%.*]] = phi float [ [[TMP2]], [[ATOMICRMW_SHARED]] ], [ [[LOADED_PRIVATE]], [[ATOMICRMW_PRIVATE]] ], [ [[TMP5]], [[ATOMICRMW_GLOBAL]] ]
; GFX90A-NEXT:    br label [[ATOMICRMW_END:%.*]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret float [[LOADED_PHI]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_flat_unsafe(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX940-NEXT:    ret float [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_flat_unsafe(
; GFX11-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX11-NEXT:    ret float [[RES]]
;
  %res = atomicrmw fadd ptr %ptr, float %value syncscope("wavefront") monotonic
  ret float %res
}

define double @test_atomicrmw_fadd_f64_flat_unsafe(ptr %ptr, double %value) #0 {
; CI-LABEL: @test_atomicrmw_fadd_f64_flat_unsafe(
; CI-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; CI-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret double [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f64_flat_unsafe(
; GFX9-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret double [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f64_flat_unsafe(
; GFX908-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret double [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f64_flat_unsafe(
; GFX90A-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[PTR:%.*]], double [[VALUE:%.*]] syncscope("wavefront") monotonic, align 8
; GFX90A-NEXT:    ret double [[RES]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f64_flat_unsafe(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[PTR:%.*]], double [[VALUE:%.*]] syncscope("wavefront") monotonic, align 8
; GFX940-NEXT:    ret double [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f64_flat_unsafe(
; GFX11-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret double [[TMP5]]
;
  %res = atomicrmw fadd ptr %ptr, double %value syncscope("wavefront") monotonic
  ret double %res
}

define float @test_atomicrmw_fadd_f32_flat(ptr %ptr, float %value) {
; CI-LABEL: @test_atomicrmw_fadd_f32_flat(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret float [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_flat(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret float [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_flat(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret float [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_flat(
; GFX90A-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX90A-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX90A-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret float [[TMP5]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_flat(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX940-NEXT:    ret float [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_flat(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret float [[TMP5]]
;
  %res = atomicrmw fadd ptr %ptr, float %value seq_cst
  ret float %res
}

define float @test_atomicrmw_fadd_f32_global(ptr addrspace(1) %ptr, float %value) {
; CI-LABEL: @test_atomicrmw_fadd_f32_global(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret float [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_global(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret float [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_global(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret float [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_global(
; GFX90A-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX90A-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX90A-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret float [[TMP5]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_global(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX940-NEXT:    ret float [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_global(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret float [[TMP5]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, float %value seq_cst
  ret float %res
}

define void @test_atomicrmw_fadd_f32_global_no_use_ieee(ptr addrspace(1) %ptr, float %value) {
; CI-LABEL: @test_atomicrmw_fadd_f32_global_no_use_ieee(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret void
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_global_no_use_ieee(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret void
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_global_no_use_ieee(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret void
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_global_no_use_ieee(
; GFX90A-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX90A-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX90A-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret void
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_global_no_use_ieee(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX940-NEXT:    ret void
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_global_no_use_ieee(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret void
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, float %value seq_cst
  ret void
}

define void @test_atomicrmw_fadd_f32_global_no_use_denorm_flush(ptr addrspace(1) %ptr, float %value) #0 {
; CI-LABEL: @test_atomicrmw_fadd_f32_global_no_use_denorm_flush(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret void
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_global_no_use_denorm_flush(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret void
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_global_no_use_denorm_flush(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret void
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_global_no_use_denorm_flush(
; GFX90A-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX90A-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX90A-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret void
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_global_no_use_denorm_flush(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX940-NEXT:    ret void
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_global_no_use_denorm_flush(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret void
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, float %value seq_cst
  ret void
}

define float @test_atomicrmw_fadd_f32_local(ptr addrspace(3) %ptr, float %value) {
; CI-LABEL: @test_atomicrmw_fadd_f32_local(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(3) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(3) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret float [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_local(
; GFX9-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX9-NEXT:    ret float [[RES]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_local(
; GFX908-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX908-NEXT:    ret float [[RES]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_local(
; GFX90A-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX90A-NEXT:    ret float [[RES]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_local(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX940-NEXT:    ret float [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_local(
; GFX11-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX11-NEXT:    ret float [[RES]]
;
  %res = atomicrmw fadd ptr addrspace(3) %ptr, float %value seq_cst
  ret float %res
}

define half @test_atomicrmw_fadd_f16_flat(ptr %ptr, half %value) {
; CI-LABEL: @test_atomicrmw_fadd_f16_flat(
; CI-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[PTR:%.*]], i64 -4)
; CI-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[PTR]] to i64
; CI-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; CI-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; CI-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; CI-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; CI-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; CI-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ALIGNEDADDR]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; CI-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; CI-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; CI-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; CI-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; CI-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; CI-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; CI-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; CI-NEXT:    [[TMP6:%.*]] = cmpxchg ptr [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; CI-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; CI-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; CI-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; CI-NEXT:    ret half [[TMP7]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f16_flat(
; GFX9-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[PTR:%.*]], i64 -4)
; GFX9-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[PTR]] to i64
; GFX9-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX9-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX9-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX9-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX9-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX9-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ALIGNEDADDR]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX9-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX9-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX9-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX9-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX9-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX9-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX9-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX9-NEXT:    [[TMP6:%.*]] = cmpxchg ptr [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX9-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX9-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX9-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX9-NEXT:    ret half [[TMP7]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f16_flat(
; GFX908-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[PTR:%.*]], i64 -4)
; GFX908-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[PTR]] to i64
; GFX908-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX908-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX908-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX908-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX908-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX908-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ALIGNEDADDR]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX908-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX908-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX908-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX908-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX908-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX908-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX908-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX908-NEXT:    [[TMP6:%.*]] = cmpxchg ptr [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX908-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX908-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX908-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX908-NEXT:    ret half [[TMP7]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f16_flat(
; GFX90A-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[PTR:%.*]], i64 -4)
; GFX90A-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[PTR]] to i64
; GFX90A-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX90A-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX90A-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX90A-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX90A-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX90A-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ALIGNEDADDR]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX90A-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX90A-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX90A-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX90A-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX90A-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX90A-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX90A-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX90A-NEXT:    [[TMP6:%.*]] = cmpxchg ptr [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX90A-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX90A-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX90A-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX90A-NEXT:    ret half [[TMP7]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f16_flat(
; GFX940-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[PTR:%.*]], i64 -4)
; GFX940-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[PTR]] to i64
; GFX940-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX940-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX940-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX940-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX940-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX940-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ALIGNEDADDR]], align 4
; GFX940-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX940:       atomicrmw.start:
; GFX940-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX940-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX940-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX940-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX940-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX940-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX940-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX940-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX940-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX940-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX940-NEXT:    [[TMP6:%.*]] = cmpxchg ptr [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX940-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX940-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX940-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX940:       atomicrmw.end:
; GFX940-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX940-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX940-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX940-NEXT:    ret half [[TMP7]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f16_flat(
; GFX11-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[PTR:%.*]], i64 -4)
; GFX11-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[PTR]] to i64
; GFX11-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX11-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX11-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX11-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX11-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX11-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ALIGNEDADDR]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX11-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX11-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX11-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX11-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX11-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX11-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX11-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX11-NEXT:    [[TMP6:%.*]] = cmpxchg ptr [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX11-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX11-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX11-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX11-NEXT:    ret half [[TMP7]]
;
  %res = atomicrmw fadd ptr %ptr, half %value seq_cst
  ret half %res
}

define half @test_atomicrmw_fadd_f16_global(ptr addrspace(1) %ptr, half %value) {
; CI-LABEL: @test_atomicrmw_fadd_f16_global(
; CI-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(1) @llvm.ptrmask.p1.i64(ptr addrspace(1) [[PTR:%.*]], i64 -4)
; CI-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(1) [[PTR]] to i64
; CI-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; CI-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; CI-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; CI-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; CI-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; CI-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(1) [[ALIGNEDADDR]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; CI-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; CI-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; CI-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; CI-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; CI-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; CI-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; CI-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; CI-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(1) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; CI-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; CI-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; CI-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; CI-NEXT:    ret half [[TMP7]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f16_global(
; GFX9-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(1) @llvm.ptrmask.p1.i64(ptr addrspace(1) [[PTR:%.*]], i64 -4)
; GFX9-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(1) [[PTR]] to i64
; GFX9-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX9-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX9-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX9-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX9-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX9-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(1) [[ALIGNEDADDR]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX9-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX9-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX9-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX9-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX9-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX9-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX9-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX9-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(1) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX9-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX9-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX9-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX9-NEXT:    ret half [[TMP7]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f16_global(
; GFX908-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(1) @llvm.ptrmask.p1.i64(ptr addrspace(1) [[PTR:%.*]], i64 -4)
; GFX908-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(1) [[PTR]] to i64
; GFX908-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX908-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX908-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX908-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX908-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX908-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(1) [[ALIGNEDADDR]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX908-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX908-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX908-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX908-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX908-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX908-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX908-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX908-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(1) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX908-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX908-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX908-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX908-NEXT:    ret half [[TMP7]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f16_global(
; GFX90A-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(1) @llvm.ptrmask.p1.i64(ptr addrspace(1) [[PTR:%.*]], i64 -4)
; GFX90A-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(1) [[PTR]] to i64
; GFX90A-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX90A-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX90A-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX90A-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX90A-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX90A-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(1) [[ALIGNEDADDR]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX90A-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX90A-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX90A-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX90A-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX90A-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX90A-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX90A-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX90A-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(1) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX90A-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX90A-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX90A-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX90A-NEXT:    ret half [[TMP7]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f16_global(
; GFX940-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(1) @llvm.ptrmask.p1.i64(ptr addrspace(1) [[PTR:%.*]], i64 -4)
; GFX940-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(1) [[PTR]] to i64
; GFX940-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX940-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX940-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX940-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX940-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX940-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(1) [[ALIGNEDADDR]], align 4
; GFX940-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX940:       atomicrmw.start:
; GFX940-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX940-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX940-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX940-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX940-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX940-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX940-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX940-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX940-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX940-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX940-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(1) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX940-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX940-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX940-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX940:       atomicrmw.end:
; GFX940-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX940-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX940-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX940-NEXT:    ret half [[TMP7]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f16_global(
; GFX11-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(1) @llvm.ptrmask.p1.i64(ptr addrspace(1) [[PTR:%.*]], i64 -4)
; GFX11-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(1) [[PTR]] to i64
; GFX11-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX11-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX11-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX11-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX11-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX11-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(1) [[ALIGNEDADDR]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX11-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX11-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX11-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX11-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX11-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX11-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX11-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX11-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(1) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX11-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX11-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX11-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX11-NEXT:    ret half [[TMP7]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, half %value seq_cst
  ret half %res
}

define half @test_atomicrmw_fadd_f16_global_align4(ptr addrspace(1) %ptr, half %value) {
; CI-LABEL: @test_atomicrmw_fadd_f16_global_align4(
; CI-NEXT:    [[TMP1:%.*]] = load i32, ptr addrspace(1) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP1]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[LOADED]] to i16
; CI-NEXT:    [[TMP2:%.*]] = bitcast i16 [[EXTRACTED]] to half
; CI-NEXT:    [[NEW:%.*]] = fadd half [[TMP2]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP3:%.*]] = bitcast half [[NEW]] to i16
; CI-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP3]] to i32
; CI-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], -65536
; CI-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[EXTENDED]]
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    [[EXTRACTED1:%.*]] = trunc i32 [[NEWLOADED]] to i16
; CI-NEXT:    [[TMP5:%.*]] = bitcast i16 [[EXTRACTED1]] to half
; CI-NEXT:    ret half [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f16_global_align4(
; GFX9-NEXT:    [[TMP1:%.*]] = load i32, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP1]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[LOADED]] to i16
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX9-NEXT:    [[NEW:%.*]] = fadd half [[TMP2]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast half [[NEW]] to i16
; GFX9-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP3]] to i32
; GFX9-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], -65536
; GFX9-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[EXTENDED]]
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    [[EXTRACTED1:%.*]] = trunc i32 [[NEWLOADED]] to i16
; GFX9-NEXT:    [[TMP5:%.*]] = bitcast i16 [[EXTRACTED1]] to half
; GFX9-NEXT:    ret half [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f16_global_align4(
; GFX908-NEXT:    [[TMP1:%.*]] = load i32, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP1]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[LOADED]] to i16
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX908-NEXT:    [[NEW:%.*]] = fadd half [[TMP2]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast half [[NEW]] to i16
; GFX908-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP3]] to i32
; GFX908-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], -65536
; GFX908-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[EXTENDED]]
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    [[EXTRACTED1:%.*]] = trunc i32 [[NEWLOADED]] to i16
; GFX908-NEXT:    [[TMP5:%.*]] = bitcast i16 [[EXTRACTED1]] to half
; GFX908-NEXT:    ret half [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f16_global_align4(
; GFX90A-NEXT:    [[TMP1:%.*]] = load i32, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP1]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[LOADED]] to i16
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX90A-NEXT:    [[NEW:%.*]] = fadd half [[TMP2]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast half [[NEW]] to i16
; GFX90A-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP3]] to i32
; GFX90A-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], -65536
; GFX90A-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[EXTENDED]]
; GFX90A-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX90A-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    [[EXTRACTED1:%.*]] = trunc i32 [[NEWLOADED]] to i16
; GFX90A-NEXT:    [[TMP5:%.*]] = bitcast i16 [[EXTRACTED1]] to half
; GFX90A-NEXT:    ret half [[TMP5]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f16_global_align4(
; GFX940-NEXT:    [[TMP1:%.*]] = load i32, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX940-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX940:       atomicrmw.start:
; GFX940-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP1]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX940-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[LOADED]] to i16
; GFX940-NEXT:    [[TMP2:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX940-NEXT:    [[NEW:%.*]] = fadd half [[TMP2]], [[VALUE:%.*]]
; GFX940-NEXT:    [[TMP3:%.*]] = bitcast half [[NEW]] to i16
; GFX940-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP3]] to i32
; GFX940-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], -65536
; GFX940-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[EXTENDED]]
; GFX940-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX940-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX940-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX940-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX940:       atomicrmw.end:
; GFX940-NEXT:    [[EXTRACTED1:%.*]] = trunc i32 [[NEWLOADED]] to i16
; GFX940-NEXT:    [[TMP5:%.*]] = bitcast i16 [[EXTRACTED1]] to half
; GFX940-NEXT:    ret half [[TMP5]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f16_global_align4(
; GFX11-NEXT:    [[TMP1:%.*]] = load i32, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP1]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[LOADED]] to i16
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX11-NEXT:    [[NEW:%.*]] = fadd half [[TMP2]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast half [[NEW]] to i16
; GFX11-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP3]] to i32
; GFX11-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], -65536
; GFX11-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[EXTENDED]]
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    [[EXTRACTED1:%.*]] = trunc i32 [[NEWLOADED]] to i16
; GFX11-NEXT:    [[TMP5:%.*]] = bitcast i16 [[EXTRACTED1]] to half
; GFX11-NEXT:    ret half [[TMP5]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, half %value seq_cst, align 4
  ret half %res
}

define half @test_atomicrmw_fadd_f16_local(ptr addrspace(3) %ptr, half %value) {
; CI-LABEL: @test_atomicrmw_fadd_f16_local(
; CI-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(3) @llvm.ptrmask.p3.i64(ptr addrspace(3) [[PTR:%.*]], i64 -4)
; CI-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(3) [[PTR]] to i64
; CI-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; CI-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; CI-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; CI-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; CI-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; CI-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(3) [[ALIGNEDADDR]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; CI-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; CI-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; CI-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; CI-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; CI-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; CI-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; CI-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; CI-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(3) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; CI-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; CI-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; CI-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; CI-NEXT:    ret half [[TMP7]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f16_local(
; GFX9-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(3) @llvm.ptrmask.p3.i64(ptr addrspace(3) [[PTR:%.*]], i64 -4)
; GFX9-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(3) [[PTR]] to i64
; GFX9-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX9-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX9-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX9-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX9-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX9-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(3) [[ALIGNEDADDR]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX9-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX9-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX9-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX9-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX9-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX9-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX9-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX9-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(3) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX9-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX9-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX9-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX9-NEXT:    ret half [[TMP7]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f16_local(
; GFX908-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(3) @llvm.ptrmask.p3.i64(ptr addrspace(3) [[PTR:%.*]], i64 -4)
; GFX908-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(3) [[PTR]] to i64
; GFX908-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX908-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX908-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX908-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX908-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX908-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(3) [[ALIGNEDADDR]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX908-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX908-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX908-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX908-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX908-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX908-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX908-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX908-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(3) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX908-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX908-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX908-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX908-NEXT:    ret half [[TMP7]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f16_local(
; GFX90A-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(3) @llvm.ptrmask.p3.i64(ptr addrspace(3) [[PTR:%.*]], i64 -4)
; GFX90A-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(3) [[PTR]] to i64
; GFX90A-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX90A-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX90A-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX90A-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX90A-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX90A-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(3) [[ALIGNEDADDR]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX90A-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX90A-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX90A-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX90A-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX90A-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX90A-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX90A-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX90A-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(3) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX90A-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX90A-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX90A-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX90A-NEXT:    ret half [[TMP7]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f16_local(
; GFX940-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(3) @llvm.ptrmask.p3.i64(ptr addrspace(3) [[PTR:%.*]], i64 -4)
; GFX940-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(3) [[PTR]] to i64
; GFX940-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX940-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX940-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX940-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX940-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX940-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(3) [[ALIGNEDADDR]], align 4
; GFX940-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX940:       atomicrmw.start:
; GFX940-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX940-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX940-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX940-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX940-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX940-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX940-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX940-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX940-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX940-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX940-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(3) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX940-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX940-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX940-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX940:       atomicrmw.end:
; GFX940-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX940-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX940-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX940-NEXT:    ret half [[TMP7]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f16_local(
; GFX11-NEXT:    [[ALIGNEDADDR:%.*]] = call ptr addrspace(3) @llvm.ptrmask.p3.i64(ptr addrspace(3) [[PTR:%.*]], i64 -4)
; GFX11-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(3) [[PTR]] to i64
; GFX11-NEXT:    [[PTRLSB:%.*]] = and i64 [[TMP1]], 3
; GFX11-NEXT:    [[TMP2:%.*]] = shl i64 [[PTRLSB]], 3
; GFX11-NEXT:    [[SHIFTAMT:%.*]] = trunc i64 [[TMP2]] to i32
; GFX11-NEXT:    [[MASK:%.*]] = shl i32 65535, [[SHIFTAMT]]
; GFX11-NEXT:    [[INV_MASK:%.*]] = xor i32 [[MASK]], -1
; GFX11-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(3) [[ALIGNEDADDR]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[SHIFTED:%.*]] = lshr i32 [[LOADED]], [[SHIFTAMT]]
; GFX11-NEXT:    [[EXTRACTED:%.*]] = trunc i32 [[SHIFTED]] to i16
; GFX11-NEXT:    [[TMP4:%.*]] = bitcast i16 [[EXTRACTED]] to half
; GFX11-NEXT:    [[NEW:%.*]] = fadd half [[TMP4]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP5:%.*]] = bitcast half [[NEW]] to i16
; GFX11-NEXT:    [[EXTENDED:%.*]] = zext i16 [[TMP5]] to i32
; GFX11-NEXT:    [[SHIFTED1:%.*]] = shl nuw i32 [[EXTENDED]], [[SHIFTAMT]]
; GFX11-NEXT:    [[UNMASKED:%.*]] = and i32 [[LOADED]], [[INV_MASK]]
; GFX11-NEXT:    [[INSERTED:%.*]] = or i32 [[UNMASKED]], [[SHIFTED1]]
; GFX11-NEXT:    [[TMP6:%.*]] = cmpxchg ptr addrspace(3) [[ALIGNEDADDR]], i32 [[LOADED]], i32 [[INSERTED]] seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1
; GFX11-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP6]], 0
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    [[SHIFTED2:%.*]] = lshr i32 [[NEWLOADED]], [[SHIFTAMT]]
; GFX11-NEXT:    [[EXTRACTED3:%.*]] = trunc i32 [[SHIFTED2]] to i16
; GFX11-NEXT:    [[TMP7:%.*]] = bitcast i16 [[EXTRACTED3]] to half
; GFX11-NEXT:    ret half [[TMP7]]
;
  %res = atomicrmw fadd ptr addrspace(3) %ptr, half %value seq_cst
  ret half %res
}

define double @test_atomicrmw_fadd_f64_flat(ptr %ptr, double %value) {
; CI-LABEL: @test_atomicrmw_fadd_f64_flat(
; CI-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; CI-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret double [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f64_flat(
; GFX9-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret double [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f64_flat(
; GFX908-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret double [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f64_flat(
; GFX90A-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX90A-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX90A-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret double [[TMP5]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f64_flat(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[PTR:%.*]], double [[VALUE:%.*]] seq_cst, align 8
; GFX940-NEXT:    ret double [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f64_flat(
; GFX11-NEXT:    [[TMP1:%.*]] = load double, ptr [[PTR:%.*]], align 8
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret double [[TMP5]]
;
  %res = atomicrmw fadd ptr %ptr, double %value seq_cst
  ret double %res
}

define double @test_atomicrmw_fadd_f64_global(ptr addrspace(1) %ptr, double %value) {
; CI-LABEL: @test_atomicrmw_fadd_f64_global(
; CI-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; CI-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret double [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f64_global(
; GFX9-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret double [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f64_global(
; GFX908-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret double [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f64_global(
; GFX90A-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX90A-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX90A-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret double [[TMP5]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f64_global(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], double [[VALUE:%.*]] seq_cst, align 8
; GFX940-NEXT:    ret double [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f64_global(
; GFX11-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret double [[TMP5]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, double %value seq_cst
  ret double %res
}

define double @test_atomicrmw_fadd_f64_local(ptr addrspace(3) %ptr, double %value) {
; CI-LABEL: @test_atomicrmw_fadd_f64_local(
; CI-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(3) [[PTR:%.*]], align 8
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; CI-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(3) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret double [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f64_local(
; GFX9-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(3) [[PTR:%.*]], align 8
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(3) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret double [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f64_local(
; GFX908-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(3) [[PTR:%.*]], align 8
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(3) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret double [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f64_local(
; GFX90A-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], double [[VALUE:%.*]] seq_cst, align 8
; GFX90A-NEXT:    ret double [[RES]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f64_local(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], double [[VALUE:%.*]] seq_cst, align 8
; GFX940-NEXT:    ret double [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f64_local(
; GFX11-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(3) [[PTR:%.*]], align 8
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd double [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(3) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] seq_cst seq_cst, align 8
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret double [[TMP5]]
;
  %res = atomicrmw fadd ptr addrspace(3) %ptr, double %value seq_cst
  ret double %res
}

define float @test_atomicrmw_fadd_f32_global_agent(ptr addrspace(1) %ptr, float %value) {
; CI-LABEL: @test_atomicrmw_fadd_f32_global_agent(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("agent") monotonic monotonic, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret float [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_global_agent(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("agent") monotonic monotonic, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret float [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_global_agent(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("agent") monotonic monotonic, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret float [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_global_agent(
; GFX90A-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX90A-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("agent") monotonic monotonic, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX90A-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret float [[TMP5]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_global_agent(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("agent") monotonic, align 4
; GFX940-NEXT:    ret float [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_global_agent(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("agent") monotonic monotonic, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret float [[TMP5]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, float %value syncscope("agent") monotonic
  ret float %res
}

define float @test_atomicrmw_fadd_f32_global_one_as(ptr addrspace(1) %ptr, float %value) {
; CI-LABEL: @test_atomicrmw_fadd_f32_global_one_as(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("one-as") monotonic monotonic, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret float [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_global_one_as(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("one-as") monotonic monotonic, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret float [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_global_one_as(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("one-as") monotonic monotonic, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret float [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_global_one_as(
; GFX90A-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX90A-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX90A-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("one-as") monotonic monotonic, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX90A-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret float [[TMP5]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_global_one_as(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("one-as") monotonic, align 4
; GFX940-NEXT:    ret float [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_global_one_as(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("one-as") monotonic monotonic, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret float [[TMP5]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, float %value syncscope("one-as") monotonic
  ret float %res
}

define void @test_atomicrmw_fadd_f32_global_no_use_unsafe_structfp(ptr addrspace(1) %ptr, float %value) #1 {
; CI-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe_structfp(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[LOADED]], float [[VALUE:%.*]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR6:[0-9]+]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret void
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe_structfp(
; GFX9-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(1) [[PTR:%.*]], align 4
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[LOADED]], float [[VALUE:%.*]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR6:[0-9]+]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 4
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret void
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe_structfp(
; GFX908-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX908-NEXT:    ret void
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe_structfp(
; GFX90A-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX90A-NEXT:    ret void
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe_structfp(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX940-NEXT:    ret void
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_global_no_use_unsafe_structfp(
; GFX11-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], float [[VALUE:%.*]] syncscope("wavefront") monotonic, align 4
; GFX11-NEXT:    ret void
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, float %value syncscope("wavefront") monotonic
  ret void
}

define double @test_atomicrmw_fadd_f64_global_unsafe_strictfp(ptr addrspace(1) %ptr, double %value) #1 {
; CI-LABEL: @test_atomicrmw_fadd_f64_global_unsafe_strictfp(
; CI-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = call double @llvm.experimental.constrained.fadd.f64(double [[LOADED]], double [[VALUE:%.*]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR6]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; CI-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret double [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f64_global_unsafe_strictfp(
; GFX9-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX9-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX9:       atomicrmw.start:
; GFX9-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX9-NEXT:    [[NEW:%.*]] = call double @llvm.experimental.constrained.fadd.f64(double [[LOADED]], double [[VALUE:%.*]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR6]]
; GFX9-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX9-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX9-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; GFX9-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX9-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX9-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX9-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX9:       atomicrmw.end:
; GFX9-NEXT:    ret double [[TMP5]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f64_global_unsafe_strictfp(
; GFX908-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = call double @llvm.experimental.constrained.fadd.f64(double [[LOADED]], double [[VALUE:%.*]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR6:[0-9]+]]
; GFX908-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX908-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX908-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret double [[TMP5]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f64_global_unsafe_strictfp(
; GFX90A-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], double [[VALUE:%.*]] syncscope("wavefront") monotonic, align 8
; GFX90A-NEXT:    ret double [[RES]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f64_global_unsafe_strictfp(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(1) [[PTR:%.*]], double [[VALUE:%.*]] syncscope("wavefront") monotonic, align 8
; GFX940-NEXT:    ret double [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f64_global_unsafe_strictfp(
; GFX11-NEXT:    [[TMP1:%.*]] = load double, ptr addrspace(1) [[PTR:%.*]], align 8
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi double [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = call double @llvm.experimental.constrained.fadd.f64(double [[LOADED]], double [[VALUE:%.*]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR6:[0-9]+]]
; GFX11-NEXT:    [[TMP2:%.*]] = bitcast double [[NEW]] to i64
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast double [[LOADED]] to i64
; GFX11-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i64 [[TMP3]], i64 [[TMP2]] syncscope("wavefront") monotonic monotonic, align 8
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP4]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i64, i1 } [[TMP4]], 0
; GFX11-NEXT:    [[TMP5]] = bitcast i64 [[NEWLOADED]] to double
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret double [[TMP5]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, double %value syncscope("wavefront") monotonic
  ret double %res
}

define float @test_atomicrmw_fadd_f32_local_strictfp(ptr addrspace(3) %ptr, float %value) #2 {
; CI-LABEL: @test_atomicrmw_fadd_f32_local_strictfp(
; CI-NEXT:    [[TMP1:%.*]] = load float, ptr addrspace(3) [[PTR:%.*]], align 4
; CI-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CI:       atomicrmw.start:
; CI-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[ATOMICRMW_START]] ]
; CI-NEXT:    [[NEW:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[LOADED]], float [[VALUE:%.*]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR6]]
; CI-NEXT:    [[TMP2:%.*]] = bitcast float [[NEW]] to i32
; CI-NEXT:    [[TMP3:%.*]] = bitcast float [[LOADED]] to i32
; CI-NEXT:    [[TMP4:%.*]] = cmpxchg ptr addrspace(3) [[PTR]], i32 [[TMP3]], i32 [[TMP2]] seq_cst seq_cst, align 4
; CI-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1
; CI-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0
; CI-NEXT:    [[TMP5]] = bitcast i32 [[NEWLOADED]] to float
; CI-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CI:       atomicrmw.end:
; CI-NEXT:    ret float [[TMP5]]
;
; GFX9-LABEL: @test_atomicrmw_fadd_f32_local_strictfp(
; GFX9-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX9-NEXT:    ret float [[RES]]
;
; GFX908-LABEL: @test_atomicrmw_fadd_f32_local_strictfp(
; GFX908-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX908-NEXT:    ret float [[RES]]
;
; GFX90A-LABEL: @test_atomicrmw_fadd_f32_local_strictfp(
; GFX90A-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX90A-NEXT:    ret float [[RES]]
;
; GFX940-LABEL: @test_atomicrmw_fadd_f32_local_strictfp(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX940-NEXT:    ret float [[RES]]
;
; GFX11-LABEL: @test_atomicrmw_fadd_f32_local_strictfp(
; GFX11-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr addrspace(3) [[PTR:%.*]], float [[VALUE:%.*]] seq_cst, align 4
; GFX11-NEXT:    ret float [[RES]]
;
  %res = atomicrmw fadd ptr addrspace(3) %ptr, float %value seq_cst
  ret float %res
}
attributes #0 = { "denormal-fp-math-f32"="preserve-sign,preserve-sign" "amdgpu-unsafe-fp-atomics"="true" }
attributes #1 = { strictfp "denormal-fp-math-f32"="preserve-sign,preserve-sign" "amdgpu-unsafe-fp-atomics"="true" }
attributes #2 = { strictfp}
