; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx | FileCheck %s

@x = common global <8 x float> zeroinitializer, align 32
@y = common global <4 x double> zeroinitializer, align 32
@z = common global <4 x float> zeroinitializer, align 16

define void @zero128() nounwind ssp {
; CHECK-LABEL: zero128:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    movq _z@GOTPCREL(%rip), %rax
; CHECK-NEXT:    vmovaps %xmm0, (%rax)
; CHECK-NEXT:    retq
  store <4 x float> zeroinitializer, ptr @z, align 16
  ret void
}

define void @zero256() nounwind ssp {
; CHECK-LABEL: zero256:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    movq _x@GOTPCREL(%rip), %rax
; CHECK-NEXT:    vmovaps %ymm0, (%rax)
; CHECK-NEXT:    movq _y@GOTPCREL(%rip), %rax
; CHECK-NEXT:    vmovaps %ymm0, (%rax)
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  store <8 x float> zeroinitializer, ptr @x, align 32
  store <4 x double> zeroinitializer, ptr @y, align 32
  ret void
}

define void @ones(ptr nocapture %RET, ptr nocapture %aFOO) nounwind {
; CHECK-LABEL: ones:
; CHECK:       ## %bb.0: ## %allocas
; CHECK-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; CHECK-NEXT:    vmovaps %ymm0, (%rdi)
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
allocas:
  store <8 x float> <float 0xFFFFFFFFE0000000, float 0xFFFFFFFFE0000000, float
0xFFFFFFFFE0000000, float 0xFFFFFFFFE0000000, float 0xFFFFFFFFE0000000, float
0xFFFFFFFFE0000000, float 0xFFFFFFFFE0000000, float 0xFFFFFFFFE0000000>, ptr %RET, align 32
  ret void
}

define void @ones2(ptr nocapture %RET, ptr nocapture %aFOO) nounwind {
; CHECK-LABEL: ones2:
; CHECK:       ## %bb.0: ## %allocas
; CHECK-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; CHECK-NEXT:    vmovaps %ymm0, (%rdi)
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
allocas:
  store <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, ptr %RET, align 32
  ret void
}

;;; Just make sure this doesn't crash
define <4 x i64> @ISelCrash(<4 x i64> %a) nounwind uwtable readnone ssp {
; CHECK-LABEL: ISelCrash:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vextractf128 $1, %ymm0, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> undef, <4 x i32> <i32 2, i32 3, i32 4, i32 4>
  ret <4 x i64> %shuffle
}

;;; Don't crash on movd
define <8 x i32> @VMOVZQI2PQI(ptr nocapture %aFOO) nounwind {
; CHECK-LABEL: VMOVZQI2PQI:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vbroadcastss (%rdi), %ymm0
; CHECK-NEXT:    retq
  %val.i34.i = load i32, ptr %aFOO, align 4
  %ptroffset.i22.i992 = getelementptr [0 x float], ptr %aFOO, i64 0, i64 1
  %val.i24.i = load i32, ptr %ptroffset.i22.i992, align 4
  %updatedret.i30.i = insertelement <8 x i32> undef, i32 %val.i34.i, i32 1
  ret <8 x i32> %updatedret.i30.i
}

;;;; Don't crash on fneg
; rdar://10566486
define <16 x float> @fneg(<16 x float> %a) nounwind {
; CHECK-LABEL: fneg:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovaps {{.*#+}} ymm2 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; CHECK-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; CHECK-NEXT:    vxorps %ymm2, %ymm1, %ymm1
; CHECK-NEXT:    retq
  %1 = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %a
  ret <16 x float> %1
}

;;; Don't crash on build vector
define <16 x i16> @build_vec_16x16(i16 %a) nounwind readonly {
; CHECK-LABEL: build_vec_16x16:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movzwl %di, %eax
; CHECK-NEXT:    vmovd %eax, %xmm0
; CHECK-NEXT:    retq
  %res = insertelement <16 x i16> <i16 undef, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0>, i16 %a, i32 0
  ret <16 x i16> %res
}

;;; Check that VMOVPQIto64rr generates the assembly string "vmovq".  Previously
;;; an incorrect mnemonic of "movd" was printed for this instruction.
define i64 @VMOVPQIto64rr(<2 x i64> %a) {
; CHECK-LABEL: VMOVPQIto64rr:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovq %xmm0, %rax
; CHECK-NEXT:    retq
  %vecext.i = extractelement <2 x i64> %a, i32 0
  ret i64 %vecext.i
}

; PR22685
define <8 x float> @mov00_8f32(ptr %ptr) {
; CHECK-LABEL: mov00_8f32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    retq
  %val = load float, ptr %ptr
  %vec = insertelement <8 x float> zeroinitializer, float %val, i32 0
  ret <8 x float> %vec
}
