; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=2 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC
;
; When a function is marked `alwaysinline` and is able to be inlined,
; we can IPO its boundaries

; the function is not exactly defined, and marked alwaysinline and can be inlined,
; so the function can be analyzed
define linkonce void @inner1() alwaysinline {
; CHECK: Function Attrs: alwaysinline nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@inner1
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  ret void
}

define void @outer1() {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@outer1
; TUNIT-SAME: () #[[ATTR1:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@outer1
; CGSCC-SAME: () #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    ret void
;
entry:
  call void @inner1()
  ret void
}

; The function is not alwaysinline and is not exactly defined
; so it will not be analyzed
define linkonce i32 @inner2() {
; CHECK-LABEL: define {{[^@]+}}@inner2() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 1
;
entry:
  ret i32 1
}

; CHECK-NOT: Function Attrs
define i32 @outer2() {
; TUNIT: Function Attrs: norecurse
; TUNIT-LABEL: define {{[^@]+}}@outer2
; TUNIT-SAME: () #[[ATTR2:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[R:%.*]] = call i32 @inner2() #[[ATTR3:[0-9]+]]
; TUNIT-NEXT:    ret i32 [[R]]
;
; CGSCC-LABEL: define {{[^@]+}}@outer2() {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[R:%.*]] = call i32 @inner2() #[[ATTR2:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[R]]
;
entry:
  %r = call i32 @inner2() alwaysinline
  ret i32 %r
}

; This function cannot be inlined although it is marked alwaysinline
; it is `unexactly defined` and alwaysinline but cannot be inlined.
; so it will not be analyzed
define linkonce i32 @inner3(ptr %addr) alwaysinline {
; TUNIT: Function Attrs: alwaysinline
; TUNIT-LABEL: define {{[^@]+}}@inner3
; TUNIT-SAME: (ptr [[ADDR:%.*]]) #[[ATTR3]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    indirectbr ptr [[ADDR]], [label [[ONE:%.*]], label %two]
; TUNIT:       one:
; TUNIT-NEXT:    ret i32 42
; TUNIT:       two:
; TUNIT-NEXT:    ret i32 44
;
; CGSCC: Function Attrs: alwaysinline
; CGSCC-LABEL: define {{[^@]+}}@inner3
; CGSCC-SAME: (ptr [[ADDR:%.*]]) #[[ATTR2]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    indirectbr ptr [[ADDR]], [label [[ONE:%.*]], label %two]
; CGSCC:       one:
; CGSCC-NEXT:    ret i32 42
; CGSCC:       two:
; CGSCC-NEXT:    ret i32 44
;
entry:
  indirectbr ptr %addr, [ label %one, label %two ]

one:
  ret i32 42

two:
  ret i32 44
}

define i32 @outer3(i32 %x) {
; TUNIT: Function Attrs: norecurse
; TUNIT-LABEL: define {{[^@]+}}@outer3
; TUNIT-SAME: (i32 [[X:%.*]]) #[[ATTR2]] {
; TUNIT-NEXT:    [[CMP:%.*]] = icmp slt i32 [[X]], 42
; TUNIT-NEXT:    [[ADDR:%.*]] = select i1 [[CMP]], ptr blockaddress(@inner3, [[ONE:%.*]]), ptr blockaddress(@inner3, [[TWO:%.*]])
; TUNIT-NEXT:    [[CALL:%.*]] = call i32 @inner3(ptr [[ADDR]])
; TUNIT-NEXT:    ret i32 [[CALL]]
;
; CGSCC-LABEL: define {{[^@]+}}@outer3
; CGSCC-SAME: (i32 [[X:%.*]]) {
; CGSCC-NEXT:    [[CMP:%.*]] = icmp slt i32 [[X]], 42
; CGSCC-NEXT:    [[ADDR:%.*]] = select i1 [[CMP]], ptr blockaddress(@inner3, [[ONE:%.*]]), ptr blockaddress(@inner3, [[TWO:%.*]])
; CGSCC-NEXT:    [[CALL:%.*]] = call i32 @inner3(ptr [[ADDR]])
; CGSCC-NEXT:    ret i32 [[CALL]]
;
  %cmp = icmp slt i32 %x, 42
  %addr = select i1 %cmp, ptr blockaddress(@inner3, %one), ptr blockaddress(@inner3, %two)
  %call = call i32 @inner3(ptr %addr)
  ret i32 %call
}
;.
; TUNIT: attributes #[[ATTR0]] = { alwaysinline nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR1]] = { nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR2]] = { norecurse }
; TUNIT: attributes #[[ATTR3]] = { alwaysinline }
;.
; CGSCC: attributes #[[ATTR0]] = { alwaysinline nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { alwaysinline }
;.
