; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i32_stride6_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride6_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm3 = mem[0],zero
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm3[0]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm7 = mem[0],zero
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm6[0]
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,3],xmm7[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2],xmm4[1,3]
; SSE-NEXT:    movaps %xmm5, 32(%rax)
; SSE-NEXT:    movaps %xmm7, 16(%rax)
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride6_vf2:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm4 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm4 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm5 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[u,u,0,2,u,u,5,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[1,3],xmm4[1,3]
; AVX1-ONLY-NEXT:    vmovaps %xmm1, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride6_vf2:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-SLOW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,2,1]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm3 = xmm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],xmm2[1,3]
; AVX2-SLOW-NEXT:    vmovaps %xmm1, 32(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride6_vf2:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FAST-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FAST-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX2-FAST-NEXT:    vshufps {{.*#+}} ymm3 = ymm0[1,3],ymm3[1,3],ymm0[5,7],ymm3[5,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[2,1,2,3]
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm4 = <0,2,4,6,u,u,1,3>
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX2-FAST-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-NEXT:    vmovaps %xmm3, 32(%rax)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride6_vf2:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FAST-PERLANE-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm3 = xmm2[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],xmm2[1,3]
; AVX2-FAST-PERLANE-NEXT:    vmovaps %xmm1, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride6_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    vinsertf64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512-NEXT:    vmovaps {{.*#+}} zmm1 = <0,2,4,6,8,10,1,3,5,7,9,11,u,u,u,u>
; AVX512-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    vextractf32x4 $2, %zmm0, 32(%rax)
; AVX512-NEXT:    vmovaps %ymm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <2 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <2 x i32>, ptr %in.vecptr5, align 64
  %1 = shufflevector <2 x i32> %in.vec0, <2 x i32> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i32> %in.vec2, <2 x i32> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <2 x i32> %in.vec4, <2 x i32> %in.vec5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x i32> %1, <4 x i32> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = shufflevector <4 x i32> %3, <4 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <8 x i32> %4, <8 x i32> %5, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %interleaved.vec = shufflevector <12 x i32> %6, <12 x i32> poison, <12 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11>
  store <12 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride6_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride6_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm2
; SSE-NEXT:    movaps (%rdx), %xmm1
; SSE-NEXT:    movaps (%rcx), %xmm3
; SSE-NEXT:    movaps (%r8), %xmm4
; SSE-NEXT:    movaps (%r9), %xmm5
; SSE-NEXT:    movaps %xmm1, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; SSE-NEXT:    movaps %xmm4, %xmm7
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm5[1]
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[3,3],xmm5[3,3]
; SSE-NEXT:    movaps %xmm4, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[1,1],xmm5[1,1]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm4[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm6[0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2],xmm0[2,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,3],xmm8[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,3],xmm9[0,2]
; SSE-NEXT:    movaps %xmm5, 16(%rax)
; SSE-NEXT:    movaps %xmm6, 32(%rax)
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps %xmm1, 80(%rax)
; SSE-NEXT:    movaps %xmm7, 64(%rax)
; SSE-NEXT:    movaps %xmm4, (%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride6_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm3
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm8
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm9
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm10 = ymm9[0],ymm8[0],ymm9[1],ymm8[1],ymm9[4],ymm8[4],ymm9[5],ymm8[5]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm11
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm6[0],ymm11[0],ymm6[2],ymm11[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm12 = ymm12[0,2,3,1,4,6,7,5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm13 = xmm3[0,0],xmm1[0,0]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = xmm13[0,1,2,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm13[2,3],ymm12[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm12[0,1,2,3],ymm10[4,5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm11[2],ymm6[2],ymm11[3],ymm6[3],ymm11[6],ymm6[6],ymm11[7],ymm6[7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm11
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[1,2],ymm11[1,2],ymm7[5,6],ymm11[5,6]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm7 = ymm7[0,2,3,1,4,6,7,5]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm6[0,1],ymm4[2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm8[1],ymm9[1],ymm8[3],ymm9[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,2,3,1,4,6,7,5]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,3],ymm2[3,3],ymm0[7,7],ymm2[7,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i32_stride6_vf4:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm2
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm3
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm4
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm5
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm7
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm8
; AVX2-ONLY-NEXT:    vmovaps {{.*#+}} xmm9 = <u,u,0,4>
; AVX2-ONLY-NEXT:    vpermps %ymm7, %ymm9, %ymm9
; AVX2-ONLY-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = [0,4,1,5,0,4,1,5]
; AVX2-ONLY-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-ONLY-NEXT:    vpermps %ymm6, %ymm10, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2,3],ymm10[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd {{.*#+}} ymm10 = [17179869184,17179869184,17179869184,17179869184]
; AVX2-ONLY-NEXT:    vpermps %ymm8, %ymm10, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5],ymm9[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd {{.*#+}} ymm10 = [25769803778,25769803778,25769803778,25769803778]
; AVX2-ONLY-NEXT:    vpermps %ymm6, %ymm10, %ymm6
; AVX2-ONLY-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = [1,5,2,6,1,5,2,6]
; AVX2-ONLY-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-ONLY-NEXT:    vpermps %ymm7, %ymm10, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm6[0,1],ymm4[2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [2,6,3,7,2,6,3,7]
; AVX2-ONLY-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-ONLY-NEXT:    vpermps %ymm8, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 32(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride6_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm1
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [18,22,3,7,11,15,19,23]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,4,8,12,16,20,1,5,9,13,17,21,2,6,10,14]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512-NEXT:    vmovdqa %ymm2, 64(%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <4 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <4 x i32>, ptr %in.vecptr5, align 64
  %1 = shufflevector <4 x i32> %in.vec0, <4 x i32> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %in.vec2, <4 x i32> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <4 x i32> %in.vec4, <4 x i32> %in.vec5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <8 x i32> %1, <8 x i32> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %5 = shufflevector <8 x i32> %3, <8 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <16 x i32> %4, <16 x i32> %5, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %interleaved.vec = shufflevector <24 x i32> %6, <24 x i32> poison, <24 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 3, i32 7, i32 11, i32 15, i32 19, i32 23>
  store <24 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride6_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride6_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps (%rsi), %xmm7
; SSE-NEXT:    movaps 16(%rsi), %xmm10
; SSE-NEXT:    movaps (%rdx), %xmm6
; SSE-NEXT:    movaps 16(%rdx), %xmm2
; SSE-NEXT:    movaps (%rcx), %xmm5
; SSE-NEXT:    movaps 16(%rcx), %xmm9
; SSE-NEXT:    movaps (%r8), %xmm3
; SSE-NEXT:    movaps 16(%r8), %xmm11
; SSE-NEXT:    movaps (%r9), %xmm8
; SSE-NEXT:    movaps 16(%r9), %xmm4
; SSE-NEXT:    movaps %xmm9, %xmm12
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm2[1]
; SSE-NEXT:    movaps %xmm1, %xmm13
; SSE-NEXT:    unpckhps {{.*#+}} xmm13 = xmm13[2],xmm10[2],xmm13[3],xmm10[3]
; SSE-NEXT:    movaps %xmm11, %xmm14
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,2],xmm13[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm12[2,0]
; SSE-NEXT:    movaps %xmm11, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,1],xmm4[1,1]
; SSE-NEXT:    movaps %xmm2, %xmm15
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm9[0],xmm15[1],xmm9[1]
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm10[0],xmm1[1],xmm10[1]
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[3,3],xmm4[3,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm11[0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm1[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm15[0]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[2,3],xmm12[0,2]
; SSE-NEXT:    movaps %xmm3, %xmm11
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[3,3],xmm8[3,3]
; SSE-NEXT:    movaps %xmm6, %xmm12
; SSE-NEXT:    unpckhps {{.*#+}} xmm12 = xmm12[2],xmm5[2],xmm12[3],xmm5[3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,3],xmm11[0,2]
; SSE-NEXT:    movaps %xmm0, %xmm11
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm7[2],xmm11[3],xmm7[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm9[2],xmm2[3],xmm9[3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,3],xmm10[0,2]
; SSE-NEXT:    movaps %xmm6, %xmm7
; SSE-NEXT:    unpcklps {{.*#+}} xmm7 = xmm7[0],xmm5[0],xmm7[1],xmm5[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm6[1]
; SSE-NEXT:    movaps %xmm3, %xmm6
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,2],xmm11[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm3[0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm8[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm0[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm7[0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm3[0,2]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm7, 32(%rax)
; SSE-NEXT:    movaps %xmm11, 48(%rax)
; SSE-NEXT:    movaps %xmm1, 96(%rax)
; SSE-NEXT:    movaps %xmm4, 112(%rax)
; SSE-NEXT:    movaps %xmm14, 160(%rax)
; SSE-NEXT:    movaps %xmm2, 176(%rax)
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movaps %xmm5, 16(%rax)
; SSE-NEXT:    movaps %xmm6, 64(%rax)
; SSE-NEXT:    movaps %xmm12, 80(%rax)
; SSE-NEXT:    movaps %xmm15, 128(%rax)
; SSE-NEXT:    movaps %xmm13, 144(%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride6_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm7
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm8
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm7[0],ymm8[0],ymm7[1],ymm8[1],ymm7[4],ymm8[4],ymm7[5],ymm8[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm3[0],ymm2[0],ymm3[2],ymm2[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm4[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 16(%r9), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm4[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm9
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm10
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm4 = xmm10[1,2],xmm9[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm4[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm6
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm11 = xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm12[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 4(%r8), %xmm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm12[2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 4(%r9), %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2],ymm12[3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm7[2],ymm8[2],ymm7[3],ymm8[3],ymm7[6],ymm8[6],ymm7[7],ymm8[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm2[1,2],ymm3[1,2],ymm2[5,6],ymm3[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm7 = ymm7[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 20(%r8), %xmm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm12[2,3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 20(%r9), %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2],ymm12[3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm9 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm9 = xmm9[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm11, %ymm9
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2,3,4,5],ymm10[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm10
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm11 = xmm10[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1],ymm9[2,3,4,5,6],ymm10[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[3,0],ymm2[3,0],ymm3[7,4],ymm2[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm8[2,3],ymm2[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6],ymm2[7]
; AVX1-ONLY-NEXT:    vbroadcastss (%rcx), %xmm2
; AVX1-ONLY-NEXT:    vbroadcastss (%rdx), %xmm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1],ymm2[2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r8), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss (%r9), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm3[5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovaps %ymm2, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 160(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 128(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride6_vf8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm11
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm7 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm8
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm8[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm9
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm12 = xmm9[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm12[0],xmm10[0],xmm12[1],xmm10[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm10[0,1,2,3],ymm5[4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm10
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm10[0],zero,xmm10[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1],ymm12[2,3],ymm5[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 4(%r9), %ymm12
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2],ymm12[3],ymm5[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd (%rcx), %xmm12
; AVX2-SLOW-NEXT:    vpbroadcastd (%rdx), %xmm13
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm11[0],xmm6[0],xmm11[1],xmm6[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm12[2,3],ymm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq %xmm10, %ymm11
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm11[4,5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm12
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm12, %ymm11
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4],ymm11[5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm13 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm4[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm14[0],ymm11[1],ymm14[2],ymm11[3],ymm14[4],ymm11[5],ymm14[6],ymm11[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm13[4,5],ymm11[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm14 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1],ymm14[2,3],ymm11[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 20(%r9), %ymm14
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2],ymm14[3],ymm11[4,5,6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm8 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,3,2,3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm7, %ymm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm10[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0,1],ymm7[2,3,4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm12[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3,4,5,6],ymm8[7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm8 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm8 = ymm13[2,3],ymm8[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm2[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1],ymm8[2,3,4,5],ymm9[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0],ymm9[1],ymm8[2,3,4,5,6],ymm9[7]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 16(%r9), %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, 160(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, 64(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm11, 128(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, (%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, 32(%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride6_vf8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm2
; AVX2-FAST-NEXT:    vmovdqa (%r9), %ymm5
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm7
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm11
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm8 = xmm11[2],xmm7[2],xmm11[3],xmm7[3]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm6
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm9
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm12 = xmm9[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm10
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm10[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm12[0,1,2,3],ymm6[4,5],ymm12[6,7]
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm12
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm12[0],zero,xmm12[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm13[2,3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 4(%r9), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2],ymm13[3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd (%rcx), %xmm13
; AVX2-FAST-NEXT:    vpbroadcastd (%rdx), %xmm14
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm13 = xmm14[0],xmm13[0],xmm14[1],xmm13[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm11[0],xmm7[0],xmm11[1],xmm7[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1],ymm13[2,3],ymm7[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq %xmm12, %ymm11
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm11[4,5],ymm7[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd (%r9), %ymm11
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3,4],ymm11[5],ymm7[6,7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm11 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm12 = ymm4[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm13 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0],ymm12[1],ymm13[2],ymm12[3],ymm13[4],ymm12[5],ymm13[6],ymm12[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm11[4,5],ymm12[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm13 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1],ymm13[2,3],ymm12[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 20(%r9), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2],ymm13[3],ymm12[4,5,6,7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm9 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,3,2,3]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [2,2,3,3,2,2,3,3]
; AVX2-FAST-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm9, %ymm10
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm10[0,1],ymm8[2,3,4,5],ymm10[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm9, %ymm9
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0],ymm9[1],ymm8[2,3,4,5,6],ymm9[7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm9 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 {{.*#+}} ymm9 = ymm11[2,3],ymm9[2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = <6,u,u,u,u,u,7,u>
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm10, %ymm10
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm10[0,1],ymm9[2,3,4,5],ymm10[6,7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,6,u,u,u,u,u,7>
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm10, %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm9[0],ymm5[1],ymm9[2,3,4,5,6],ymm5[7]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 16(%r9), %ymm1
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm5, 160(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm8, 64(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm12, 128(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm7, (%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm6, 32(%rax)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride6_vf8:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm7 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm10 = xmm8[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm12 = xmm9[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm12[0],xmm10[0],xmm12[1],xmm10[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm5 = ymm10[0,1,2,3],ymm5[4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm10[0],zero,xmm10[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1],ymm12[2,3],ymm5[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 4(%r9), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2],ymm12[3],ymm5[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rcx), %xmm12
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rdx), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm11[0],xmm6[0],xmm11[1],xmm6[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm12[2,3],ymm6[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq %xmm10, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm11[4,5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %xmm12
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm12, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4],ymm11[5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm13 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm11 = ymm4[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm14[0],ymm11[1],ymm14[2],ymm11[3],ymm14[4],ymm11[5],ymm14[6],ymm11[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm13[4,5],ymm11[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm14 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1],ymm14[2,3],ymm11[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 20(%r9), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2],ymm14[3],ymm11[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm8 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm8, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm8 = xmm10[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0,1],ymm7[2,3,4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm8 = xmm12[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3,4,5,6],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm8 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 {{.*#+}} ymm8 = ymm13[2,3],ymm8[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = ymm2[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1],ymm8[2,3,4,5],ymm9[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0],ymm9[1],ymm8[2,3,4,5,6],ymm9[7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 16(%r9), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, 160(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm7, 64(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm11, 128(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride6_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-NEXT:    vmovdqa (%r8), %ymm2
; AVX512-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <0,8,16,24,u,u,1,9,17,25,u,u,2,10,18,26>
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,2,3,16,24,6,7,8,9,17,25,12,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,u,3,11,19,27,u,u,4,12,20,28,u,u,5,13>
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [18,26,2,3,4,5,19,27,8,9,10,11,20,28,14,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <5,13,u,u,22,30,6,14,u,u,23,31,7,15,u,u>
; AVX512-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,1,21,29,4,5,6,7,22,30,10,11,12,13,23,31]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <8 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <8 x i32>, ptr %in.vecptr5, align 64
  %1 = shufflevector <8 x i32> %in.vec0, <8 x i32> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i32> %in.vec2, <8 x i32> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <8 x i32> %in.vec4, <8 x i32> %in.vec5, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <16 x i32> %1, <16 x i32> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %5 = shufflevector <16 x i32> %3, <16 x i32> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <32 x i32> %4, <32 x i32> %5, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %interleaved.vec = shufflevector <48 x i32> %6, <48 x i32> poison, <48 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 1, i32 9, i32 17, i32 25, i32 33, i32 41, i32 2, i32 10, i32 18, i32 26, i32 34, i32 42, i32 3, i32 11, i32 19, i32 27, i32 35, i32 43, i32 4, i32 12, i32 20, i32 28, i32 36, i32 44, i32 5, i32 13, i32 21, i32 29, i32 37, i32 45, i32 6, i32 14, i32 22, i32 30, i32 38, i32 46, i32 7, i32 15, i32 23, i32 31, i32 39, i32 47>
  store <48 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride6_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride6_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movaps (%rdi), %xmm4
; SSE-NEXT:    movaps 16(%rdi), %xmm5
; SSE-NEXT:    movaps (%rsi), %xmm8
; SSE-NEXT:    movaps 16(%rsi), %xmm11
; SSE-NEXT:    movaps (%rdx), %xmm6
; SSE-NEXT:    movaps 16(%rdx), %xmm7
; SSE-NEXT:    movaps (%rcx), %xmm1
; SSE-NEXT:    movaps 16(%rcx), %xmm14
; SSE-NEXT:    movaps (%r8), %xmm9
; SSE-NEXT:    movaps 16(%r8), %xmm15
; SSE-NEXT:    movaps (%r9), %xmm2
; SSE-NEXT:    movaps 16(%r9), %xmm0
; SSE-NEXT:    movaps %xmm6, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm1[0],xmm10[1],xmm1[1]
; SSE-NEXT:    movaps %xmm4, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm8[0],xmm3[1],xmm8[1]
; SSE-NEXT:    movaps %xmm2, %xmm12
; SSE-NEXT:    movlhps {{.*#+}} xmm12 = xmm12[0],xmm9[0]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,0],xmm3[2,3]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm10[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm3[0,2]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm6[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm4 = xmm4[2],xmm8[2],xmm4[3],xmm8[3]
; SSE-NEXT:    movaps %xmm9, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,2],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[3,3],xmm2[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,3],xmm9[0,2]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm14[0],xmm2[1],xmm14[1]
; SSE-NEXT:    movaps %xmm5, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[1],xmm11[1]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm15[0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm1[2,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm11[2],xmm5[3],xmm11[3]
; SSE-NEXT:    movaps %xmm15, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm5[2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdi), %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[3,3],xmm0[3,3]
; SSE-NEXT:    movaps 32(%rdx), %xmm13
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm14[2],xmm7[3],xmm14[3]
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm15[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm15
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm0[0],xmm15[1],xmm0[1]
; SSE-NEXT:    movaps 32(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm12, %xmm14
; SSE-NEXT:    unpcklps {{.*#+}} xmm14 = xmm14[0],xmm1[0],xmm14[1],xmm1[1]
; SSE-NEXT:    movaps 32(%r8), %xmm2
; SSE-NEXT:    movaps 32(%r9), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,0],xmm14[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm15[0]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[2,3],xmm3[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm12 = xmm12[2],xmm1[2],xmm12[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm13[1]
; SSE-NEXT:    movaps %xmm2, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,2],xmm12[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm4[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm13 = xmm13[2],xmm0[2],xmm13[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,3],xmm2[0,2]
; SSE-NEXT:    movaps 48(%rdx), %xmm2
; SSE-NEXT:    movaps 48(%rcx), %xmm9
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1]
; SSE-NEXT:    movaps 48(%rdi), %xmm0
; SSE-NEXT:    movaps 48(%rsi), %xmm10
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm10[0],xmm5[1],xmm10[1]
; SSE-NEXT:    movaps 48(%r8), %xmm3
; SSE-NEXT:    movaps 48(%r9), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm3[0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm5[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,3],xmm1[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm10[2],xmm0[3],xmm10[3]
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movaps %xmm3, %xmm10
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm7[1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm0[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm7[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm9[2],xmm2[3],xmm9[3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,3],xmm3[0,2]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm2, 368(%rax)
; SSE-NEXT:    movaps %xmm10, 352(%rax)
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps %xmm4, 320(%rax)
; SSE-NEXT:    movaps %xmm6, 304(%rax)
; SSE-NEXT:    movaps %xmm5, 288(%rax)
; SSE-NEXT:    movaps %xmm13, 272(%rax)
; SSE-NEXT:    movaps %xmm8, 256(%rax)
; SSE-NEXT:    movaps %xmm12, 240(%rax)
; SSE-NEXT:    movaps %xmm15, 224(%rax)
; SSE-NEXT:    movaps %xmm11, 208(%rax)
; SSE-NEXT:    movaps %xmm14, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride6_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $104, %rsp
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %ymm13
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %ymm11
; AVX1-ONLY-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm8
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm10
; AVX1-ONLY-NEXT:    vmovaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm6[1,2],xmm8[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 4(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 4(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm4[0],ymm13[0],ymm4[1],ymm13[1],ymm4[4],ymm13[4],ymm4[5],ymm13[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm9[0],ymm7[0],ymm9[2],ymm7[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm11[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 48(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm10[1,2],xmm3[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm15 = xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm11[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 36(%r8), %xmm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm11[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 36(%r9), %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm11[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm11 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm11[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm11
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %ymm12
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm12[0],ymm11[0],ymm12[2],ymm11[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm14[0,1],ymm10[2,3],ymm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm14
; AVX1-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm14[4,5],ymm10[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 16(%r9), %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm10[0,1,2,3,4],ymm14[5],ymm10[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm13 = ymm4[2],ymm13[2],ymm4[3],ymm13[3],ymm4[6],ymm13[6],ymm4[7],ymm13[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm4 = ymm7[1,2],ymm9[1,2],ymm7[5,6],ymm9[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm13[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 52(%r8), %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm10[2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 52(%r9), %ymm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm4[0,1,2],ymm10[3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm11[1,2],ymm12[1,2],ymm11[5,6],ymm12[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 20(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 20(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm6[2],xmm8[2],xmm6[3],xmm8[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm0[0],ymm5[1],ymm0[2,3,4,5,6],ymm5[7]
; AVX1-ONLY-NEXT:    vbroadcastss 32(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vbroadcastss 32(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%r8), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 32(%r9), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm9[3,0],ymm7[3,0],ymm9[7,4],ymm7[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm13[2,3],ymm0[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm3 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4,5,6],ymm3[7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = xmm3[2],mem[2],xmm3[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm15, %ymm3
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm6
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm6[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm6[1],ymm3[2,3,4,5,6],ymm6[7]
; AVX1-ONLY-NEXT:    vbroadcastss (%rcx), %xmm6
; AVX1-ONLY-NEXT:    vbroadcastss (%rdx), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm7 = xmm7[0],mem[0],xmm7[1],mem[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm8[0,1],ymm6[2,3],ymm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r8), %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss (%r9), %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4],ymm7[5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm12[3,0],ymm11[3,0],ymm12[7,4],ymm11[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm7 = ymm7[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm7[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm7 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm7 = ymm7[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1],ymm4[2,3,4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm7 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm7 = ymm7[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm7[1],ymm4[2,3,4,5,6],ymm7[7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 160(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 256(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 192(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 320(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm14, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    addq $104, %rsp
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride6_vf16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $200, %rsp
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm11
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm0[2],xmm11[2],xmm0[3],xmm11[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm4
; AVX2-SLOW-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm8
; AVX2-SLOW-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm13
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %xmm7
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm13[0],zero,xmm13[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 4(%r9), %ymm4
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2],ymm4[3],ymm3[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm6[1,2,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm8[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm7[0],zero,xmm7[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 36(%r9), %ymm4
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2],ymm4[3],ymm3[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd 32(%rcx), %xmm3
; AVX2-SLOW-NEXT:    vpbroadcastd 32(%rdx), %xmm4
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm10
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq %xmm7, %ymm2
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 32(%r9), %xmm15
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm15, %ymm2
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm14
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm14[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm10[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm9
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm8
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm9[2],ymm8[2],ymm9[3],ymm8[3],ymm9[6],ymm8[6],ymm9[7],ymm8[7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 52(%r9), %ymm3
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm3[3],ymm1[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd (%rcx), %xmm1
; AVX2-SLOW-NEXT:    vpbroadcastd (%rdx), %xmm3
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm11[0],xmm0[1],xmm11[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq %xmm13, %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm1
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm1, %ymm2
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm0[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0],ymm3[1],ymm5[2],ymm3[3],ymm5[4],ymm3[5],ymm5[6],ymm3[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm3[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm6
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm5
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm6[2],ymm5[2],ymm6[3],ymm5[3],ymm6[6],ymm5[6],ymm6[7],ymm5[7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm3[4,5],ymm11[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm12 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1],ymm12[2,3],ymm11[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 20(%r9), %ymm12
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2],ymm12[3],ymm11[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm12 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm12 = xmm11[2],mem[2],xmm11[3],mem[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovdqu (%rsp), %ymm11 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm11, %ymm12
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1],ymm12[2,3,4,5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm12[0],ymm1[1],ymm12[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm12 = ymm10[2],ymm14[2],ymm10[3],ymm14[3],ymm10[6],ymm14[6],ymm10[7],ymm14[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm4[2,3],ymm12[2,3]
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %ymm12
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm12[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm13[0,1],ymm4[2,3,4,5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0],ymm13[1],ymm4[2,3,4,5,6],ymm13[7]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm13 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm13 = xmm11[2],mem[2],xmm11[3],mem[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm13, %ymm11, %ymm13
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1],ymm13[2,3,4,5],ymm7[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm15[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0],ymm13[1],ymm7[2,3,4,5,6],ymm13[7]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm10 = ymm10[0],ymm14[0],ymm10[1],ymm14[1],ymm10[4],ymm14[4],ymm10[5],ymm14[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm9[0],ymm8[0],ymm9[1],ymm8[1],ymm9[4],ymm8[4],ymm9[5],ymm8[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm10[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm12[4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 48(%r9), %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4],ymm9[5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm9 = ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[6],ymm0[6],ymm2[7],ymm0[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm3[2,3],ymm9[2,3]
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm9
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm9[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm10[0,1],ymm3[2,3,4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0],ymm10[1],ymm3[2,3,4,5,6],ymm10[7]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[4],ymm0[4],ymm2[5],ymm0[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm2 = ymm6[0],ymm5[0],ymm6[1],ymm5[1],ymm6[4],ymm5[4],ymm6[5],ymm5[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm9[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 16(%r9), %ymm2
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, 160(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, 288(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, 256(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 352(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-SLOW-NEXT:    addq $200, %rsp
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride6_vf16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $232, %rsp
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm11
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm13
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm6 = xmm13[2],xmm11[2],xmm13[3],xmm11[3]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm8
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %xmm7
; AVX2-FAST-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm8[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm9
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX2-FAST-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm9[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm0[4,5],ymm3[6,7]
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm0
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %xmm4
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm5[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 4(%r9), %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2],ymm5[3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm7[1,2,2,3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm10[0],xmm5[0],xmm10[1],xmm5[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5],ymm5[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm5[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 36(%r9), %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2],ymm5[3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd 32(%rcx), %xmm3
; AVX2-FAST-NEXT:    vpbroadcastd 32(%rdx), %xmm5
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %ymm10
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %ymm12
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq %xmm4, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 32(%r9), %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm10[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %ymm15
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm2[2],ymm15[2],ymm2[3],ymm15[3],ymm2[6],ymm15[6],ymm2[7],ymm15[7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 52(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm3[3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd (%rcx), %xmm1
; AVX2-FAST-NEXT:    vpbroadcastd (%rdx), %xmm3
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm13[0],xmm11[0],xmm13[1],xmm11[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq %xmm0, %ymm0
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd (%r9), %ymm1
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm5
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm1[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm5[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2],ymm3[3],ymm4[4],ymm3[5],ymm4[6],ymm3[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm3[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm14
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm4
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm14[2],ymm4[2],ymm14[3],ymm4[3],ymm14[6],ymm4[6],ymm14[7],ymm4[7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm3[4,5],ymm13[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm11 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm11 = ymm13[0,1],ymm11[2,3],ymm13[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 20(%r9), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm11[0,1,2],ymm13[3],ymm11[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm7, (%rsp) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm8 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,3,2,3]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm8
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [2,2,3,3,2,2,3,3]
; AVX2-FAST-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermd %ymm8, %ymm9, %ymm11
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm11[0,1],ymm6[2,3,4,5],ymm11[6,7]
; AVX2-FAST-NEXT:    vmovdqa (%r9), %ymm11
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm9, %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0],ymm13[1],ymm6[2,3,4,5,6],ymm13[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm13 = ymm10[2],ymm12[2],ymm10[3],ymm12[3],ymm10[6],ymm12[6],ymm10[7],ymm12[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm13 = ymm13[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm2[2,3],ymm13[2,3]
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %ymm13
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [6,5,3,3,6,5,7,7]
; AVX2-FAST-NEXT:    vpermd %ymm13, %ymm0, %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm7[0,1],ymm2[2,3,4,5],ymm7[6,7]
; AVX2-FAST-NEXT:    vmovdqa 32(%r9), %ymm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [4,6,2,3,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm7, %ymm0, %ymm6
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm6[1],ymm2[2,3,4,5,6],ymm6[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm6 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm6 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm2, %ymm6
; AVX2-FAST-NEXT:    vpermd %ymm13, %ymm9, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1],ymm6[2,3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm7, %ymm9, %ymm6
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm6[1],ymm2[2,3,4,5,6],ymm6[7]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm6 = ymm10[0],ymm12[0],ymm10[1],ymm12[1],ymm10[4],ymm12[4],ymm10[5],ymm12[5]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm7 = ymm7[0],ymm15[0],ymm7[1],ymm15[1],ymm7[4],ymm15[4],ymm7[5],ymm15[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm13[4,5],ymm6[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 48(%r9), %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4],ymm7[5],ymm6[6,7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm7 = ymm5[2],ymm1[2],ymm5[3],ymm1[3],ymm5[6],ymm1[6],ymm5[7],ymm1[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm3[2,3],ymm7[2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [6,5,3,3,6,5,7,7]
; AVX2-FAST-NEXT:    vpermd %ymm8, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm7[0,1],ymm3[2,3,4,5],ymm7[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm0, %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0],ymm7[1],ymm3[2,3,4,5,6],ymm7[7]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm5[0],ymm1[0],ymm5[1],ymm1[1],ymm5[4],ymm1[4],ymm5[5],ymm1[5]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm14[0],ymm4[0],ymm14[1],ymm4[1],ymm14[4],ymm4[4],ymm14[5],ymm4[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 16(%r9), %ymm1
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 160(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm6, 288(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 256(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FAST-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FAST-NEXT:    addq $232, %rsp
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride6_vf16:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $200, %rsp
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm0[2],xmm11[2],xmm0[3],xmm11[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm13[0],zero,xmm13[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 4(%r9), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2],ymm4[3],ymm3[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm6[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm8[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm7[0],zero,xmm7[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 36(%r9), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2],ymm4[3],ymm3[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 32(%rcx), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 32(%rdx), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq %xmm7, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r9), %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm15, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm14[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm10[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm9[2],ymm8[2],ymm9[3],ymm8[3],ymm9[6],ymm8[6],ymm9[7],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 52(%r9), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm3[3],ymm1[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rcx), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rdx), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm11[0],xmm0[1],xmm11[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq %xmm13, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm1, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm0[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0],ymm3[1],ymm5[2],ymm3[3],ymm5[4],ymm3[5],ymm5[6],ymm3[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm3[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm6[2],ymm5[2],ymm6[3],ymm5[3],ymm6[6],ymm5[6],ymm6[7],ymm5[7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm3[4,5],ymm11[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm12 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1],ymm12[2,3],ymm11[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 20(%r9), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2],ymm12[3],ymm11[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm12 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm12 = xmm11[2],mem[2],xmm11[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu (%rsp), %ymm11 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm12, %ymm11, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1],ymm12[2,3,4,5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm12[0],ymm1[1],ymm12[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm12 = ymm10[2],ymm14[2],ymm10[3],ymm14[3],ymm10[6],ymm14[6],ymm10[7],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm4[2,3],ymm12[2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm13 = ymm12[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm13[0,1],ymm4[2,3,4,5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm13 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0],ymm13[1],ymm4[2,3,4,5,6],ymm13[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm13 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm13 = xmm11[2],mem[2],xmm11[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm13, %ymm11, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1],ymm13[2,3,4,5],ymm7[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm13 = xmm15[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0],ymm13[1],ymm7[2,3,4,5,6],ymm13[7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm10 = ymm10[0],ymm14[0],ymm10[1],ymm14[1],ymm10[4],ymm14[4],ymm10[5],ymm14[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm9[0],ymm8[0],ymm9[1],ymm8[1],ymm9[4],ymm8[4],ymm9[5],ymm8[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm10[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm12[4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 48(%r9), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4],ymm9[5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm9 = ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[6],ymm0[6],ymm2[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm3[2,3],ymm9[2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm10 = ymm9[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm10[0,1],ymm3[2,3,4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm10 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0],ymm10[1],ymm3[2,3,4,5,6],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[4],ymm0[4],ymm2[5],ymm0[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm2 = ymm6[0],ymm5[0],ymm6[1],ymm5[1],ymm6[4],ymm5[4],ymm6[5],ymm5[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm9[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 16(%r9), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, 160(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, 288(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm7, 256(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, 352(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    addq $200, %rsp
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i32_stride6_vf16:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512F-SLOW-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 (%r9), %zmm0
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512F-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %ymm7
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [3,11,0,8,7,15,4,12]
; AVX512F-SLOW-NEXT:    vpermi2d (%rcx), %ymm7, %ymm8
; AVX512F-SLOW-NEXT:    movb $36, %cl
; AVX512F-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm6 {%k1} = zmm8[0,1,0,1,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512F-SLOW-NEXT:    vpermi2d %zmm1, %zmm6, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm0, %zmm7, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,0,16,11,27,u,u,15,31,12,28,u,u,0,16>
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512F-SLOW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512F-SLOW-NEXT:    vpermi2d %zmm1, %zmm8, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm0, %zmm7, %zmm8
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512F-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512F-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512F-SLOW-NEXT:    movb $-110, %cl
; AVX512F-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512F-SLOW-NEXT:    vpermi2d %zmm1, %zmm9, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm0, %zmm7, %zmm9
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512F-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512F-SLOW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm10
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm10 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512F-SLOW-NEXT:    vpermi2d %zmm1, %zmm10, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm0, %zmm7, %zmm10
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512F-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %ymm11
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm11 = ymm11[2],mem[2],ymm11[3],mem[3],ymm11[6],mem[6],ymm11[7],mem[7]
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm7 {%k1} = zmm11[0,1,2,3,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512F-SLOW-NEXT:    vpermi2d %zmm1, %zmm7, %zmm11
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm0, %zmm11, %zmm7
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512F-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm11
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm2 = zmm2[2],zmm3[2],zmm2[3],zmm3[3],zmm2[6],zmm3[6],zmm2[7],zmm3[7],zmm2[10],zmm3[10],zmm2[11],zmm3[11],zmm2[14],zmm3[14],zmm2[15],zmm3[15]
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm11 {%k1} = zmm2[0,1,6,7,6,7,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512F-SLOW-NEXT:    vpermi2d %zmm1, %zmm11, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm10, (%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm9, 192(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm1, 320(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm8, 256(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm7, 128(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm6, 64(%rax)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i32_stride6_vf16:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 (%rsi), %zmm5
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512F-FAST-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 (%r9), %zmm0
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512F-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm6
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512F-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512F-FAST-NEXT:    movb $-110, %cl
; AVX512F-FAST-NEXT:    kmovw %ecx, %k2
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, %zmm7 {%k2}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512F-FAST-NEXT:    vpermi2d %zmm1, %zmm7, %zmm8
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm8, %zmm6
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,0,16,3,19,u,u,7,23,4,20,u,u,0,16>
; AVX512F-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm7
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512F-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm8
; AVX512F-FAST-NEXT:    movb $36, %cl
; AVX512F-FAST-NEXT:    kmovw %ecx, %k1
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512F-FAST-NEXT:    vpermi2d %zmm1, %zmm8, %zmm7
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm7, %zmm8
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <2,18,u,u,6,22,7,23,u,u,7,23,2,18,u,u>
; AVX512F-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512F-FAST-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512F-FAST-NEXT:    vpermi2d %zmm1, %zmm9, %zmm7
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm7, %zmm9
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512F-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm7
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512F-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm10 {%k2}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512F-FAST-NEXT:    vpermi2d %zmm1, %zmm10, %zmm7
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm7, %zmm10
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,0,16,11,27,u,u,15,31,12,28,u,u,0,16>
; AVX512F-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm7
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512F-FAST-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm11 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512F-FAST-NEXT:    vpermi2d %zmm1, %zmm11, %zmm7
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm7, %zmm11
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <2,18,u,u,14,30,15,31,u,u,15,31,2,18,u,u>
; AVX512F-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512F-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm3 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512F-FAST-NEXT:    vpermi2d %zmm1, %zmm3, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm2, %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, 320(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm11, 256(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm10, 192(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm9, 128(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-SLOW-LABEL: store_i32_stride6_vf16:
; AVX512BW-SLOW:       # %bb.0:
; AVX512BW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%r9), %zmm0
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512BW-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512BW-SLOW-NEXT:    vmovdqa (%rdx), %ymm7
; AVX512BW-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [3,11,0,8,7,15,4,12]
; AVX512BW-SLOW-NEXT:    vpermi2d (%rcx), %ymm7, %ymm8
; AVX512BW-SLOW-NEXT:    movb $36, %cl
; AVX512BW-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm6 {%k1} = zmm8[0,1,0,1,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm1, %zmm6, %zmm7
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm0, %zmm7, %zmm6
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,0,16,11,27,u,u,15,31,12,28,u,u,0,16>
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512BW-SLOW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm1, %zmm8, %zmm7
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm0, %zmm7, %zmm8
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512BW-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512BW-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512BW-SLOW-NEXT:    movb $-110, %cl
; AVX512BW-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm1, %zmm9, %zmm7
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm0, %zmm7, %zmm9
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512BW-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512BW-SLOW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm10
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm10 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm1, %zmm10, %zmm7
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm0, %zmm7, %zmm10
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512BW-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512BW-SLOW-NEXT:    vmovdqa (%rdi), %ymm11
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm11 = ymm11[2],mem[2],ymm11[3],mem[3],ymm11[6],mem[6],ymm11[7],mem[7]
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm7 {%k1} = zmm11[0,1,2,3,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm1, %zmm7, %zmm11
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm0, %zmm11, %zmm7
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512BW-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm11
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm2 = zmm2[2],zmm3[2],zmm2[3],zmm3[3],zmm2[6],zmm3[6],zmm2[7],zmm3[7],zmm2[10],zmm3[10],zmm2[11],zmm3[11],zmm2[14],zmm3[14],zmm2[15],zmm3[15]
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm11 {%k1} = zmm2[0,1,6,7,6,7,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm1, %zmm11, %zmm2
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm1
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm10, (%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm9, 192(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm1, 320(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm8, 256(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm7, 128(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm6, 64(%rax)
; AVX512BW-SLOW-NEXT:    vzeroupper
; AVX512BW-SLOW-NEXT:    retq
;
; AVX512BW-FAST-LABEL: store_i32_stride6_vf16:
; AVX512BW-FAST:       # %bb.0:
; AVX512BW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rsi), %zmm5
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512BW-FAST-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512BW-FAST-NEXT:    vmovdqa64 (%r9), %zmm0
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512BW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm6
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512BW-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512BW-FAST-NEXT:    movb $-110, %cl
; AVX512BW-FAST-NEXT:    kmovd %ecx, %k2
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm7 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm1, %zmm7, %zmm8
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm8, %zmm6
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,0,16,3,19,u,u,7,23,4,20,u,u,0,16>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm7
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512BW-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm8
; AVX512BW-FAST-NEXT:    movb $36, %cl
; AVX512BW-FAST-NEXT:    kmovd %ecx, %k1
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm1, %zmm8, %zmm7
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm7, %zmm8
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <2,18,u,u,6,22,7,23,u,u,7,23,2,18,u,u>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512BW-FAST-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm1, %zmm9, %zmm7
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm7, %zmm9
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512BW-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm7
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512BW-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm10 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm1, %zmm10, %zmm7
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm7, %zmm10
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,0,16,11,27,u,u,15,31,12,28,u,u,0,16>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm7
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512BW-FAST-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm11 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm1, %zmm11, %zmm7
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm7, %zmm11
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <2,18,u,u,14,30,15,31,u,u,15,31,2,18,u,u>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512BW-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm4, %zmm2, %zmm3
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm3 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512BW-FAST-NEXT:    vpermi2d %zmm1, %zmm3, %zmm2
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm2, %zmm1
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm1, 320(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm11, 256(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm10, 192(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm9, 128(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512BW-FAST-NEXT:    vzeroupper
; AVX512BW-FAST-NEXT:    retq
  %in.vec0 = load <16 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <16 x i32>, ptr %in.vecptr5, align 64
  %1 = shufflevector <16 x i32> %in.vec0, <16 x i32> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i32> %in.vec2, <16 x i32> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <16 x i32> %in.vec4, <16 x i32> %in.vec5, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <32 x i32> %1, <32 x i32> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %5 = shufflevector <32 x i32> %3, <32 x i32> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <64 x i32> %4, <64 x i32> %5, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %interleaved.vec = shufflevector <96 x i32> %6, <96 x i32> poison, <96 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 80, i32 1, i32 17, i32 33, i32 49, i32 65, i32 81, i32 2, i32 18, i32 34, i32 50, i32 66, i32 82, i32 3, i32 19, i32 35, i32 51, i32 67, i32 83, i32 4, i32 20, i32 36, i32 52, i32 68, i32 84, i32 5, i32 21, i32 37, i32 53, i32 69, i32 85, i32 6, i32 22, i32 38, i32 54, i32 70, i32 86, i32 7, i32 23, i32 39, i32 55, i32 71, i32 87, i32 8, i32 24, i32 40, i32 56, i32 72, i32 88, i32 9, i32 25, i32 41, i32 57, i32 73, i32 89, i32 10, i32 26, i32 42, i32 58, i32 74, i32 90, i32 11, i32 27, i32 43, i32 59, i32 75, i32 91, i32 12, i32 28, i32 44, i32 60, i32 76, i32 92, i32 13, i32 29, i32 45, i32 61, i32 77, i32 93, i32 14, i32 30, i32 46, i32 62, i32 78, i32 94, i32 15, i32 31, i32 47, i32 63, i32 79, i32 95>
  store <96 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride6_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride6_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $456, %rsp # imm = 0x1C8
; SSE-NEXT:    movaps (%rdi), %xmm9
; SSE-NEXT:    movaps 16(%rdi), %xmm10
; SSE-NEXT:    movaps (%rsi), %xmm4
; SSE-NEXT:    movaps 16(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm11
; SSE-NEXT:    movaps 16(%rdx), %xmm12
; SSE-NEXT:    movaps (%rcx), %xmm5
; SSE-NEXT:    movaps 16(%rcx), %xmm1
; SSE-NEXT:    movaps (%r8), %xmm6
; SSE-NEXT:    movaps 16(%r8), %xmm2
; SSE-NEXT:    movaps (%r9), %xmm7
; SSE-NEXT:    movaps 16(%r9), %xmm3
; SSE-NEXT:    movaps %xmm11, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1]
; SSE-NEXT:    movaps %xmm9, %xmm8
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm4[0],xmm8[1],xmm4[1]
; SSE-NEXT:    movaps %xmm7, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm6[0]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,0],xmm8[2,3]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm13[0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,3],xmm8[0,2]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm11[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm4[2],xmm9[3],xmm4[3]
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm7[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm9[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[3,3],xmm7[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm5[2],xmm11[3],xmm5[3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm6[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    movaps %xmm10, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1]
; SSE-NEXT:    movaps %xmm3, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm12[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm0[2],xmm10[3],xmm0[3]
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm10[2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm4[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdi), %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    movaps 32(%rdx), %xmm6
; SSE-NEXT:    unpckhps {{.*#+}} xmm12 = xmm12[2],xmm1[2],xmm12[3],xmm1[3]
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm7
; SSE-NEXT:    unpcklps {{.*#+}} xmm7 = xmm7[0],xmm0[0],xmm7[1],xmm0[1]
; SSE-NEXT:    movaps 32(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 32(%r8), %xmm2
; SSE-NEXT:    movaps 32(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm7[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm6[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm5[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm7
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rdi), %xmm6
; SSE-NEXT:    movaps 48(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 48(%r8), %xmm2
; SSE-NEXT:    movaps 48(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm7
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 64(%rdi), %xmm6
; SSE-NEXT:    movaps 64(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 64(%r8), %xmm2
; SSE-NEXT:    movaps 64(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm7
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 80(%rdi), %xmm6
; SSE-NEXT:    movaps 80(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 80(%r8), %xmm2
; SSE-NEXT:    movaps 80(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm11
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm11, %xmm12
; SSE-NEXT:    unpcklps {{.*#+}} xmm12 = xmm12[0],xmm0[0],xmm12[1],xmm0[1]
; SSE-NEXT:    movaps 96(%rdi), %xmm10
; SSE-NEXT:    movaps 96(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm10, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm1[0],xmm13[1],xmm1[1]
; SSE-NEXT:    movaps 96(%r8), %xmm2
; SSE-NEXT:    movaps 96(%r9), %xmm8
; SSE-NEXT:    movaps %xmm8, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[2,0],xmm13[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm12[0]
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm8[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,3],xmm5[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm1[2],xmm10[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm11[1]
; SSE-NEXT:    movaps %xmm2, %xmm9
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm10[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm8[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm0[2],xmm11[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm2[0,2]
; SSE-NEXT:    movaps 112(%rdx), %xmm2
; SSE-NEXT:    movaps 112(%rcx), %xmm8
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1]
; SSE-NEXT:    movaps 112(%rdi), %xmm0
; SSE-NEXT:    movaps 112(%rsi), %xmm14
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm14[0],xmm5[1],xmm14[1]
; SSE-NEXT:    movaps 112(%r8), %xmm3
; SSE-NEXT:    movaps 112(%r9), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm3[0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm5[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,3],xmm1[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm14[2],xmm0[3],xmm14[3]
; SSE-NEXT:    movaps %xmm8, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movaps %xmm3, %xmm14
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm7[1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,2],xmm0[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm7[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm8[2],xmm2[3],xmm8[3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,3],xmm3[0,2]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm2, 752(%rax)
; SSE-NEXT:    movaps %xmm14, 736(%rax)
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps %xmm4, 704(%rax)
; SSE-NEXT:    movaps %xmm6, 688(%rax)
; SSE-NEXT:    movaps %xmm5, 672(%rax)
; SSE-NEXT:    movaps %xmm11, 656(%rax)
; SSE-NEXT:    movaps %xmm9, 640(%rax)
; SSE-NEXT:    movaps %xmm10, 624(%rax)
; SSE-NEXT:    movaps %xmm12, 608(%rax)
; SSE-NEXT:    movaps %xmm15, 592(%rax)
; SSE-NEXT:    movaps %xmm13, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $456, %rsp # imm = 0x1C8
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride6_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $1016, %rsp # imm = 0x3F8
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm8
; AVX1-ONLY-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm9
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %ymm10
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm5
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm1[2],xmm7[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 4(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 4(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm10[0],ymm4[0],ymm10[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 16(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[1,2],xmm2[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 36(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 36(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %ymm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm8[0],ymm7[0],ymm8[1],ymm7[1],ymm8[4],ymm7[4],ymm8[5],ymm7[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 48(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,2],xmm0[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 68(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 68(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %ymm5
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm5[0],ymm0[1],ymm5[1],ymm0[4],ymm5[4],ymm0[5],ymm5[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %ymm6
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %ymm14
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm14[0],ymm6[0],ymm14[2],ymm6[2]
; AVX1-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 80(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %xmm15
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,2],xmm15[1,2]
; AVX1-ONLY-NEXT:    vmovaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm13
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm4[2],xmm13[2],xmm4[3],xmm13[3]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 100(%r8), %xmm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 100(%r9), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm3[3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm12 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[4],ymm2[4],ymm3[5],ymm2[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm12[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %ymm12
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %ymm11
; AVX1-ONLY-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm11[0],ymm12[0],ymm11[2],ymm12[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm11 = ymm11[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm11, %xmm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm11[2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 112(%r9), %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm11[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm0[2],ymm9[2],ymm0[3],ymm9[3],ymm0[6],ymm9[6],ymm0[7],ymm9[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm9 = ymm0[1,2],ymm10[1,2],ymm0[5,6],ymm10[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm9 = ymm9[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm11[4,5],ymm9[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 20(%r8), %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1],ymm10[2,3],ymm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 20(%r9), %ymm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2],ymm10[3],ymm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm8[2],ymm7[2],ymm8[3],ymm7[3],ymm8[6],ymm7[6],ymm8[7],ymm7[7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm10[1,2],ymm9[1,2],ymm10[5,6],ymm9[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm7 = ymm7[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm1[4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 52(%r8), %xmm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm8[2,3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 52(%r9), %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm7[0,1,2],ymm8[3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm1[2],ymm5[2],ymm1[3],ymm5[3],ymm1[6],ymm5[6],ymm1[7],ymm5[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[1,2],ymm14[1,2],ymm6[5,6],ymm14[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm7[4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 84(%r8), %xmm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm6[2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 84(%r9), %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2],ymm6[3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm4[0],xmm13[0],xmm4[1],xmm13[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm15[0,0,0,0]
; AVX1-ONLY-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm5 = mem[0,0,0,0]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%r8), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm4[2,3],ymm1[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 96(%r9), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm1[0,1,2,3,4],ymm4[5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm3[2],ymm2[2],ymm3[3],ymm2[3],ymm3[6],ymm2[6],ymm3[7],ymm2[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm12[1,2],ymm13[1,2],ymm12[5,6],ymm13[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 116(%r8), %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 116(%r9), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vbroadcastss (%rcx), %xmm1
; AVX1-ONLY-NEXT:    vbroadcastss (%rdx), %xmm2
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r8), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss (%r9), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm2[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6],ymm2[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm11[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm1 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm1 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vbroadcastss 32(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vbroadcastss 32(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklps (%rsp), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%r8), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 32(%r9), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4],ymm2[5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm3
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm3[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm1[0],ymm3[1],ymm1[2,3,4,5,6],ymm3[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm9[3,0],ymm10[3,0],ymm9[7,4],ymm10[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm3 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3,4,5,6],ymm3[7]
; AVX1-ONLY-NEXT:    vbroadcastss 64(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vbroadcastss 64(%rdx), %xmm5
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm5 = xmm5[0],mem[0],xmm5[1],mem[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm8[0,1],ymm3[2,3],ymm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%r8), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3],ymm5[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 64(%r9), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm5[5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm5 = xmm5[2],mem[2],xmm5[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm8, %ymm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm8 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3,4,5],ymm8[6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm8
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm9 = xmm8[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm9, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm8[1],ymm5[2,3,4,5,6],ymm8[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm8 = ymm8[3,0],mem[3,0],ymm8[7,4],mem[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm7[2,3],ymm8[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm8 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm8 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2,3,4,5],ymm8[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm8 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3,4,5,6],ymm8[7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm8 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm8 = xmm8[2],mem[2],xmm8[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm8 = xmm8[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm9, %ymm8
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm9 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm9, %ymm9
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1],ymm8[2,3,4,5],ymm9[6,7]
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %xmm9
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm9[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm9[1],ymm8[2,3,4,5,6],ymm9[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm9 = ymm13[3,0],ymm12[3,0],ymm13[7,4],ymm12[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm9 = ymm9[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm9[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm9 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm9 = ymm9[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0,1],ymm4[2,3,4,5],ymm9[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm9 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm9 = ymm9[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm9[1],ymm4[2,3,4,5,6],ymm9[7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 736(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 640(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 544(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 448(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 384(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 352(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm14, 256(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 192(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm15, 576(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    addq $1016, %rsp # imm = 0x3F8
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride6_vf32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $904, %rsp # imm = 0x388
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm8
; AVX2-SLOW-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rcx), %xmm7
; AVX2-SLOW-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX2-SLOW-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5],ymm5[6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm10
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %xmm6
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm10[0],zero,xmm10[1],zero
; AVX2-SLOW-NEXT:    vmovdqa %xmm10, %xmm11
; AVX2-SLOW-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 4(%r9), %ymm5
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm10 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm8[1,2,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm9[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm6[0],zero,xmm6[1],zero
; AVX2-SLOW-NEXT:    vmovdqa %xmm6, %xmm13
; AVX2-SLOW-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 36(%r9), %ymm5
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm7[1,2,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[0,1,2,1]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %xmm4
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm7 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 64(%r8), %xmm10
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm10[0],zero,xmm10[1],zero
; AVX2-SLOW-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm7[2,3],ymm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 68(%r9), %ymm7
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2],ymm7[3],ymm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%rcx), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdx), %xmm7
; AVX2-SLOW-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm6[0,1,2,1]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm9 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 96(%r8), %xmm9
; AVX2-SLOW-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm9[0],zero,xmm9[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 100(%r9), %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2],ymm9[3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd (%rcx), %xmm8
; AVX2-SLOW-NEXT:    vpbroadcastd (%rdx), %xmm9
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm8[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq %xmm11, %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm1, %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm14
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm1[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm14[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2],ymm8[3],ymm9[4],ymm8[5],ymm9[6],ymm8[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm8[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm9
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm8
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm9[2],ymm8[2],ymm9[3],ymm8[3],ymm9[6],ymm8[6],ymm9[7],ymm8[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm0[4,5],ymm11[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm12 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1],ymm12[2,3],ymm11[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 20(%r9), %ymm12
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2],ymm12[3],ymm11[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd 32(%rcx), %xmm11
; AVX2-SLOW-NEXT:    vpbroadcastd 32(%rdx), %xmm12
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1],ymm11[2,3],ymm2[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq %xmm13, %ymm3
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm0, %ymm3
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm3[5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm2
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm2[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm12[0],ymm11[1],ymm12[2],ymm11[3],ymm12[4],ymm11[5],ymm12[6],ymm11[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm15 = ymm11[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm12
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm11
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm12[2],ymm11[2],ymm12[3],ymm11[3],ymm12[6],ymm11[6],ymm12[7],ymm11[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm0[4,5],ymm15[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm13 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = ymm15[0,1],ymm13[2,3],ymm15[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 52(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2],ymm15[3],ymm13[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd 64(%rcx), %xmm13
; AVX2-SLOW-NEXT:    vpbroadcastd 64(%rdx), %xmm15
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm13 = xmm15[0],xmm13[0],xmm15[1],xmm13[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm13[2,3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq %xmm10, %ymm5
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 64(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm0, %ymm5
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3,4],ymm5[5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdx), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa 64(%rcx), %ymm4
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm4[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm5[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = ymm15[0],ymm13[1],ymm15[2],ymm13[3],ymm15[4],ymm13[5],ymm15[6],ymm13[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %ymm10
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm10 = ymm0[2],ymm10[2],ymm0[3],ymm10[3],ymm0[6],ymm10[6],ymm0[7],ymm10[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm10[4,5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1],ymm15[2,3],ymm13[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 84(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm13[0,1,2],ymm15[3],ymm13[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm13 = xmm15[0],xmm13[0],xmm15[1],xmm13[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm13[2,3],ymm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 96(%r9), %xmm7
; AVX2-SLOW-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm7, %ymm7
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4],ymm7[5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdx), %ymm7
; AVX2-SLOW-NEXT:    vmovdqa 96(%rcx), %ymm6
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm7[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = ymm15[0],ymm13[1],ymm15[2],ymm13[3],ymm15[4],ymm13[5],ymm15[6],ymm13[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm10
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm10 = ymm10[2],ymm0[2],ymm10[3],ymm0[3],ymm10[6],ymm0[6],ymm10[7],ymm0[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm10[4,5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1],ymm15[2,3],ymm13[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 116(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm13[0,1,2],ymm15[3],ymm13[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm13 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm13 = xmm10[2],mem[2],xmm10[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm13 = xmm13[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm13, %ymm10, %ymm13
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm15 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1],ymm13[2,3,4,5],ymm15[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm10 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm10[1],ymm13[2,3,4,5,6],ymm10[7]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm9[0],ymm8[0],ymm9[1],ymm8[1],ymm9[4],ymm8[4],ymm9[5],ymm8[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm9 = ymm14[0],ymm1[0],ymm14[1],ymm1[1],ymm14[4],ymm1[4],ymm14[5],ymm1[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 16(%r9), %ymm10
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm15 = ymm8[0,1,2,3,4],ymm10[5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm14[2],ymm1[2],ymm14[3],ymm1[3],ymm14[6],ymm1[6],ymm14[7],ymm1[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm9[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm8, %ymm1
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm8 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm8[0,1],ymm1[2,3,4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm8 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm8[1],ymm1[2,3,4,5,6],ymm8[7]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm12[0],ymm11[0],ymm12[1],ymm11[1],ymm12[4],ymm11[4],ymm12[5],ymm11[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm9 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[4],ymm2[4],ymm3[5],ymm2[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 48(%r9), %ymm10
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4],ymm10[5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm3[2],ymm2[2],ymm3[3],ymm2[3],ymm3[6],ymm2[6],ymm3[7],ymm2[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm2 = mem[2,3],ymm2[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm9[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5],ymm3[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4,5,6],ymm3[7]
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm3 = xmm3[2],mem[2],xmm3[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm9, %ymm3
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm9 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm3 = ymm9[0,1],ymm3[2,3,4,5],ymm9[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, (%rsp), %xmm9 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm9 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm9[1],ymm3[2,3,4,5,6],ymm9[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm9 = ymm9[0],mem[0],ymm9[1],mem[1],ymm9[4],mem[4],ymm9[5],mem[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm10 = ymm5[0],ymm4[0],ymm5[1],ymm4[1],ymm5[4],ymm4[4],ymm5[5],ymm4[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1],ymm10[2,3],ymm9[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa 64(%r8), %ymm10
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5],ymm9[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 80(%r9), %ymm11
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4],ymm11[5],ymm9[6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm5[2],ymm4[2],ymm5[3],ymm4[3],ymm5[6],ymm4[6],ymm5[7],ymm4[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm4 = mem[2,3],ymm4[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm10[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3,4,5],ymm5[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2,3,4,5,6],ymm5[7]
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm5 = xmm5[2],mem[2],xmm5[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm5, %ymm10, %ymm5
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm10 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0,1],ymm5[2,3,4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm10 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm10[1],ymm5[2,3,4,5,6],ymm10[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = ymm10[0],mem[0],ymm10[1],mem[1],ymm10[4],mem[4],ymm10[5],mem[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm11 = ymm7[0],ymm6[0],ymm7[1],ymm6[1],ymm7[4],ymm6[4],ymm7[5],ymm6[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1],ymm11[2,3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa 96(%r8), %ymm11
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 112(%r9), %ymm12
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3,4],ymm12[5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm6 = ymm7[2],ymm6[2],ymm7[3],ymm6[3],ymm7[6],ymm6[6],ymm7[7],ymm6[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm6 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm6 = mem[2,3],ymm6[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm11[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3,4,5],ymm7[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3,4,5,6],ymm7[7]
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, 736(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm10, 672(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm5, 640(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 544(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, 480(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm3, 448(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 352(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, 288(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm1, 256(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 160(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm15, 96(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm13, 64(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-SLOW-NEXT:    addq $904, %rsp # imm = 0x388
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride6_vf32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $888, %rsp # imm = 0x378
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX2-FAST-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm4
; AVX2-FAST-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX2-FAST-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rcx), %xmm8
; AVX2-FAST-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm5
; AVX2-FAST-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX2-FAST-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm6[0],xmm4[0],xmm6[1],xmm4[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm4[0,1,2,3],ymm2[4,5],ymm4[6,7]
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %xmm5
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm2[0],zero,xmm2[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm7[2,3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 4(%r9), %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2],ymm7[3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm3[2],xmm11[2],xmm3[3],xmm11[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm9[1,2,2,3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm10[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm7
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm5[0],zero,xmm5[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm7[2,3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 36(%r9), %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2],ymm7[3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rdx), %xmm4
; AVX2-FAST-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm8[1,2,2,3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm4[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,2,1]
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %xmm12
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %xmm15
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm15[2],xmm12[2],xmm15[3],xmm12[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-FAST-NEXT:    vmovdqa 64(%r8), %xmm7
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm8[2,3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 68(%r9), %ymm8
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2],ymm8[3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rcx), %xmm13
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm13[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rdx), %xmm10
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm10[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm8[0],xmm6[0],xmm8[1],xmm6[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,2,1]
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %xmm11
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %xmm14
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm14[2],xmm11[2],xmm14[3],xmm11[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm8
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3],ymm8[4,5],ymm6[6,7]
; AVX2-FAST-NEXT:    vmovdqa 96(%r8), %xmm4
; AVX2-FAST-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm4[0],zero,xmm4[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 100(%r9), %ymm9
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm8[0,1,2],ymm9[3],ymm8[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd (%rcx), %xmm8
; AVX2-FAST-NEXT:    vpbroadcastd (%rdx), %xmm9
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm8[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq %xmm2, %ymm1
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd (%r9), %ymm1
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm4
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm2
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm2[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm8 = ymm4[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0],ymm0[1],ymm8[2],ymm0[3],ymm8[4],ymm0[5],ymm8[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm6[2],ymm1[2],ymm6[3],ymm1[3],ymm6[6],ymm1[6],ymm6[7],ymm1[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm8 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm8[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 20(%r9), %ymm8
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm8[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd 32(%rcx), %xmm0
; AVX2-FAST-NEXT:    vpbroadcastd 32(%rdx), %xmm8
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm8[0],xmm0[0],xmm8[1],xmm0[1]
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq %xmm5, %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 32(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %ymm8
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %ymm5
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm5[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm8[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3],ymm3[4],ymm0[5],ymm3[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm3[2],ymm1[2],ymm3[3],ymm1[3],ymm3[6],ymm1[6],ymm3[7],ymm1[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 52(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd 64(%rcx), %xmm0
; AVX2-FAST-NEXT:    vpbroadcastd 64(%rdx), %xmm3
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm15[0],xmm12[0],xmm15[1],xmm12[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq %xmm7, %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 64(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rdx), %ymm7
; AVX2-FAST-NEXT:    vmovdqa 64(%rcx), %ymm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm7[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3],ymm3[4],ymm0[5],ymm3[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %ymm12
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm1[2],ymm12[2],ymm1[3],ymm12[3],ymm1[6],ymm12[6],ymm1[7],ymm12[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 84(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd %xmm13, %xmm0
; AVX2-FAST-NEXT:    vpbroadcastd %xmm10, %xmm3
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm14[0],xmm11[0],xmm14[1],xmm11[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 96(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rdx), %ymm9
; AVX2-FAST-NEXT:    vmovdqa 96(%rcx), %ymm3
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm3[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm11 = ymm9[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0],ymm0[1],ymm11[2],ymm0[3],ymm11[4],ymm0[5],ymm11[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %ymm10
; AVX2-FAST-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm10[2],ymm1[2],ymm10[3],ymm1[3],ymm10[6],ymm1[6],ymm10[7],ymm1[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm14 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm14[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 116(%r9), %ymm14
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm14[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm14
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm0
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [2,2,3,3,2,2,3,3]
; AVX2-FAST-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm15
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3,4,5],ymm15[6,7]
; AVX2-FAST-NEXT:    vmovdqa (%r9), %ymm15
; AVX2-FAST-NEXT:    vpermd %ymm15, %ymm1, %ymm11
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = ymm14[0],ymm11[1],ymm14[2,3,4,5,6],ymm11[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm10 = ymm10[0],mem[0],ymm10[1],mem[1],ymm10[4],mem[4],ymm10[5],mem[5]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm11 = ymm4[0],ymm2[0],ymm4[1],ymm2[1],ymm4[4],ymm2[4],ymm4[5],ymm2[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1],ymm11[2,3],ymm10[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm0[4,5],ymm10[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 16(%r9), %ymm11
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3,4],ymm11[5],ymm10[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm4[2],ymm2[2],ymm4[3],ymm2[3],ymm4[6],ymm2[6],ymm4[7],ymm2[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm4 = mem[2,3],ymm2[2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [6,5,3,3,6,5,7,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm4[2,3,4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [4,6,2,3,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm15, %ymm4, %ymm10
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm10[1],ymm0[2,3,4,5,6],ymm10[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm10 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm10 = xmm10[2],mem[2],xmm10[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %ymm11
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm1, %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = ymm13[0,1],ymm10[2,3,4,5],ymm13[6,7]
; AVX2-FAST-NEXT:    vmovdqa 32(%r9), %ymm14
; AVX2-FAST-NEXT:    vpermd %ymm14, %ymm1, %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm13[1],ymm10[2,3,4,5,6],ymm13[7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm13 = ymm13[0],mem[0],ymm13[1],mem[1],ymm13[4],mem[4],ymm13[5],mem[5]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm15 = ymm8[0],ymm5[0],ymm8[1],ymm5[1],ymm8[4],ymm5[4],ymm8[5],ymm5[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1],ymm15[2,3],ymm13[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm11[4,5],ymm13[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 48(%r9), %ymm15
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3,4],ymm15[5],ymm13[6,7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm5 = ymm8[2],ymm5[2],ymm8[3],ymm5[3],ymm8[6],ymm5[6],ymm8[7],ymm5[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm5 = mem[2,3],ymm5[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm2, %ymm8
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3,4,5],ymm8[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm14, %ymm4, %ymm8
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0],ymm8[1],ymm5[2,3,4,5,6],ymm8[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm8 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm8 = xmm8[2],mem[2],xmm8[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-FAST-NEXT:    vmovdqa 64(%r8), %ymm11
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm1, %ymm14
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm14[0,1],ymm8[2,3,4,5],ymm14[6,7]
; AVX2-FAST-NEXT:    vmovdqa 64(%r9), %ymm14
; AVX2-FAST-NEXT:    vpermd %ymm14, %ymm1, %ymm15
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0],ymm15[1],ymm8[2,3,4,5,6],ymm15[7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm12 = ymm15[0],ymm12[0],ymm15[1],ymm12[1],ymm15[4],ymm12[4],ymm15[5],ymm12[5]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm15 = ymm7[0],ymm6[0],ymm7[1],ymm6[1],ymm7[4],ymm6[4],ymm7[5],ymm6[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1],ymm15[2,3],ymm12[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm11[4,5],ymm12[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 80(%r9), %ymm15
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3,4],ymm15[5],ymm12[6,7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm6 = ymm7[2],ymm6[2],ymm7[3],ymm6[3],ymm7[6],ymm6[6],ymm7[7],ymm6[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm6 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm6 = mem[2,3],ymm6[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm2, %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3,4,5],ymm7[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm14, %ymm4, %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3,4,5,6],ymm7[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm7 = xmm7[2],mem[2],xmm7[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm11, %ymm7
; AVX2-FAST-NEXT:    vmovdqa 96(%r8), %ymm11
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm1, %ymm14
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm14[0,1],ymm7[2,3,4,5],ymm14[6,7]
; AVX2-FAST-NEXT:    vmovdqa 96(%r9), %ymm14
; AVX2-FAST-NEXT:    vpermd %ymm14, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm7[0],ymm1[1],ymm7[2,3,4,5,6],ymm1[7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm7 = ymm7[0],mem[0],ymm7[1],mem[1],ymm7[4],mem[4],ymm7[5],mem[5]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm15 = ymm9[0],ymm3[0],ymm9[1],ymm3[1],ymm9[4],ymm3[4],ymm9[5],ymm3[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1],ymm15[2,3],ymm7[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm11[4,5],ymm7[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 112(%r9), %ymm15
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3,4],ymm15[5],ymm7[6,7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm9[2],ymm3[2],ymm9[3],ymm3[3],ymm9[6],ymm3[6],ymm9[7],ymm3[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm3 = mem[2,3],ymm3[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm14, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4,5,6],ymm3[7]
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 736(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm7, 672(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 640(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm6, 544(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm12, 480(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm8, 448(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm5, 352(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm13, 288(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm10, 256(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 160(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FAST-NEXT:    addq $888, %rsp # imm = 0x378
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride6_vf32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $904, %rsp # imm = 0x388
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rcx), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5],ymm5[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm10[0],zero,xmm10[1],zero
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm10, %xmm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 4(%r9), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm10 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm8[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm9[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm6[0],zero,xmm6[1],zero
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm6, %xmm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 36(%r9), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm7[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm7 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r8), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm10[0],zero,xmm10[1],zero
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm7[2,3],ymm6[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 68(%r9), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2],ymm7[3],ymm6[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rcx), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdx), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm6[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm9 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r8), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm9[0],zero,xmm9[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 100(%r9), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2],ymm9[3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rcx), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rdx), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm8[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq %xmm11, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm8 = ymm1[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = ymm14[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2],ymm8[3],ymm9[4],ymm8[5],ymm9[6],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm8[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm9[2],ymm8[2],ymm9[3],ymm8[3],ymm9[6],ymm8[6],ymm9[7],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm0[4,5],ymm11[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm12 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1],ymm12[2,3],ymm11[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 20(%r9), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2],ymm12[3],ymm11[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 32(%rcx), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 32(%rdx), %xmm12
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1],ymm11[2,3],ymm2[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq %xmm13, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm3[5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm11 = ymm2[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm12 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm11 = ymm12[0],ymm11[1],ymm12[2],ymm11[3],ymm12[4],ymm11[5],ymm12[6],ymm11[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm15 = ymm11[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm12[2],ymm11[2],ymm12[3],ymm11[3],ymm12[6],ymm11[6],ymm12[7],ymm11[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm0[4,5],ymm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm13 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm13 = ymm15[0,1],ymm13[2,3],ymm15[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 52(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2],ymm15[3],ymm13[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 64(%rcx), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 64(%rdx), %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm13 = xmm15[0],xmm13[0],xmm15[1],xmm13[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm13[2,3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq %xmm10, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3,4],ymm5[5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdx), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rcx), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm13 = ymm4[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm5[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm13 = ymm15[0],ymm13[1],ymm15[2],ymm13[3],ymm15[4],ymm13[5],ymm15[6],ymm13[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm10 = ymm0[2],ymm10[2],ymm0[3],ymm10[3],ymm0[6],ymm10[6],ymm0[7],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm10[4,5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1],ymm15[2,3],ymm13[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 84(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm13[0,1,2],ymm15[3],ymm13[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm13 = xmm15[0],xmm13[0],xmm15[1],xmm13[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm13[2,3],ymm6[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r9), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4],ymm7[5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdx), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rcx), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm13 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm7[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm13 = ymm15[0],ymm13[1],ymm15[2],ymm13[3],ymm15[4],ymm13[5],ymm15[6],ymm13[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm10 = ymm10[2],ymm0[2],ymm10[3],ymm0[3],ymm10[6],ymm0[6],ymm10[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm10[4,5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1],ymm15[2,3],ymm13[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 116(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm13[0,1,2],ymm15[3],ymm13[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm13 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm13 = xmm10[2],mem[2],xmm10[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm13 = xmm13[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm13, %ymm10, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm15 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1],ymm13[2,3,4,5],ymm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm10 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm10[1],ymm13[2,3,4,5,6],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm9[0],ymm8[0],ymm9[1],ymm8[1],ymm9[4],ymm8[4],ymm9[5],ymm8[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm9 = ymm14[0],ymm1[0],ymm14[1],ymm1[1],ymm14[4],ymm1[4],ymm14[5],ymm1[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 16(%r9), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm15 = ymm8[0,1,2,3,4],ymm10[5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm14[2],ymm1[2],ymm14[3],ymm1[3],ymm14[6],ymm1[6],ymm14[7],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm9[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm8, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm8 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm8[0,1],ymm1[2,3,4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm8 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm8[1],ymm1[2,3,4,5,6],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm12[0],ymm11[0],ymm12[1],ymm11[1],ymm12[4],ymm11[4],ymm12[5],ymm11[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm9 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[4],ymm2[4],ymm3[5],ymm2[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 48(%r9), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4],ymm10[5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm3[2],ymm2[2],ymm3[3],ymm2[3],ymm3[6],ymm2[6],ymm3[7],ymm2[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm2 = mem[2,3],ymm2[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm9[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5],ymm3[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4,5,6],ymm3[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm3 = xmm3[2],mem[2],xmm3[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm3, %ymm9, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm9 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm3 = ymm9[0,1],ymm3[2,3,4,5],ymm9[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, (%rsp), %xmm9 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm9 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm9[1],ymm3[2,3,4,5,6],ymm9[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm9 = ymm9[0],mem[0],ymm9[1],mem[1],ymm9[4],mem[4],ymm9[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm10 = ymm5[0],ymm4[0],ymm5[1],ymm4[1],ymm5[4],ymm4[4],ymm5[5],ymm4[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1],ymm10[2,3],ymm9[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r8), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5],ymm9[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 80(%r9), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4],ymm11[5],ymm9[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm5[2],ymm4[2],ymm5[3],ymm4[3],ymm5[6],ymm4[6],ymm5[7],ymm4[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm4 = mem[2,3],ymm4[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm5 = ymm10[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3,4,5],ymm5[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm5 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2,3,4,5,6],ymm5[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm5 = xmm5[2],mem[2],xmm5[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm5, %ymm10, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm10 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0,1],ymm5[2,3,4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm10 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm10[1],ymm5[2,3,4,5,6],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = ymm10[0],mem[0],ymm10[1],mem[1],ymm10[4],mem[4],ymm10[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm11 = ymm7[0],ymm6[0],ymm7[1],ymm6[1],ymm7[4],ymm6[4],ymm7[5],ymm6[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1],ymm11[2,3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r8), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 112(%r9), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3,4],ymm12[5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm6 = ymm7[2],ymm6[2],ymm7[3],ymm6[3],ymm7[6],ymm6[6],ymm7[7],ymm6[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm6 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm6 = mem[2,3],ymm6[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm7 = ymm11[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3,4,5],ymm7[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm7 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3,4,5,6],ymm7[7]
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, 736(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm10, 672(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm5, 640(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, 544(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm9, 480(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm3, 448(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, 352(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, 288(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm1, 256(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 160(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm15, 96(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm13, 64(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    addq $904, %rsp # imm = 0x388
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i32_stride6_vf32:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm14
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm4
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm0
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm8
; AVX512F-SLOW-NEXT:    vmovdqa64 (%r8), %zmm6
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm9
; AVX512F-SLOW-NEXT:    vmovdqa64 (%r9), %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm10
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512F-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512F-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512F-SLOW-NEXT:    vpermt2d %zmm4, %zmm13, %zmm11
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512F-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm15
; AVX512F-SLOW-NEXT:    vpermt2d %zmm4, %zmm16, %zmm15
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512F-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm17
; AVX512F-SLOW-NEXT:    vpermt2d %zmm4, %zmm18, %zmm17
; AVX512F-SLOW-NEXT:    vpermi2d %zmm14, %zmm12, %zmm13
; AVX512F-SLOW-NEXT:    vpermi2d %zmm14, %zmm12, %zmm16
; AVX512F-SLOW-NEXT:    vpermi2d %zmm14, %zmm12, %zmm18
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm19 = zmm12[2],zmm14[2],zmm12[3],zmm14[3],zmm12[6],zmm14[6],zmm12[7],zmm14[7],zmm12[10],zmm14[10],zmm12[11],zmm14[11],zmm12[14],zmm14[14],zmm12[15],zmm14[15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm14, %zmm3, %zmm12
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %ymm14
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rdx), %ymm20
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm21 = [3,11,0,8,7,15,4,12]
; AVX512F-SLOW-NEXT:    vpermt2d (%rcx), %ymm21, %ymm14
; AVX512F-SLOW-NEXT:    movb $36, %dl
; AVX512F-SLOW-NEXT:    kmovw %edx, %k1
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm12 {%k1} = zmm14[0,1,0,1,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm6, %zmm14, %zmm12
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm7, %zmm22, %zmm12
; AVX512F-SLOW-NEXT:    vpermi2d %zmm4, %zmm2, %zmm3
; AVX512F-SLOW-NEXT:    vpermt2d 64(%rcx), %ymm21, %ymm20
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm3 {%k1} = zmm20[0,1,0,1,2,3,0,1]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm14, %zmm3
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm22, %zmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [3,19,0,16,11,27,8,24,15,31,12,28,3,19,0,16]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm20
; AVX512F-SLOW-NEXT:    vpermt2d %zmm8, %zmm14, %zmm20
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm11 {%k1}
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm20 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm20, %zmm11
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm21 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm21, %zmm11
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm22 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512F-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm23
; AVX512F-SLOW-NEXT:    vpermt2d %zmm8, %zmm22, %zmm23
; AVX512F-SLOW-NEXT:    movb $-110, %cl
; AVX512F-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm23, %zmm15 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm23 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm23, %zmm15
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm24, %zmm15
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512F-SLOW-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm26
; AVX512F-SLOW-NEXT:    vpermt2d %zmm8, %zmm25, %zmm26
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm26 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm26, %zmm17
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm27 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm27, %zmm17
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm1, %zmm14
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm13 {%k1}
; AVX512F-SLOW-NEXT:    vpermt2d %zmm6, %zmm20, %zmm13
; AVX512F-SLOW-NEXT:    vpermt2d %zmm7, %zmm21, %zmm13
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm1, %zmm22
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512F-SLOW-NEXT:    vpermt2d %zmm6, %zmm23, %zmm16
; AVX512F-SLOW-NEXT:    vpermt2d %zmm7, %zmm24, %zmm16
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm1, %zmm25
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512F-SLOW-NEXT:    vpermt2d %zmm6, %zmm26, %zmm18
; AVX512F-SLOW-NEXT:    vpermt2d %zmm7, %zmm27, %zmm18
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512F-SLOW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm20
; AVX512F-SLOW-NEXT:    vpermt2d %zmm8, %zmm14, %zmm20
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdi), %ymm21
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rdi), %ymm22
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm22 = ymm22[2],mem[2],ymm22[3],mem[3],ymm22[6],mem[6],ymm22[7],mem[7]
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm20 {%k1} = zmm22[0,1,2,3,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm22 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm22, %zmm20
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm23 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm23, %zmm20
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm1, %zmm14
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm21 = ymm21[2],mem[2],ymm21[3],mem[3],ymm21[6],mem[6],ymm21[7],mem[7]
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm21[0,1,2,3,2,3,0,1]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm6, %zmm22, %zmm14
; AVX512F-SLOW-NEXT:    vpermt2d %zmm7, %zmm23, %zmm14
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512F-SLOW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm8, %zmm21, %zmm0
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm2 = zmm2[2],zmm4[2],zmm2[3],zmm4[3],zmm2[6],zmm4[6],zmm2[7],zmm4[7],zmm2[10],zmm4[10],zmm2[11],zmm4[11],zmm2[14],zmm4[14],zmm2[15],zmm4[15]
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k1} = zmm2[0,1,6,7,6,7,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm2, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm4, %zmm0
; AVX512F-SLOW-NEXT:    vpermt2d %zmm5, %zmm21, %zmm1
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k1} = zmm19[0,1,6,7,6,7,0,1]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm6, %zmm2, %zmm1
; AVX512F-SLOW-NEXT:    vpermt2d %zmm7, %zmm4, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm18, (%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm16, 192(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm1, 320(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm17, 384(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm15, 576(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, 704(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm11, 640(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm14, 128(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm3, 448(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm20, 512(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm12, 64(%rax)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i32_stride6_vf32:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdi), %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512F-FAST-NEXT:    vmovdqa64 (%rsi), %zmm7
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm8
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512F-FAST-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm24
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512F-FAST-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512F-FAST-NEXT:    vpermt2d %zmm9, %zmm25, %zmm10
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512F-FAST-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512F-FAST-NEXT:    vpermt2d %zmm7, %zmm14, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [2,18,3,19,14,30,15,31,14,30,15,31,2,18,3,19]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm12, %zmm15
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512F-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512F-FAST-NEXT:    vpermt2d %zmm24, %zmm6, %zmm5
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [3,19,0,16,11,27,8,24,15,31,12,28,3,19,0,16]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm19
; AVX512F-FAST-NEXT:    vpermt2d %zmm24, %zmm17, %zmm19
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512F-FAST-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm13, %zmm11
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512F-FAST-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm23
; AVX512F-FAST-NEXT:    vpermt2d %zmm24, %zmm21, %zmm23
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512F-FAST-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm18, %zmm16
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm22 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512F-FAST-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm20
; AVX512F-FAST-NEXT:    vpermt2d %zmm24, %zmm22, %zmm20
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512F-FAST-NEXT:    vpermt2d %zmm24, %zmm25, %zmm4
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm25 = [3,19,0,16,3,19,0,16,7,23,4,20,3,19,0,16]
; AVX512F-FAST-NEXT:    vpermt2d %zmm24, %zmm25, %zmm26
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [2,18,3,19,6,22,7,23,6,22,7,23,2,18,3,19]
; AVX512F-FAST-NEXT:    vpermi2d %zmm9, %zmm3, %zmm6
; AVX512F-FAST-NEXT:    vpermi2d %zmm9, %zmm3, %zmm17
; AVX512F-FAST-NEXT:    vpermi2d %zmm9, %zmm3, %zmm21
; AVX512F-FAST-NEXT:    vpermi2d %zmm9, %zmm3, %zmm22
; AVX512F-FAST-NEXT:    vpermt2d %zmm9, %zmm25, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm24, %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm25
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm14, %zmm0
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512F-FAST-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm14, %zmm25
; AVX512F-FAST-NEXT:    vpermi2d %zmm7, %zmm1, %zmm12
; AVX512F-FAST-NEXT:    vpermi2d %zmm7, %zmm1, %zmm13
; AVX512F-FAST-NEXT:    vpermi2d %zmm7, %zmm1, %zmm18
; AVX512F-FAST-NEXT:    vpermi2d %zmm7, %zmm1, %zmm24
; AVX512F-FAST-NEXT:    vpermt2d %zmm7, %zmm14, %zmm1
; AVX512F-FAST-NEXT:    movb $-110, %al
; AVX512F-FAST-NEXT:    kmovw %eax, %k2
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm10, %zmm2 {%k2}
; AVX512F-FAST-NEXT:    vmovdqa64 (%r8), %zmm7
; AVX512F-FAST-NEXT:    movb $36, %al
; AVX512F-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm15, %zmm5 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 64(%r8), %zmm8
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm19, %zmm11 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512F-FAST-NEXT:    vpermt2d %zmm7, %zmm10, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm23, %zmm16 {%k2}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm14, %zmm5
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm9, %zmm20 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm9, %zmm11
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm26, %zmm25 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm15, %zmm16
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k2}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm4, %zmm20
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm10, %zmm0
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm10, %zmm25
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm12, %zmm6 {%k1}
; AVX512F-FAST-NEXT:    vpermt2d %zmm7, %zmm14, %zmm6
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k1}
; AVX512F-FAST-NEXT:    vpermt2d %zmm7, %zmm9, %zmm13
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm21, %zmm18 {%k2}
; AVX512F-FAST-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512F-FAST-NEXT:    vpermt2d %zmm7, %zmm15, %zmm18
; AVX512F-FAST-NEXT:    vmovdqa64 64(%r9), %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm12, %zmm2
; AVX512F-FAST-NEXT:    vpermt2d %zmm7, %zmm4, %zmm22
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512F-FAST-NEXT:    vpermt2d %zmm9, %zmm4, %zmm5
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512F-FAST-NEXT:    vpermt2d %zmm9, %zmm3, %zmm11
; AVX512F-FAST-NEXT:    vpermt2d %zmm7, %zmm10, %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512F-FAST-NEXT:    vpermt2d %zmm9, %zmm7, %zmm16
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512F-FAST-NEXT:    vpermt2d %zmm9, %zmm10, %zmm20
; AVX512F-FAST-NEXT:    vpermt2d %zmm9, %zmm12, %zmm0
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512F-FAST-NEXT:    vpermt2d %zmm9, %zmm12, %zmm25
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm4, %zmm6
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm3, %zmm13
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm7, %zmm18
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm10, %zmm22
; AVX512F-FAST-NEXT:    vpermt2d %zmm8, %zmm12, %zmm1
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm22, 128(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm18, 192(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, 320(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, 384(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm25, 448(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm20, 512(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm16, 576(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm11, 640(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm5, 704(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-SLOW-LABEL: store_i32_stride6_vf32:
; AVX512BW-SLOW:       # %bb.0:
; AVX512BW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm14
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm4
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm0
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm8
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%r8), %zmm6
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm9
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%r9), %zmm7
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm10
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512BW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512BW-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm4, %zmm13, %zmm11
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512BW-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm15
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm4, %zmm16, %zmm15
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512BW-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm17
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm4, %zmm18, %zmm17
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm14, %zmm12, %zmm13
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm14, %zmm12, %zmm16
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm14, %zmm12, %zmm18
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm19 = zmm12[2],zmm14[2],zmm12[3],zmm14[3],zmm12[6],zmm14[6],zmm12[7],zmm14[7],zmm12[10],zmm14[10],zmm12[11],zmm14[11],zmm12[14],zmm14[14],zmm12[15],zmm14[15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm14, %zmm3, %zmm12
; AVX512BW-SLOW-NEXT:    vmovdqa (%rdx), %ymm14
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rdx), %ymm20
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm21 = [3,11,0,8,7,15,4,12]
; AVX512BW-SLOW-NEXT:    vpermt2d (%rcx), %ymm21, %ymm14
; AVX512BW-SLOW-NEXT:    movb $36, %dl
; AVX512BW-SLOW-NEXT:    kmovd %edx, %k1
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm12 {%k1} = zmm14[0,1,0,1,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm6, %zmm14, %zmm12
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm7, %zmm22, %zmm12
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm4, %zmm2, %zmm3
; AVX512BW-SLOW-NEXT:    vpermt2d 64(%rcx), %ymm21, %ymm20
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm3 {%k1} = zmm20[0,1,0,1,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm14, %zmm3
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm22, %zmm3
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [3,19,0,16,11,27,8,24,15,31,12,28,3,19,0,16]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm20
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm8, %zmm14, %zmm20
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm11 {%k1}
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm20 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm20, %zmm11
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm21 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm21, %zmm11
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm22 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512BW-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm23
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm8, %zmm22, %zmm23
; AVX512BW-SLOW-NEXT:    movb $-110, %cl
; AVX512BW-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm23, %zmm15 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm23 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm23, %zmm15
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm24, %zmm15
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512BW-SLOW-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm26
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm8, %zmm25, %zmm26
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm26 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm26, %zmm17
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm27 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm27, %zmm17
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm5, %zmm1, %zmm14
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm13 {%k1}
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm6, %zmm20, %zmm13
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm7, %zmm21, %zmm13
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm5, %zmm1, %zmm22
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm6, %zmm23, %zmm16
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm7, %zmm24, %zmm16
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm5, %zmm1, %zmm25
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm6, %zmm26, %zmm18
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm7, %zmm27, %zmm18
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512BW-SLOW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm20
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm8, %zmm14, %zmm20
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rdi), %ymm21
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rdi), %ymm22
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm22 = ymm22[2],mem[2],ymm22[3],mem[3],ymm22[6],mem[6],ymm22[7],mem[7]
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm20 {%k1} = zmm22[0,1,2,3,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm22 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm22, %zmm20
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm23 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm23, %zmm20
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm5, %zmm1, %zmm14
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm21 = ymm21[2],mem[2],ymm21[3],mem[3],ymm21[6],mem[6],ymm21[7],mem[7]
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm21[0,1,2,3,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm6, %zmm22, %zmm14
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm7, %zmm23, %zmm14
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512BW-SLOW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm8, %zmm21, %zmm0
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm2 = zmm2[2],zmm4[2],zmm2[3],zmm4[3],zmm2[6],zmm4[6],zmm2[7],zmm4[7],zmm2[10],zmm4[10],zmm2[11],zmm4[11],zmm2[14],zmm4[14],zmm2[15],zmm4[15]
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k1} = zmm2[0,1,6,7,6,7,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm2, %zmm0
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm4, %zmm0
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm5, %zmm21, %zmm1
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k1} = zmm19[0,1,6,7,6,7,0,1]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm6, %zmm2, %zmm1
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm7, %zmm4, %zmm1
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm18, (%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm16, 192(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm1, 320(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm17, 384(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm15, 576(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, 704(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm11, 640(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm14, 128(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm3, 448(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm20, 512(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm12, 64(%rax)
; AVX512BW-SLOW-NEXT:    vzeroupper
; AVX512BW-SLOW-NEXT:    retq
;
; AVX512BW-FAST-LABEL: store_i32_stride6_vf32:
; AVX512BW-FAST:       # %bb.0:
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rdi), %zmm1
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rsi), %zmm7
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm8
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm24
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512BW-FAST-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512BW-FAST-NEXT:    vpermt2d %zmm9, %zmm25, %zmm10
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512BW-FAST-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-FAST-NEXT:    vpermt2d %zmm7, %zmm14, %zmm2
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [2,18,3,19,14,30,15,31,14,30,15,31,2,18,3,19]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm12, %zmm15
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512BW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512BW-FAST-NEXT:    vpermt2d %zmm24, %zmm6, %zmm5
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [3,19,0,16,11,27,8,24,15,31,12,28,3,19,0,16]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm19
; AVX512BW-FAST-NEXT:    vpermt2d %zmm24, %zmm17, %zmm19
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512BW-FAST-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm13, %zmm11
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512BW-FAST-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm23
; AVX512BW-FAST-NEXT:    vpermt2d %zmm24, %zmm21, %zmm23
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512BW-FAST-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm18, %zmm16
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm22 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512BW-FAST-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm20
; AVX512BW-FAST-NEXT:    vpermt2d %zmm24, %zmm22, %zmm20
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512BW-FAST-NEXT:    vpermt2d %zmm24, %zmm25, %zmm4
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm25 = [3,19,0,16,3,19,0,16,7,23,4,20,3,19,0,16]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm24, %zmm25, %zmm26
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [2,18,3,19,6,22,7,23,6,22,7,23,2,18,3,19]
; AVX512BW-FAST-NEXT:    vpermi2d %zmm9, %zmm3, %zmm6
; AVX512BW-FAST-NEXT:    vpermi2d %zmm9, %zmm3, %zmm17
; AVX512BW-FAST-NEXT:    vpermi2d %zmm9, %zmm3, %zmm21
; AVX512BW-FAST-NEXT:    vpermi2d %zmm9, %zmm3, %zmm22
; AVX512BW-FAST-NEXT:    vpermt2d %zmm9, %zmm25, %zmm3
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm24, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm25
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm14, %zmm0
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512BW-FAST-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm14, %zmm25
; AVX512BW-FAST-NEXT:    vpermi2d %zmm7, %zmm1, %zmm12
; AVX512BW-FAST-NEXT:    vpermi2d %zmm7, %zmm1, %zmm13
; AVX512BW-FAST-NEXT:    vpermi2d %zmm7, %zmm1, %zmm18
; AVX512BW-FAST-NEXT:    vpermi2d %zmm7, %zmm1, %zmm24
; AVX512BW-FAST-NEXT:    vpermt2d %zmm7, %zmm14, %zmm1
; AVX512BW-FAST-NEXT:    movb $-110, %al
; AVX512BW-FAST-NEXT:    kmovd %eax, %k2
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm2 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqa64 (%r8), %zmm7
; AVX512BW-FAST-NEXT:    movb $36, %al
; AVX512BW-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm5 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%r8), %zmm8
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm19, %zmm11 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm7, %zmm10, %zmm2
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm23, %zmm16 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm14, %zmm5
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm9, %zmm20 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm9, %zmm11
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm26, %zmm25 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm15, %zmm16
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm4, %zmm20
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm10, %zmm0
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm10, %zmm25
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm6 {%k1}
; AVX512BW-FAST-NEXT:    vpermt2d %zmm7, %zmm14, %zmm6
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k1}
; AVX512BW-FAST-NEXT:    vpermt2d %zmm7, %zmm9, %zmm13
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm21, %zmm18 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512BW-FAST-NEXT:    vpermt2d %zmm7, %zmm15, %zmm18
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%r9), %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm12, %zmm2
; AVX512BW-FAST-NEXT:    vpermt2d %zmm7, %zmm4, %zmm22
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm9, %zmm4, %zmm5
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm9, %zmm3, %zmm11
; AVX512BW-FAST-NEXT:    vpermt2d %zmm7, %zmm10, %zmm1
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm9, %zmm7, %zmm16
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm9, %zmm10, %zmm20
; AVX512BW-FAST-NEXT:    vpermt2d %zmm9, %zmm12, %zmm0
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm9, %zmm12, %zmm25
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm4, %zmm6
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm3, %zmm13
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm7, %zmm18
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm10, %zmm22
; AVX512BW-FAST-NEXT:    vpermt2d %zmm8, %zmm12, %zmm1
; AVX512BW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm22, 128(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm18, 192(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm6, 320(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, 384(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm25, 448(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm20, 512(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm16, 576(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm11, 640(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm5, 704(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512BW-FAST-NEXT:    vzeroupper
; AVX512BW-FAST-NEXT:    retq
  %in.vec0 = load <32 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <32 x i32>, ptr %in.vecptr5, align 64
  %1 = shufflevector <32 x i32> %in.vec0, <32 x i32> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i32> %in.vec2, <32 x i32> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <32 x i32> %in.vec4, <32 x i32> %in.vec5, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <64 x i32> %1, <64 x i32> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %5 = shufflevector <64 x i32> %3, <64 x i32> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <128 x i32> %4, <128 x i32> %5, <192 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191>
  %interleaved.vec = shufflevector <192 x i32> %6, <192 x i32> poison, <192 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191>
  store <192 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride6_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride6_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1224, %rsp # imm = 0x4C8
; SSE-NEXT:    movaps (%rdi), %xmm9
; SSE-NEXT:    movaps 16(%rdi), %xmm10
; SSE-NEXT:    movaps (%rsi), %xmm2
; SSE-NEXT:    movaps 16(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm11
; SSE-NEXT:    movaps 16(%rdx), %xmm12
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps 16(%rcx), %xmm1
; SSE-NEXT:    movaps (%r8), %xmm6
; SSE-NEXT:    movaps 16(%r8), %xmm3
; SSE-NEXT:    movaps (%r9), %xmm7
; SSE-NEXT:    movaps 16(%r9), %xmm5
; SSE-NEXT:    movaps %xmm11, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm4[0],xmm13[1],xmm4[1]
; SSE-NEXT:    movaps %xmm9, %xmm8
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1]
; SSE-NEXT:    movaps %xmm7, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm6[0]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,0],xmm8[2,3]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm13[0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,3],xmm8[0,2]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm11[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm2[2],xmm9[3],xmm2[3]
; SSE-NEXT:    movaps %xmm6, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm9[2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[3,3],xmm7[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm4[2],xmm11[3],xmm4[3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm6[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps %xmm10, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm5, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm3[0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm2[2,3]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm4[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm5[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm12[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm0[2],xmm10[3],xmm0[3]
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm10[2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdi), %xmm6
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm5[3,3]
; SSE-NEXT:    movaps 32(%rdx), %xmm5
; SSE-NEXT:    unpckhps {{.*#+}} xmm12 = xmm12[2],xmm1[2],xmm12[3],xmm1[3]
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,3],xmm3[0,2]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    unpcklps {{.*#+}} xmm7 = xmm7[0],xmm0[0],xmm7[1],xmm0[1]
; SSE-NEXT:    movaps 32(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 32(%r8), %xmm2
; SSE-NEXT:    movaps 32(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm7[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm5[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm0[2],xmm5[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm7
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rdi), %xmm6
; SSE-NEXT:    movaps 48(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 48(%r8), %xmm2
; SSE-NEXT:    movaps 48(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm7
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 64(%rdi), %xmm6
; SSE-NEXT:    movaps 64(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 64(%r8), %xmm2
; SSE-NEXT:    movaps 64(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm7
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 80(%rdi), %xmm6
; SSE-NEXT:    movaps 80(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 80(%r8), %xmm2
; SSE-NEXT:    movaps 80(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm7
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 96(%rdi), %xmm6
; SSE-NEXT:    movaps 96(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 96(%r8), %xmm2
; SSE-NEXT:    movaps 96(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdx), %xmm7
; SSE-NEXT:    movaps 112(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 112(%rdi), %xmm6
; SSE-NEXT:    movaps 112(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 112(%r8), %xmm2
; SSE-NEXT:    movaps 112(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdx), %xmm7
; SSE-NEXT:    movaps 128(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 128(%rdi), %xmm6
; SSE-NEXT:    movaps 128(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 128(%r8), %xmm2
; SSE-NEXT:    movaps 128(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdx), %xmm7
; SSE-NEXT:    movaps 144(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 144(%rdi), %xmm6
; SSE-NEXT:    movaps 144(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 144(%r8), %xmm2
; SSE-NEXT:    movaps 144(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdx), %xmm7
; SSE-NEXT:    movaps 160(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 160(%rdi), %xmm6
; SSE-NEXT:    movaps 160(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 160(%r8), %xmm2
; SSE-NEXT:    movaps 160(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdx), %xmm7
; SSE-NEXT:    movaps 176(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 176(%rdi), %xmm6
; SSE-NEXT:    movaps 176(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 176(%r8), %xmm2
; SSE-NEXT:    movaps 176(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdx), %xmm7
; SSE-NEXT:    movaps 192(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 192(%rdi), %xmm6
; SSE-NEXT:    movaps 192(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 192(%r8), %xmm2
; SSE-NEXT:    movaps 192(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdx), %xmm7
; SSE-NEXT:    movaps 208(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 208(%rdi), %xmm6
; SSE-NEXT:    movaps 208(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps 208(%r8), %xmm2
; SSE-NEXT:    movaps 208(%r9), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm4[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm6[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%rdx), %xmm11
; SSE-NEXT:    movaps 224(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm11, %xmm12
; SSE-NEXT:    unpcklps {{.*#+}} xmm12 = xmm12[0],xmm0[0],xmm12[1],xmm0[1]
; SSE-NEXT:    movaps 224(%rdi), %xmm10
; SSE-NEXT:    movaps 224(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm10, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm1[0],xmm13[1],xmm1[1]
; SSE-NEXT:    movaps 224(%r8), %xmm2
; SSE-NEXT:    movaps 224(%r9), %xmm8
; SSE-NEXT:    movaps %xmm8, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[2,0],xmm13[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm12[0]
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm8[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,3],xmm5[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm1[2],xmm10[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm11[1]
; SSE-NEXT:    movaps %xmm2, %xmm9
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm10[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm8[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm0[2],xmm11[3],xmm0[3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm2[0,2]
; SSE-NEXT:    movaps 240(%rdx), %xmm2
; SSE-NEXT:    movaps 240(%rcx), %xmm8
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1]
; SSE-NEXT:    movaps 240(%rdi), %xmm0
; SSE-NEXT:    movaps 240(%rsi), %xmm14
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm14[0],xmm5[1],xmm14[1]
; SSE-NEXT:    movaps 240(%r8), %xmm3
; SSE-NEXT:    movaps 240(%r9), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm3[0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm5[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,3],xmm1[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm14[2],xmm0[3],xmm14[3]
; SSE-NEXT:    movaps %xmm8, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movaps %xmm3, %xmm14
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm7[1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,2],xmm0[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm7[3,3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm8[2],xmm2[3],xmm8[3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,3],xmm3[0,2]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm2, 1520(%rax)
; SSE-NEXT:    movaps %xmm14, 1504(%rax)
; SSE-NEXT:    movaps %xmm0, 1488(%rax)
; SSE-NEXT:    movaps %xmm4, 1472(%rax)
; SSE-NEXT:    movaps %xmm6, 1456(%rax)
; SSE-NEXT:    movaps %xmm5, 1440(%rax)
; SSE-NEXT:    movaps %xmm11, 1424(%rax)
; SSE-NEXT:    movaps %xmm9, 1408(%rax)
; SSE-NEXT:    movaps %xmm10, 1392(%rax)
; SSE-NEXT:    movaps %xmm12, 1376(%rax)
; SSE-NEXT:    movaps %xmm15, 1360(%rax)
; SSE-NEXT:    movaps %xmm13, 1344(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1328(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1312(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $1224, %rsp # imm = 0x4C8
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride6_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $2392, %rsp # imm = 0x958
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm8
; AVX1-ONLY-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm9
; AVX1-ONLY-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %ymm5
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm6
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm1[2],xmm7[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 4(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 4(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 16(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[1,2],xmm2[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 36(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 36(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm2[0],ymm1[0],ymm2[2],ymm1[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 48(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,2],xmm0[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 68(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 68(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm2[0],ymm1[0],ymm2[2],ymm1[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 80(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm13[2],xmm1[2],xmm13[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 100(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 100(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm2[0],ymm1[0],ymm2[2],ymm1[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 112(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 132(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 132(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %ymm11
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm11[0],ymm0[1],ymm11[1],ymm0[4],ymm11[4],ymm0[5],ymm11[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 128(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm2[0],ymm1[0],ymm2[2],ymm1[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 128(%r8), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 144(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 164(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 164(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 160(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm2[0],ymm1[0],ymm2[2],ymm1[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 160(%r8), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 176(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,2],xmm0[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 196(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 196(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %ymm4
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm10[0],ymm4[0],ymm10[1],ymm4[1],ymm10[4],ymm4[4],ymm10[5],ymm4[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 192(%rdx), %ymm5
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[2],ymm5[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 192(%r8), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 208(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[1,2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 228(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 228(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %ymm9
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %ymm8
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm12 = ymm9[0],ymm8[0],ymm9[1],ymm8[1],ymm9[4],ymm8[4],ymm9[5],ymm8[5]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 224(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovaps 224(%rcx), %ymm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm5[0],ymm1[0],ymm5[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm15 = ymm15[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm15, %xmm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm15[2,3],ymm12[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 224(%r8), %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm0[4,5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 240(%r9), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3,4],ymm15[5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm12 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm12 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $153, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm15 = ymm0[1,2],mem[1,2],ymm0[5,6],mem[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm15[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm15 = ymm15[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm12[4,5],ymm15[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 20(%r8), %xmm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3],ymm15[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 20(%r9), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm15 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7]
; AVX1-ONLY-NEXT:    vmovups %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $153, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm14 = ymm0[1,2],mem[1,2],ymm0[5,6],mem[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm14[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 52(%r8), %xmm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 52(%r9), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm15 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7]
; AVX1-ONLY-NEXT:    vmovups %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $153, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm14 = ymm0[1,2],mem[1,2],ymm0[5,6],mem[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm14[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 84(%r8), %xmm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 84(%r9), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm13 = xmm13[0],mem[0],xmm13[1],mem[1]
; AVX1-ONLY-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm14 = mem[0,0,0,0]
; AVX1-ONLY-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[0,0,0,0]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3],ymm15[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%r8), %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm14[2,3],ymm13[4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 96(%r9), %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm13[0,1,2,3,4],ymm14[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm13 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $153, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm14 = ymm0[1,2],mem[1,2],ymm0[5,6],mem[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm14[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm13[4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 116(%r8), %xmm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 116(%r9), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm11[2],ymm0[3],ymm11[3],ymm0[6],ymm11[6],ymm0[7],ymm11[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $153, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm11 = ymm11[1,2],mem[1,2],ymm11[5,6],mem[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm11 = ymm11[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm0[4,5],ymm11[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 148(%r8), %xmm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm14[2,3],ymm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 148(%r9), %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1,2],ymm14[3],ymm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm15[0,0,0,0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm11 = xmm14[0,0,0,0]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm11[0],xmm7[0],xmm11[1],xmm7[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0,1],ymm7[2,3],ymm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%r8), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm7[2,3],ymm6[4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 160(%r9), %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3,4],ymm7[5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm7 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7]
; AVX1-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $153, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm6 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm6 = ymm0[1,2],mem[1,2],ymm0[5,6],mem[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm6[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm6 = ymm6[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 180(%r8), %xmm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm7[2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 180(%r9), %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2],ymm7[3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX1-ONLY-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = mem[0,0,0,0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm7[0,0,0,0]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 192(%r8), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 192(%r9), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4],ymm3[5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm10[2],ymm4[2],ymm10[3],ymm4[3],ymm10[6],ymm4[6],ymm10[7],ymm4[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $153, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm2 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm2 = ymm3[1,2],mem[1,2],ymm3[5,6],mem[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm6[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 212(%r8), %xmm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 212(%r9), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm4[3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm9[2],ymm8[2],ymm9[3],ymm8[3],ymm9[6],ymm8[6],ymm9[7],ymm8[7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,2],ymm5[1,2],ymm1[5,6],ymm5[5,6]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 244(%r8), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 244(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vbroadcastss (%rcx), %xmm0
; AVX1-ONLY-NEXT:    vbroadcastss (%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r8), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss (%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm1[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[3,0],mem[3,0],ymm0[7,4],mem[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm12[2,3],ymm0[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm1 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm1 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vbroadcastss 32(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vbroadcastss 32(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%r8), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 32(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm1[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[3,0],mem[3,0],ymm0[7,4],mem[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm1 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm1 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vbroadcastss 64(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vbroadcastss 64(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm2 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm2 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1],ymm1[2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%r8), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 64(%r9), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm2[5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm2[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6],ymm2[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm2 = ymm0[3,0],mem[3,0],ymm0[7,4],mem[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm2 = mem[2,3],ymm2[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm4 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm4 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm2[0],ymm4[1],ymm2[2,3,4,5,6],ymm4[7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm2 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm2 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %xmm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm4[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3,4,5,6],ymm4[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm4 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm4 = ymm0[3,0],mem[3,0],ymm0[7,4],mem[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm13[2,3],ymm4[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm5 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm5 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm5 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm4[0],ymm5[1],ymm4[2,3,4,5,6],ymm5[7]
; AVX1-ONLY-NEXT:    vbroadcastss 128(%rcx), %xmm4
; AVX1-ONLY-NEXT:    vbroadcastss 128(%rdx), %xmm11
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm11[0],xmm4[0],xmm11[1],xmm4[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm11 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm11 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm12[0,1],ymm4[2,3],ymm12[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 128(%r8), %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm11[0,1],ymm4[2,3],ymm11[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 128(%r9), %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4],ymm11[5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm11 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm11 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm11 = xmm11[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm12 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0,1],ymm11[2,3,4,5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vmovaps 128(%r9), %xmm12
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = xmm12[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm12[1],ymm11[2,3,4,5,6],ymm12[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm12 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm12 = ymm0[3,0],mem[3,0],ymm0[7,4],mem[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm12 = ymm12[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm10 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm10 = mem[2,3],ymm12[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm12 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm12 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm12 = ymm12[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm12[0,1],ymm10[2,3,4,5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm12 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm12 = ymm12[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm12[1],ymm10[2,3,4,5,6],ymm12[7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm12 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm12 = xmm12[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2,3,4,5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vmovaps 160(%r9), %xmm13
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm13[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3,4,5,6],ymm13[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm13 = ymm0[3,0],mem[3,0],ymm0[7,4],mem[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm9 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm9 = mem[2,3],ymm13[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm13 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm13[0,1],ymm9[2,3,4,5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm13 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm13[1],ymm9[2,3,4,5,6],ymm13[7]
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm13 = xmm7[2],mem[2],xmm7[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = xmm13[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm13
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm14, %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1],ymm13[2,3,4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vmovaps 192(%r9), %xmm14
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm15 = xmm14[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm15, %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm14[1],ymm13[2,3,4,5,6],ymm14[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm14 = ymm0[3,0],ymm3[3,0],ymm0[7,4],ymm3[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm6[2,3],ymm14[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm14 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm14[0,1],ymm3[2,3,4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm14[1],ymm3[2,3,4,5,6],ymm14[7]
; AVX1-ONLY-NEXT:    vbroadcastss 224(%rcx), %xmm14
; AVX1-ONLY-NEXT:    vbroadcastss 224(%rdx), %xmm15
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm14[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%r8), %ymm15, %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1],ymm0[2,3],ymm14[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastss 224(%r9), %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm14[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm14 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm14 = xmm7[2],mem[2],xmm7[3],mem[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm14[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm7, %ymm14
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm15 = mem[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm15, %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3,4,5],ymm15[6,7]
; AVX1-ONLY-NEXT:    vmovaps 224(%r9), %xmm15
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm15[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm14[0],ymm7[1],ymm14[2,3,4,5,6],ymm7[7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufps $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm14 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm14 = ymm6[3,0],mem[3,0],ymm6[7,4],mem[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm6 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm6 = mem[2,3],ymm14[2,3]
; AVX1-ONLY-NEXT:    vperm2f128 $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm14 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[2,1,3,3,6,5,7,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm14[0,1],ymm6[2,3,4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = mem[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[0,2,2,3,4,6,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm14[1],ymm6[2,3,4,5,6],ymm14[7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 1504(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 1408(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 1312(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm13, 1216(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, 1120(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm12, 1024(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 928(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 832(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 768(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 736(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 640(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 544(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 448(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1440(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    addq $2392, %rsp # imm = 0x958
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride6_vf64:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $2488, %rsp # imm = 0x9B8
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm3
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm10
; AVX2-SLOW-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm8
; AVX2-SLOW-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rcx), %xmm7
; AVX2-SLOW-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX2-SLOW-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5],ymm5[6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm2[0],zero,xmm2[1],zero
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 4(%r9), %ymm5
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm10[2],xmm1[2],xmm10[3],xmm1[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm8[1,2,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm9[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm6[0],zero,xmm6[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 36(%r9), %ymm5
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm7[1,2,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[0,1,2,1]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %xmm4
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm7
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 64(%r8), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm0[0],zero,xmm0[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm7[2,3],ymm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 68(%r9), %ymm7
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2],ymm7[3],ymm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%rcx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm6[0,1,2,1]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 96(%r8), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm0[0],zero,xmm0[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 100(%r9), %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2],ymm9[3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 128(%rcx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 128(%rdx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm8[0,1,2,1]
; AVX2-SLOW-NEXT:    vmovdqa 128(%rsi), %xmm8
; AVX2-SLOW-NEXT:    vmovdqa 128(%rdi), %xmm9
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm11
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 128(%r8), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm0[0],zero,xmm0[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1],ymm11[2,3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 132(%r9), %ymm11
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1,2],ymm11[3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 160(%rcx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 160(%rdx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm10[0,1,2,1]
; AVX2-SLOW-NEXT:    vmovdqa 160(%rsi), %xmm10
; AVX2-SLOW-NEXT:    vmovdqa 160(%rdi), %xmm11
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm13
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm13[4,5],ymm12[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 160(%r8), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm0[0],zero,xmm0[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1],ymm13[2,3],ymm12[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 164(%r9), %ymm13
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2],ymm13[3],ymm12[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 192(%rcx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm12 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 192(%rdx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm12[0,1,2,1]
; AVX2-SLOW-NEXT:    vmovdqa 192(%rsi), %xmm12
; AVX2-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm13
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 192(%r8), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm0[0],zero,xmm0[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 196(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 224(%rcx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 224(%rdx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm0[1,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm14[0,1,2,1]
; AVX2-SLOW-NEXT:    vmovdqa 224(%rsi), %xmm14
; AVX2-SLOW-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 224(%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm14 = xmm0[2],xmm14[2],xmm0[3],xmm14[3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm14[4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 224(%r8), %xmm14
; AVX2-SLOW-NEXT:    vmovdqa %xmm14, (%rsp) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm14[0],zero,xmm14[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm14[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 228(%r9), %ymm14
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm14[3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd (%rcx), %xmm0
; AVX2-SLOW-NEXT:    vpbroadcastd (%rdx), %xmm14
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm14[0],xmm0[0],xmm14[1],xmm0[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = xmm3[0],mem[0],xmm3[1],mem[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq %xmm2, %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm1, %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm1[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm0[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm14[0],ymm2[1],ymm14[2],ymm2[3],ymm14[4],ymm2[5],ymm14[6],ymm2[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm14 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1],ymm14[2,3],ymm2[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 20(%r9), %ymm14
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm14[3],ymm2[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastss 32(%rcx), %xmm2
; AVX2-SLOW-NEXT:    vbroadcastss 32(%rdx), %xmm14
; AVX2-SLOW-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm14[0],xmm2[0],xmm14[1],xmm2[1]
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm3 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm3 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-SLOW-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastss %xmm0, %ymm3
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4],ymm3[5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm3
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm3[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm0[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 52(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd 64(%rcx), %xmm14
; AVX2-SLOW-NEXT:    vpbroadcastd 64(%rdx), %xmm15
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm14[2,3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 64(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm0, %ymm5
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3,4],ymm5[5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdx), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa 64(%rcx), %ymm4
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm4[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm5[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 84(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm14[2,3],ymm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 96(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm0, %ymm7
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4],ymm7[5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdx), %ymm7
; AVX2-SLOW-NEXT:    vmovdqa 96(%rcx), %ymm6
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm7[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 116(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd 128(%rcx), %xmm14
; AVX2-SLOW-NEXT:    vpbroadcastd 128(%rdx), %xmm15
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm14[2,3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 128(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm0, %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3,4],ymm9[5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 128(%rdx), %ymm9
; AVX2-SLOW-NEXT:    vmovdqa 128(%rcx), %ymm8
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm8[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm9[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 128(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 148(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1],ymm14[2,3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 160(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm0, %ymm11
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1,2,3,4],ymm11[5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 160(%rdx), %ymm11
; AVX2-SLOW-NEXT:    vmovdqa 160(%rcx), %ymm10
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm10[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm11[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 160(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 160(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 180(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,2,1]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1],ymm14[2,3],ymm12[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm13[4,5],ymm12[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 192(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastd %xmm0, %ymm13
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2,3,4],ymm13[5],ymm12[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 192(%rdx), %ymm13
; AVX2-SLOW-NEXT:    vmovdqa 192(%rcx), %ymm12
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm12[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm13[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 192(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 192(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 212(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastss 224(%rcx), %xmm14
; AVX2-SLOW-NEXT:    vbroadcastss 224(%rdx), %xmm15
; AVX2-SLOW-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm15 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm15 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3],ymm15[4,5,6,7]
; AVX2-SLOW-NEXT:    vbroadcastsd (%rsp), %ymm15 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vmovaps 224(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastss %xmm0, %ymm15
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1,2,3,4],ymm15[5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 224(%rdx), %ymm14
; AVX2-SLOW-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 224(%rcx), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm14[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0],ymm0[1],ymm15[2],ymm0[3],ymm15[4],ymm0[5],ymm15[6],ymm0[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,1,2,3]
; AVX2-SLOW-NEXT:    vmovdqa 224(%rdi), %ymm14
; AVX2-SLOW-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 224(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm14 = ymm14[2],ymm0[2],ymm14[3],ymm0[3],ymm14[6],ymm0[6],ymm14[7],ymm0[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm14[4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm15[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 244(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm15[3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm0, %ymm14, %ymm0
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm15 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1],ymm0[2,3,4,5],ymm15[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm15 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2,3,4,5,6],ymm15[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm15[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovaps (%r8), %ymm15
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vbroadcastss 16(%r9), %ymm14
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm14[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm15[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 48(%r9), %ymm14
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm14[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm5[0],ymm4[0],ymm5[1],ymm4[1],ymm5[4],ymm4[4],ymm5[5],ymm4[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa 64(%r8), %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 80(%r9), %ymm2
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm5[2],ymm4[2],ymm5[3],ymm4[3],ymm5[6],ymm4[6],ymm5[7],ymm4[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm7[0],ymm6[0],ymm7[1],ymm6[1],ymm7[4],ymm6[4],ymm7[5],ymm6[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa 96(%r8), %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 112(%r9), %ymm2
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm7[2],ymm6[2],ymm7[3],ymm6[3],ymm7[6],ymm6[6],ymm7[7],ymm6[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm9[0],ymm8[0],ymm9[1],ymm8[1],ymm9[4],ymm8[4],ymm9[5],ymm8[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa 128(%r8), %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 144(%r9), %ymm2
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm9[2],ymm8[2],ymm9[3],ymm8[3],ymm9[6],ymm8[6],ymm9[7],ymm8[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm11[0],ymm10[0],ymm11[1],ymm10[1],ymm11[4],ymm10[4],ymm11[5],ymm10[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa 160(%r8), %ymm14
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm14[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 176(%r9), %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm11[2],ymm10[2],ymm11[3],ymm10[3],ymm11[6],ymm10[6],ymm11[7],ymm10[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm14[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1],ymm0[2,3,4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm0[0],ymm10[1],ymm0[2,3,4,5,6],ymm10[7]
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm11 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1],ymm0[2,3,4,5],ymm11[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm11 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0],ymm11[1],ymm0[2,3,4,5,6],ymm11[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} ymm14 = ymm13[0],ymm12[0],ymm13[1],ymm12[1],ymm13[4],ymm12[4],ymm13[5],ymm12[5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm14[2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa 192(%r8), %ymm14
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm14[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 208(%r9), %ymm15
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4],ymm15[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm12 = ymm13[2],ymm12[2],ymm13[3],ymm12[3],ymm13[6],ymm12[6],ymm13[7],ymm12[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm12 = mem[2,3],ymm12[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm14[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1],ymm12[2,3,4,5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3,4,5,6],ymm13[7]
; AVX2-SLOW-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-SLOW-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm13 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm13 = xmm3[2],mem[2],xmm3[3],mem[3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm13 = xmm13[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm13, %ymm3, %ymm13
; AVX2-SLOW-NEXT:    vpermilps $250, (%rsp), %xmm14 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm14 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1],ymm13[2,3,4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm14 = mem[2,2,3,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[0,1,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm14[1],ymm13[2,3,4,5,6],ymm14[7]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm14 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovaps 224(%r8), %ymm15
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vbroadcastss 240(%r9), %ymm3
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm3 = ymm14[0,1,2,3,4],ymm3[5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vunpckhps {{.*#+}} ymm14 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm14 = mem[2,3],ymm14[2,3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm15 = ymm15[2,1,3,3,6,5,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,1,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3,4,5],ymm15[6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm15 = mem[0,2,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,1,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1],ymm14[2,3,4,5,6],ymm15[7]
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovaps %ymm14, 1504(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm3, 1440(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm13, 1408(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm12, 1312(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 1248(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm11, 1216(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm10, 1120(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 1056(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm9, 1024(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, 928(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, 864(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm7, 832(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, 736(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-SLOW-NEXT:    addq $2488, %rsp # imm = 0x9B8
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride6_vf64:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $2312, %rsp # imm = 0x908
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm11
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm9
; AVX2-FAST-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm6[2],xmm11[2],xmm6[3],xmm11[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm2
; AVX2-FAST-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %xmm7
; AVX2-FAST-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rcx), %xmm5
; AVX2-FAST-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-FAST-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %xmm8
; AVX2-FAST-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm2[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm0[4,5],ymm3[6,7]
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %xmm10
; AVX2-FAST-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm2[0],zero,xmm2[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 4(%r9), %ymm4
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2],ymm4[3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm9[2],xmm1[2],xmm9[3],xmm1[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm7[1,2,2,3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm8[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm10[0],zero,xmm10[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 36(%r9), %ymm4
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2],ymm4[3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rdx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm5[1,2,2,3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %xmm4
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm8
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5],ymm7[6,7]
; AVX2-FAST-NEXT:    vmovdqa 64(%r8), %xmm12
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm12[0],zero,xmm12[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1],ymm8[2,3],ymm7[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 68(%r9), %ymm8
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm7[0,1,2],ymm8[3],ymm7[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rcx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa 96(%rdx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm7[0,1,2,1]
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %xmm8
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm10
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5],ymm9[6,7]
; AVX2-FAST-NEXT:    vmovdqa 96(%r8), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1],ymm10[2,3],ymm9[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 100(%r9), %ymm10
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm9[0,1,2],ymm10[3],ymm9[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 128(%rcx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa 128(%rdx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm10 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm14 = ymm9[0,1,2,1]
; AVX2-FAST-NEXT:    vmovdqa 128(%rsi), %xmm10
; AVX2-FAST-NEXT:    vmovdqa 128(%rdi), %xmm9
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm15
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm15 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-FAST-NEXT:    vmovdqa 128(%r8), %xmm14
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm14[0],zero,xmm14[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm13 = ymm15[0,1],ymm13[2,3],ymm15[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 132(%r9), %ymm15
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm13[0,1,2],ymm15[3],ymm13[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 160(%rcx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa 160(%rdx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm13 = xmm15[0],xmm13[0],xmm15[1],xmm13[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-FAST-NEXT:    vmovdqa 160(%rsi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 160(%rdi), %xmm15
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm13[0,1,2,3],ymm5[4,5],ymm13[6,7]
; AVX2-FAST-NEXT:    vmovdqa 160(%r8), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1],ymm13[2,3],ymm5[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 164(%r9), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2],ymm13[3],ymm5[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 192(%rcx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa 192(%rdx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm13[0],xmm5[0],xmm13[1],xmm5[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FAST-NEXT:    vmovdqa 192(%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 192(%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm13[4,5],ymm5[6,7]
; AVX2-FAST-NEXT:    vmovdqa 192(%r8), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1],ymm13[2,3],ymm5[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 196(%r9), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2],ymm13[3],ymm5[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 224(%rcx), %xmm5
; AVX2-FAST-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa 224(%rdx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[1,2,2,3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm13[0],xmm5[0],xmm13[1],xmm5[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FAST-NEXT:    vmovdqa 224(%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 224(%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm13[4,5],ymm5[6,7]
; AVX2-FAST-NEXT:    vmovdqa 224(%r8), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1],ymm13[2,3],ymm5[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 228(%r9), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2],ymm13[3],ymm5[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd (%rcx), %xmm5
; AVX2-FAST-NEXT:    vpbroadcastd (%rdx), %xmm13
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm13[0],xmm5[0],xmm13[1],xmm5[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm6[0],xmm11[0],xmm6[1],xmm11[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm5[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq %xmm2, %ymm0
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd (%r9), %ymm1
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm2
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm1[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0],ymm0[1],ymm5[2],ymm0[3],ymm5[4],ymm0[5],ymm5[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm5
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm5 = ymm6[2],ymm5[2],ymm6[3],ymm5[3],ymm6[6],ymm5[6],ymm6[7],ymm5[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm5 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 20(%r9), %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm5[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vbroadcastss 32(%rcx), %xmm0
; AVX2-FAST-NEXT:    vbroadcastss 32(%rdx), %xmm5
; AVX2-FAST-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; AVX2-FAST-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FAST-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm5 = xmm5[0],mem[0],xmm5[1],mem[1]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6,7]
; AVX2-FAST-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vbroadcastss 32(%r9), %ymm5
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm5[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %ymm5
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %ymm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0],ymm0[1],ymm5[2],ymm0[3],ymm5[4],ymm0[5],ymm5[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm11
; AVX2-FAST-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %ymm5
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm5 = ymm11[2],ymm5[2],ymm11[3],ymm5[3],ymm11[6],ymm5[6],ymm11[7],ymm5[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm5 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 52(%r9), %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm5[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd 64(%rcx), %xmm0
; AVX2-FAST-NEXT:    vpbroadcastd 64(%rdx), %xmm5
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq %xmm12, %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 64(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rcx), %ymm5
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm5[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3],ymm3[4],ymm0[5],ymm3[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm4[2],ymm3[2],ymm4[3],ymm3[3],ymm4[6],ymm3[6],ymm4[7],ymm3[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 84(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm7[0],xmm8[0],xmm7[1],xmm8[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 96(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rcx), %ymm11
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm11[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3],ymm3[4],ymm0[5],ymm3[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm4[2],ymm3[2],ymm4[3],ymm3[3],ymm4[6],ymm3[6],ymm4[7],ymm3[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 116(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd 128(%rcx), %xmm0
; AVX2-FAST-NEXT:    vpbroadcastd 128(%rdx), %xmm3
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm9[0],xmm10[0],xmm9[1],xmm10[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq %xmm14, %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 128(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 128(%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 128(%rcx), %ymm10
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm10[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3],ymm3[4],ymm0[5],ymm3[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 128(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 128(%rsi), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm4[2],ymm3[2],ymm4[3],ymm3[3],ymm4[6],ymm3[6],ymm4[7],ymm3[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 148(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm3 = xmm15[0],mem[0],xmm15[1],mem[1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 160(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 160(%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 160(%rcx), %ymm9
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm9[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3],ymm3[4],ymm0[5],ymm3[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 160(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 160(%rsi), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm4[2],ymm3[2],ymm4[3],ymm3[3],ymm4[6],ymm3[6],ymm4[7],ymm3[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 180(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vbroadcastss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vbroadcastss {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; AVX2-FAST-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FAST-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vbroadcastss 192(%r9), %ymm3
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 192(%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 192(%rcx), %ymm15
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm15[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3],ymm3[4],ymm0[5],ymm3[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 192(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 192(%rsi), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm4[2],ymm3[2],ymm4[3],ymm3[3],ymm4[6],ymm3[6],ymm4[7],ymm3[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 212(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vbroadcastss 224(%rcx), %xmm0
; AVX2-FAST-NEXT:    vbroadcastss 224(%rdx), %xmm3
; AVX2-FAST-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; AVX2-FAST-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FAST-NEXT:    vunpcklps (%rsp), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vbroadcastss 224(%r9), %ymm3
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 224(%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 224(%rcx), %ymm14
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm14[0,1,2,2,4,5,6,6]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[1,1,2,3,5,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3],ymm3[4],ymm0[5],ymm3[6],ymm0[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa 224(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 224(%rsi), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm4[2],ymm3[2],ymm4[3],ymm3[3],ymm4[6],ymm3[6],ymm4[7],ymm3[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm3, (%rsp) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = mem[0],zero,mem[1],zero
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 244(%r9), %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm4
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm3
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [2,2,3,3,2,2,3,3]
; AVX2-FAST-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm0, %ymm12
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm12[0,1],ymm4[2,3,4,5],ymm12[6,7]
; AVX2-FAST-NEXT:    vmovdqa (%r9), %ymm12
; AVX2-FAST-NEXT:    vpermd %ymm12, %ymm0, %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0],ymm13[1],ymm4[2,3,4,5,6],ymm13[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm4 = ymm4[0],mem[0],ymm4[1],mem[1],ymm4[4],mem[4],ymm4[5],mem[5]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm13 = ymm2[0],ymm1[0],ymm2[1],ymm1[1],ymm2[4],ymm1[4],ymm2[5],ymm1[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm13[2,3],ymm4[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 16(%r9), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3,4],ymm13[5],ymm4[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [6,5,3,3,6,5,7,7]
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm8, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [4,6,2,3,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm12, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm0, %ymm12
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm12[0,1],ymm1[2,3,4,5],ymm12[6,7]
; AVX2-FAST-NEXT:    vmovdqa 32(%r9), %ymm12
; AVX2-FAST-NEXT:    vpermd %ymm12, %ymm0, %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm13[1],ymm1[2,3,4,5,6],ymm13[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm13 = ymm3[0],ymm6[0],ymm3[1],ymm6[1],ymm3[4],ymm6[4],ymm3[5],ymm6[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm13[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 48(%r9), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm13[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm3[2],ymm6[2],ymm3[3],ymm6[3],ymm3[6],ymm6[6],ymm3[7],ymm6[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm8, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm12, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa 64(%r8), %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm0, %ymm6
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1],ymm1[2,3,4,5],ymm6[6,7]
; AVX2-FAST-NEXT:    vmovdqa 64(%r9), %ymm6
; AVX2-FAST-NEXT:    vpermd %ymm6, %ymm0, %ymm12
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm12[1],ymm1[2,3,4,5,6],ymm12[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm12 = ymm3[0],ymm5[0],ymm3[1],ymm5[1],ymm3[4],ymm5[4],ymm3[5],ymm5[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm12[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 80(%r9), %ymm12
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm12[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm3[2],ymm5[2],ymm3[3],ymm5[3],ymm3[6],ymm5[6],ymm3[7],ymm5[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm8, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm6, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa 96(%r8), %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm0, %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1],ymm1[2,3,4,5],ymm5[6,7]
; AVX2-FAST-NEXT:    vmovdqa 96(%r9), %ymm5
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm0, %ymm6
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm6[1],ymm1[2,3,4,5,6],ymm6[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm6 = ymm3[0],ymm11[0],ymm3[1],ymm11[1],ymm3[4],ymm11[4],ymm3[5],ymm11[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm6[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 112(%r9), %ymm6
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm6[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm3[2],ymm11[2],ymm3[3],ymm11[3],ymm3[6],ymm11[6],ymm3[7],ymm11[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm8, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa 128(%r8), %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm0, %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1],ymm1[2,3,4,5],ymm5[6,7]
; AVX2-FAST-NEXT:    vmovdqa 128(%r9), %ymm5
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm0, %ymm6
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm6[1],ymm1[2,3,4,5,6],ymm6[7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm6 = ymm3[0],ymm10[0],ymm3[1],ymm10[1],ymm3[4],ymm10[4],ymm3[5],ymm10[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm6[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 144(%r9), %ymm6
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm6[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm3[2],ymm10[2],ymm3[3],ymm10[3],ymm3[6],ymm10[6],ymm3[7],ymm10[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm8, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm11 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa 160(%r8), %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm0, %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1],ymm1[2,3,4,5],ymm5[6,7]
; AVX2-FAST-NEXT:    vmovdqa 160(%r9), %ymm3
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm0, %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = ymm1[0],ymm5[1],ymm1[2,3,4,5,6],ymm5[7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm5 = ymm4[0],ymm9[0],ymm4[1],ymm9[1],ymm4[4],ymm9[4],ymm4[5],ymm9[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm5[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 176(%r9), %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm1[0,1,2,3,4],ymm5[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm4[2],ymm9[2],ymm4[3],ymm9[3],ymm4[6],ymm9[6],ymm4[7],ymm9[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm8, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa 192(%r8), %ymm3
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vmovdqa 192(%r9), %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm0, %ymm4
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm1[0],ymm4[1],ymm1[2,3,4,5,6],ymm4[7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm13 = ymm12[0],ymm15[0],ymm12[1],ymm15[1],ymm12[4],ymm15[4],ymm12[5],ymm15[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1],ymm13[2,3],ymm1[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 208(%r9), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm1[0,1,2,3,4],ymm13[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm13 = ymm12[2],ymm15[2],ymm12[3],ymm15[3],ymm12[6],ymm15[6],ymm12[7],ymm15[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm13 = ymm13[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm13 = mem[2,3],ymm13[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm8, %ymm3
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm13[2,3,4,5],ymm3[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4,5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm3 = xmm3[2],mem[2],xmm3[3],mem[3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm12, %ymm3
; AVX2-FAST-NEXT:    vmovdqa 224(%r8), %ymm13
; AVX2-FAST-NEXT:    vpermd %ymm13, %ymm0, %ymm15
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm15[0,1],ymm3[2,3,4,5],ymm15[6,7]
; AVX2-FAST-NEXT:    vmovdqa 224(%r9), %ymm15
; AVX2-FAST-NEXT:    vpermd %ymm15, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0],ymm0[1],ymm3[2,3,4,5,6],ymm0[7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm3 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} ymm12 = ymm0[0],ymm14[0],ymm0[1],ymm14[1],ymm0[4],ymm14[4],ymm0[5],ymm14[5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,2,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,1,2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm12[2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm13[4,5],ymm3[6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 240(%r9), %ymm12
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm12[5],ymm3[6,7]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} ymm12 = ymm0[2],ymm14[2],ymm0[3],ymm14[3],ymm0[6],ymm14[6],ymm0[7],ymm14[7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vperm2i128 $19, (%rsp), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm12 = mem[2,3],ymm12[2,3]
; AVX2-FAST-NEXT:    vpermd %ymm13, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm12[2,3,4,5],ymm8[6,7]
; AVX2-FAST-NEXT:    vpermd %ymm15, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2,3,4,5,6],ymm7[7]
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm7, 1504(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 1440(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 1408(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 1312(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm4, 1248(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm5, 1216(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm9, 1120(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm6, 1056(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm10, 1024(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm11, 928(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FAST-NEXT:    addq $2312, %rsp # imm = 0x908
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride6_vf64:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $2488, %rsp # imm = 0x9B8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rcx), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5],ymm5[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm2[0],zero,xmm2[1],zero
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 4(%r9), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm10[2],xmm1[2],xmm10[3],xmm1[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm8[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm9[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm6[0],zero,xmm6[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 36(%r9), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm7[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r8), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm7[2,3],ymm6[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 68(%r9), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2],ymm7[3],ymm6[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rcx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm7 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm6[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r8), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 100(%r9), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2],ymm9[3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rcx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm8 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rdx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm9 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm8[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rsi), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rdi), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%r8), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1],ymm11[2,3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 132(%r9), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1,2],ymm11[3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rcx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm10 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rdx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm10[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rsi), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rdi), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm13[4,5],ymm12[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%r8), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1],ymm13[2,3],ymm12[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 164(%r9), %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2],ymm13[3],ymm12[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rcx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm12 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rdx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm12[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rsi), %xmm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rdi), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%r8), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 196(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%rcx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm14 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%rdx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm15 = xmm0[1,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm14[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%rsi), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm14 = xmm0[2],xmm14[2],xmm0[3],xmm14[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm14[4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%r8), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm14, (%rsp) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm14[0],zero,xmm14[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm14[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 228(%r9), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm14[3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rcx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rdx), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm14[0],xmm0[0],xmm14[1],xmm0[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = xmm3[0],mem[0],xmm3[1],mem[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq %xmm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm1[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm0[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm14[0],ymm2[1],ymm14[2],ymm2[3],ymm14[4],ymm2[5],ymm14[6],ymm2[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm14 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1],ymm14[2,3],ymm2[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 20(%r9), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm14[3],ymm2[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss 32(%rcx), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss 32(%rdx), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm14[0],xmm2[0],xmm14[1],xmm2[1]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm3 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm3 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss %xmm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4],ymm3[5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm3[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm0[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 52(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 64(%rcx), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 64(%rdx), %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm14[2,3],ymm4[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3,4],ymm5[5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdx), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rcx), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm4[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm5[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 84(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1],ymm14[2,3],ymm6[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4],ymm7[5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdx), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rcx), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm7[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 116(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 128(%rcx), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 128(%rdx), %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1],ymm14[2,3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm0, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3,4],ymm9[5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rdx), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rcx), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm8[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm9[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 148(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1],ymm14[2,3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm0, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1,2,3,4],ymm11[5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rdx), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rcx), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm10[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm11[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 180(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1],ymm14[2,3],ymm12[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm13[4,5],ymm12[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd %xmm0, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2,3,4],ymm13[5],ymm12[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rdx), %ymm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rcx), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm12[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm13[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3],ymm15[4],ymm14[5],ymm15[6],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 212(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2],ymm15[3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss 224(%rcx), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss 224(%rdx), %xmm15
; AVX2-FAST-PERLANE-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm15 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm15 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3],ymm15[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd (%rsp), %ymm15 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 224(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss %xmm0, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1,2,3,4],ymm15[5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%rdx), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%rcx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm14[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0],ymm0[1],ymm15[2],ymm0[3],ymm15[4],ymm0[5],ymm15[6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%rdi), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm14 = ymm14[2],ymm0[2],ymm14[3],ymm0[3],ymm14[6],ymm0[6],ymm14[7],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm14[4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm15 = mem[0],zero,mem[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm15[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 244(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm15[3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm0, %ymm14, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm15 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1],ymm0[2,3,4,5],ymm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm15 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2,3,4,5,6],ymm15[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm15[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%r8), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss 16(%r9), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm14[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm15[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 48(%r9), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm14[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm5[0],ymm4[0],ymm5[1],ymm4[1],ymm5[4],ymm4[4],ymm5[5],ymm4[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 80(%r9), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm5[2],ymm4[2],ymm5[3],ymm4[3],ymm5[6],ymm4[6],ymm5[7],ymm4[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm7[0],ymm6[0],ymm7[1],ymm6[1],ymm7[4],ymm6[4],ymm7[5],ymm6[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 112(%r9), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm7[2],ymm6[2],ymm7[3],ymm6[3],ymm7[6],ymm6[6],ymm7[7],ymm6[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm9[0],ymm8[0],ymm9[1],ymm8[1],ymm9[4],ymm8[4],ymm9[5],ymm8[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 144(%r9), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm5 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm9[2],ymm8[2],ymm9[3],ymm8[3],ymm9[6],ymm8[6],ymm9[7],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm11[0],ymm10[0],ymm11[1],ymm10[1],ymm11[4],ymm10[4],ymm11[5],ymm10[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%r8), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm14[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 176(%r9), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm11[2],ymm10[2],ymm11[3],ymm10[3],ymm11[6],ymm10[6],ymm11[7],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm10 = ymm14[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1],ymm0[2,3,4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm10 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm10 = ymm0[0],ymm10[1],ymm0[2,3,4,5,6],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm11 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1],ymm0[2,3,4,5],ymm11[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm11 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0],ymm11[1],ymm0[2,3,4,5,6],ymm11[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} ymm14 = ymm13[0],ymm12[0],ymm13[1],ymm12[1],ymm13[4],ymm12[4],ymm13[5],ymm12[5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm14[2,3],ymm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%r8), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm14[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 208(%r9), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4],ymm15[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} ymm12 = ymm13[2],ymm12[2],ymm13[3],ymm12[3],ymm13[6],ymm12[6],ymm13[7],ymm12[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm12 = mem[2,3],ymm12[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm13 = ymm14[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1],ymm12[2,3,4,5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm13 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3,4,5,6],ymm13[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm13 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm13 = xmm3[2],mem[2],xmm3[3],mem[3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm13 = xmm13[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm13, %ymm3, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, (%rsp), %xmm14 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm14 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1],ymm13[2,3,4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm14 = mem[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[0,1,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm14[1],ymm13[2,3,4,5,6],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm14 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 224(%r8), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss 240(%r9), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm3 = ymm14[0,1,2,3,4],ymm3[5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vunpckhps {{.*#+}} ymm14 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm14 = ymm14[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm14 = mem[2,3],ymm14[2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm15 = ymm15[2,1,3,3,6,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3,4,5],ymm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm15 = mem[0,2,2,3,4,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1],ymm14[2,3,4,5,6],ymm15[7]
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm14, 1504(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm3, 1440(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm13, 1408(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm12, 1312(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, 1248(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm11, 1216(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm10, 1120(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, 1056(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm9, 1024(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, 928(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, 864(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm7, 832(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, 736(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    addq $2488, %rsp # imm = 0x9B8
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i32_stride6_vf64:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    subq $584, %rsp # imm = 0x248
; AVX512F-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm24
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm29
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm8
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm11
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm20
; AVX512F-SLOW-NEXT:    vmovdqa64 128(%rsi), %zmm17
; AVX512F-SLOW-NEXT:    vmovdqa64 192(%rdx), %zmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 128(%rdx), %zmm30
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm16
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm15
; AVX512F-SLOW-NEXT:    vmovdqa64 128(%rcx), %zmm13
; AVX512F-SLOW-NEXT:    vmovdqa64 192(%rcx), %zmm12
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512F-SLOW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm25
; AVX512F-SLOW-NEXT:    vpermt2d %zmm11, %zmm21, %zmm25
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %ymm14
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512F-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512F-SLOW-NEXT:    vpermt2d %zmm16, %zmm0, %zmm22
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512F-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512F-SLOW-NEXT:    vpermt2d %zmm16, %zmm9, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [3,19,0,16,11,27,8,24,15,31,12,28,3,19,0,16]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512F-SLOW-NEXT:    vpermt2d %zmm16, %zmm10, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512F-SLOW-NEXT:    vpermt2d %zmm15, %zmm0, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512F-SLOW-NEXT:    vpermt2d %zmm15, %zmm9, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512F-SLOW-NEXT:    vpermt2d %zmm15, %zmm10, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm18
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm0, %zmm18
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm18
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm9, %zmm18
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm18
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm10, %zmm18
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512F-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm27
; AVX512F-SLOW-NEXT:    vpermt2d %zmm16, %zmm28, %zmm27
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512F-SLOW-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm16, %zmm31, %zmm5
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm23
; AVX512F-SLOW-NEXT:    vpermt2d %zmm15, %zmm28, %zmm23
; AVX512F-SLOW-NEXT:    vpermt2d %zmm15, %zmm31, %zmm4
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm26
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm28, %zmm26
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm31, %zmm30
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdx), %ymm13
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm18
; AVX512F-SLOW-NEXT:    vpermi2d %zmm12, %zmm3, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpermi2d %zmm12, %zmm3, %zmm9
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpermi2d %zmm12, %zmm3, %zmm10
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpermi2d %zmm12, %zmm3, %zmm28
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm31, %zmm18
; AVX512F-SLOW-NEXT:    vmovdqa64 128(%rdx), %ymm31
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,11,0,8,7,15,4,12]
; AVX512F-SLOW-NEXT:    vpermt2d (%rcx), %ymm0, %ymm14
; AVX512F-SLOW-NEXT:    movb $36, %al
; AVX512F-SLOW-NEXT:    kmovw %eax, %k1
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm25 {%k1} = zmm14[0,1,0,1,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm19
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm4
; AVX512F-SLOW-NEXT:    vpermt2d %zmm20, %zmm21, %zmm19
; AVX512F-SLOW-NEXT:    vpermt2d 64(%rcx), %ymm0, %ymm13
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm19 {%k1} = zmm13[0,1,0,1,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm16
; AVX512F-SLOW-NEXT:    vpermt2d %zmm17, %zmm21, %zmm16
; AVX512F-SLOW-NEXT:    vpermt2d 128(%rcx), %ymm0, %ymm31
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm16 {%k1} = zmm31[0,1,0,1,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa 192(%rdx), %ymm14
; AVX512F-SLOW-NEXT:    vpermt2d 192(%rcx), %ymm0, %ymm14
; AVX512F-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm20
; AVX512F-SLOW-NEXT:    vmovdqa64 192(%rsi), %zmm31
; AVX512F-SLOW-NEXT:    vpermi2d %zmm31, %zmm20, %zmm21
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm21 {%k1} = zmm14[0,1,0,1,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 (%r8), %zmm12
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm14, %zmm25
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm10
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm14, %zmm19
; AVX512F-SLOW-NEXT:    vmovdqa64 128(%r8), %zmm9
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm14, %zmm16
; AVX512F-SLOW-NEXT:    vmovdqa64 192(%r8), %zmm13
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm14, %zmm21
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm15
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512F-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm11, %zmm3, %zmm15
; AVX512F-SLOW-NEXT:    movb $-110, %al
; AVX512F-SLOW-NEXT:    kmovw %eax, %k2
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm22, %zmm15 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm14
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512F-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm11, %zmm2, %zmm14
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm22
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm0 = zmm8[2],zmm11[2],zmm8[3],zmm11[3],zmm8[6],zmm11[6],zmm8[7],zmm11[7],zmm8[10],zmm11[10],zmm8[11],zmm11[11],zmm8[14],zmm11[14],zmm8[15],zmm11[15]
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512F-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm11, %zmm1, %zmm22
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm11
; AVX512F-SLOW-NEXT:    vpermt2d %zmm4, %zmm3, %zmm11
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm8
; AVX512F-SLOW-NEXT:    vpermt2d %zmm4, %zmm2, %zmm8
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm7
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm29 = zmm29[2],zmm4[2],zmm29[3],zmm4[3],zmm29[6],zmm4[6],zmm29[7],zmm4[7],zmm29[10],zmm4[10],zmm29[11],zmm4[11],zmm29[14],zmm4[14],zmm29[15],zmm4[15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm4, %zmm1, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm7 {%k1}
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm6
; AVX512F-SLOW-NEXT:    vpermt2d %zmm17, %zmm3, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm5
; AVX512F-SLOW-NEXT:    vpermt2d %zmm17, %zmm2, %zmm5
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm4
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm24 = zmm24[2],zmm17[2],zmm24[3],zmm17[3],zmm24[6],zmm17[6],zmm24[7],zmm17[7],zmm24[10],zmm17[10],zmm24[11],zmm17[11],zmm24[14],zmm17[14],zmm24[15],zmm17[15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm17, %zmm1, %zmm4
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512F-SLOW-NEXT:    vpermi2d %zmm31, %zmm20, %zmm3
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm15
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm11
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm3
; AVX512F-SLOW-NEXT:    vpermi2d %zmm31, %zmm20, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm14
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm8
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm5
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm2
; AVX512F-SLOW-NEXT:    vpermi2d %zmm31, %zmm20, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm22
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm4
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdi), %ymm17
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm17 = ymm17[2],mem[2],ymm17[3],mem[3],ymm17[6],mem[6],ymm17[7],mem[7]
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm27 {%k1} = zmm17[0,1,2,3,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rdi), %ymm17
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm17 = ymm17[2],mem[2],ymm17[3],mem[3],ymm17[6],mem[6],ymm17[7],mem[7]
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm23 {%k1} = zmm17[0,1,2,3,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 128(%rdi), %ymm17
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm17 = ymm17[2],mem[2],ymm17[3],mem[3],ymm17[6],mem[6],ymm17[7],mem[7]
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm26 {%k1} = zmm17[0,1,2,3,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 192(%rdi), %ymm17
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm17 = ymm17[2],mem[2],ymm17[3],mem[3],ymm17[6],mem[6],ymm17[7],mem[7]
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm28 {%k1} = zmm17[0,1,2,3,2,3,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm27
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm23
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm26
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm28
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k1} = zmm17[0,1,6,7,6,7,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm12 {%k1} = zmm29[0,1,6,7,6,7,0,1]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm12
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm30 {%k1} = zmm24[0,1,6,7,6,7,0,1]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm30
; AVX512F-SLOW-NEXT:    vmovdqa64 (%r9), %zmm9
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm10 = zmm20[2],zmm31[2],zmm20[3],zmm31[3],zmm20[6],zmm31[6],zmm20[7],zmm31[7],zmm20[10],zmm31[10],zmm20[11],zmm31[11],zmm20[14],zmm31[14],zmm20[15],zmm31[15]
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm12
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm18 {%k1} = zmm10[0,1,6,7,6,7,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 128(%r9), %zmm10
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm18
; AVX512F-SLOW-NEXT:    vmovdqa64 192(%r9), %zmm13
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm25
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm19
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm16
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm21
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm15
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm11
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm6
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm14
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm8
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm5
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm22
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm7
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm4
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm27
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm23
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm26
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm28
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm0
; AVX512F-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm29
; AVX512F-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm30
; AVX512F-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm18
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm18, 1472(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm1, 1408(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm2, 1344(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm3, 1152(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm30, 1088(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm5, 960(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm6, 768(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm29, 704(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm7, 640(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm8, 576(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm11, 384(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, 320(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm22, 256(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm14, 192(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm15, (%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm28, 1280(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm21, 1216(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm26, 896(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm16, 832(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm23, 512(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm19, 448(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm27, 128(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm25, 64(%rax)
; AVX512F-SLOW-NEXT:    addq $584, %rsp # imm = 0x248
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i32_stride6_vf64:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    subq $1224, %rsp # imm = 0x4C8
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdi), %zmm24
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm4
; AVX512F-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 (%rsi), %zmm20
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512F-FAST-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512F-FAST-NEXT:    vmovdqa64 192(%rsi), %zmm14
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdx), %zmm7
; AVX512F-FAST-NEXT:    vmovdqa64 (%rcx), %zmm15
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512F-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm31
; AVX512F-FAST-NEXT:    vpermt2d %zmm15, %zmm8, %zmm31
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512F-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm24, %zmm21
; AVX512F-FAST-NEXT:    vpermt2d %zmm20, %zmm5, %zmm21
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [3,19,0,16,3,19,0,16,7,23,4,20,3,19,0,16]
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512F-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm24, %zmm28
; AVX512F-FAST-NEXT:    vpermt2d %zmm20, %zmm6, %zmm28
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [2,18,3,19,6,22,7,23,6,22,7,23,2,18,3,19]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm24, %zmm11
; AVX512F-FAST-NEXT:    vpermt2d %zmm20, %zmm6, %zmm11
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512F-FAST-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm24, %zmm1
; AVX512F-FAST-NEXT:    vpermt2d %zmm20, %zmm12, %zmm1
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512F-FAST-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm24, %zmm6
; AVX512F-FAST-NEXT:    vpermt2d %zmm20, %zmm13, %zmm6
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm27 = [2,18,3,19,14,30,15,31,14,30,15,31,2,18,3,19]
; AVX512F-FAST-NEXT:    vpermt2d %zmm20, %zmm27, %zmm24
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512F-FAST-NEXT:    vpermt2d %zmm25, %zmm5, %zmm6
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512F-FAST-NEXT:    vpermt2d %zmm25, %zmm9, %zmm6
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512F-FAST-NEXT:    vpermt2d %zmm25, %zmm11, %zmm16
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermt2d %zmm25, %zmm12, %zmm4
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, %zmm4
; AVX512F-FAST-NEXT:    vpermt2d %zmm25, %zmm13, %zmm4
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermt2d %zmm25, %zmm27, %zmm6
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm5, %zmm4
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm9, %zmm4
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm11, %zmm4
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, %zmm29
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm12, %zmm29
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, %zmm30
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm13, %zmm30
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm27, %zmm3
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-FAST-NEXT:    vpermt2d %zmm15, %zmm10, %zmm1
; AVX512F-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm5
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm9
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm11
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm12
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm13
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermt2d %zmm14, %zmm27, %zmm2
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512F-FAST-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm14
; AVX512F-FAST-NEXT:    vpermt2d %zmm15, %zmm27, %zmm14
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512F-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm12
; AVX512F-FAST-NEXT:    vpermt2d %zmm15, %zmm6, %zmm12
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [3,19,0,16,11,27,8,24,15,31,12,28,3,19,0,16]
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm9, %zmm22
; AVX512F-FAST-NEXT:    vpermt2d %zmm15, %zmm7, %zmm22
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512F-FAST-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermt2d %zmm15, %zmm2, %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm15
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm0
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm15, %zmm19
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm8, %zmm20
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm8, %zmm19
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm15, %zmm18
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm10, %zmm25
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm10, %zmm18
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm15, %zmm5
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm27, %zmm5
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm15, %zmm13
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm6, %zmm13
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm15, %zmm10
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm7, %zmm10
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm2, %zmm15
; AVX512F-FAST-NEXT:    vmovdqa64 128(%rdx), %zmm17
; AVX512F-FAST-NEXT:    vmovdqa64 128(%rcx), %zmm0
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm17, %zmm23
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm8, %zmm23
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm17, %zmm16
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm16
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm17, %zmm4
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm27, %zmm4
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm17, %zmm11
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm6, %zmm11
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm17, %zmm8
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm7, %zmm8
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm2, %zmm17
; AVX512F-FAST-NEXT:    vmovdqa64 192(%rdx), %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm20
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm20, (%rsp) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm25
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm27
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm6
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm7
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm2, %zmm3
; AVX512F-FAST-NEXT:    movb $-110, %al
; AVX512F-FAST-NEXT:    kmovw %eax, %k2
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm31, %zmm21 {%k2}
; AVX512F-FAST-NEXT:    movb $36, %al
; AVX512F-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k1}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm12, %zmm1 {%k2}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm22, %zmm31 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm24, %zmm9 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm25 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm21
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm20 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm20, %zmm28
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm22 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm22, %zmm14
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm26 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm26, %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm12, %zmm31
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm1, %zmm9
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm19, %zmm24 {%k2}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm18, %zmm19 {%k1}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm13, %zmm18 {%k2}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm10, %zmm2 {%k1}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm24
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm20, %zmm19
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm22, %zmm5
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm26, %zmm18
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm18, %zmm13
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm18 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm18, %zmm15
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm23, %zmm2 {%k2}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm16, %zmm10 {%k1}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm11, %zmm29 {%k2}
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm8, %zmm30 {%k1}
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm2, %zmm23
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm20, %zmm10
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm22, %zmm4
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm26, %zmm29
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm12, %zmm30
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm18, %zmm17
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512F-FAST-NEXT:    vmovdqa64 192(%r8), %zmm0
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm8
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm8, %zmm2 {%k1}
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm20, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm2, %zmm27 {%k1}
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm22, %zmm27
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, %zmm8 {%k2}
; AVX512F-FAST-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm26, %zmm8
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm8, %zmm16
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm20, %zmm21
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm6, %zmm25
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm7, %zmm8
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm8, %zmm18
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm22, %zmm14
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, %zmm3 {%k1}
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm8, %zmm28
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512F-FAST-NEXT:    vpermt2d %zmm0, %zmm7, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm0, %zmm31
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm7, %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 64(%r9), %zmm2
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm20, %zmm24
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm6, %zmm19
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm22, %zmm5
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm8, %zmm13
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm0, %zmm1
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm7, %zmm15
; AVX512F-FAST-NEXT:    vmovdqa64 128(%r9), %zmm2
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm20, %zmm23
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm6, %zmm10
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm22, %zmm4
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm8, %zmm29
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm0, %zmm30
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm7, %zmm17
; AVX512F-FAST-NEXT:    vmovdqa64 192(%r9), %zmm2
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm20, %zmm11
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm6, %zmm12
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm22, %zmm27
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm8, %zmm16
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm0, %zmm18
; AVX512F-FAST-NEXT:    vpermt2d %zmm2, %zmm7, %zmm3
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, 1472(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm18, 1408(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm16, 1344(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm27, 1280(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm12, 1216(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm11, 1152(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm17, 1088(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm30, 1024(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm29, 960(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, 896(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm10, 832(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm23, 768(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm15, 704(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, 640(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm13, 576(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm19, 448(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm24, 384(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm9, 320(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm31, 256(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm28, 192(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm14, 128(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm25, 64(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm21, (%rax)
; AVX512F-FAST-NEXT:    addq $1224, %rsp # imm = 0x4C8
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-SLOW-LABEL: store_i32_stride6_vf64:
; AVX512BW-SLOW:       # %bb.0:
; AVX512BW-SLOW-NEXT:    subq $584, %rsp # imm = 0x248
; AVX512BW-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm24
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm29
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm8
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm11
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm20
; AVX512BW-SLOW-NEXT:    vmovdqa64 128(%rsi), %zmm17
; AVX512BW-SLOW-NEXT:    vmovdqa64 192(%rdx), %zmm3
; AVX512BW-SLOW-NEXT:    vmovdqa64 128(%rdx), %zmm30
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm16
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm15
; AVX512BW-SLOW-NEXT:    vmovdqa64 128(%rcx), %zmm13
; AVX512BW-SLOW-NEXT:    vmovdqa64 192(%rcx), %zmm12
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512BW-SLOW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm25
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm11, %zmm21, %zmm25
; AVX512BW-SLOW-NEXT:    vmovdqa (%rdx), %ymm14
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512BW-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm16, %zmm0, %zmm22
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512BW-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm16, %zmm9, %zmm6
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [3,19,0,16,11,27,8,24,15,31,12,28,3,19,0,16]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm16, %zmm10, %zmm6
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm15, %zmm0, %zmm6
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm15, %zmm9, %zmm7
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm15, %zmm10, %zmm6
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm18
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm0, %zmm18
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm18
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm9, %zmm18
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm18
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm10, %zmm18
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512BW-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm27
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm16, %zmm28, %zmm27
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512BW-SLOW-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm16, %zmm31, %zmm5
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm23
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm15, %zmm28, %zmm23
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm15, %zmm31, %zmm4
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm26
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm28, %zmm26
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm31, %zmm30
; AVX512BW-SLOW-NEXT:    vmovdqa 64(%rdx), %ymm13
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm18
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm12, %zmm3, %zmm0
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm12, %zmm3, %zmm9
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm12, %zmm3, %zmm10
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm12, %zmm3, %zmm28
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm31, %zmm18
; AVX512BW-SLOW-NEXT:    vmovdqa64 128(%rdx), %ymm31
; AVX512BW-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,11,0,8,7,15,4,12]
; AVX512BW-SLOW-NEXT:    vpermt2d (%rcx), %ymm0, %ymm14
; AVX512BW-SLOW-NEXT:    movb $36, %al
; AVX512BW-SLOW-NEXT:    kmovd %eax, %k1
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm25 {%k1} = zmm14[0,1,0,1,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm19
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm4
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm20, %zmm21, %zmm19
; AVX512BW-SLOW-NEXT:    vpermt2d 64(%rcx), %ymm0, %ymm13
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm19 {%k1} = zmm13[0,1,0,1,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm16
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm17, %zmm21, %zmm16
; AVX512BW-SLOW-NEXT:    vpermt2d 128(%rcx), %ymm0, %ymm31
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm16 {%k1} = zmm31[0,1,0,1,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa 192(%rdx), %ymm14
; AVX512BW-SLOW-NEXT:    vpermt2d 192(%rcx), %ymm0, %ymm14
; AVX512BW-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm20
; AVX512BW-SLOW-NEXT:    vmovdqa64 192(%rsi), %zmm31
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm31, %zmm20, %zmm21
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm21 {%k1} = zmm14[0,1,0,1,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%r8), %zmm12
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm14, %zmm25
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm10
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm14, %zmm19
; AVX512BW-SLOW-NEXT:    vmovdqa64 128(%r8), %zmm9
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm14, %zmm16
; AVX512BW-SLOW-NEXT:    vmovdqa64 192(%r8), %zmm13
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm14, %zmm21
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm15
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512BW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm11, %zmm3, %zmm15
; AVX512BW-SLOW-NEXT:    movb $-110, %al
; AVX512BW-SLOW-NEXT:    kmovd %eax, %k2
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm22, %zmm15 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm14
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512BW-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm11, %zmm2, %zmm14
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm22
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm0 = zmm8[2],zmm11[2],zmm8[3],zmm11[3],zmm8[6],zmm11[6],zmm8[7],zmm11[7],zmm8[10],zmm11[10],zmm8[11],zmm11[11],zmm8[14],zmm11[14],zmm8[15],zmm11[15]
; AVX512BW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512BW-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm11, %zmm1, %zmm22
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm11
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm4, %zmm3, %zmm11
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm8
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm4, %zmm2, %zmm8
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm7
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm29 = zmm29[2],zmm4[2],zmm29[3],zmm4[3],zmm29[6],zmm4[6],zmm29[7],zmm4[7],zmm29[10],zmm4[10],zmm29[11],zmm4[11],zmm29[14],zmm4[14],zmm29[15],zmm4[15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm4, %zmm1, %zmm7
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm7 {%k1}
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm6
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm17, %zmm3, %zmm6
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm5
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm17, %zmm2, %zmm5
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm4
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm24 = zmm24[2],zmm17[2],zmm24[3],zmm17[3],zmm24[6],zmm17[6],zmm24[7],zmm17[7],zmm24[10],zmm17[10],zmm24[11],zmm17[11],zmm24[14],zmm17[14],zmm24[15],zmm17[15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm17, %zmm1, %zmm4
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm31, %zmm20, %zmm3
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm15
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm11
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm3
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm31, %zmm20, %zmm2
; AVX512BW-SLOW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm14
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm8
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm5
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm2
; AVX512BW-SLOW-NEXT:    vpermi2d %zmm31, %zmm20, %zmm1
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm22
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm4
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm1
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rdi), %ymm17
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm17 = ymm17[2],mem[2],ymm17[3],mem[3],ymm17[6],mem[6],ymm17[7],mem[7]
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm27 {%k1} = zmm17[0,1,2,3,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rdi), %ymm17
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm17 = ymm17[2],mem[2],ymm17[3],mem[3],ymm17[6],mem[6],ymm17[7],mem[7]
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm23 {%k1} = zmm17[0,1,2,3,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 128(%rdi), %ymm17
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm17 = ymm17[2],mem[2],ymm17[3],mem[3],ymm17[6],mem[6],ymm17[7],mem[7]
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm26 {%k1} = zmm17[0,1,2,3,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 192(%rdi), %ymm17
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} ymm17 = ymm17[2],mem[2],ymm17[3],mem[3],ymm17[6],mem[6],ymm17[7],mem[7]
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm28 {%k1} = zmm17[0,1,2,3,2,3,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm27
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm23
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm26
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm28
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k1} = zmm17[0,1,6,7,6,7,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm0
; AVX512BW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm12 {%k1} = zmm29[0,1,6,7,6,7,0,1]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm12
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm30 {%k1} = zmm24[0,1,6,7,6,7,0,1]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm30
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%r9), %zmm9
; AVX512BW-SLOW-NEXT:    vpunpckhdq {{.*#+}} zmm10 = zmm20[2],zmm31[2],zmm20[3],zmm31[3],zmm20[6],zmm31[6],zmm20[7],zmm31[7],zmm20[10],zmm31[10],zmm20[11],zmm31[11],zmm20[14],zmm31[14],zmm20[15],zmm31[15]
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm12
; AVX512BW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm18 {%k1} = zmm10[0,1,6,7,6,7,0,1]
; AVX512BW-SLOW-NEXT:    vmovdqa64 128(%r9), %zmm10
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm18
; AVX512BW-SLOW-NEXT:    vmovdqa64 192(%r9), %zmm13
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm25
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm19
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm16
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm21
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm15
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm11
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm6
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm3
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm14
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm8
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm5
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm2
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm22
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm7
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm4
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm1
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm27
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm23
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm26
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm28
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm0
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm12, %zmm17, %zmm29
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm30
; AVX512BW-SLOW-NEXT:    vpermt2d %zmm13, %zmm17, %zmm18
; AVX512BW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm18, 1472(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm1, 1408(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm2, 1344(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm3, 1152(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm30, 1088(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm5, 960(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm6, 768(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm29, 704(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm7, 640(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm8, 576(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm11, 384(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm0, 320(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm22, 256(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm14, 192(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm15, (%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm28, 1280(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm21, 1216(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm26, 896(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm16, 832(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm23, 512(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm19, 448(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm27, 128(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa64 %zmm25, 64(%rax)
; AVX512BW-SLOW-NEXT:    addq $584, %rsp # imm = 0x248
; AVX512BW-SLOW-NEXT:    vzeroupper
; AVX512BW-SLOW-NEXT:    retq
;
; AVX512BW-FAST-LABEL: store_i32_stride6_vf64:
; AVX512BW-FAST:       # %bb.0:
; AVX512BW-FAST-NEXT:    subq $1224, %rsp # imm = 0x4C8
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rdi), %zmm24
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm4
; AVX512BW-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512BW-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm2
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rsi), %zmm20
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512BW-FAST-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512BW-FAST-NEXT:    vmovdqa64 192(%rsi), %zmm14
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rdx), %zmm7
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rcx), %zmm15
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,17,0,16,0,0,2,18,1,17,0,16,0,0,2,18]
; AVX512BW-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm31
; AVX512BW-FAST-NEXT:    vpermt2d %zmm15, %zmm8, %zmm31
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [0,16,0,0,2,18,1,17,0,16,0,0,2,18,1,17]
; AVX512BW-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm24, %zmm21
; AVX512BW-FAST-NEXT:    vpermt2d %zmm20, %zmm5, %zmm21
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [3,19,0,16,3,19,0,16,7,23,4,20,3,19,0,16]
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [4,20,3,19,0,0,5,21,4,20,3,19,0,0,5,21]
; AVX512BW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm24, %zmm28
; AVX512BW-FAST-NEXT:    vpermt2d %zmm20, %zmm6, %zmm28
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [2,18,3,19,6,22,7,23,6,22,7,23,2,18,3,19]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm24, %zmm11
; AVX512BW-FAST-NEXT:    vpermt2d %zmm20, %zmm6, %zmm11
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [8,24,0,0,10,26,9,25,8,24,0,0,10,26,9,25]
; AVX512BW-FAST-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm24, %zmm1
; AVX512BW-FAST-NEXT:    vpermt2d %zmm20, %zmm12, %zmm1
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [12,28,11,27,0,0,13,29,12,28,11,27,0,0,13,29]
; AVX512BW-FAST-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm24, %zmm6
; AVX512BW-FAST-NEXT:    vpermt2d %zmm20, %zmm13, %zmm6
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm27 = [2,18,3,19,14,30,15,31,14,30,15,31,2,18,3,19]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm20, %zmm27, %zmm24
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-FAST-NEXT:    vpermt2d %zmm25, %zmm5, %zmm6
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-FAST-NEXT:    vpermt2d %zmm25, %zmm9, %zmm6
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-FAST-NEXT:    vpermt2d %zmm25, %zmm11, %zmm16
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vpermt2d %zmm25, %zmm12, %zmm4
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm4
; AVX512BW-FAST-NEXT:    vpermt2d %zmm25, %zmm13, %zmm4
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vpermt2d %zmm25, %zmm27, %zmm6
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm5, %zmm4
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm9, %zmm4
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm11, %zmm4
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm29
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm12, %zmm29
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm30
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm13, %zmm30
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm27, %zmm3
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512BW-FAST-NEXT:    vpermt2d %zmm15, %zmm10, %zmm1
; AVX512BW-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm5
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm11
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm12
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vpermi2d %zmm14, %zmm2, %zmm13
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vpermt2d %zmm14, %zmm27, %zmm2
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [5,21,0,0,7,23,6,22,5,21,0,0,7,23,6,22]
; AVX512BW-FAST-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm14
; AVX512BW-FAST-NEXT:    vpermt2d %zmm15, %zmm27, %zmm14
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [9,25,8,24,0,0,10,26,9,25,8,24,0,0,10,26]
; AVX512BW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm12
; AVX512BW-FAST-NEXT:    vpermt2d %zmm15, %zmm6, %zmm12
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [3,19,0,16,11,27,8,24,15,31,12,28,3,19,0,16]
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm9, %zmm22
; AVX512BW-FAST-NEXT:    vpermt2d %zmm15, %zmm7, %zmm22
; AVX512BW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [13,29,0,0,15,31,14,30,13,29,0,0,15,31,14,30]
; AVX512BW-FAST-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm15, %zmm2, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm15
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm0
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm19
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm20
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm8, %zmm19
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm18
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm25
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm10, %zmm18
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm5
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm27, %zmm5
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm13
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm6, %zmm13
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm10
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm7, %zmm10
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm2, %zmm15
; AVX512BW-FAST-NEXT:    vmovdqa64 128(%rdx), %zmm17
; AVX512BW-FAST-NEXT:    vmovdqa64 128(%rcx), %zmm0
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm17, %zmm23
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm8, %zmm23
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm17, %zmm16
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm16
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm17, %zmm4
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm27, %zmm4
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm17, %zmm11
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm6, %zmm11
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm17, %zmm8
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm7, %zmm8
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm2, %zmm17
; AVX512BW-FAST-NEXT:    vmovdqa64 192(%rdx), %zmm3
; AVX512BW-FAST-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm20
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm20, (%rsp) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm25
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm27
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm6
; AVX512BW-FAST-NEXT:    vpermi2d %zmm0, %zmm3, %zmm7
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm2, %zmm3
; AVX512BW-FAST-NEXT:    movb $-110, %al
; AVX512BW-FAST-NEXT:    kmovd %eax, %k2
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm31, %zmm21 {%k2}
; AVX512BW-FAST-NEXT:    movb $36, %al
; AVX512BW-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm1 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm22, %zmm31 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm24, %zmm9 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm25 = <0,1,2,3,16,u,6,7,8,9,17,u,12,13,14,15>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm21
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm20 = <18,u,2,3,4,5,19,u,8,9,10,11,20,u,14,15>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm20, %zmm28
; AVX512BW-FAST-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm22 = <0,1,21,u,4,5,6,7,22,u,10,11,12,13,23,u>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm22, %zmm14
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm26 = <0,1,2,3,24,u,6,7,8,9,25,u,12,13,14,15>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm26, %zmm1
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm12, %zmm31
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm1, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm19, %zmm24 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm18, %zmm19 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm13, %zmm18 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm2 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm24
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm20, %zmm19
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm22, %zmm5
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm26, %zmm18
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm18, %zmm13
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm18 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm18, %zmm15
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm23, %zmm2 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm16, %zmm10 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm29 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm30 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm2
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm23
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm20, %zmm10
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm22, %zmm4
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm26, %zmm29
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm12, %zmm30
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm18, %zmm17
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqa64 192(%r8), %zmm0
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm25, %zmm8
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm2 {%k1}
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm20, %zmm2
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm27 {%k1}
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm22, %zmm27
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm8 {%k2}
; AVX512BW-FAST-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm26, %zmm8
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm16
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [0,1,2,3,4,16,6,7,8,9,10,17,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm20, %zmm21
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,18,2,3,4,5,6,19,8,9,10,11,12,20,14,15]
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm6, %zmm25
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <26,u,2,3,4,5,27,u,8,9,10,11,28,u,14,15>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm7, %zmm8
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm18
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [0,1,2,21,4,5,6,7,8,22,10,11,12,13,14,23]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm22, %zmm14
; AVX512BW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm3 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,1,2,3,4,24,6,7,8,9,10,25,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm8, %zmm28
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,29,u,4,5,6,7,30,u,10,11,12,13,31,u>
; AVX512BW-FAST-NEXT:    vpermt2d %zmm0, %zmm7, %zmm3
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,26,2,3,4,5,6,27,8,9,10,11,12,28,14,15]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm0, %zmm31
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,2,29,4,5,6,7,8,30,10,11,12,13,14,31]
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm7, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%r9), %zmm2
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm20, %zmm24
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm6, %zmm19
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm22, %zmm5
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm8, %zmm13
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm0, %zmm1
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm7, %zmm15
; AVX512BW-FAST-NEXT:    vmovdqa64 128(%r9), %zmm2
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm20, %zmm23
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm6, %zmm10
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm22, %zmm4
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm8, %zmm29
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm0, %zmm30
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm7, %zmm17
; AVX512BW-FAST-NEXT:    vmovdqa64 192(%r9), %zmm2
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm20, %zmm11
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm6, %zmm12
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm22, %zmm27
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm8, %zmm16
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm0, %zmm18
; AVX512BW-FAST-NEXT:    vpermt2d %zmm2, %zmm7, %zmm3
; AVX512BW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm3, 1472(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm18, 1408(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm16, 1344(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm27, 1280(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm12, 1216(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm11, 1152(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm17, 1088(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm30, 1024(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm29, 960(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm4, 896(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm10, 832(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm23, 768(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm15, 704(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm1, 640(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm13, 576(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm19, 448(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm24, 384(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm9, 320(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm31, 256(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm28, 192(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm14, 128(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm25, 64(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa64 %zmm21, (%rax)
; AVX512BW-FAST-NEXT:    addq $1224, %rsp # imm = 0x4C8
; AVX512BW-FAST-NEXT:    vzeroupper
; AVX512BW-FAST-NEXT:    retq
  %in.vec0 = load <64 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <64 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <64 x i32>, ptr %in.vecptr5, align 64
  %1 = shufflevector <64 x i32> %in.vec0, <64 x i32> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i32> %in.vec2, <64 x i32> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <64 x i32> %in.vec4, <64 x i32> %in.vec5, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %4 = shufflevector <128 x i32> %1, <128 x i32> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %5 = shufflevector <128 x i32> %3, <128 x i32> poison, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <256 x i32> %4, <256 x i32> %5, <384 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255, i32 256, i32 257, i32 258, i32 259, i32 260, i32 261, i32 262, i32 263, i32 264, i32 265, i32 266, i32 267, i32 268, i32 269, i32 270, i32 271, i32 272, i32 273, i32 274, i32 275, i32 276, i32 277, i32 278, i32 279, i32 280, i32 281, i32 282, i32 283, i32 284, i32 285, i32 286, i32 287, i32 288, i32 289, i32 290, i32 291, i32 292, i32 293, i32 294, i32 295, i32 296, i32 297, i32 298, i32 299, i32 300, i32 301, i32 302, i32 303, i32 304, i32 305, i32 306, i32 307, i32 308, i32 309, i32 310, i32 311, i32 312, i32 313, i32 314, i32 315, i32 316, i32 317, i32 318, i32 319, i32 320, i32 321, i32 322, i32 323, i32 324, i32 325, i32 326, i32 327, i32 328, i32 329, i32 330, i32 331, i32 332, i32 333, i32 334, i32 335, i32 336, i32 337, i32 338, i32 339, i32 340, i32 341, i32 342, i32 343, i32 344, i32 345, i32 346, i32 347, i32 348, i32 349, i32 350, i32 351, i32 352, i32 353, i32 354, i32 355, i32 356, i32 357, i32 358, i32 359, i32 360, i32 361, i32 362, i32 363, i32 364, i32 365, i32 366, i32 367, i32 368, i32 369, i32 370, i32 371, i32 372, i32 373, i32 374, i32 375, i32 376, i32 377, i32 378, i32 379, i32 380, i32 381, i32 382, i32 383>
  %interleaved.vec = shufflevector <384 x i32> %6, <384 x i32> poison, <384 x i32> <i32 0, i32 64, i32 128, i32 192, i32 256, i32 320, i32 1, i32 65, i32 129, i32 193, i32 257, i32 321, i32 2, i32 66, i32 130, i32 194, i32 258, i32 322, i32 3, i32 67, i32 131, i32 195, i32 259, i32 323, i32 4, i32 68, i32 132, i32 196, i32 260, i32 324, i32 5, i32 69, i32 133, i32 197, i32 261, i32 325, i32 6, i32 70, i32 134, i32 198, i32 262, i32 326, i32 7, i32 71, i32 135, i32 199, i32 263, i32 327, i32 8, i32 72, i32 136, i32 200, i32 264, i32 328, i32 9, i32 73, i32 137, i32 201, i32 265, i32 329, i32 10, i32 74, i32 138, i32 202, i32 266, i32 330, i32 11, i32 75, i32 139, i32 203, i32 267, i32 331, i32 12, i32 76, i32 140, i32 204, i32 268, i32 332, i32 13, i32 77, i32 141, i32 205, i32 269, i32 333, i32 14, i32 78, i32 142, i32 206, i32 270, i32 334, i32 15, i32 79, i32 143, i32 207, i32 271, i32 335, i32 16, i32 80, i32 144, i32 208, i32 272, i32 336, i32 17, i32 81, i32 145, i32 209, i32 273, i32 337, i32 18, i32 82, i32 146, i32 210, i32 274, i32 338, i32 19, i32 83, i32 147, i32 211, i32 275, i32 339, i32 20, i32 84, i32 148, i32 212, i32 276, i32 340, i32 21, i32 85, i32 149, i32 213, i32 277, i32 341, i32 22, i32 86, i32 150, i32 214, i32 278, i32 342, i32 23, i32 87, i32 151, i32 215, i32 279, i32 343, i32 24, i32 88, i32 152, i32 216, i32 280, i32 344, i32 25, i32 89, i32 153, i32 217, i32 281, i32 345, i32 26, i32 90, i32 154, i32 218, i32 282, i32 346, i32 27, i32 91, i32 155, i32 219, i32 283, i32 347, i32 28, i32 92, i32 156, i32 220, i32 284, i32 348, i32 29, i32 93, i32 157, i32 221, i32 285, i32 349, i32 30, i32 94, i32 158, i32 222, i32 286, i32 350, i32 31, i32 95, i32 159, i32 223, i32 287, i32 351, i32 32, i32 96, i32 160, i32 224, i32 288, i32 352, i32 33, i32 97, i32 161, i32 225, i32 289, i32 353, i32 34, i32 98, i32 162, i32 226, i32 290, i32 354, i32 35, i32 99, i32 163, i32 227, i32 291, i32 355, i32 36, i32 100, i32 164, i32 228, i32 292, i32 356, i32 37, i32 101, i32 165, i32 229, i32 293, i32 357, i32 38, i32 102, i32 166, i32 230, i32 294, i32 358, i32 39, i32 103, i32 167, i32 231, i32 295, i32 359, i32 40, i32 104, i32 168, i32 232, i32 296, i32 360, i32 41, i32 105, i32 169, i32 233, i32 297, i32 361, i32 42, i32 106, i32 170, i32 234, i32 298, i32 362, i32 43, i32 107, i32 171, i32 235, i32 299, i32 363, i32 44, i32 108, i32 172, i32 236, i32 300, i32 364, i32 45, i32 109, i32 173, i32 237, i32 301, i32 365, i32 46, i32 110, i32 174, i32 238, i32 302, i32 366, i32 47, i32 111, i32 175, i32 239, i32 303, i32 367, i32 48, i32 112, i32 176, i32 240, i32 304, i32 368, i32 49, i32 113, i32 177, i32 241, i32 305, i32 369, i32 50, i32 114, i32 178, i32 242, i32 306, i32 370, i32 51, i32 115, i32 179, i32 243, i32 307, i32 371, i32 52, i32 116, i32 180, i32 244, i32 308, i32 372, i32 53, i32 117, i32 181, i32 245, i32 309, i32 373, i32 54, i32 118, i32 182, i32 246, i32 310, i32 374, i32 55, i32 119, i32 183, i32 247, i32 311, i32 375, i32 56, i32 120, i32 184, i32 248, i32 312, i32 376, i32 57, i32 121, i32 185, i32 249, i32 313, i32 377, i32 58, i32 122, i32 186, i32 250, i32 314, i32 378, i32 59, i32 123, i32 187, i32 251, i32 315, i32 379, i32 60, i32 124, i32 188, i32 252, i32 316, i32 380, i32 61, i32 125, i32 189, i32 253, i32 317, i32 381, i32 62, i32 126, i32 190, i32 254, i32 318, i32 382, i32 63, i32 127, i32 191, i32 255, i32 319, i32 383>
  store <384 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX1: {{.*}}
; AVX2: {{.*}}
; AVX512BW: {{.*}}
; AVX512BW-ONLY-FAST: {{.*}}
; AVX512BW-ONLY-SLOW: {{.*}}
; AVX512DQ-FAST: {{.*}}
; AVX512DQ-SLOW: {{.*}}
; AVX512DQBW-FAST: {{.*}}
; AVX512DQBW-SLOW: {{.*}}
; AVX512F: {{.*}}
; AVX512F-ONLY-FAST: {{.*}}
; AVX512F-ONLY-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
